/*\ XMMS - Cross-platform multimedia player
|*| Copyright (C) 1998-1999  Peter Alm, Mikael Alm, Olle Hallnas,
|*|                             Thomas Nilsson and 4Front Technologies
|*|
|*| CD audio data input plugin by Willem Monsuwe (willem@stack.nl)
|*|
|*| This program is free software; you can redistribute it and/or modify
|*| it under the terms of the GNU General Public License as published by
|*| the Free Software Foundation; either version 2 of the License, or
|*| (at your option) any later version.
|*|
|*| This program is distributed in the hope that it will be useful,
|*| but WITHOUT ANY WARRANTY; without even the implied warranty of
|*| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
|*| GNU General Public License for more details.
|*|
|*| You should have received a copy of the GNU General Public License
|*| along with this program; if not, write to the Free Software
|*| Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
\*/
#ifndef _XMMS_CDREAD_H
#define _XMMS_CDREAD_H

#include <glib.h>
#include <stdlib.h>
#include <pthread.h>

#define TRACK_CDR "%02u-track.cdr"

extern struct cd_cfg {
	gchar *cddb_dir;
	gboolean dtitle;
	gboolean out_cdrom;
	gboolean use_oss_mixer;
	gboolean playorder;
	gboolean cddb_auto;
	gboolean cddb_choice_one;
	gchar *cddb_server;
	gint cddb_port;
	gchar *cddb_cgi;
	gchar *format;
	gint cdrom_speed;
	gchar *cd_device;
} cd_cfg;

extern struct cd_struct {
	struct cd_struct *next;
	gint first_trk, last_trk;
	guint32 lba[100];
	gchar data[100];
	gchar datacd;
	guint32 id;
	gchar *discid;
	gchar *dtitle;
	gchar *ttitle[100];
	gchar *extd;
	gchar *extt[100];
	gchar *playorder;
	gchar *device;
	gint cdfd;
	gint flags;
	gboolean paused;
	gboolean cddb_pending;
	pthread_t thread;
	pthread_mutex_t title_mutex;
	gint volume_left, volume_right;
	enum {
		CD_STOP_NOW, CD_STOP, CD_DIRECT,
		CD_TRACK, CD_SEEK, CD_PLAY, CD_EXIT
	} action;
	gboolean error;
} *cd_list;

#define FLAG_FAIL_BLK 0x1
#define FLAG_FAIL_SPD 0x2

/*\ cdconf.c \*/
void cd_configure(void);
void get_configure(void);

/*\ cddb.c \*/
gchar *my_strcat(char *, char *);
gint cd_read_cddb(struct cd_struct *, gboolean);
void cddb_write_file(struct cd_struct *cd);
gchar *cd_strdup_title(struct cd_struct *, gint);

/*\ fileinfo.c \*/
void cd_file_info(gchar *);
void cddb_reread(void);

/*\ playlist.c \*/
gboolean playlist_replace(gchar *, GList *);
void playlist_dirty(gchar *);
GList *playlist_find(gchar *);
gint playlist_check(gchar *);

/*\ server.c \*/
void show_dialog(gchar *fmt, ...);
void cddb_server_get(struct cd_struct *, gchar *, gboolean);
void cddb_server_cleanup(void);

extern pthread_mutex_t cd_list_mutex;

#define DB(x...) (fprintf(stderr, ##x) && fflush(stdout))

#define TT_LOCK()	pthread_mutex_lock(&(cd->title_mutex));
#define TT_UNLOCK()	pthread_mutex_unlock(&(cd->title_mutex));

#define CD_LOCK()	pthread_mutex_lock(&cd_list_mutex);
#define CD_UNLOCK()	pthread_mutex_unlock(&cd_list_mutex);

/*\ Utility macro's \*/

#define NEW(ptr,nelem)		((ptr) = malloc((nelem) * (sizeof(*ptr))))
#define CNEW(ptr,nelem)		((ptr) = calloc((nelem) , (sizeof(*ptr))))
#define RENEW(ptr,nelem)	((ptr) = realloc((ptr), (nelem) * (sizeof(*ptr))))
#define COPY(tgt,src,nelem)	(memcpy((tgt),(src),(nelem) * (sizeof(*src))))
#define MOVE(tgt,src,nelem)	(memmove((tgt),(src),(nelem) * (sizeof(*src))))
#define STRCAT(str,add)		((str) = my_strcat((str), (add)))
#define STRNCAT(str,add,n)	((str) = my_strncat((str), (add), (n)))
#define NELEM(arr)		(sizeof(arr) / sizeof(*(arr)))

/*\ xmms internals we want to call.. (hackediehack) \*/
void playlist_ins(gchar *, glong);

void mainwin_set_info_text(void);
void mainwin_set_song_info(gint, gint, gint);

void input_stop(void);
gboolean get_input_playing(void);
void playlistwin_update_list(void);

void cd_filter(void *buf, int len);
void cd_init_eq(void);

#endif /*\ _XMMS_CDREAD_H \*/
