#include "cdread.h"

#include <gtk/gtk.h>
#include <xmms/configfile.h>
#include <netdb.h>
#include <netinet/in.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

static GtkWidget *cd_configure_win, *cddb_dir_entry;
static GtkWidget *format_entry, *device_entry;
static GtkWidget *opt_playorder, *opt_dtitle;
static GtkWidget *cddb_auto, *cddb_server, *cddb_port, *cddb_cgi;
static GtkWidget *cddb_choice_one;
static GtkWidget *out_cdrom, *volume_oss, *volume_drive;
static GtkObject *cdrom_speed;
static GtkWidget *bbox, *ok, *cancel;

static gint
service_to_port(gchar *s)
{
	struct servent *se;
	se = getservbyname(s, "tcp");
	if (se) return ntohs(se->s_port);
	return atoi(s);
}

static gchar *
port_to_service(gint p)
{
	static gchar buf[20];
	struct servent *se;
	se = getservbyport(htons(p), "tcp");
	if (se) return se->s_name;
	sprintf(buf, "%d", p);
	return buf;
}

void
get_configure(void)
{
	gchar *filename = g_strconcat(g_get_home_dir(),"/.xmms/config",NULL);
	ConfigFile *cfg = xmms_cfg_open_file(filename);
	cd_cfg.cddb_dir = NULL;
	cd_cfg.dtitle = TRUE;
	cd_cfg.out_cdrom = FALSE;
	cd_cfg.use_oss_mixer = FALSE;
	cd_cfg.playorder = TRUE;
	cd_cfg.cddb_auto = TRUE;
	cd_cfg.cddb_choice_one = FALSE;
	cd_cfg.cddb_server = NULL;
	cd_cfg.cddb_port = 888;
	cd_cfg.cddb_cgi = NULL;
	cd_cfg.format = NULL;
	cd_cfg.cd_device = NULL;
	cd_cfg.cdrom_speed = 4;
	if (cfg) {
		xmms_cfg_read_string(cfg, "CDRD", "cddb_dir", &cd_cfg.cddb_dir);
		xmms_cfg_read_boolean(cfg, "CDRD", "dtitle", &cd_cfg.dtitle);
		xmms_cfg_read_boolean(cfg, "CDRD", "out_cdrom",
						&cd_cfg.out_cdrom);
		xmms_cfg_read_boolean(cfg, "CDRD", "use_oss_mixer",
						&cd_cfg.use_oss_mixer);
		xmms_cfg_read_boolean(cfg, "CDRD", "playorder",
						&cd_cfg.playorder);
		xmms_cfg_read_boolean(cfg, "CDRD", "cddb_auto",
						&cd_cfg.cddb_auto);
		xmms_cfg_read_boolean(cfg, "CDRD", "cddb_choice_one",
						&cd_cfg.cddb_choice_one);
		xmms_cfg_read_string(cfg, "CDRD", "cddb_server",
						&cd_cfg.cddb_server);
		xmms_cfg_read_int(cfg, "CDRD", "cddb_port",
						&cd_cfg.cddb_port);
		xmms_cfg_read_string(cfg, "CDRD", "cddb_cgi", &cd_cfg.cddb_cgi);
		xmms_cfg_read_string(cfg, "CDRD", "format", &cd_cfg.format);
		xmms_cfg_read_string(cfg, "CDRD", "cd_device",
						&cd_cfg.cd_device);
		xmms_cfg_read_int(cfg, "CDRD", "cdrom_speed",
						&cd_cfg.cdrom_speed);
		xmms_cfg_free(cfg);
	}
	g_free(filename);
	if (!cd_cfg.cddb_dir)
		cd_cfg.cddb_dir = g_strconcat(g_get_home_dir(),
						"/.cddb",NULL);
	if (!cd_cfg.cddb_server)
		cd_cfg.cddb_server = g_strdup("freedb.org");
	if (!cd_cfg.cddb_cgi)
		cd_cfg.cddb_cgi = g_strdup("/~cddb/cddb.cgi");
	if (!cd_cfg.format)
		cd_cfg.format = g_strdup("%t");
	if (!cd_cfg.cd_device)
		cd_cfg.cd_device = g_strdup("/dev/cdrom");
}

static void
cd_configurewin_ok_cb(GtkWidget *w, gpointer data)
{
	ConfigFile *cfg;
	gchar *tmp, *filename;
	struct cd_struct *cd;

	g_free(cd_cfg.cddb_dir);
	tmp = gtk_entry_get_text(GTK_ENTRY(cddb_dir_entry));

	if (tmp[strlen(tmp) - 1] == '/')
		cd_cfg.cddb_dir = g_strdup(tmp);
	else
		cd_cfg.cddb_dir = g_strconcat(tmp, "/", NULL);
	
	cd_cfg.dtitle = gtk_toggle_button_get_active(
				GTK_TOGGLE_BUTTON(opt_dtitle));
	cd_cfg.playorder = gtk_toggle_button_get_active(
				GTK_TOGGLE_BUTTON(opt_playorder));

	cd_cfg.out_cdrom = gtk_toggle_button_get_active(
				GTK_TOGGLE_BUTTON(out_cdrom));
	cd_cfg.use_oss_mixer = gtk_toggle_button_get_active(
				GTK_TOGGLE_BUTTON(volume_oss));
	cd_cfg.cddb_auto = gtk_toggle_button_get_active(
				GTK_TOGGLE_BUTTON(cddb_auto));
	cd_cfg.cddb_choice_one = gtk_toggle_button_get_active(
				GTK_TOGGLE_BUTTON(cddb_choice_one));

	g_free(cd_cfg.cddb_server);
	cd_cfg.cddb_server = g_strdup(gtk_entry_get_text(
				GTK_ENTRY(cddb_server)));
	cd_cfg.cddb_port = service_to_port(gtk_entry_get_text(
				GTK_ENTRY(cddb_port)));
	cd_cfg.cdrom_speed = (gint)GTK_ADJUSTMENT(cdrom_speed)->value;
	g_free(cd_cfg.cddb_cgi);
	cd_cfg.cddb_cgi = g_strdup(gtk_entry_get_text(GTK_ENTRY(cddb_cgi)));

	g_free(cd_cfg.format);
	cd_cfg.format = g_strdup(gtk_entry_get_text(GTK_ENTRY(format_entry)));

	g_free(cd_cfg.cd_device);
	cd_cfg.cd_device = g_strdup(gtk_entry_get_text(GTK_ENTRY(device_entry)));

	if (!cd_cfg.cddb_server[0]) {
		g_free(cd_cfg.cddb_server);
		cd_cfg.cddb_server = g_strdup("freedb.org");
	}
	if (!cd_cfg.cddb_port) cd_cfg.cddb_port = 888;

	CD_LOCK();
	cd = cd_list;
	while (cd) {
		cd->id = 0xff; /*\ Force a reread \*/
		cd_read_cddb(cd, FALSE);
		playlist_dirty(cd->device);
		cd = cd->next;
	}
	CD_UNLOCK();

	filename = g_strconcat(g_get_home_dir(), "/.xmms/config", NULL);
	cfg = xmms_cfg_open_file(filename);
	if (!cfg) cfg = xmms_cfg_new();

	xmms_cfg_write_string(cfg, "CDRD", "cddb_dir", cd_cfg.cddb_dir);
	xmms_cfg_write_boolean(cfg, "CDRD", "dtitle", cd_cfg.dtitle);
	xmms_cfg_write_boolean(cfg, "CDRD", "out_cdrom", cd_cfg.out_cdrom);
	xmms_cfg_write_boolean(cfg, "CDRD", "use_oss_mixer",
						cd_cfg.use_oss_mixer);
	xmms_cfg_write_boolean(cfg, "CDRD", "playorder", cd_cfg.playorder);
	xmms_cfg_write_boolean(cfg, "CDRD", "cddb_auto", cd_cfg.cddb_auto);
	xmms_cfg_write_boolean(cfg, "CDRD", "cddb_choice_one", cd_cfg.cddb_choice_one);
	xmms_cfg_write_string(cfg, "CDRD", "cddb_server", cd_cfg.cddb_server);
	xmms_cfg_write_int(cfg, "CDRD", "cddb_port", cd_cfg.cddb_port);
	xmms_cfg_write_string(cfg, "CDRD", "cddb_cgi", cd_cfg.cddb_cgi);
	xmms_cfg_write_string(cfg, "CDRD", "format", cd_cfg.format);
	xmms_cfg_write_string(cfg, "CDRD", "cd_device", cd_cfg.cd_device);
	xmms_cfg_write_int(cfg, "CDRD", "cdrom_speed", cd_cfg.cdrom_speed);
	xmms_cfg_write_file(cfg, filename);
	xmms_cfg_free(cfg);

	g_free(filename);

	gtk_widget_destroy(cd_configure_win);
}

void playlist_ins(gchar * filename, glong pos);

static void
add_default_cd_device(void)
{
	playlist_ins(cd_cfg.cd_device, -1);
}

static void
set_vol_sensitive(void)
{
	gboolean s;
	s = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(out_cdrom));
#if defined(HAVE_SYS_SOUNDCARD_H) || defined(HAVE_MACHINE_SOUNDCARD_H)
	gtk_widget_set_sensitive(volume_oss, s);
#endif
	gtk_widget_set_sensitive(volume_drive, s);
}

void proto_win_show(void);

void
cd_configure(void)
{
	if (!cd_configure_win)
	{
		GtkWidget *win_vbox, *notebook;
		GtkWidget *box, *pbox;
		GtkWidget *frame, *table;
		GtkWidget *label, *out_card;
		GtkWidget *spin;

		cd_configure_win = gtk_window_new(GTK_WINDOW_DIALOG);
		gtk_signal_connect(GTK_OBJECT(cd_configure_win), "destroy",
				GTK_SIGNAL_FUNC(gtk_widget_destroyed),
				&cd_configure_win);
		gtk_window_set_title(GTK_WINDOW(cd_configure_win),
				"CD Reader Configuration");
		gtk_window_set_policy(GTK_WINDOW(cd_configure_win),
				FALSE, FALSE, FALSE);
		gtk_window_set_position(GTK_WINDOW(cd_configure_win),
				GTK_WIN_POS_MOUSE);
		gtk_container_border_width(GTK_CONTAINER(cd_configure_win), 10);

		win_vbox = gtk_vbox_new(FALSE, 10);
		gtk_container_add(GTK_CONTAINER(cd_configure_win), win_vbox);

		notebook = gtk_notebook_new();
		gtk_box_pack_start(GTK_BOX(win_vbox), notebook, TRUE, TRUE, 0);

		box = gtk_vbox_new(FALSE, 5);
		gtk_container_set_border_width(GTK_CONTAINER(box), 5);

		frame = gtk_frame_new("CDDB:");
		gtk_box_pack_start(GTK_BOX(box),
					frame, FALSE, FALSE, 0);

		gtk_widget_show(box);
		gtk_notebook_append_page(GTK_NOTEBOOK(notebook),
					box, gtk_label_new("CDDB"));

		table = gtk_table_new(2, 4, FALSE);
		gtk_container_set_border_width(GTK_CONTAINER(table), 5);
		gtk_container_add(GTK_CONTAINER(frame), table);
		gtk_widget_show(frame);

		label = gtk_label_new("Local dir:");
		gtk_misc_set_alignment(GTK_MISC(label), 1.0, 0.5);
		gtk_table_attach(GTK_TABLE(table), label,
				0, 1, 0, 1, GTK_FILL, GTK_FILL, 5, 5);
		gtk_widget_show(label);

		cddb_dir_entry = gtk_entry_new();
		gtk_entry_set_text(GTK_ENTRY(cddb_dir_entry), cd_cfg.cddb_dir);
		gtk_table_attach(GTK_TABLE(table), cddb_dir_entry, 1, 2,
				0, 1, GTK_FILL|GTK_EXPAND, GTK_FILL, 5, 5);
		gtk_widget_show(cddb_dir_entry);

		cddb_auto = gtk_check_button_new_with_label(
				"Automatically connect to CDDB server");
		gtk_table_attach(GTK_TABLE(table), cddb_auto, 0, 2,
				1, 2, GTK_FILL, GTK_FILL, 5, 5);
		if (cd_cfg.cddb_auto)
			gtk_toggle_button_set_active(
					GTK_TOGGLE_BUTTON(cddb_auto), TRUE);
		gtk_widget_show(cddb_auto);

		cddb_choice_one = gtk_check_button_new_with_label(
				"Ask for choice even if there is only one");
		gtk_table_attach(GTK_TABLE(table), cddb_choice_one, 0, 2,
				2, 3, GTK_FILL, GTK_FILL, 5, 5);
		if (cd_cfg.cddb_choice_one)
			gtk_toggle_button_set_active(
					GTK_TOGGLE_BUTTON(cddb_choice_one), TRUE);
		gtk_widget_show(cddb_choice_one);

		label = gtk_label_new("Server:");
		gtk_misc_set_alignment(GTK_MISC(label), 1.0, 0.5);
		gtk_table_attach(GTK_TABLE(table), label,
				0, 1, 3, 4, GTK_FILL, GTK_FILL, 5, 5);
		gtk_widget_show(label);

		cddb_server = gtk_entry_new();
		gtk_entry_set_text(GTK_ENTRY(cddb_server), cd_cfg.cddb_server);
		gtk_table_attach(GTK_TABLE(table), cddb_server, 1, 2,
				3, 4, GTK_FILL|GTK_EXPAND, GTK_FILL, 5, 5);
		gtk_widget_show(cddb_server);

		label = gtk_label_new("Port:");
		gtk_misc_set_alignment(GTK_MISC(label), 1.0, 0.5);
		gtk_table_attach(GTK_TABLE(table), label,
				0, 1, 4, 5, GTK_FILL, GTK_FILL, 5, 5);
		gtk_widget_show(label);

		cddb_port = gtk_entry_new();
		gtk_entry_set_text(GTK_ENTRY(cddb_port),
					port_to_service(cd_cfg.cddb_port));
		gtk_table_attach(GTK_TABLE(table), cddb_port, 1, 2,
				4, 5, GTK_FILL|GTK_EXPAND, GTK_FILL, 5, 5);
		gtk_widget_show(cddb_port);

		label = gtk_label_new("CGI path (HTTP):");
		gtk_misc_set_alignment(GTK_MISC(label), 1.0, 0.5);
		gtk_table_attach(GTK_TABLE(table), label,
				0, 1, 5, 6, GTK_FILL, GTK_FILL, 5, 5);
		gtk_widget_show(label);

		cddb_cgi = gtk_entry_new();
		gtk_entry_set_text(GTK_ENTRY(cddb_cgi), cd_cfg.cddb_cgi);
		gtk_table_attach(GTK_TABLE(table), cddb_cgi, 1, 2,
				5, 6, GTK_FILL|GTK_EXPAND, GTK_FILL, 5, 5);
		gtk_widget_show(cddb_cgi);

		/*\ PROTO \*/
		label = gtk_button_new_with_label("Show CDDB protocol trace");
		gtk_signal_connect(GTK_OBJECT(label), "clicked",
				GTK_SIGNAL_FUNC(proto_win_show), NULL);
		gtk_table_attach(GTK_TABLE(table), label, 0, 2, 6, 7,
					GTK_FILL, GTK_FILL, 5, 5);
		gtk_widget_show(label);
		/*\ PROTO \*/

		gtk_widget_show(table);

		pbox = gtk_vbox_new(FALSE, 5);
		gtk_container_set_border_width(GTK_CONTAINER(pbox), 5);
		gtk_widget_show(pbox);

		gtk_notebook_append_page(GTK_NOTEBOOK(notebook),
					pbox, gtk_label_new("Options"));

		frame = gtk_frame_new("Options:");
		gtk_box_pack_start(GTK_BOX(pbox), frame, FALSE, FALSE, 0);

		box = gtk_vbox_new(FALSE, 5);
		gtk_container_add(GTK_CONTAINER(frame), box);
		gtk_widget_show(frame);

		opt_dtitle = gtk_check_button_new_with_label(
				"Show Disc title in playlist");
		gtk_box_pack_start(GTK_BOX(box), opt_dtitle, FALSE, FALSE, 0);
		if (cd_cfg.dtitle)
			gtk_toggle_button_set_active(
					GTK_TOGGLE_BUTTON(opt_dtitle), TRUE);

		gtk_widget_show(opt_dtitle);

		opt_playorder = gtk_check_button_new_with_label(
				"Save playlist order in database");
		gtk_box_pack_start(GTK_BOX(box), opt_playorder, FALSE, FALSE, 0);
		if (cd_cfg.playorder)
			gtk_toggle_button_set_active(
					GTK_TOGGLE_BUTTON(opt_playorder), TRUE);

		gtk_widget_show(opt_playorder);
		gtk_widget_show(box);

		frame = gtk_frame_new("Title format:");
		gtk_box_pack_start(GTK_BOX(pbox), frame, FALSE, FALSE, 0);
		gtk_widget_show(frame);

		box = gtk_vbox_new(FALSE, 5);
		gtk_container_add(GTK_CONTAINER(frame), box);
		gtk_widget_show(box);

		format_entry = gtk_entry_new();
		gtk_entry_set_text(GTK_ENTRY(format_entry), cd_cfg.format);
		gtk_box_pack_start(GTK_BOX(box),
					format_entry, TRUE, FALSE, 0);
		gtk_widget_show(format_entry);

		label = gtk_label_new(
			"%p = Performer/Artist        %a = Album\n"
			"%t = Track title        %n = Track number");
		gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_LEFT);
		gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.0);
		gtk_box_pack_start(GTK_BOX(box), label, FALSE, FALSE, 0);
		gtk_widget_show(label);

		frame = gtk_frame_new("Default CD Device:");
		gtk_box_pack_start(GTK_BOX(pbox), frame, FALSE, FALSE, 0);
		gtk_widget_show(frame);

		box = gtk_vbox_new(FALSE, 5);
		gtk_container_add(GTK_CONTAINER(frame), box);
		gtk_widget_show(box);

		device_entry = gtk_entry_new();
		gtk_entry_set_text(GTK_ENTRY(device_entry), cd_cfg.cd_device);
		gtk_box_pack_start(GTK_BOX(box),
					device_entry, TRUE, FALSE, 0);
		gtk_widget_show(device_entry);

		label = gtk_button_new_with_label("Add CD to playlist");
		gtk_signal_connect(GTK_OBJECT(label), "clicked",
				GTK_SIGNAL_FUNC(add_default_cd_device), NULL);
		gtk_box_pack_start(GTK_BOX(box), label, FALSE, FALSE, 0);
		gtk_widget_show(label);

		label = gtk_label_new(
			"You can add a CD manually by selecting the\n"
			"device entry in the add-file dialog, or by\n"
			"typing it in the add-URL dialog.");
		gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_LEFT);
		gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.0);
		gtk_box_pack_start(GTK_BOX(box), label, FALSE, FALSE, 0);
		gtk_widget_show(label);

		pbox = gtk_vbox_new(FALSE, 5);
		gtk_container_set_border_width(GTK_CONTAINER(pbox), 5);
		gtk_widget_show(pbox);

		gtk_notebook_append_page(GTK_NOTEBOOK(notebook),
					pbox, gtk_label_new("Output"));

		frame = gtk_frame_new("Output mode:");
		gtk_box_pack_start(GTK_BOX(pbox), frame, FALSE, FALSE, 0);
		gtk_widget_show(frame);

		box = gtk_vbox_new(FALSE, 5);
		gtk_container_add(GTK_CONTAINER(frame), box);
		gtk_widget_show(box);

		out_card = gtk_radio_button_new_with_label(NULL,
				"Read Digital CD Audio");
		out_cdrom = gtk_radio_button_new_with_label(
			gtk_radio_button_group(GTK_RADIO_BUTTON(out_card)),
				"Play Audio CD Directly");

		gtk_signal_connect(GTK_OBJECT(out_cdrom), "clicked",
			GTK_SIGNAL_FUNC(set_vol_sensitive), NULL);
		gtk_signal_connect(GTK_OBJECT(out_card), "clicked",
			GTK_SIGNAL_FUNC(set_vol_sensitive), NULL);

		gtk_box_pack_start(GTK_BOX(box), out_card, FALSE, FALSE, 0);
		gtk_box_pack_start(GTK_BOX(box), out_cdrom, FALSE, FALSE, 0);

		gtk_widget_show(out_card);
		gtk_widget_show(out_cdrom);

		frame = gtk_frame_new("Volume setting:");
		gtk_box_pack_start(GTK_BOX(pbox), frame, FALSE, FALSE, 0);
		gtk_widget_show(frame);

		box = gtk_vbox_new(5, FALSE);
		gtk_container_add(GTK_CONTAINER(frame), box);
		gtk_widget_show(frame);

		volume_oss = gtk_radio_button_new_with_label(NULL, "OSS Mixer");
		gtk_box_pack_start(GTK_BOX(box), volume_oss, FALSE, FALSE, 0);
#if !defined(HAVE_SYS_SOUNDCARD_H) && !defined(HAVE_MACHINE_SOUNDCARD_H)
		gtk_widget_set_sensitive(volume_oss, FALSE);
#endif
		volume_drive = gtk_radio_button_new_with_label_from_widget(
				GTK_RADIO_BUTTON(volume_oss), "CDROM drive");
		gtk_box_pack_start(GTK_BOX(box), volume_drive, FALSE, FALSE, 0);
		gtk_widget_show(box);

		gtk_widget_show(volume_oss);
		gtk_widget_show(volume_drive);

		box = gtk_hbox_new(FALSE, 5);
		gtk_box_pack_start(GTK_BOX(pbox), box, FALSE, FALSE, 0);
		gtk_widget_show(box);

		label = gtk_label_new("Cdrom speed:");
		gtk_box_pack_start(GTK_BOX(box), label, FALSE, FALSE, 0);
		gtk_widget_show(label);

		cdrom_speed = gtk_adjustment_new(cd_cfg.cdrom_speed,
				0, 666, 1, 1, 1);
		spin = gtk_spin_button_new(
				GTK_ADJUSTMENT(cdrom_speed), 8, 0);
		gtk_box_pack_start(GTK_BOX(box), spin, FALSE, FALSE, 0);
		gtk_widget_show(spin);

		set_vol_sensitive();
		if (cd_cfg.out_cdrom) {
			gtk_toggle_button_set_active(
					GTK_TOGGLE_BUTTON(out_cdrom), TRUE);
		} else {
			gtk_toggle_button_set_active(
					GTK_TOGGLE_BUTTON(out_card), TRUE);
		}
		if (cd_cfg.use_oss_mixer)
			gtk_toggle_button_set_active(
					GTK_TOGGLE_BUTTON(volume_oss), TRUE);
		else
			gtk_toggle_button_set_active(
					GTK_TOGGLE_BUTTON(volume_drive), TRUE);

		gtk_widget_show(notebook);

		bbox = gtk_hbutton_box_new();
		gtk_button_box_set_layout(GTK_BUTTON_BOX(bbox),
						GTK_BUTTONBOX_END);
		gtk_button_box_set_spacing(GTK_BUTTON_BOX(bbox), 5);
		gtk_box_pack_start(GTK_BOX(win_vbox), bbox, FALSE, FALSE, 0);

		ok = gtk_button_new_with_label("Ok");
		gtk_signal_connect(GTK_OBJECT(ok), "clicked",
				GTK_SIGNAL_FUNC(cd_configurewin_ok_cb), NULL);
		GTK_WIDGET_SET_FLAGS(ok, GTK_CAN_DEFAULT);
		gtk_box_pack_start(GTK_BOX(bbox), ok, TRUE, TRUE, 0);
		gtk_widget_show(ok);
		gtk_widget_grab_default(ok);

		cancel = gtk_button_new_with_label("Cancel");
		gtk_signal_connect_object(GTK_OBJECT(cancel),
				"clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy),
				GTK_OBJECT(cd_configure_win));
		GTK_WIDGET_SET_FLAGS(cancel, GTK_CAN_DEFAULT);
		gtk_box_pack_start(GTK_BOX(bbox), cancel, TRUE, TRUE, 0);
		gtk_widget_show(cancel);

		gtk_widget_show(bbox);

		gtk_widget_show(win_vbox);
		gtk_widget_show(cd_configure_win);
	}
}
