/*
 *   xmcd - Motif(tm) CD Audio Player
 *
 *   Copyright (C) 1993-2000  Ti Kan
 *   E-mail: ti@amb.org
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifndef LINT
static char *_help_c_ident_ = "@(#)help.c	6.65 99/12/27";
#endif

#include "common_d/appenv.h"
#include "common_d/util.h"
#include "common_d/patchlevel.h"
#include "xmcd_d/xmcd.h"
#include "xmcd_d/widget.h"
#include "xmcd_d/callback.h"
#include "xmcd_d/cdfunc.h"
#include "xmcd_d/help.h"
#include "zlib.h"

extern appdata_t	app_data;
extern widgets_t	widgets;
extern FILE		*errfp;


STATIC wname_t		wname[] = {
    { &widgets.main.mode_btn, 		"Mode.btn",	HELP_XLAT_1	},
    { &widgets.main.lock_btn, 		"Main.cbx",	HELP_XLAT_1	},
    { &widgets.main.repeat_btn, 	"Main.cbx",	HELP_XLAT_1	},
    { &widgets.main.shuffle_btn, 	"Main.cbx",	HELP_XLAT_1	},
    { &widgets.main.eject_btn, 		"Eject.btn",	HELP_XLAT_1	},
    { &widgets.main.quit_btn, 		"Quit.btn",	HELP_XLAT_1	},
    { &widgets.main.dbprog_btn, 	"DbProg.btn",	HELP_XLAT_1	},
    { &widgets.main.options_btn, 	"Options.btn",	HELP_XLAT_1	},
    { &widgets.main.time_btn, 		"Time.btn",	HELP_XLAT_1	},
    { &widgets.main.ab_btn,	 	"Ab.btn",	HELP_XLAT_1	},
    { &widgets.main.sample_btn, 	"Sample.btn",	HELP_XLAT_1	},
    { &widgets.main.keypad_btn, 	"Keypad.btn",	HELP_XLAT_1	},
    { &widgets.main.wwwwarp_btn, 	"WWWwarp.btn",	HELP_XLAT_1	},
    { &widgets.main.level_scale, 	"Level.scl",	HELP_XLAT_1	},
    { &widgets.main.playpause_btn, 	"PlayPaus.btn",	HELP_XLAT_1	},
    { &widgets.main.stop_btn, 		"Stop.btn",	HELP_XLAT_1	},
    { &widgets.main.prevdisc_btn, 	"PrevDisc.btn",	HELP_XLAT_1	},
    { &widgets.main.nextdisc_btn, 	"NextDisc.btn",	HELP_XLAT_1	},
    { &widgets.main.prevtrk_btn, 	"PrevTrk.btn",	HELP_XLAT_1	},
    { &widgets.main.nexttrk_btn, 	"NextTrk.btn",	HELP_XLAT_1	},
    { &widgets.main.previdx_btn, 	"PrevIdx.btn",	HELP_XLAT_1	},
    { &widgets.main.nextidx_btn, 	"NextIdx.btn",	HELP_XLAT_1	},
    { &widgets.main.rew_btn, 		"Rew.btn",	HELP_XLAT_1	},
    { &widgets.main.ff_btn, 		"Ff.btn",	HELP_XLAT_1	},
    { &widgets.main.disc_ind, 		"Disc.lbl",	HELP_XLAT_1	},
    { &widgets.main.track_ind, 		"Track.lbl",	HELP_XLAT_1	},
    { &widgets.main.index_ind, 		"Index.lbl",	HELP_XLAT_1	},
    { &widgets.main.time_ind, 		"Time.lbl",	HELP_XLAT_1	},
    { &widgets.main.rptcnt_ind, 	"RptCnt.lbl",	HELP_XLAT_1	},
    { &widgets.main.dbmode_ind, 	"DbMode.lbl",	HELP_XLAT_1	},
    { &widgets.main.progmode_ind, 	"ProgMode.lbl",	HELP_XLAT_1	},
    { &widgets.main.timemode_ind, 	"TimeMode.lbl",	HELP_XLAT_1	},
    { &widgets.main.playmode_ind, 	"PlayMode.lbl",	HELP_XLAT_1	},
    { &widgets.main.dtitle_ind, 	"DiscTitl.lbl",	HELP_XLAT_1	},
    { &widgets.main.ttitle_ind, 	"TrkTitle.lbl",	HELP_XLAT_1	},
    { &widgets.keypad.keypad_ind, 	"Keypad.lbl",	HELP_XLAT_1	},
    { &widgets.keypad.radio_box, 	"KpSel.btn",	HELP_XLAT_1	},
    { &widgets.keypad.num_btn[0], 	"KpNum.btn",	HELP_XLAT_1	},
    { &widgets.keypad.num_btn[1], 	"KpNum.btn",	HELP_XLAT_1	},
    { &widgets.keypad.num_btn[2], 	"KpNum.btn",	HELP_XLAT_1	},
    { &widgets.keypad.num_btn[3], 	"KpNum.btn",	HELP_XLAT_1	},
    { &widgets.keypad.num_btn[4], 	"KpNum.btn",	HELP_XLAT_1	},
    { &widgets.keypad.num_btn[5], 	"KpNum.btn",	HELP_XLAT_1	},
    { &widgets.keypad.num_btn[6], 	"KpNum.btn",	HELP_XLAT_1	},
    { &widgets.keypad.num_btn[7], 	"KpNum.btn",	HELP_XLAT_1	},
    { &widgets.keypad.num_btn[8], 	"KpNum.btn",	HELP_XLAT_1	},
    { &widgets.keypad.num_btn[9], 	"KpNum.btn",	HELP_XLAT_1	},
    { &widgets.keypad.clear_btn, 	"KpClear.btn",	HELP_XLAT_1	},
    { &widgets.keypad.enter_btn, 	"KpEnter.btn",	HELP_XLAT_1	},
    { &widgets.keypad.warp_lbl, 	"KpWarp.scl",	HELP_XLAT_1	},
    { &widgets.keypad.warp_scale, 	"KpWarp.scl",	HELP_XLAT_1	},
    { &widgets.keypad.cancel_btn, 	"KpCancel.btn",	HELP_XLAT_1	},
    { &widgets.options.load_chkbox,	"OpLoad.cbx",	HELP_XLAT_1	},
    { &widgets.options.load_radbox,	"OpLoad.rbx",	HELP_XLAT_1	},
    { &widgets.options.exit_radbox,	"OpExit.rbx",	HELP_XLAT_1	},
    { &widgets.options.done_chkbox,	"OpDone.cbx",	HELP_XLAT_1	},
    { &widgets.options.eject_chkbox,	"OpEject.cbx",	HELP_XLAT_1	},
    { &widgets.options.chg_chkbox, 	"OpChgr.cbx",	HELP_XLAT_1	},
    { &widgets.options.chroute_radbox,	"OpChRt.rbx",	HELP_XLAT_1	},
    { &widgets.options.vol_radbox, 	"OpVolTpr.rbx",	HELP_XLAT_1	},
    { &widgets.options.bal_lbl, 	"OpBal.scl",	HELP_XLAT_1	},
    { &widgets.options.bal_scale, 	"OpBal.scl",	HELP_XLAT_1	},
    { &widgets.options.ball_lbl, 	"OpBal.scl",	HELP_XLAT_1	},
    { &widgets.options.balr_lbl, 	"OpBal.scl",	HELP_XLAT_1	},
    { &widgets.options.balctr_btn, 	"OpBalCtr.btn",	HELP_XLAT_1	},
    { &widgets.options.reset_btn, 	"OpReset.btn",	HELP_XLAT_1	},
    { &widgets.options.save_btn, 	"OpSave.btn",	HELP_XLAT_1	},
    { &widgets.options.ok_btn,	 	"OpOk.btn",	HELP_XLAT_1	},
    { &widgets.dbprog.discid_ind, 	"DiscId.lbl",	HELP_XLAT_1	},
    { &widgets.dbprog.tottime_ind, 	"DpTotTim.lbl",	HELP_XLAT_1	},
    { &widgets.dbprog.dlist_btn, 	"DpDList.btn",	HELP_XLAT_1	},
    { &widgets.dbprog.dtitle_txt, 	"DpDTitle.txw",	HELP_XLAT_1	},
    { &widgets.dbprog.extd_btn, 	"DpDExt.btn",	HELP_XLAT_1	},
    { &widgets.dbprog.trk_list, 	"DpTrk.lsw",	HELP_XLAT_2	},
    { &widgets.dbprog.addpgm_btn, 	"DpAddPgm.btn",	HELP_XLAT_1	},
    { &widgets.dbprog.clrpgm_btn, 	"DpClrPgm.btn",	HELP_XLAT_1	},
    { &widgets.dbprog.radio_box, 	"DpTimSel.btn",	HELP_XLAT_1	},
    { &widgets.dbprog.ttitle_txt, 	"DpTTitle.txw",	HELP_XLAT_1	},
    { &widgets.dbprog.extt_btn, 	"DpTExt.btn",	HELP_XLAT_1	},
    { &widgets.dbprog.pgmseq_txt, 	"DpPgmSeq.txw",	HELP_XLAT_1	},
    { &widgets.dbprog.rmtdsbl_btn, 	"DpRmDsbl.btn",	HELP_XLAT_1	},
    { &widgets.dbprog.submit_btn, 	"DpSubmit.btn",	HELP_XLAT_1	},
    { &widgets.dbprog.savedb_btn, 	"DpSave.btn",	HELP_XLAT_1	},
    { &widgets.dbprog.linkdb_btn, 	"DpLink.btn",	HELP_XLAT_1	},
    { &widgets.dbprog.loaddb_btn, 	"DpLoad.btn",	HELP_XLAT_1	},
    { &widgets.dbprog.cancel_btn, 	"DpCancel.btn",	HELP_XLAT_1	},
    { &widgets.dlist.type_opt, 		"DlType.opt",	HELP_XLAT_1	},
    { &widgets.dlist.disc_list, 	"DlDisc.lsw",	HELP_XLAT_2	},
    { &widgets.dlist.show_btn, 		"DlShow.btn",	HELP_XLAT_1	},
    { &widgets.dlist.goto_btn, 		"DlChgTo.btn",	HELP_XLAT_1	},
    { &widgets.dlist.del_btn, 		"DlDel.btn",	HELP_XLAT_1	},
    { &widgets.dlist.delall_btn, 	"DlDelAll.btn",	HELP_XLAT_1	},
    { &widgets.dlist.rescan_btn, 	"DlReScan.btn",	HELP_XLAT_1	},
    { &widgets.dlist.cancel_btn, 	"DlCancel.btn",	HELP_XLAT_1	},
    { &widgets.dbextd.disc_txt, 	"DdDisc.txw",	HELP_XLAT_1	},
    { &widgets.dbextd.ok_btn, 		"DdOk.btn",	HELP_XLAT_1	},
    { &widgets.dbextd.clear_btn, 	"DdClr.btn",	HELP_XLAT_1	},
    { &widgets.dbextd.cancel_btn, 	"DdCancel.btn",	HELP_XLAT_1	},
    { &widgets.dbextt.prev_btn, 	"DtDir.btn",	HELP_XLAT_1	},
    { &widgets.dbextt.next_btn, 	"DtDir.btn",	HELP_XLAT_1	},
    { &widgets.dbextt.autotrk_btn, 	"DtAutoTr.btn",	HELP_XLAT_1	},
    { &widgets.dbextt.trk_txt, 		"DtTrack.txw",	HELP_XLAT_1	},
    { &widgets.dbextt.ok_btn, 		"DtOk.btn",	HELP_XLAT_1	},
    { &widgets.dbextt.clear_btn, 	"DtClr.btn",	HELP_XLAT_1	},
    { &widgets.dbextt.cancel_btn, 	"DtCancel.btn",	HELP_XLAT_1	},
    { &widgets.dirsel.dir_list, 	"DsDir.lsw",	HELP_XLAT_2	},
    { &widgets.dirsel.ok_btn, 		"DsOk.btn",	HELP_XLAT_1	},
    { &widgets.dirsel.cancel_btn, 	"DsCancel.btn",	HELP_XLAT_1	},
    { &widgets.linksel.link_list, 	"LsLink.lsw",	HELP_XLAT_2	},
    { &widgets.linksel.ok_btn, 		"LsOk.btn",	HELP_XLAT_1	},
    { &widgets.linksel.cancel_btn, 	"LsCancel.btn",	HELP_XLAT_1	},
    { &widgets.wwwwarp.help_btn, 	"Help.btn",	HELP_XLAT_1	},
    { &widgets.wwwwarp.sel_radbox, 	"WwSelect.rbx",	HELP_XLAT_1	},
    { &widgets.wwwwarp.srchsite_opt,	"WwSearch.opt",	HELP_XLAT_1	},
    { &widgets.wwwwarp.go_btn, 		"WwGo.btn",	HELP_XLAT_1	},
    { &widgets.wwwwarp.cancel_btn, 	"WwCancel.btn",	HELP_XLAT_1	},
    { &widgets.help.topic_opt, 		"HpTopic.opt",	HELP_XLAT_1	},
    { &widgets.help.help_txt, 		"HpText.txw",	HELP_XLAT_1	},
    { &widgets.help.about_btn, 		"HpAbout.btn",	HELP_XLAT_1	},
    { &widgets.help.cancel_btn, 	"HpCancel.btn",	HELP_XLAT_1	},
    { NULL, 				NULL,		0		},
};

STATIC doc_topic_t	*dochead,
			*doctail;


/***********************
 *  internal routines  *
 ***********************/

/*
 * help_docinit
 *	Initialize the documentation topics list.
 *
 * Args:
 *	None.
 *
 * Return:
 *	Nothing.
 */
STATIC void
help_docinit(void)
{
	DIR		*dp;
	struct dirent	*de;
	doc_topic_t	*p;
	struct stat	stbuf;
	char		docdir[FILE_PATH_SZ],
			fname[FILE_PATH_SZ];

	if (app_data.libdir == NULL)
		/* shrug */
		return;

	(void) sprintf(docdir, DOCFILE_PATH, app_data.libdir);
	if ((dp = OPENDIR(docdir)) == NULL) {
		DBGPRN(errfp, "Cannot open %s, no topics added.\n", docdir);
		return;
	}

	while ((de = READDIR(dp)) != NULL) {
		/* Skip ".", ".." and dot files */
		if (de->d_name[0] == '.')
			continue;

		(void) sprintf(fname, "%s%s", docdir, de->d_name);
		if (stat(fname, &stbuf) < 0)
			continue;

		/* Skip non-regular files */
		if (!S_ISREG(stbuf.st_mode))
			continue;

		p = (doc_topic_t *) MEM_ALLOC(
			"doc_topic_t",
			sizeof(doc_topic_t)
		);
		if (p == NULL) {
			(void) CLOSEDIR(dp);
			CD_FATAL(app_data.str_nomemory);
			return;
		}
		p->next = NULL;
		if ((strlen(de->d_name) > 4) && 
		  ! strcmp(".gz", &(de->d_name[strlen(de->d_name)-3])))
			de->d_name[strlen(de->d_name)-3] = '\0';
		p->name = (char *) MEM_ALLOC(
			"p->name",
			strlen(de->d_name) + 1
		);
		if (p->name == NULL) {
			(void) CLOSEDIR(dp);
			CD_FATAL(app_data.str_nomemory);
			return;
		}
		p->path = (char *) MEM_ALLOC("p->path", strlen(fname) + 1);
		if (p->path == NULL) {
			(void) CLOSEDIR(dp);
			CD_FATAL(app_data.str_nomemory);
			return;
		}
		(void) strcpy(p->name, de->d_name);
		(void) strcpy(p->path, fname);

		if (dochead == NULL)
			dochead = doctail = p;
		else if (strcmp(p->name, "README") == 0) {
			/* Put README file on top */
			p->next = dochead;
			dochead = p;
		}
		else {
			doctail->next = p;
			doctail = p;
		}
	}

	for (p = dochead; p != NULL; p = p->next) {
		p->actbtn = XmCreatePushButton(
			widgets.help.topic_menu,
			p->name,
			NULL,
			0
		);
		XtManageChild(p->actbtn);

		register_activate_cb(p->actbtn, help_topic_sel, p);
	}

	(void) CLOSEDIR(dp);
}


/*
 * help_getname
 *	Given a widget, return the associated help file name.
 *
 * Args:
 *	w - The widget
 *
 * Return:
 *	The help file name text string.
 */
STATIC char *
help_getname(Widget w)
{
	int	i;

	for (i = 0; wname[i].widgetp != NULL; i++) {
		if (w == *(wname[i].widgetp))
			return (wname[i].hlpname);
	}
	return NULL;
}


/*
 * help_loadfile
 *	Pop up the help window and display text from the specified file.
 *
 * Args:
 *	path - The file path
 *
 * Return:
 *	Nothing.
 */
STATIC void
help_loadfile(char *path)
{
	int		bufsz = STR_BUF_SZ * 2;
	char		*tmpbuf,
			*helptext;
	FILE		*fp;
#ifndef __VMS
	pid_t		cpid;
	waitret_t	stat_val;
	int		ret,
			pfd[2];
	FILE		*wfp;

	if (PIPE(pfd) < 0) {
		DBGPRN(errfp, "help_loadfile: pipe failed (errno=%d)\n",
			errno);
		cd_beep();
		return;
	}

	switch (cpid = FORK()) {
	case 0:
		/* Child */

		/* Close un-needed pipe descriptor */
		(void) close(pfd[0]);

		/* Force uid and gid to original setting */
		if (!util_set_ougid()) {
			(void) close(pfd[1]);
			exit(1);
		}

		DBGPRN(errfp, "Help: loading %s\n", path);

		if ((fp = gzopen((gzFile) path, "r")) == NULL)
			DBGPRN(errfp, "Cannot open %s\n", path);

		if ((wfp = fdopen(pfd[1], "w")) == NULL) {
			DBGPRN(errfp,
				"help_loadfile: write pipe fdopen failed\n");
			(void) close(pfd[1]);
			exit(4);
		}

		if (fp == NULL) {
			(void) fprintf(wfp, "%s", app_data.str_nohelp);
			(void) fclose(wfp);
			exit(0);
		}

		/* Allocate temporary buffer */
		tmpbuf = (char *) MEM_ALLOC("help_loadfile_tmpbuf", bufsz);
		if (tmpbuf == NULL) {
			(void) close(pfd[1]);
			exit(2);
		}
		
		while (gzgets((gzFile) fp, tmpbuf, bufsz) != NULL)
			(void) fprintf(wfp, "%s", tmpbuf);

		(void) gzclose(fp);
		(void) fclose(wfp);

		exit(0);
		/*NOTREACHED*/

	case -1:
		DBGPRN(errfp, "help_loadfile: fork failed (errno=%d)\n",
			errno);
		(void) close(pfd[0]);
		(void) close(pfd[1]);

		cd_beep();
		return;

	default:
		/* Parent */

		/* Close un-needed pipe descriptor */
		(void) close(pfd[1]);

		if ((fp = fdopen(pfd[0], "r")) == NULL) {
			DBGPRN(errfp,
			    "help_loadfile: read pipe fdopen failed\n");
			cd_beep();
			return;
		}
		break;
	}
#else
	DBGPRN(errfp, "Help: loading %s\n", path);

	if ((fp = fopen(path, "r")) == NULL)
		DBGPRN(errfp, "Cannot open %s\n", path);
#endif	/* __VMS */

	if (fp == NULL) {
		helptext = (char *) MEM_ALLOC(
			"helptext",
			strlen(app_data.str_nohelp) + 1
		);
		if (helptext == NULL) {
			CD_FATAL(app_data.str_nomemory);
			return;
		}
		strcpy(helptext, app_data.str_nohelp);
	}
	else {
		/* Allocate temporary buffer */
		tmpbuf = (char *) MEM_ALLOC("help_tmpbuf", bufsz);
		if (tmpbuf == NULL) {
			CD_FATAL(app_data.str_nomemory);
			return;
		}

		helptext = NULL;

		while (fgets(tmpbuf, bufsz, fp) != NULL) {
			if (tmpbuf[0] == '#')
				/* Comment */
				continue;
			if (strncmp(tmpbuf, "@(#)", 4) == 0)
				/* SCCS ident */
				continue;

			if (helptext == NULL) {
				helptext = (char *) MEM_ALLOC(
					"helptext",
					strlen(tmpbuf) + 1
				);

				if (helptext != NULL)
					*helptext = '\0';
			}
			else {
				helptext = (char *) MEM_REALLOC(
					"helptext",
					helptext,
					strlen(helptext) + strlen(tmpbuf) + 1
				);
			}

			if (helptext == NULL) {
				CD_FATAL(app_data.str_nomemory);
				(void) fclose(fp);
				MEM_FREE(tmpbuf);
				return;
			}

			(void) strcat(helptext, tmpbuf);
		}

		(void) fclose(fp);
		MEM_FREE(tmpbuf);
	}

#ifndef __VMS
	/* Wait for child to finish */
	while ((ret = WAITPID(cpid, &stat_val, 0)) != cpid) {
		if (ret < 0)
			break;

		/* Service some events */
		event_loop(0);
	}
#endif

	/* Set new help text */
	XmTextSetString(widgets.help.help_txt, helptext);
	MEM_FREE(helptext);

	if (!XtIsManaged(widgets.help.form)) {
		/* Pop it up */
		XtManageChild(widgets.help.form);
	}
	else {
		/* Raise the window to the top of stack */
		XRaiseWindow(
			XtDisplay(widgets.help.form),
			XtWindow(XtParent(widgets.help.form))
		);
	}

	/* Set keyboard focus on the Cancel button */
	XmProcessTraversal(
		widgets.help.cancel_btn,
		XmTRAVERSE_CURRENT
	);
}


/***********************
 *   public routines   *
 ***********************/


/*
 * help_init
 *	Top level function to set up the help subsystem.
 *
 * Args:
 *	Nothing.
 *
 * Return:
 *	Nothing.
 */
void
help_init(void)
{
	int		i;
	XtTranslations	xtab1,
			xtab2;

	xtab1 = XtParseTranslationTable(
		"<Btn3Down>,<Btn3Up>: Help()\n"
	);
	xtab2 = XtParseTranslationTable(
		"<Btn3Down>,<Btn3Up>: PrimitiveHelp()\n"
	);

	/* Set up translations */
	for (i = 0; wname[i].widgetp != NULL; i++) {
		XtOverrideTranslations(
			*(wname[i].widgetp),
			(wname[i].xlat_typ == HELP_XLAT_1) ? xtab1 : xtab2
		);
	}

	/* Initialize documentation topics list */
	help_docinit();
}


/*
 * help_start
 *	Start up xmcd help system.
 *
 * Args:
 *	None.
 *
 * Return:
 *	Nothing.
 */
void
help_start(void)
{
	int		ret;
	pid_t		cpid;
	waitret_t	stat_val;
	char		*dirpath,
			vfile[16],
			path[FILE_PATH_SZ + 16];
	struct stat	stbuf;

	/* Popup the help window if this version of xmcd is being run
	 * by the user for the first time.
	 */

	dirpath = util_homedir(util_get_ouid());
	if (dirpath == NULL) {
		/* No home directory: shrug */
		return;
	}
	if ((int) strlen(dirpath) >= FILE_PATH_SZ) {
		CD_FATAL(app_data.str_longpatherr);
		return;
	}
	(void) sprintf(vfile, "%s-%s", PROGNAME, VERSION);
	(void) sprintf(path, USR_VINIT_PATH, dirpath, vfile);

	switch (cpid = FORK()) {
	case 0:
		/* Child process */
		DBGPRN(errfp, "\nSetting uid to %d, gid to %d\n",
			(int) util_get_ouid(), (int) util_get_ogid());

		/* Force uid and gid to original setting */
		if (setuid(util_get_ouid()) < 0 ||
		    setgid(util_get_ogid()) < 0)
			exit(1);

		if (stat(path, &stbuf) == 0)
			exit(0);

		dirpath = util_dirname(path);
		if (!util_mkdir(dirpath, 0755)) {
			DBGPRN(errfp, "help_setup: cannot mkdir %s.\n",
				dirpath);
			exit(2);
		}

		/* Create version file */
		if (creat(path, 0666) < 0) {
			DBGPRN(errfp, "help_setup: cannot creat %s.\n",
				path);
			exit(3);
		}

		exit(4);
		/*NOTREACHED*/

	case -1:
		/* fork failed */
		break;

	default:
		/* Parent: wait for child to finish */
		while ((ret = WAITPID(cpid, &stat_val, 0)) != cpid) {
			if (ret < 0)
				break;
			/* Handle some events */
			event_loop(0);
		}

		if (WIFEXITED(stat_val) && WEXITSTATUS(stat_val) != 0)
			/* Pop up help */
			help_popup(widgets.wwwwarp.help_btn);

		break;
	}
}


/*
 * help_popup
 *	Pop up the help window and display help text based on the
 *	specified widget.
 *
 * Args:
 *	w - The widget which the help info is being displayed about.
 *
 * Return:
 *	Nothing.
 */
void
help_popup(Widget w)
{
	char	hlpfile[FILE_PATH_SZ * 2],
		*hlpname;

	if ((hlpname = help_getname(w)) == NULL)
		return;

	(void) sprintf(hlpfile, HELPFILE_PATH, app_data.libdir, hlpname);

	XtVaSetValues(widgets.help.topic_opt,
		XmNmenuHistory, widgets.help.online_btn,
		NULL
	);

	/* Change to watch cursor */
	cd_busycurs(TRUE, CURS_HELP);

	/* Load the help file */
	help_loadfile(hlpfile);

	/* Change to normal cursor */
	cd_busycurs(FALSE, CURS_HELP);
}


/*
 * help_popdown
 *	Pop down the help window.
 *
 * Args:
 *	None
 *
 * Return:
 *	Nothing.
 */
void
help_popdown(void)
{
	if (XtIsManaged(widgets.help.form))
		XtUnmanageChild(widgets.help.form);
}


/* help_isactive
 *	Check if the help window is currently popped up.
 *
 * Args:
 *	None
 *
 * Return:
 *	TRUE: help currently popped up
 *	FALSE: help not currently popped up
 */
bool_t
help_isactive(void)
{
	return ((bool_t) XtIsManaged(widgets.help.form));
}


/**************** vv Callback routines vv ****************/

/*
 * help_topic_sel
 *	Help topic selector callback
 */
/*ARGSUSED*/
void
help_topic_sel(Widget w, XtPointer client_data, XtPointer call_data)
{
	doc_topic_t	*p = (doc_topic_t *)(void *) client_data;

	if (p == NULL) {
		/* Display generic help text */
		help_popup(widgets.wwwwarp.help_btn);
	}
	else if (p->actbtn == w) {
		/* Display appropriate doc file */
		help_loadfile(p->path);
	}
}


