#!/bin/sh
#
# @(#)start.sh	6.6 00/01/14
# Startup wrapper script for xmcd, cda and related programs.
# This script is used to setup the basic startup environment,
# and allows network sharing of xmcd files under different
# platforms and architectures.
#
#    xmcd  - Motif(tm) CD Audio Player
#    cda   - Command-line CD Audio Player
#
#    Copyright (C) 1993-2000  Ti Kan
#    E-mail: ti@amb.org
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
PATH=${PATH}:/sbin:/usr/sbin:/bin:/usr/bin:/etc
export PATH

if [ -z "$XMCD_LIBDIR" ]
then
	XMCD_LIBDIR=/usr/share/xmcd
	export XMCD_LIBDIR
elif [ -z "$XMCD_LIBDIR_QUIET" ]; then
  cat <<EOF >&2
Older versions of xmcd relied on the XMCD_LIBDIR environment
variable to find the location of the xmcd data directory. The
use of XMCD_LIBDIR with the current version of xmcd is not
recommended, however you currently have this variable set. If 
you really think that this is a correct setting, also set the 
XMCD_LIBDIR_QUIET variable to get rid of this warning.
EOF
  exit 2
fi

XUSERFILESEARCHPATH=$HOME/.xmcdcfg/%N%S:$XUSERFILESEARCHPATH

PROG=`(basename $0) 2>/dev/null`

export XUSERFILESEARCHPATH

exec /usr/lib/xmcd/$PROG ${1+"$@"}
