# xjadeo.spec
#
# Copyright (C) 2005, 2006 GPL
#  Luis Garrido <luisgarrido@users.sourceforge.net>
#  Robin Gareus <robin@gareus.org>
#
%define useqt4 0
%define svnbuild 1
#
#
%define name xjadeo
%define version 0.4.0.rc3
%define release 1

Name: %{name}
Summary: jack video monitor
Version: %{version}
Release: %{release}
License: GPL
Group: Application/Multimedia

URL: http://sourceforge.net/projects/xjadeo/
Vendor: Robin Gareus <robin@gareus.org>, Luis Garrido <luisgarrido@users.sourceforge.net>
Packager: Robin Gareus <robin@gareus.org>
#Icon:

# source + patches
Source: %{name}-%{version}.tar.gz
Prefix: /usr
BuildRoot: /var/tmp/%{name}-%{version}-build

# RPM info
Provides: xjadeo 
Requires: ffmpeg >= 0.4.9
Requires: jack-audio-connection-kit >= 0.100
Requires: alsa-lib >= 1.0.10
Requires: imlib >= 1.1.9
#Requires: imlib2 >= 1.3.0
Requires: lash >= 0.4.0
Requires: SDL >= 1.2.8
#Requires: portmidi >= 20041117
#Requires: libXv >= 1.0.1
#Requires: libX11 >= 1.0.0
##
## if built with message queues:
##Requires: 'librt' aka. glibc > 2.4.? + linux >= 2.6.9 (?)
##
BuildRequires:	jack-audio-connection-kit-devel >= 0.100
BuildRequires:	ffmpeg-devel >= 0.4.9
BuildRequires:	alsa-lib-devel >= 1.0.10
BuildRequires:	imlib-devel >= 1.1.13
#BuildRequires:	imlib2-devel >= 1.3.0
BuildRequires:	lash-devel >= 0.4.0
BuildRequires:	zlib-devel >= 1.2.2
BuildRequires:	SDL-devel >= 1.2.8
#Requires: libXv-devel >= 1.0.1
#Requires: libX11-devel >= 1.0.0
%if "%{useqt4}" == "1"
BuildRequires:	qt4-devel >= 4.1
BuildRequires:	qt4-x11
%else
BuildRequires:	qt-devel
%endif

%description
xjadeo is a simple video player that receives sync from jackd or MTC.

It has applications in soundtrack creation, video monitoring or any task that requires
to associate movie frames with audio events.

For instance when a jack-client (like Muse, Rosegarden or Ardour) acts as a timebase master,
xjadeo will display the video synchronized to jack transport.

xjadeo is also capable to read Midi Time Clock as an alternate sync source and comes
along with an optional GUI.

see http://xjadeo.sourceforge.net/doc/ for further information.

Authors: 
	Luis Garrido <luisgarrido@users.sourceforge.net>
	Robin Gareus <robin@gareus.org>
%prep
%setup -q
%if "%{svnbuild}" == "1"
./autogen.sh
%endif

%build
./configure \
	--prefix=%{_prefix} \
	--mandir=%{_mandir} \
	--sysconfdir=%{_sysconfdir} \
	--enable-sdl 
#%__make
make
%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT
%makeinstall
# icons
%__install -dm 755 %{buildroot}%{_datadir}/pixmaps
convert src/xjadeo/icons/xjadeo-color.xpm -resize 48x48! xjadeo.png
convert src/qt-gui/images/qjadeo -resize 48x48! qjadeo.png
%__install -m 644 xjadeo.png 	%{buildroot}%{_datadir}/pixmaps
%__install -m 644 qjadeo.png 	%{buildroot}%{_datadir}/pixmaps

# menu-entry
%__cat > %{name}.desktop << EOF
[Desktop Entry]
Name=%{name}
Comment=A simple video player that gets sync from jack
Exec=qjadeo
Icon=qjadeo
Terminal=0
Type=Application
EOF
%__install -dm 755 %{buildroot}%{_datadir}/applications
%__install -m 644 %{name}.desktop	%{buildroot}%{_datadir}/applications/%{name}.desktop
#install -m 644  %{name}.desktop	${RPM_BUILD_ROOT}%{_sysconfdir}/X11/applnk/Multimedia/

#%__install -m 644 doc/xjadeorc	%{buildroot}%{_sysconfdir}/xjadeorc
%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%doc AUTHORS COPYING ChangeLog INSTALL NEWS README TODO
%{_bindir}/%{name}
%{_bindir}/qjadeo
%{_bindir}/xjremote
%{_bindir}/xjinfo
%{_mandir}/man1
#%config %{_sysconfdir}/xjadeorc
%{_datadir}/pixmaps/xjadeo.png
%{_datadir}/pixmaps/qjadeo.png
%{_datadir}/applications/%{name}.desktop

%changelog
* Tue Nov 23 2006 Robin Gareus <x42@users.sourceforge.net>
- another draft of the spec file for version 0.3.26.

* Thu Nov 3 2005 Luis Garrido <luisgarrido@users.sourceforge.net>
- First draft of the spec file for version 0.1.1.

