#!/usr/bin/python
#
# Copyright (C) 2006, Stefano Zacchiroli <zack@debian.org>
#
# This program is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free Software
# Foundation; either version 2 of the License, or (at your option) any later
# version.
#
# $Id: get_patches.py 762 2006-09-09 14:17:16Z zack $

host='ftp.vim.org'
dir='pub/vim/patches/7.0'

import os
import re
import string

from ftplib import FTP

patch_RE = re.compile(r'^\d+\.\d+\.\d+$')

print 'connecting to %s' % host

ftp=FTP(host)
ftp.login()

patches = []

files = ftp.nlst(dir)
for f in files:
    base = os.path.basename(f)
    if patch_RE.match(base) and not os.path.isfile(base):
        print 'patch %s is missing here: retrieving it from %s ...' % (base, host)
        ftp.retrbinary('RETR %s' % f, open(base, 'w').write)
        patches.append(base)

if patches:
    print 'updating debian/README to latest upstream ...'
    ftp.retrbinary('RETR %s/README' % dir,
            open('../../debian/README', 'w').write)
    print 'adding downloaded patches to the SVN repository ...'
    os.system('svn add %s' % string.join(patches))

print 'All done.'

