#!/bin/sh

### BEGIN INIT INFO
# Provides:          thttpd
# Required-Start:    $network
# Required-Stop:     $network
# Should-Start:
# Should-Stop:
# Default-Start:     2 3 4 5
# Default-Stop:      0 1 6
# Short-Description: Starts tiny/turbo/throttling HTTP server
# Description:       thttpd is a small, fast secure webserver.
### END INIT INFO

PATH=/usr/local/sbin:/usr/local/bin:/sbin:/bin:/usr/sbin:/usr/bin
DAEMON=/usr/sbin/thttpd
NAME="web server"
DESC=thttpd

CONFFILE=/etc/thttpd/thttpd.conf
PIDFILE=/var/run/thttpd.pid
NETSTAT=/bin/netstat

test -x $DAEMON || exit 0

# Include thttpd defaults if available
if [ ! -f $CONFFILE ]
then
	exit 1
fi

set -e

case "$1" in
	start)
		echo -n "Starting $DESC: "

		if [ -f $PIDFILE ]
		then
			PID=`cat $PIDFILE`

			if ps ax | grep -q "^$PID"
			then
				echo "$NAME already running."
			else
				rm -f $PIDFILE
				$DAEMON -C $CONFFILE -i $PIDFILE
				echo "$NAME."
			fi
		else
			$DAEMON -C $CONFFILE -i $PIDFILE
			echo "$NAME."
		fi
		;;

	stop)
		echo -n "Stopping $DESC: "

		if [ -f $PIDFILE ]
		then
			PID=`cat $PIDFILE`

			if ps ax | grep -q "^$PID"
			then
				kill -10 $PID
				echo "$NAME."
			else
				echo "No $NAME found running; none killed."
			fi

			rm -f $PIDFILE
		else
			echo "No $NAME found running; none killed."
		fi
		;;

	force-stop)
		echo -n "Terminating $DESC: "

		if [ -f $PIDFILE ]
		then
			PID=`cat $PIDFILE`

			if ps ax | grep -q "^$PID"
			then
				kill -10 $PID
				echo "$NAME."
			else
				echo "No $NAME found running; none killed."
			fi

			rm -f $PIDFILE
		else
			echo "No $NAME found running; none killed."
		fi
		;;

	restart|force-reload)
		$0 stop
		sleep 1
		$0 start
		;;

	*)
		N=/etc/init.d/$NAME
		echo "Usage: $N {start|stop|restart|force-reload}" >&2
		exit 1
		;;
esac

exit 0
