/*
 * Copyright (c) 2004 SuSE Linux AG
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *  
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file COPYING); if not, write to the
 * Free Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 ****************************************************************
 */

#include <string.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>

#include "proc.h"

static unsigned long int scan_one(const char* buff, const char *key)
{
    const char *b = strstr(buff, key);
    unsigned long val = 0;

    if (!b) {
	fprintf(stderr, "ERROR: no hit for %s\n", key);
	return ~0UL;
    }
    if (sscanf(b + strlen(key), " %lu", &val) != 1)
	return 0;
    return val;
}

int read_proc(unsigned long int * const prcs_run, unsigned long int * const prcs_blked)
{
    static char StatBuf[32*1024];
    unsigned long int running, blocked;
    ssize_t n;
    int fd;

    *prcs_run = 0;
    *prcs_blked = 0;

    if ((fd = open( "/proc/stat", O_RDONLY )) < 0) {
	fprintf(stderr, "ERROR: could not open /proc/stat: %s\n", strerror(errno));
	return 1;
    }

    n = read( fd, StatBuf, (sizeof(StatBuf) - 1));
    close(fd);
    if (n < 40) {
	if (n < 0) {
	    fprintf(stderr, "ERROR: could not read /proc/stat: %s\n", strerror(errno));
	    return 1;
	}
	fprintf(stderr, "ERROR: no enough data in /proc/stat?\n");
	return 1;
    }
    StatBuf[n] = 0;
    
    /* These fields are not present in /proc/stat for 2.4 kernels */
    running = scan_one(StatBuf, "procs_running");
    blocked = scan_one(StatBuf, "procs_blocked");

    if (running == ~0UL || blocked == ~0UL)
	return 1;

    *prcs_run   = running;
    *prcs_blked = blocked;

    return 0;
}
