/*
 */

enum {
	T_READY, T_RUNNING, T_FINISHED
};

/* target nodes */
struct makenode {
	char *name;
	int num_deps;
	struct makelist *depend;
	int num_sels;
	struct makelist *select;
	int status;
	struct makenode *next;
	int interactive;
};

/* dependency and selection list nodes */
struct makelist {
	struct makenode *node;
	struct makelist *next;
};

extern int tree_entries;
extern struct makenode *tree_list;
extern char *run_action;

void parse_makefile(const char *path);
void check_run_files(const char *action, const char *prev, const char *run);

struct makenode *pickup_task(void);
void finish_task(struct makenode *n);

extern int do_splash;
extern int progress;
void init_splash(char *action);

void *xcalloc(size_t nmemb, size_t size);

void print_run_result(int *resvec, struct makenode **nodevec, const char *action);
