/* -*- c-basic-offset: 4 indent-tabs-mode: nil -*-  vi:set ts=8 sts=4 sw=4: */

#ifndef _SOUNDCARD_SELECT_H_
#define _SOUNDCARD_SELECT_H_

#include <vector>

class QLabel;
class QToolButton;
class QFrame;

#include <QString>
#include <QDialog>
#include <QGridLayout>


struct SoundcardData
{
    SoundcardData() : id(-1) { }
    SoundcardData(QString dc, int i, QString cc, QString d, QString n) :
        driverClass(dc), id(i), cardClass(cc), driver(d), name(n) { }

    QString driverClass;
    int id;
    QString cardClass;
    QString driver;
    QString name;
};


class SoundcardSelector : public QDialog
{
    Q_OBJECT

public:
    SoundcardSelector(QWidget *parent = 0, bool startup = false, bool showOptions = true);
    virtual ~SoundcardSelector();

    bool haveSoundcard() const { return !m_audioCards.empty(); }
    SoundcardData getSelectedSoundcard() { return m_selectedCard; }
    std::vector<SoundcardData> getSecondarySoundcards() const;

    enum JackOption {
        JackAuto,
        Jackd,
        Jackdmp
    };

    JackOption getJackOption() const;

    enum LatencyOption {
        LatencyAuto,
        LowLatency,
        ConservativeLatency
    };

    LatencyOption getLatencyOption() const;

    int getSampleRate() const;

    bool getUseSecondaryCards() const;
    bool getStartSynth() const;

    bool havePreviousPreference() const;
    bool changed() const;

    void addSoundcard(SoundcardData data);
    void addMIDIInterface(SoundcardData data);
    void done();

protected slots:
    void audioCardSelected();
    void advancedToggled();
    void jackOptionChanged(int);
    void latencyOptionChanged(int);
    void sampleRateChanged(QString);
    void useSecondaryChanged(int);
    void startSynthChanged(int);
    void help();

protected:
    int m_audioRow;
    QGridLayout *m_audioLayout;

    int m_midiRow;
    QGridLayout *m_midiLayout;

    bool m_advancedVisible;
    QPushButton *m_advancedButton;
    QPushButton *m_okButton;

    QFrame *m_advanced;

    QLabel *m_audioIntro;
    QLabel *m_midiIntro;

    std::vector<QToolButton *> m_audioCardButtons;
    std::vector<SoundcardData> m_audioCards;
    std::vector<SoundcardData> m_midiCards;
    SoundcardData m_selectedCard;

    std::vector<QWidget *> m_toResize;

    void updateButtons();
    void setAdvancedVisible(bool);

    static std::vector<int> m_sampleRates;
    static int m_defaultSampleRate;

    bool m_havePreviousPreference;
    bool m_previousPreferenceValid;

    QString m_rememberedCard;
    JackOption m_jackOption;
    JackOption m_initialJackOption;
    LatencyOption m_latencyOption;
    LatencyOption m_initialLatencyOption;
    int m_sampleRate;
    int m_initialSampleRate;
    bool m_useSecondary;
    bool m_initialUseSecondary;
    bool m_startSynth;
    bool m_initialStartSynth;
};


#endif
