/***************************************************************************
                          pppstatus.h  -  description
                             -------------------
    begin                : Mar 13 1999
    copyright            : (C) 2000 by Gabriel Montenegro
    email                : johnpetrucci@users.sourceforge.net
 
 ***************************************************************************
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or      *
 *  (at your option) any later version.                                    *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful,        *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          *
 *  GNU General Public License for more details.                           *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the Free Software            *
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,  *
 *  USA.                                                                   *
 *                                                                         *
 ***************************************************************************/

#define VERSION "0.4.2"
#define AUTHOR "Gabriel Montenegro"

#define LED_RX    1
#define LED_TX    2
#define LED_POWER 3

#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif

/* was #define ROOTandRUNONBOOTcfgPATH "/var/log" JGH */
#define GLOBALCFGDIR "/etc/pppstatus"
#define GLOBALLOGDIR "/var/log/pppstatus"
#define GLOBALCOSTDIR "/var/log/pppstatus"
#define TOTAL_COST_FILE "total.costs"
#define PATH_PROC_NET_ROUTE "/proc/net/route"
#define RC_FILENAME "pppstatus.cfg"
#define PPP_PID_PATH "/var/run/"
#define MAIL_PATH "/var/spool/mail/"
#define PPP_UP_PATH "/var/run/"

/* This will put the statistic coordinates (THIS WILL WORK WITH 0, 1, 2 and 3) */

typedef struct statvline
{
  int hline[76];		/* This will be the horzontal lines */
}
statvline[10];			/* ... and this will be vertical lines */
statvline graph;

typedef struct theme
{
  int background;
  int border[2];
  int labels[2];
  int data[2];
  int version[2];
  int outgoing[2];
  int ingoing[2];
  int intersection[2];
  int power_led[4];
}
theme;
theme colors;

typedef struct c
{
  float minutes;
  float costs[3][24];
  float total[2];
  float poc_cost;
  short int poc;
  unsigned long next_check;
  char costs_file[256];
  char monetary_sign[4];
}
c;
c costs;


/* This structure stays the INFO variables */
typedef struct DataStats
{
  unsigned long rx_packets;	/* This is for RX LED/TX PACKETS INFO */
  unsigned long rx_errors;	/* Shows how many erros has ocurred on receive */
  double rx_bytes;		/* How many bytes has received */
  /* --------------------------------------------------------------------- */
  unsigned long tx_packets;	/* This is for TX LED/TX PACKETS INFO */
  unsigned long tx_errors;	/* Shows how many erros has ocurred on transmition */
  double tx_bytes;		/* How many Bytes has sent */
  /* --------------------COMPARATION-VARIABLES---------------------------- */
  unsigned long rx_packets_comp;
  unsigned long tx_packets_comp;
  double rx_bytes_comp;
  double tx_bytes_comp;
  /* --------------------------------------------------------------------- */
  unsigned long connect_time;
  unsigned long current_time;
  float top_speed;
  int online_days;
  int online_hour;
  int online_min;
  int online_sec;
  char *ip_addr_rtrn;
  char user_box[32];
  int email;
  char start_time;
}
DataStats;
DataStats stats;

struct stat st;

/* Functions Declarations */
char *opt_analiser (char *in);
char *get_option (char *in);
int stc (short int cm, short int cy);
void check_costs_file (void);
void get_costs (void);
void center (short int line, char *strg, ...);
void close_ppps (char *errmsg, ...);
void chcolor (int x, int y);
void the_face (void);
void update_stat (int reload);
void update_info (void);
void led_on (unsigned int who);
void led_off (unsigned int who);
int is_online (short int force, short int only_check);
int get_stat (void);
void get_ppp_stats (struct ppp_stats *cur);
void clear_info (void);
void show_usage (char *name);
void get_time ();
void ip_address (int display);
int log (int quit);
void check_email (void);
static void signal_cleanup (int x);
static void signal_hup (int x);
/* End of Functions Declarations */

/* Variables Declarations */
char home[1024], logdir[1024], costdir[1024], pidfile[1024];
char *interface = "ppp0";	/* ppp0... Default interface */
char var_run_pid[30] = "/var/run/ppp0.pid";
char mth[12][4] = { "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug",
  "Sep", "Oct", "Nov", "Dec"
};
int ppp_s = -1;
#define CHAR ACS_BLOCK		/* Bars character    was 'int CHAR = 219;' JGH Aug 8 2001 */
int sec_value = 0;
int min_value = 0;
float SPEED[2] = { 33.6, 33.6 };
unsigned short int first = 1;
unsigned short int VGA = 1;
unsigned short int GRAPHIC_BRIGHT = 0;
unsigned short int con = 0;
unsigned short int discon = 0;
unsigned short int disconnected = 0;
unsigned short int check = 0;
unsigned short int check_costs = 0;
static unsigned short int curmon = 12;	/*undefined yet */
static unsigned short int curyear = 12;	/*undefined yet */
unsigned short int online = 0;
char data_type[6] = "bytes";
/* End of Variables Declarations */
