#! /usr/bin/perl
'di ';
'ds 00 \"';
'ig 00 ';
#
# This is a mkfontdir for TrueType font files.
$rcsid = q$Id: mkttfdir.pl,v 1.19 1998/12/14 05:12:33 jam Exp $;
#
# Copyright (c) 1998  Kazushi (Jam) Marukawa
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice in the documentation and/or other materials provided with 
#    the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY
# EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
# PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT 
# OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR 
# BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
# WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
# OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN 
# IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#

use FreeTypeWrapper;
use Getopt::Std;

my %opts;
getopts('dhejoi:w', \%opts);

die "Usage: $0 [-dheo] [-inum] [directory-name...]
    -d: dump fonts.dir screen instead of fonts.dir file
    -h: show this help
    -e: force ISO8859-1 encoding (for wrong header fonts)
    -j: force JISX 0208, JISX 0201 and ISO8859-1  encoding
        (for wrong header fonts)
    -o: add -o- fonts for each font
    -i num: value for auto-italic option (default 0.2)
    -w: list any files for which no entry exists in fonts.dir
" if $opts{'h'};
$ai = 0.2;
$ai = $opts{'i'} if defined $opts{'i'};

push @ARGV, "." unless @ARGV;

my %achVendIDList =
    ( "ACG" => "Agfa",
      "ADBE" => "Adobe",	# reg, http://www.adobe.com/type/
      "AGFA" => "AGFA Compugraphic", # according to MS docs,
				# http://www.agfahome.com/agfatype/
#     "ALTS" => "Altsys/Macromedia",
			# http://www.microsoft.com/typography/links/fog.htm
      "ALTS" => "misc",		# Because I couldn't found exact Altsys fonts
      "APPL" => "Apple",	# reg
      "B&H" => "Bigelow & Holmes",
      "BERT" => "Berthold",
      "BITM" => "Bitmap Software",
      "BITS" => "Bitstream",	# reg, http://www.bitstream.com
      "C&C" => "Carter & Cone",
      "CANO" => "Canon",	# http://www.canon.com
      "CTDL" => "China Type Design Ltd.",
      "DSCI" => "Design Science, Inc.",
      "DYNA" => "DynaLab",	# http://www.dynalab.co.jp/
      "DTC" => "Digital Typeface Corp.",
      "EDGE" => "Rivers Edge Corp.", # http://www.riversedge.com/
      "ELSE" => "Elseware",	# http://www.fonts.com/
      "EPSN" => "Epson",	# http://www.epson.co.jp/
      "ERAM" => "Eraman",
      "FBI" => "The Font Bureau, Inc.", # http://www.fontbureau.com/
      "FJ" => "Fujitsu",	# http://www.fujitsu.co.jp/
      "GALA" => "Gal=E1pagos Design Group, Inc.",
				# http://www.galapagosdesign.com/
      "GLYF" => "Glyph Systems",
      "GPI" => "Gamma Productions, Inc", # http://www.gammapro.com/
      "HP" => "Hewlett-Packard", # http://www.fonts.com/
      "HY" => "Han Yang System",
      "IBM" => "IBM",		# reg, http://www.ibm.com/
      "IDF" => "International Digital Fonts",
      "IMPR" => "Impress",	# reg, http://www.impress.co.jp
      "KATF" => "Kigsley/ATF",
      "LANS" => "Lanston Type Co., Ltd.",
      "LEAF" => "Interleaf, Inc.", # http://www.ileaf.com/
      "LETR" => "Letraset",	# http://www.letraset.com/letraset/
      "LINO" => "Linotype",	# http://www.fonts.de/
      "LP" => "LetterPerfect Fonts",
      "LTRX" => "Lighttracks",
      "MACR" => "Macromedia",
			# http://www.microsoft.com/typography/links/fog.htm
      "MLGC" => "Micrologic Software",
      "MONO" => "Monotype",
			# http://www.monotype.com/html/mtname/ms_welcome.html
      "MS" => "Microsoft",	# http://www.microsoft.com/typography/
      "MT" => "Monotype",
			# http://www.monotype.com/html/mtname/ms_welcome.html
      "NEC" => "NEC",		# http://www.necsoft.co.jp/
      "PARA" => "ParaGraph Intl", # http://www.paragraph.com/
      "PRFS" => "Production First Software",
			# http://ourworld.compuserv.com/homepages/profirst/
      "QMSI" => "QMS/Imagen",	# http://www.qms.com/
      "RICO" => "Ricoh",	# http://font.ricoh.co.jp/
      "SFUN" => "Soft Union",
      "SOHO" => "Soft Horizons",
      "SWFT" => "Swfte International",
      "TILD" => "SIA Tilde",
      "UNKN" => "Unknown",
      "URW" => "URW",		# http://www.urwpp.de/
      "VLKF" => "Visualogik Technology & Design",
      "ZSFT" => "Zsoft" );

# "reg" means the XLFD name is "official" (listed in X registry)


my $font;
foreach $dir (@ARGV) {
    opendir(DIR, $dir) || die "opendir: $!\n";
    my @files = grep { (/.ttf$/i || /.ttc$/i) && -f "$dir/$_" } readdir(DIR);
    closedir DIR;

    my ($face, $name, $subname, @lines);
    foreach $filename (@files) {
	my $fn = "$dir/$filename";
	$font = FreeTypeWrapper->new($fn);
	warn "open failed: $fn\n" and next
	  unless defined $font;

	$face = $font->open_face($font);
	warn "open_face failed: $fn\n" and next
	  unless defined $face;

	my $prop = $face->TT_Get_Face_Properties();

	# Decide foundry.

	$foundry = "misc";
	$achVendID = $prop->{os2}->{achVendID};
	$achVendID =~ tr/a-z/A-Z/;
	$achVendID =~ s/(\s|\0)*$//;
	if (defined $achVendIDList{$achVendID}) {
	    $foundry = $achVendIDList{$achVendID};
	}

	if ($foundry eq "misc") {
	    $copyright = $face->lookup_allnamestring(0); # Copyright
	    $foundry = "SoftKey"
		if $copyright =~ /softkey software products, inc./i;
#	    $foundry = "DynaLab"
#		if $copyright =~ /dynalab inc./i;
#	    $foundry = "Ricoh"
#		if $copyright =~ /ricoh company,ltd./i;
#	    $foundry = "Monotype"
#		if $copyright =~ /monotype corporation/i;
#	    $foundry = "Microsoft"
#		if $copyright =~ /microsoft corporation./i;
        }

	# Decide family name.
	#  1. Try to find english family name.
	#  2. Try to find Postscript name in any languages
	#    since it will be english.
        #  3. Use family name in any languages.

	$name = $face->lookup_englishname(1); # Family Name
	$name = $face->lookup_anyname(6) # PS name
	    unless defined $name;
	$name = $face->lookup_anyname(1) # Family name
	    unless defined $name;
	if (defined $name) {
	    $family_name = $name->string;
	} else {
	    $family_name = "unknown";
	}
	$family_name =~ s/-/ /g;

	# Decide weight name.
	#  1. Try to find english subfamily name.
        #  2. Use subfamily name in any languages.

	$subname = $face->lookup_englishname(2); # SubFamily Name
	$subname = $face->lookup_anyname(2) # SubFamily Name
	    unless defined $subname;
	if (defined $subname) {
	    $weight_name = $subname->string;
	} else {
	    $weight_name = "regular";
	}
	$weight_name =~ s/-/ /g;

	$_ = $weight_name;
	if (/^regular$/i) {
	    $weight_name = "medium";
	    $slant = "r";
	} elsif (/^bold$/i) {
	    $weight_name = "bold";
	    $slant = "r";
	} elsif (/^bold italic$/i) {
	    $weight_name = "bold";
	    $slant = "i";
	} elsif (/^italic$/i) {
	    $weight_name = "medium";
	    $slant = "i";
	} else {
	    $weight_name = "medium";
	    $slant = "r";
	}

	$setwidth_name = "normal";
	$add_style_name = "";
	$pixel_size = "0";
	$point_size = "0";	# decipoints
	$resolution_x = "0";
	$resolution_y = "0";
	$spacing = "p";
	$average_width = "0";
	$charset_registry = "";
	$charset_encoding = "";

	# Mapping for especial fonts.
	$_ = "$foundry-$family_name-$weight_name-" .
	    "$slant-$setwidth_name-$add_style_name";

	# DynaLab fonts have many kinds of weight.  So use
	# a value of weight as a weight_name.
	s/(DynaLab-.*) W3-medium-/$1-W3-/;
	s/(DynaLab-.*) W4-medium-/$1-W4-/;
	s/(DynaLab-.*) W5-medium-/$1-W5-/;
	s/(DynaLab-.*) W7-medium-/$1-W7-/;
	s/(DynaLab-.*) W9-medium-/$1-W9-/;
	s/(DynaLab-.*) W12-medium-/$1-W12-/;
	# DynaLab SL (SuperLight?) weighted fonts.
	s/(DynaLab-DFMaruMoji) SL-medium-/$1-W5-/;
	# DynaLab Lt (Light?) weighted fonts.
	s/(DynaLab-DFGyoSho) Lt-medium-/$1-W3-/;
	s/(DynaLab-DFKaiSho) Lt-medium-/$1-W3-/;
	s/(DynaLab-DFSMGothic) Lt-medium-/$1-W2-/;
	s/(DynaLab-DFMaruGothic) Lt-medium-/$1-W3-/;
	# DynaLab Md (Medidum?) weighted fonts.
	s/(DynaLab-DFKaiSho) Md-medium-/$1-W5-/;
	s/(DynaLab-DFMaruGothic) Md-medium-/$1-W5-/;
	# DynaLab Bd (Bold?) weighted fonts.
	s/(DynaLab-DFKaiSho) Bd-medium-/$1-W9-/;
	s/(DynaLab-DFMaruGothic) Bd-medium-/$1-W7-/;
	s/(DynaLab-DFGiHiDEMO) Bd-medium-/$1-W7-/;
	# DynaLab SB (Super Bold?) weighted fonts.
	s/(DynaLab-DFKaiSho) SB-medium-/$1-W7-/;
	s/(DynaLab-DFLeiSho) SB-medium-/$1-W6-/;
	s/(DynaLab-DFPOP1) SB-medium-/$1-W7-/;
	# DynaLab EB, XB (Extra Bold?) weighted fonts.
	s/(DynaLab-DFGothic) EB-medium-/$1-W10-/;
	s/(DynaLab-DFKanTeiRyu) XB-medium-/$1-W8-/;
	# DynaLab UB (Ultra Bold?) weighted fonts.
	s/(DynaLab-DFGothic) UB-medium-/$1-W12-/;
	s/(DynaLab-DFKaiSho) UB-medium-/$1-W12-/;
	s/(DynaLab-DFMincho) UB-medium-/$1-W12-/;
	# DynaLab SU (Super Ultra Bold?) weighted fonts.
	s/(DynaLab-DFGothic) SU-medium-/$1-W14-/;
	s/(DynaLab-DFMincho) SU-medium-/$1-W14-/;

	($foundry, $family_name, $weight_name, $slant,
	 $setwidth_name, $add_style_name) = split('-');

	# protect from wrong characters
	foreach $i ($foundry, $family_name, $weight_name,
		    $slant, $setwidth_name, $add_style_name, $pixel_size,
		    $point_size, $resolution_x, $resolution_y, $spacing,
		    $average_width, $charset_registry, $charset_encoding) {
	    $i =~ tr[-?*,\"\0-\037\177-\227][ ];
	}

	$fontname = "$foundry-$family_name-$weight_name-" .
	    "$slant-$setwidth_name-$add_style_name";

	# If it has "US English" language description, it
	# may have iso8859-1 encoding.

	if ($opts{'e'} || $face->get_codepagerange =~ /Latin 1/) {
	  push(@lines, "$filename " .
	       "-$fontname-" .
	       "$pixel_size-$point_size-$resolution_x-$resolution_y-" .
	       "$spacing-$average_width-iso8859-1\n");
	  push(@lines, "ai=$ai:$filename " .
	       "-$foundry-$family_name-$weight_name-o-" .
	       "$setwidth_name-$add_style_name-" .
	       "$pixel_size-$point_size-$resolution_x-$resolution_y-" .
	       "$spacing-$average_width-iso8859-1\n")
	    if $opts{'o'} && $slant eq "r";
	}
	elsif ($opts {'w'}) {
	  warn "$filename does not contain a iso8859-1 codepage.\n";
	}

	# If it has "Japanese" language description, it
	# may have iso8859-1, jisx0201.1976-0 and jisx0208.1983-0 encoding.

	if ($opts{'j'} || $face->get_codepagerange =~ /JIS\/Japan/) {
	  $spacing = "c";	# Change all spacing to "c"`
	  push(@lines, "$filename " .
	       "-$fontname-" .
	       "$pixel_size-$point_size-$resolution_x-$resolution_y-" .
	       "$spacing-$average_width-jisx0208.1983-0\n");
	  push(@lines, "ai=$ai:$filename " .
	       "-$foundry-$family_name-$weight_name-o-" .
	       "$setwidth_name-$add_style_name-" .
	       "$pixel_size-$point_size-$resolution_x-$resolution_y-" .
	       "$spacing-$average_width-jisx0208.1983-0\n")
	    if $opts{'o'} && $slant eq "r";
	  push(@lines, "bw=0.5:$filename " .
	       "-$fontname-" . 
	       "$pixel_size-$point_size-$resolution_x-$resolution_y-" .
	       "$spacing-$average_width-jisx0201.1976-0\n");
	  push(@lines, "ai=$ai:bw=0.5:$filename " .
	       "-$foundry-$family_name-$weight_name-o-" .
	       "$setwidth_name-$add_style_name-" .
	       "$pixel_size-$point_size-$resolution_x-$resolution_y-" .
	       "$spacing-$average_width-jisx0201.1976-0\n")
	    if $opts{'o'} && $slant eq "r";
	  push(@lines, "bw=0.5:$filename " .
	       "-$fontname-" .
	       "$pixel_size-$point_size-$resolution_x-$resolution_y-" .
	       "$spacing-$average_width-iso8859-1\n");
	  push(@lines, "ai=$ai:bw=0.5:$filename " .
	       "-$foundry-$family_name-$weight_name-o-" .
	       "$setwidth_name-$add_style_name-" .
	       "$pixel_size-$point_size-$resolution_x-$resolution_y-" .
	       "$spacing-$average_width-iso8859-1\n")
	    if $opts{'o'} && $slant eq "r";
	}
	elsif ($opts{'w'}) {
	  warn "$filename does not contain a JIS codepage.\n";
	}

	# Should I do something about Symbol?
    }

    if (@lines) {
	if ($opts{'d'}) {
	    print $#lines + 1, "\n";
	    foreach $l (sort @lines) {
		print $l;
	    }
	} else {
	    open(OUTPUT, ">$dir/fonts.dir") ||
		die "$dir/fonts.dir: $!\n";
	    print OUTPUT $#lines + 1, "\n";
	    foreach $l (sort @lines) {
		print OUTPUT $l;
	    }
	    close(OUTPUT);
	}
    }
}
##############################################################################

	# These next few lines are legal in both Perl and nroff.

			# finish .ig
.00 ;
 
'di			\" finish diversion--previous line must be blank
.nr nl 0-1		\" fake up transition to first page again
.nr % 0			\" start at page 1
';<<'.ex'; #__END__ ############# From here on it's a standard manual page ############
.TH MKTTFDIR 1 "May 10, 1998"
.AT 3
.SH NAME
mkttfdir \- create an index of TrueType font files for X-TrueType server in a directory.
.SH SYNOPSIS
.B mkttfdir [-dheow] [-inum] [directory-name ... ]
.SH DESCRIPTION
For each directory argument,
.I mkttfdir
reads all of the TrueType font files in the directory and parses them.
It then creates suitable font names and writes them into "fonts.dir"
in the same directory.  The X-TrueType server (xfs-tt) and any X
server which suports the X-TrueType ability use "fonts.dir" to find
TrueType font files.
.pp
.I mkttfdir
does not create a "fonts.scale" file as this is not used by the
X-TrueType (xtt) extension.  The "fonts.dir" created by
.I mkttfdir
may not be compatible with the xfsft font server do to the inclusion
of data for the TTCap extension, which xfsft does not know how to
parse.
.SH OPTIONS
.IP -h
Display usage.
.IP -d
Dump created information on screen instead of "fonts.dir" file.
.IP -e
Force to create ISO8859-1 font entry without checking.
.IP -j
Force to create JISX 0208 and JISX 0201 font entries without checking.
.IP -o
Force the creation of an opaque font entry for every font.
.IP -i\fInumber\fP
Use this number as an auto-italic field if you choose -o option.
.IP -w
Use this to list any files for which mkfont will not create an entry
in "fonts.dir"
.SH FILES
fonts.dir - List of fonts in the directory and the files they are stored in.
.SH SEE ALSO
.BR XFree86 (1),
.BR xfsft(1)
.SH COPYRIGHT
Copyright (c) 1998  Kazushi (Jam) Marukawa
.br
Comments to: jam@pobox.com
.ex
