#!/bin/sh
#
# ipx       Bring up/down IPX networking
#

test -f /usr/sbin/ipx_configure || exit 0

. /etc/ipx.conf

# See how we were called.
case "$1" in
	start)
		if [ ${IPX_CONFIGURED} = "yes" ]; then
			if [ ${IPX_INTERNAL_NET} = "yes" ]; then
				ipx_internal_net add ${IPX_NETNUM}
			else
				ipx_interface add -p ${IPX_DEVICE} \
					${IPX_FRAME} ${IPX_NETNUM}
			fi
			if [ ${IPX_SERVER_ROUTE} = "yes" ]; then
				ipx_route add ${IPX_SERVER_NETNUM} \
					${IPX_NETNUM} \
					${IPX_SERVER_NODENUM}
			fi
		fi
		ipx_configure \
			--auto_primary=${IPX_AUTO_PRIMARY} \
			--auto_interface=${IPX_AUTO_INTERFACE}
		;;
	stop)
		ipx_configure --auto_primary=off --auto_interface=off
		ipx_interface delall
		;;
	restart|force-reload)
		echo -n "Reconfiguring IPX..."
		/etc/init.d/ipx stop
		sleep 2
		/etc/init.d/ipx start
		echo " done."
		;;
	*)
		echo "Usage: /etc/init.d/ipx {start|stop|restart}"
		exit 1
esac

exit 0
