#!/bin/bash
# utility for clean firmware stuff from upstream source 
# copyright by Enrico Tassi <gareuselesinge@users.sourceforge.net>
# License:
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License with
# the Debian GNU/Linux distribution in file /usr/share/common-licenses/GPL;
# if not, write to the Free Software Foundation, Inc., 59 Temple Place,
# Suite 330, Boston, MA  02111-1307  USA
#
# See /usr/share/common-licenses/GPL for the full text of the GPL.

#set -x

BASEURL="ftp://ftp.linux-wlan.org/pub/linux-wlan-ng/"
BASENAME="linux-wlan-ng-"
EXTENSION=".tar.gz"
RC=""

function tempdir {
	local NAME="/tmp/linux-wlan-ng-$1-`date +%s`"
	mkdir "$NAME"
	if [ $? != 0 ]; then
		return 1
	else
		RC="$NAME"
		return 0
	fi
}

# $1: the version you want to fetch
function fetch {
	local DIR=""
	local FILENAME="$BASENAME$1$EXTENSION"
	local URL="$BASEURL$FILENAME"
	local DOWNLOADER=""

	tempdir fetch
	if [ $? = 0 ]; then
		DIR="$RC"
	else
		echo "Unable to create a temporary directory"
		return 1
	fi
	if [ ! -z "`which wget`" ]; then
		DOWNLOADER="wget"
	elif [ ! -z "`which curl`" ]; then
		#FIXME: options are not quoted when $DOWNLAODER is used!
		DOWNLOADER="curl -o $FILENAME"
	else
		echo "I need wget or curl to fetch the upstream tarball"
		rm -rf "$DIR"
		return 1
	fi
	cd "$DIR"
	$DOWNLOADER "$URL"
	if [ $? != 0 ]; then
		echo "$DOWNLOADER returned an error"
		rm -rf "$DIR"
		cd -
		return 1
	fi
	cd - >&/dev/null
	RC="$DIR/$FILENAME"
	return 0
} 

# $1: the tarball
function remove-hex {
	local DIR=""
	local FILENAME="`basename "$1"`"
	
	tempdir remove-hex
	if [ $? = 0 ]; then
		DIR="$RC"
	else
		echo "Unable to create a temporary directory"
		return 1
	fi
	
	tar -xzf "$1" -C "$DIR"
	if [ $? != 0 ]; then
		echo "Unable to untar original file"
		rm -rf "$DIR"
		return 1
	fi
	
	find "$DIR" -name \*.hex -exec rm \{\} \;
	if [ $? != 0 ]; then
		echo "Unable to remove hex files"
		rm -rf "$DIR"
		return 1
	fi

	cd "$DIR"
	tar -czf "$DIR/$FILENAME" *
	if [ $? != 0 ]; then
		echo "Unable to repack cleaned sources"
		rm -rf "$DIR"
		cd -
		return 1
	fi
	cd - >&/dev/null

	RC="$DIR/$FILENAME"
	return 0
}

if [ -z "$1" ]; then
	echo 
	echo "usage: `basename "$0"` version"
	echo
	echo "Will produce the following files in the current directory:"
	echo -e "\tlinux-wlan-ng-version.tar.gz"
	echo -e "\tlinux-wlan-ng-version.orig.tar.gz"
	echo "The latter is suitable for Debian."
	echo
	exit 1
fi
VERSION="$1"

fetch "$VERSION"
if [ $? != 0 ]; then
	exit 1
fi
UPSTREAM="$RC"
remove-hex "$RC"
if [ $? != 0 ]; then
	exit 2
fi
CLEANED="$RC"
cp "$UPSTREAM" "$BASENAME$VERSION$EXTENSION"
cp "$CLEANED" "linux-wlan-ng_$VERSION.orig$EXTENSION"
rm -rf "`dirname "$UPSTREAM"`" "`dirname "$CLEANED"`"

#eof
