############################ -*- Mode: Makefile -*- ###########################
## local.mk --- 
## Author	    : Manoj Srivastava ( srivasta@glaurung.green-gryphon.com ) 
## Created On	    : Sat Nov 15 10:42:10 2003
## Created On Node  : glaurung.green-gryphon.com
## Last Modified By : Manoj Srivastava
## Last Modified On : Fri Oct 20 14:18:06 2006
## Last Machine Used: glaurung.internal.golden-gryphon.com
## Update Count	    : 74
## Status	    : Unknown, Use with caution!
## HISTORY	    : 
## Description	    : 
## 
## arch-tag: b07b1015-30ba-4b46-915f-78c776a808f4
## 
###############################################################################

testdir:
	$(testdir)

BUILD/libselinux1:: build/libselinux1
INST/libselinux1:: install/libselinux1
BIN/libselinux1:: binary/libselinux1


INST/libselinux1-dev:: install/libselinux1-dev
BIN/libselinux1-dev:: binary/libselinux1-dev

INST/python-selinux:: install/python-selinux
BIN/python-selinux:: binary/python-selinux


INST/selinux-utils:: install/selinux-utils
BIN/selinux-utils:: binary/selinux-utils


CLN-common::
	$(REASON)
	-test ! -f Makefile || $(MAKE) clean

CLEAN/libselinux1::
	test ! -d $(TMPTOP) || rm -rf $(TMPTOP)

CLEAN/libselinux1-dev::
	test ! -d $(TMPTOP) || rm -rf $(TMPTOP)


CLEAN/python-selinux::
	test ! -d $(TMPTOP) || rm -rf $(TMPTOP)

CLEAN/selinux-utils::
	test ! -d $(TMPTOP) || rm -rf $(TMPTOP)


build/libselinux1:
	$(checkdir)
	$(REASON)
	$(MAKE) CC="$(CC)" CFLAGS="$(CFLAGS)" LDFLAGS="$(LDFLAGS)" all 
	$(MAKE) -C src libselinux.pc
	touch stamp-build-libselinux1

STAMPS_TO_CLEAN += stamp-build-libselinux1

install/libselinux1: testroot
	$(checkdir)
	$(REASON)
	rm -rf		    $(TMPTOP)
	$(make_directory)   $(TMPTOP)
	$(make_directory)   $(DOCDIR)
	$(make_directory)   $(LIBDIR)
	$(make_directory)   $(TMPTOP)/DEBIAN
	$(install_file)	    debian/shlibs	     $(TMPTOP)/DEBIAN
	$(MAKE)		    DESTDIR=$(TMPTOP) -C src install
	rm -f		    $(LIBDIR)/libselinux.a
	rm -f		    $(LIBDIR)/libselinux.so
	rm -rf		    $(TMPTOP)/usr/lib/
	chmod 0644          $(LIBDIR)/libselinux.so.1
	$(install_file)	    debian/changelog	     $(DOCDIR)/changelog.Debian
	$(install_file)	    ChangeLog		     $(DOCDIR)/changelog
	gzip -9fqr	    $(DOCDIR)/
# Make sure the copyright file is not compressed
	$(install_file)	     debian/copyright	     $(DOCDIR)/copyright
ifeq (,$(findstring nostrip,$(DEB_BUILD_OPTIONS)))
	find $(TMPTOP) -type f | while read i; do					 \
	  if file -b $$i | egrep -q "^ELF.*shared object"; then				 \
	    strip --strip-unneeded --remove-section=.comment --remove-section=.note $$i; \
	  fi;										 \
	done
endif

install/libselinux1-dev: testroot
	$(checkdir)
	$(REASON)
	rm -rf		    $(TMPTOP)
	$(make_directory)   $(TMPTOP)
	$(make_directory)   $(DOCDIR)
	$(make_directory)   $(LIBDIR)
	$(make_directory)   $(INCDIR)
	$(make_directory)   $(MAN3DIR)
	$(make_directory)   $(MAN8DIR)
	$(MAKE)		    DESTDIR=$(TMPTOP) -C man install
	rm -rf		    $(MAN8DIR)
	$(MAKE)		    DESTDIR=$(TMPTOP) -C include install
	$(MAKE)		    DESTDIR=$(TMPTOP) -C src install
	rm -fr		    $(LIBDIR)
	rm -f		    $(TMPTOP)/usr/lib/libselinux.so
	ln -s               /lib/libselinux.so.1     $(TMPTOP)/usr/lib/libselinux.so
	rm -rf              $(TMPTOP)/usr/lib/python2.4/
	$(install_file)	    debian/changelog 	     $(DOCDIR)/changelog.Debian
	$(install_file)	    ChangeLog		     $(DOCDIR)/changelog
	gzip -9fqr	    $(DOCDIR)/
	gzip -9fqr	    $(MANDIR)/
# Make sure the copyright file is not compressed
	$(install_file)	     debian/copyright	     $(DOCDIR)/copyright
ifeq (,$(findstring nostrip,$(DEB_BUILD_OPTIONS)))
	find $(TMPTOP) -type f | while read i; do					 \
	  if file -b $$i | egrep -q "^ELF.*shared object"; then				 \
	    strip --strip-unneeded --remove-section=.comment --remove-section=.note $$i; \
	  fi;										 \
	done
endif

install/python-selinux: testroot
	$(checkdir)
	$(REASON)
	rm -rf		    $(TMPTOP)
	$(make_directory)   $(TMPTOP)
	$(make_directory)   $(DOCDIR)
	$(make_directory)   $(MODULES_DIR)
	$(make_directory)   $(EXTENSIONS_DIR)     
	for version in $(ALL_PY_VERSIONS); do                          \
          rm -f             src/$(SWIGSO) src/$(SWIGLOBJ);             \
          $(MAKE) -C src DESTDIR=$(TMPTOP) PYLIBVER=python$$version    \
                  PYTHONLIBDIR=$(PYTHONLIBDIRTOP)/python$$version/     \
                  pywrap install-pywrap;                               \
          chmod -x $(EXTENSIONS_DIR)/python$$version/site-packages/*;  \
          mv -f $(EXTENSIONS_DIR)/python$$version/site-packages/*.py   \
                $(MODULES_DIR)/;                                       \
          mv -f $(EXTENSIONS_DIR)/python$$version/site-packages/*      \
                $(EXTENSIONS_DIR)/python$$version/;                    \
	  rmdir $(EXTENSIONS_DIR)/python$$version/site-packages;       \
          if [ -z "$$versions" ]; then versions="$$version";           \
          else             versions="$$versions,$$version";            \
          fi;                                                          \
        done; echo "$$versions" > $(MODULES_DIR)/.version
	$(install_file)	    debian/changelog 	     $(DOCDIR)/changelog.Debian
	$(install_file)	    ChangeLog		     $(DOCDIR)/changelog
	gzip -9fqr	    $(DOCDIR)/
# Make sure the copyright file is not compressed
	$(install_file)	     debian/copyright	     $(DOCDIR)/copyright
ifeq (,$(findstring nostrip,$(DEB_BUILD_OPTIONS)))
	find $(TMPTOP) -type f | while read i; do					 \
	  if file -b $$i | egrep -q "^ELF.*shared object"; then				 \
	    strip --strip-unneeded --remove-section=.comment --remove-section=.note $$i; \
	  fi;										 \
	done
endif



install/selinux-utils: testroot
	$(checkdir)
	$(REASON)
	rm -rf		    $(TMPTOP)
	$(make_directory)   $(TMPTOP)
	$(make_directory)   $(DOCDIR)
	$(make_directory)   $(MAN1DIR)
	$(make_directory)   $(MAN3DIR)
	$(make_directory)   $(MAN8DIR)
	$(MAKE)             DESTDIR=$(TMPTOP) -C man install
	rm -rf              $(MAN3DIR)
	mv                  $(MAN8DIR)/setenforce.8     $(MAN1DIR)/setenforce.1
	mv                  $(MAN8DIR)/getenforce.8     $(MAN1DIR)/getenforce.1
	mv                  $(MAN8DIR)/selinuxenabled.8 $(MAN1DIR)/selinuxenabled.1
	mv                  $(MAN8DIR)/togglesebool.8   $(MAN1DIR)/togglesebool.1
	$(MAKE) DESTDIR=$(TMPTOP) -C utils install
	$(install_file)	     debian/changelog	     $(DOCDIR)/changelog.Debian
	$(install_file)	    ChangeLog		     $(DOCDIR)/changelog
	gzip -9fqr	    $(DOCDIR)/
	gzip -9fqr	    $(MANDIR)/
# Make sure the copyright file is not compressed
	$(install_file)	     debian/copyright	     $(DOCDIR)/copyright
ifeq (,$(findstring nostrip,$(DEB_BUILD_OPTIONS)))
	find $(TMPTOP) -type f | while read i; do				    \
	  if file -b $$i | egrep -q "^ELF.*executable"; then			    \
	    strip --strip-all --remove-section=.comment --remove-section=.note $$i; \
	  fi;									    \
	done
endif


binary/libselinux1: testroot
	$(checkdir)
	$(REASON)
	$(install_script)    debian/postrm	     $(TMPTOP)/DEBIAN/postrm
	$(install_script)    debian/postinst	     $(TMPTOP)/DEBIAN/postinst
	k=`find $(TMPTOP) -type f | ( while read i; do		 \
	    if file -b $$i | egrep -q "^ELF.*shared object"; then	 \
	      j="$$j $$i";					 \
	    fi;							 \
	   done; echo $$j; )`; if [ -n "$$k" ]; then dpkg-shlibdeps $$k; fi
	dpkg-gencontrol	     -p$(package) -isp	     -P$(TMPTOP)
	$(create_md5sum)     $(TMPTOP)
	chown -R root:root   $(TMPTOP)
	chmod -R u+w,go=rX   $(TMPTOP)
	dpkg --build	     $(TMPTOP) ..

binary/libselinux1-dev: testroot
	$(checkdir)
	$(REASON)
	$(make_directory)    $(TMPTOP)/DEBIAN
	dpkg-gencontrol	     -p$(package) -isp	     -P$(TMPTOP)
	$(create_md5sum)     $(TMPTOP)
	chown -R root:root   $(TMPTOP)
	chmod -R u+w,go=rX   $(TMPTOP)
	dpkg --build	     $(TMPTOP) ..

binary/python-selinux: testroot
	$(checkdir)
	$(REASON)
	$(make_directory)    $(TMPTOP)/DEBIAN
	$(install_script)    debian/python_prerm	     $(TMPTOP)/DEBIAN/prerm
	$(install_script)    debian/python_postinst	     $(TMPTOP)/DEBIAN/postinst
	if dpkg --compare-versions $(MIN_PY_VERSIONS) le $(PYDEFAULT); then              \
	  echo 'python:Depends=python (>= $(MIN_PY_VERSIONS)), python (<< $(STOP_VERSION))'  >  debian/substvars;     \
        else                                                                             \
          echo 'python:Depends=python (>= $(MIN_PY_VERSIONS)) | python$(MIN_PY_VERSIONS), python (<< $(STOP_VERSION))'\
                                                                  >  debian/substvars;   \
        fi
	echo 'python:Provides=$(PY_PROVIDES)'                 >> debian/substvars
	k=`find $(TMPTOP) -type f | ( while read i; do		 \
	    if file -b $$i | egrep -q "^ELF.*shared object"; then	 \
	      j="$$j $$i";					 \
	    fi;							 \
	   done; echo $$j; )`; if [ -n "$$k" ]; then dpkg-shlibdeps $$k; fi
	dpkg-gencontrol	     -p$(package) -isp	     -P$(TMPTOP)
	$(create_md5sum)     $(TMPTOP)
	chown -R root:root   $(TMPTOP)
	chmod -R u+w,go=rX   $(TMPTOP)
	dpkg --build	     $(TMPTOP) ..

binary/selinux-utils: testroot
	$(checkdir)
	$(REASON)
	$(make_directory)    $(TMPTOP)/DEBIAN
	k=`find $(TMPTOP) -type f | ( while read i; do		 \
	    if file -b $$i | egrep -q "^ELF.*executable"; then	 \
	      j="$$j $$i";					 \
	    fi;							 \
	   done; echo $$j; )`; dpkg-shlibdeps -Ldebian/shlibs -Tsubstvars.utils $$k
	dpkg-gencontrol	     -Tsubstvars.utils -p$(package) -isp    -P$(TMPTOP)
	$(create_md5sum)     $(TMPTOP)
	chown -R root:root   $(TMPTOP)
	chmod -R u+w,go=rX   $(TMPTOP)
	dpkg --build	     $(TMPTOP) ..
