/* -*- c-basic-offset: 4 indent-tabs-mode: nil -*-  vi:set ts=8 sts=4 sw=4: */

#ifndef _JACK_LOADER_H_
#define _JACK_LOADER_H_

#include <jack/jack.h>

jack_client_t *dynamic_jack_client_new(const char *);
jack_nframes_t dynamic_jack_get_buffer_size(jack_client_t *);
jack_nframes_t dynamic_jack_get_sample_rate(jack_client_t *);
int            dynamic_jack_set_process_callback(jack_client_t *,
						 JackProcessCallback, void *);
int            dynamic_jack_set_xrun_callback(jack_client_t *,
					      JackXRunCallback, void *);
int            dynamic_jack_activate(jack_client_t *);
int	       dynamic_jack_deactivate(jack_client_t *);
int 	       dynamic_jack_client_close(jack_client_t *);
const char   **dynamic_jack_get_ports(jack_client_t *, const char *,
				      const char *, unsigned long);
jack_port_t   *dynamic_jack_port_register(jack_client_t *, const char *,
					  const char *, unsigned long,
					  unsigned long);
int            dynamic_jack_port_unregister(jack_client_t *, jack_port_t *);
jack_nframes_t dynamic_jack_port_get_latency(jack_port_t *);
const char    *dynamic_jack_port_name(const jack_port_t *);
int            dynamic_jack_connect(jack_client_t *, const char *,
				    const char *);
void          *dynamic_jack_port_get_buffer(jack_port_t *, jack_nframes_t);
int            dynamic_jack_port_connected (const jack_port_t *port);
void           dynamic_jack_on_shutdown(jack_client_t *, void (*)(void *),
					void *);

#define jack_client_new dynamic_jack_client_new
#define jack_get_buffer_size dynamic_jack_get_buffer_size
#define jack_get_sample_rate dynamic_jack_get_sample_rate
#define jack_set_process_callback dynamic_jack_set_process_callback
#define jack_set_xrun_callback dynamic_jack_set_xrun_callback
#define jack_activate dynamic_jack_activate
#define jack_deactivate dynamic_jack_deactivate
#define jack_client_close dynamic_jack_client_close
#define jack_get_ports dynamic_jack_get_ports
#define jack_port_register dynamic_jack_port_register
#define jack_port_unregister dynamic_jack_port_unregister
#define jack_port_get_latency dynamic_jack_port_get_latency
#define jack_port_name dynamic_jack_port_name
#define jack_connect dynamic_jack_connect
#define jack_port_get_buffer dynamic_jack_port_get_buffer
#define jack_port_connected dynamic_jack_port_connected
#define jack_on_shutdown dynamic_jack_on_shutdown

int dynamic_jack_unload();

#endif
