/* $Id: ibod.h,v 1.2 2001/01/10 10:18:34 datenwelt Exp $
 * $Symbol$
 */

/*                                                                         
 * IBOD - a daemon that increases/decreases isdn bandwidth on demand       
 * Copyright (C) 1999 Bjoern Smith                                         
 *                                                                         
 * This program is free software; you can redistribute it and/or modify    
 * it under the terms of the GNU General Public License as published by    
 * the Free Software Foundation; either version 2 of the License, or       
 * (at your option) any later version.                                     
 *                                                                         
 * This program is distributed in the hope that it will be useful,         
 * but WITHOUT ANY WARRANTY; without even the implied warranty of          
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           
 * GNU General Public License for more details.                            
 *                                                                        
 * You should have received a copy of the GNU General Public License       
 * along with this program; if not, write to the Free Software             
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              
 *                                                                         
 * Authors: Bjoern Smith, smith@compound.se                                
 *          Jan Obladen, obladen@datenwelt.net                             
 *                                                                         
 *          KBE GmbH, datenwelt IT Service                                 
 *          Jan Obladen                                                    
 *          Im MediaPark 7                                                 
 *          D-50670 Koeln                                                  
 *          Germany                                                        
 *                                                                         */


#define DEVICE			"ippp0"
#define ENABLE			1
#define INTERVAL		500
#define FILTER			5
#define UPLIMIT			90
#define DOWNLIMIT		80
#define STAYUP			0
#define STAYUP_TIME		30
#define STAYDOWN_TIME		10
#define FULL_THROUGHPUT		7500
#define MAX_CHANNELS		2

#ifndef IBOD_DEFAULT_DIR
#define IBOD_DEFAULT_DIR	"/etc/ppp"
#endif
#define MAX_STR_LEN		512
#define ISDN_INFO_DEV		"/dev/isdninfo"
#define ISDN_CTLR_DEV		"/dev/isdnctrl"
#define IBOD_PORT		6050

/* Protocol specification */
#define MAX_MSG_LEN		1024
#define POBJ_SIZE		4
#define LINK_STATUS_POS		0
#define INBOUND_RATE_POS	4
#define OUTBOUND_RATE_POS	8
#define STATUS_FRAME_SIZE	12

#define CMD_OPEN		0
#define CMD_CLOSE		1
#define CMD_ENABLE		2
#define CMD_DISABLE		3
#define CMD_UP2			4
#define CMD_DOWN2		5

typedef struct {
	char	dev[32];
	int	enable;
	int	interval;
	int	uplimit;
	int	downlimit;
	int	filter;
	int	stayup;
	int	stayup_time;
	int	staydown_time;
	int	full;
	int	max_channels;
} Conf;

typedef struct {
	unsigned long ibytes;
	unsigned long obytes;
} Siobytes;

