#! /bin/bash

rename_pkg()
{
  src=$1
  dest=$2
  for ext in preinst postinst prerm postrm doc-base; do
    if [ -f $src.$ext ]; then
      if [ -f $dest.ext ]; then
	echo already exists: $dest.$ext
      else
	mv $src.$ext $dest.$ext
      fi
    fi
  done
}

for p in chill cpp gcc g++ g77 gpc gcj gobjc protoize; do
  rename_pkg $p $p-2.95
done

for p in cpp gcc g77 gpc; do
  rename_pkg $p-doc $p-2.95-doc
done
