#!/bin/sh

ver=`ls -1 /lib/libc-*.so | sed -e 's|/.*-||' -e 's|\.so||'`

major=`echo $ver | awk -F. '{print $1}'`
minor=`echo $ver | awk -F. '{print $2}'`
rev=`echo $ver | awk -F. '{print $3}'`

if [ -z "$rev" ]; then
	version=$ver
else
	if [ "$rev" -ge 90 ]; then
		minor=`expr $minor + 1`
	fi

	version="${major}.${minor}"
fi

if [ "$version" = 2.3 ]; then
	version=2.2
fi
echo -n $version
exit
