/*
I'm not sure this is a bug, and whether it's a glibc or gcc problem.

The following program compiles fine with "cc -O2 string.c":
*/

/* string.c: shows a problem with headers in string.h */

#include <string.h>

main(void)
{
	char D[20];

	D[0] = '\0';
	strcat(D, "a string");
}

/*
However if you try to compile with "cc -O2 -traditional string.c" you
get

In file included from /usr/include/string.h:346,
                 from string.c:3:
/usr/include/bits/string2.h:1104: macro or `#include' recursion too deep
/usr/include/bits/string2.h:1171: macro or `#include' recursion too deep
/usr/include/bits/string2.h:1171: macro or `#include' recursion too deep
/usr/include/bits/string2.h:1171: macro or `#include' recursion too deep
/usr/include/bits/string2.h:1171: macro or `#include' recursion too deep
...
until the preprocessor gets a memory error. The same happens with -O
instead of -O2.

I know -traditional isn't the best thing to use it's sometimes
necessary to compile legacy stuff...
*/
