#include <sys/time.h> /* for gettimeofday() */

#define rdtsc(low,high) \
     __asm__ __volatile__("rdtsc" : "=a" (low), "=d" (high))

static unsigned long tsc_per_usec = 0, init_tsc_upper = 0;

static void init_gettime(void)
{
    unsigned long usecs, a1, b1, a2, b2, a3, b3, a4, b4;
    struct timeval tv1, tv2;

    usecs = (tv2.tv_usec + ((tv1.tv_sec==tv2.tv_sec) ? 0 : 1e6)) - tv1.tv_usec;
    tsc_per_usec = (a3-a2)/usecs;
}

double
gettime(void)
{
    unsigned long a, b;

    if(tsc_per_usec == 0)
	init_gettime();

    return ((b-init_tsc_upper)*((double)ULONG_MAX+1) + a) / tsc_per_usec / 1e6;
}

