/*
Here's the source code, I'm trying to use the printer port as a generic I/O
port:
*/
/* termwatch.c=20
   080100 Sigmund Skjelnes
   Dette programmet viser om pinne 2 p=E5 /dev/lp0 utgangen skifter status
*/

#include<stdio.h>
#include<asm/io.h>

#define base 0x0378U
#define lp_data base=20
#define lp_control (base + 2)
#define IRQFLAG 0x10
#define INIFLAG 4

int main( void ){
  int i;
  /* sett opp registre */
  ioperm( base, 3, 1 ); /* reserver portadresser */
  i = inb( lp_control );
  i |= INIFLAG;           /* INI flag = 1 */
  i &= ~IRQFLAG;       /* IRQ flag = 0 IRQ brukes ikke */
   outb( lp_control, (unsigned char) (i & 0xff) );
   outb( lp_data, (unsigned char) 0 );     /* leser data reg */

  while( 1 ){  //finn en m=E5te =E5 stoppe programmet kontrollert p=E5!
    if ( inb( lp_data ) == 1 ){
      printf( "Bryter =E5pen\r\n" );
    }
    else {
      printf( "Bryter lukket\r\n" );
    }

    sleep( 1 );  /* 1s */

  }
  ioperm( base, 3, 0 ); /* fjern reservasjon */
}

/*
Obviously, the code for __outp etc. is missing, hence the linker can't find
the function definition. It's possible the source code should have been
linked to something, but this is unlikely.

The source are compiled the usual way:=20
gcc -o termwatch termwatch.c

*/
