/*
I notified that doing things like
	cout << setw(30) << text;
where text is some std::string does not work. setw setting
is not used while outputting text, instead it is used
while something else is being output later.
Sample program below illustrates the problem.
*/
	
// Sample by Marcin.Kasperski@bigfoot.com
// The program illustrates the fact that setw is ignored
// while outputting string's into iostream.
// setw setting is used on the first const char * instead
// Below one would expect output:
// [      1111      2222]
// but instead he gets
// [11112222         ]

#include <iostream.h>
#include <iomanip.h>
#include <string>

int main()
{
    string text1 = "1111";
    string text2 = "2222";

    cout << "[" << setw(10) << text1 << setw(10) << text2 << "]" <<
endl;
}

