/*
From: Zdenek Kabelac <kabi@informatics.muni.cz>
To: Debian Bug Tracking System <submit@bugs.debian.org>
Subject: Bug#47743: Miscompilation with -mpentiumpro & -funroll-loop
Date: Mon, 18 Oct 1999 20:57:35 +0200

Package: gcc
Version: 1:2.95.2-0pre2
Severity: normal

Hello 

I was trying to compile bytemark benchmark - and I found out that this
part is being miscompiled by latest gcc.

here is demo makefile:
--
CFLAGS = -O3 -fomit-frame-pointer -Wall -mpentiumpro -fforce-addr \             
         -funroll-all-loops  -inline-functions\                                 
                                                                                
all: test                                                                       
                                                                                
test: test.o                                                                    
        $(CC) -g -o $@ test.o                                                   

---

and here is the stripped code itself:

---
*/

#include <stdio.h>                                                              
                                                                                
#define MAXPATS 10                                                              
#define IN_SIZE 35                                                              
#define OUT_SIZE 8                                                              
#define MID_SIZE 8                                                              
                                                                                
double out_wt_change[OUT_SIZE][MID_SIZE];                                       
double mid_wt_change[MID_SIZE][IN_SIZE];                                        
double out_wt_cum_change[OUT_SIZE][MID_SIZE];                                   
double mid_wt_cum_change[MID_SIZE][IN_SIZE];                                    
                                                                                
int numpats;                                                                    
int n;                                                                          
                                                                                
void testerr(void)                                                              
{                                                                               
    int i, j;                                                                   
                                                                                
    printf("n: %d %d\n", numpats, n);                                           
                                                                                
    for (i = 0; i<MID_SIZE; i++) {                                              
        for (j=0; j<IN_SIZE; j++) {                                             
            mid_wt_change[i][j] = 0.0;                                          
            mid_wt_cum_change[i][j] = 0.0;                                      
        }                                                                       
    }                                                                           
                                                                                
    printf("n: %d %d\n", numpats, n);                                           
                                                                                
    for (i = 0; i< OUT_SIZE; i++) {                                             
        for (j=0; j<MID_SIZE; j++) {                                            
            out_wt_change[i][j] = 0.0;                                          
            out_wt_cum_change[i][j] = 0.0;                                      
        }                                                                       
    }                                                                           
}                                                                               
                                                                                
int main(int argc, char *argv[])                                                
{                                                                               
    n = numpats = 10;                                                           
    testerr();                                                                  
                                                                                
    return 0;                                                                   
}                                                                               

/*
---

The output of variable numpats should remain the same, but its being
modified to 0.
The strange thing is - n has the right value, and even more
when I change the name of numpats to other name everything seems
to be ok.

There are no such problems when the code is compiled with -mpentium
or without -funroll-loop.
*/
