/*
From: Richard Kettlewell <richard.kettlewell@kewill.com>
Sender: Richard Kettlewell <richard@elmail.co.uk>
To: Matthias Klose <doko@cs.tu-berlin.de>
Cc: gcc@packages.debian.org
Subject: Bug#46181: c++ error message improvement suggestion
Date: Wed, 29 Sep 1999 11:41:35 +0100 (BST)

Here is a small example:

: muskogee; cat t.cc
*/

#include <string>

class foo {
public:
    foo();
};

void bar(const string &s) {
    foo x(s);
}

/*
: muskogee; c++ -o t t.cc
t.cc: In function `void bar(const class string &)':
t.cc:9: no matching function for call to `foo::foo (const basic_string<char,string_char_traits<char>,__default_alloc_template<true,0> > &)'
t.cc:6: candidates are: foo::foo(const foo &)
t.cc:5:                 foo::foo()
: muskogee; c++ --version
egcs-2.91.60

Here the compiler knew (at least originally...) that the user wrote
`const string &' but still expands the typedef when it generates the
error message.

ttfn/rjk
*/
