/*
From: David Marwood <marwood@infranetsolutions.com>
To: submit@bugs.debian.org
Subject: Bug#45041: pthread/throw causes abort()
Date: Mon, 13 Sep 1999 16:50:28 -0700 (PDT)


Package: g++
Version: 2.91.60-5


I have a problem with pthreads and C++ exceptions interacting badly.
The attached program incorrectly aborts after several seconds of
execution when compiled with:
	g++ -o main -DREENTRANT main.cpp -lpthread

Here's some machine info, followed by the results of the execution.
Removing the multi-threading or removing the throw fixes the problem
(obviously at reduced functionality).  Adding "while (true);" right
before the lats close-brace causes the program to behave correctly.
If you are unable to reproduce the problem then I'm very interested as
it probably indicates a very strange problem with my setup.

[patricia:~]dpkg --list | grep libstdc
ii  libstdc++2.8    2.90.29-2      The GNU stdc++ library (old egcs version)
ii  libstdc++2.9    2.91.60-5      The GNU stdc++ library (egcs version)
ii  libstdc++2.9-de 2.91.60-5      The GNU stdc++ library (development files)
[patricia:~]dpkg --list | grep 'g++'  
ii  g++             2.91.60-5      The GNU (egcs) C++ compiler.
ii  libg++27        2.7.2.1-14.4   The GNU C++ libraries (ELF version).
ii  libg++272       2.7.2.8-0.1    The GNU C++ libraries (libc6 version).
[patricia:~]uname -a
Linux patricia 2.0.34 #52 Wed Sep 23 16:47:48 PDT 1998 i586 unknown
[patricia:~]./main
Aborted
[patricia:~]


I don't get the problem on my Solaris box.  Oddly, the program seems
to be using only one of the box's two cpus, although I don't see how
that's relevant.  Here's the info:

[farrah:~]g++ -v
Reading specs from /usr/local/lib/gcc-lib/sparc-sun-solaris2.6/2.8.1/specs
gcc version 2.8.1
[farrah:~]uname -a
SunOS farrah 5.6 Generic_105181-05 sun4u sparc SUNW,Ultra-250
[farrah:~]g++ -D_REENTRANT -o main main.cpp -lpthread
[farrah:~]./main
[farrah:~]

David

----------------------------------------------------------------
*/

#include <pthread.h> 
 
 
class MyException 
{ 
}; 
 
 
void* newthread(void*) 
{ 
  while (true) 
    { 
      try { 
        throw MyException(); 
      } catch (MyException) { 
      } 
    } 
} 
 
 
void main(void) 
{ 
  for (int i = 0; i < 20; i++) 
    { 
      pthread_t tid; 
      pthread_create(&tid, NULL, newthread, NULL); 
    } 
} 
