template <class Type, unsigned Width, unsigned Height>
class Matrix {
    Type    Values[Height][Width];

public:
  Type const& operator()(unsigned row, unsigned col) const { return Values[row][col]; }
  Type&       operator()(unsigned row, unsigned col) { return Values[row][col]; }

    template <unsigned Size>
    Matrix<Type,Size,Width> operator* (Matrix<Type,Height,Size> const& rhs) const;
};



template <class Type, unsigned Width, unsigned Height, unsigned Size>
inline
Matrix<Type,Size,Width> Matrix<Type,Width,Height>::operator*(Matrix<Type,Height,Size> const& rhs) const
{
    Matrix<Type,Size,Width> result;

    for (unsigned w=0; w < Width; w++) {
      for (unsigned s=0; s < Size; s++) {
	for (unsigned h=0; h < Height; h++) {
                result(s,w) += Values[h][w] * rhs(h,s);
	}
      }
    }

    return result;
}


int main(int, char**)
{
    Matrix<double,4,4>  transform;
    Matrix<double,1,4>  input;
    Matrix<double,4,1>  output;

    /* ... initialize matricies ... */

    output = input * transform;

    return 1;
}

