/********************************************************************************
*                                                                               *
*              S i n g l e - P r e c i s i o n  Q u a t e r n i o n             *
*                                                                               *
*********************************************************************************
* Copyright (C) 1994,2005 by Jeroen van der Zijp.   All Rights Reserved.        *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************
* $Id: FXQuatf.h,v 1.13.2.1 2006/03/21 05:02:32 fox Exp $                           *
********************************************************************************/
#ifndef FXQUATF_H
#define FXQUATF_H


namespace FX {


class FXMat3f;

class FXQuatf;
FXAPI FXQuatf arc(const FXVec3f& a,const FXVec3f& b);

/// Single-precision quaternion
class FXAPI FXQuatf : public FXVec4f {
public:

  /// Construct
  FXQuatf(){}

  /// Copy constructor
  FXQuatf(const FXQuatf& q):FXVec4f(q){}

  /// Construct from components
  FXQuatf(FXfloat xx,FXfloat yy,FXfloat zz,FXfloat ww):FXVec4f(xx,yy,zz,ww){}

  /// Construct from array of floats
  FXQuatf(const FXfloat v[]):FXVec4f(v){}

  /// Construct from axis and angle
  FXQuatf(const FXVec3f& axis,FXfloat phi=0.0f);

  /// Construct from euler angles yaw (z), pitch (y), and roll (x)
  FXQuatf(FXfloat roll,FXfloat pitch,FXfloat yaw);

  /// Construct quaternion from axes
  FXQuatf(const FXVec3f& ex,const FXVec3f& ey,const FXVec3f& ez);

  /// Construct quaternion from 3x3 matrix
  FXQuatf(const FXMat3f& mat);

  /// Adjust quaternion length
  FXQuatf& adjust();

  /// Set quaternion from axis and angle
  void setAxisAngle(const FXVec3f& axis,FXfloat phi=0.0f);

  /// Obtain axis and angle from quaternion
  void getAxisAngle(FXVec3f& axis,FXfloat& phi) const;

  /// Set quaternion from yaw (z), pitch (y), and roll (x)
  void setRollPitchYaw(FXfloat roll,FXfloat pitch,FXfloat yaw);

  /// Obtain yaw, pitch, and roll from quaternion
  void getRollPitchYaw(FXfloat& roll,FXfloat& pitch,FXfloat& yaw) const;

  /// Set quaternion from axes
  void setAxes(const FXVec3f& ex,const FXVec3f& ey,const FXVec3f& ez);

  /// Get quaternion axes
  void getAxes(FXVec3f& ex,FXVec3f& ey,FXVec3f& ez) const;

  /// Obtain local x axis
  FXVec3f getXAxis() const;

  /// Obtain local y axis
  FXVec3f getYAxis() const;

  /// Obtain local z axis
  FXVec3f getZAxis() const;

  /// Exponentiate quaternion
  friend FXAPI FXQuatf exp(const FXQuatf& q);

  /// Take logarithm of quaternion
  friend FXAPI FXQuatf log(const FXQuatf& q);

  /// Invert quaternion
  friend FXAPI FXQuatf invert(const FXQuatf& q);

  /// Invert unit quaternion
  friend FXAPI FXQuatf unitinvert(const FXQuatf& q);

  /// Conjugate quaternion
  friend FXAPI FXQuatf conj(const FXQuatf& q);

  /// Multiply quaternions
  friend FXAPI FXQuatf operator*(const FXQuatf& p,const FXQuatf& q);

  /// Rotation of a vector by a quaternion
  friend FXAPI FXVec3f operator*(const FXQuatf& quat,const FXVec3f& vec);

  /// Construct quaternion from arc a->b on unit sphere
  friend FXAPI FXQuatf arc(const FXVec3f& a,const FXVec3f& b);

  /// Spherical lerp
  friend FXAPI FXQuatf lerp(const FXQuatf& u,const FXQuatf& v,FXfloat f);

  /// Convert quaternion to 3x3 matrix
  friend FXAPI FXMat3f toMatrix(const FXQuatf& quat);

  /// Convert 3x3 matrix to quaternion
  friend FXAPI FXQuatf fromMatrix(const FXMat3f& mat);
  };

extern FXAPI FXQuatf exp(const FXQuatf& q);
extern FXAPI FXQuatf log(const FXQuatf& q);
extern FXAPI FXQuatf invert(const FXQuatf& q);
extern FXAPI FXQuatf unitinvert(const FXQuatf& q);
extern FXAPI FXQuatf conj(const FXQuatf& q);
extern FXAPI FXQuatf operator*(const FXQuatf& p,const FXQuatf& q);
extern FXAPI FXVec3f operator*(const FXQuatf& quat,const FXVec3f& vec);
extern FXAPI FXQuatf arc(const FXVec3f& a,const FXVec3f& b);
extern FXAPI FXQuatf lerp(const FXQuatf& u,const FXQuatf& v,FXfloat f);
extern FXAPI FXMat3f toMatrix(const FXQuatf& quat);
extern FXAPI FXQuatf fromMatrix(const FXMat3f& mat);

}

#endif
