//
// "$Id: alignment_panel.cxx 4632 2005-11-03 22:16:52Z mike $"
//
// Setting and shell dialogs for the Fast Light Tool Kit (FLTK).
//
// Copyright 1998-2005 by Bill Spitzak and others.
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA.
//
// Please report all bugs and problems on the following page:
//
//     http://www.fltk.org/str.php
//

// generated by Fast Light User Interface Designer (fluid) version 1.0107

#include <libintl.h>
#include "alignment_panel.h"
#define _(String) gettext (String)

Fl_Double_Window *project_window=(Fl_Double_Window *)0;

static void cb_Close(Fl_Button*, void*) {
  project_window->hide();
}

Fl_Input *header_file_input=(Fl_Input *)0;

Fl_Input *code_file_input=(Fl_Input *)0;

Fl_Light_Button *include_H_from_C_button=(Fl_Light_Button *)0;

Fl_Choice *i18n_type_chooser=(Fl_Choice *)0;

Fl_Menu_Item menu_i18n_type_chooser[] = {
 {_("None"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 11, 0},
 {_("GNU gettext"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 11, 0},
 {_("POSIX catgets"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 11, 0},
 {0,0,0,0,0,0,0,0,0}
};

Fl_Input *i18n_include_input=(Fl_Input *)0;

Fl_Input *i18n_file_input=(Fl_Input *)0;

Fl_Input *i18n_set_input=(Fl_Input *)0;

Fl_Input *i18n_function_input=(Fl_Input *)0;

Fl_Double_Window* make_project_window() {
  Fl_Double_Window* w;
  { Fl_Double_Window* o = project_window = new Fl_Double_Window(345, 185, _("Project Settings"));
    w = o;
    { Fl_Button* o = new Fl_Button(293, 156, 42, 20, _("Close"));
      o->tooltip(_("Close this dialog."));
      o->labelsize(11);
      o->callback((Fl_Callback*)cb_Close);
    }
    { Fl_Tabs* o = new Fl_Tabs(10, 10, 325, 138);
      o->selection_color((Fl_Color)4);
      o->labelsize(11);
      { Fl_Group* o = new Fl_Group(10, 30, 325, 116, _("Output"));
        o->labelsize(11);
        { Fl_Box* o = new Fl_Box(20, 40, 304, 15, _("Use \"name.ext\" to set name or just \".ext\" to set extension."));
          o->labelsize(11);
          o->align(132|FL_ALIGN_INSIDE);
        }
        { Fl_Input* o = header_file_input = new Fl_Input(96, 60, 228, 20, _("Header File:"));
          o->tooltip(_("The name of the generated header file."));
          o->box(FL_THIN_DOWN_BOX);
          o->labelfont(1);
          o->labelsize(11);
          o->textfont(4);
          o->textsize(11);
          o->callback((Fl_Callback*)header_input_cb, (void*)(1));
          o->when(FL_WHEN_CHANGED);
        }
        { Fl_Input* o = code_file_input = new Fl_Input(97, 85, 227, 20, _("Code File:"));
          o->tooltip(_("The name of the generated code file."));
          o->box(FL_THIN_DOWN_BOX);
          o->labelfont(1);
          o->labelsize(11);
          o->textfont(4);
          o->textsize(11);
          o->callback((Fl_Callback*)code_input_cb, (void*)(1));
          o->when(FL_WHEN_CHANGED);
        }
        { Fl_Light_Button* o = include_H_from_C_button = new Fl_Light_Button(166, 110, 158, 20, _("Include Header from Code"));
          o->tooltip(_("Include the header file from the code file."));
          o->value(1);
          o->labelsize(11);
          o->callback((Fl_Callback*)include_H_from_C_button_cb);
        }
        o->end();
      }
      { Fl_Group* o = new Fl_Group(10, 30, 325, 116, _("Internationalization"));
        o->labelsize(11);
        o->hide();
        { Fl_Choice* o = i18n_type_chooser = new Fl_Choice(80, 42, 100, 20, _("Use:"));
          o->tooltip(_("Type of internationalization to use."));
          o->box(FL_THIN_UP_BOX);
          o->down_box(FL_BORDER_BOX);
          o->labelfont(1);
          o->labelsize(11);
          o->textsize(11);
          o->callback((Fl_Callback*)i18n_type_cb);
          o->menu(menu_i18n_type_chooser);
        }
        { Fl_Input* o = i18n_include_input = new Fl_Input(80, 67, 245, 20, _("#include:"));
          o->tooltip(_("The include file for internationalization."));
          o->box(FL_THIN_DOWN_BOX);
          o->labelfont(1);
          o->labelsize(11);
          o->textfont(4);
          o->textsize(11);
          o->callback((Fl_Callback*)i18n_text_cb);
        }
        { Fl_Input* o = i18n_file_input = new Fl_Input(80, 92, 245, 20, _("File:"));
          o->tooltip(_("The name of the message catalog."));
          o->box(FL_THIN_DOWN_BOX);
          o->labelfont(1);
          o->labelsize(11);
          o->textfont(4);
          o->textsize(11);
          o->callback((Fl_Callback*)i18n_text_cb);
        }
        { Fl_Input* o = i18n_set_input = new Fl_Input(80, 117, 245, 20, _("Set:"));
          o->tooltip(_("The message set number."));
          o->type(2);
          o->box(FL_THIN_DOWN_BOX);
          o->labelfont(1);
          o->labelsize(11);
          o->textfont(4);
          o->textsize(11);
          o->callback((Fl_Callback*)i18n_text_cb);
        }
        { Fl_Input* o = i18n_function_input = new Fl_Input(80, 92, 245, 20, _("Function:"));
          o->tooltip(_("The function to call to internationalize the labels and tooltips."));
          o->box(FL_THIN_DOWN_BOX);
          o->labelfont(1);
          o->labelsize(11);
          o->textfont(4);
          o->textsize(11);
          o->callback((Fl_Callback*)i18n_text_cb);
        }
        o->end();
      }
      o->end();
    }
    o->set_modal();
    o->end();
  }
  return w;
}
Fl_Text_Buffer *shell_run_buffer;
void scheme_cb(Fl_Choice *, void *);

Fl_Double_Window *settings_window=(Fl_Double_Window *)0;

Fl_Choice *scheme_choice=(Fl_Choice *)0;

Fl_Menu_Item menu_scheme_choice[] = {
 {_("Default"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {_("None"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {_("Plastic"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {0,0,0,0,0,0,0,0,0}
};

Fl_Check_Button *tooltips_button=(Fl_Check_Button *)0;

static void cb_tooltips_button(Fl_Check_Button*, void*) {
  Fl_Tooltip::enable(tooltips_button->value());
fluid_prefs.set("show_tooltips", tooltips_button->value());
}

Fl_Check_Button *completion_button=(Fl_Check_Button *)0;

static void cb_completion_button(Fl_Check_Button*, void*) {
  fluid_prefs.set("show_completion_dialogs", completion_button->value());
}

Fl_Check_Button *openlast_button=(Fl_Check_Button *)0;

static void cb_openlast_button(Fl_Check_Button*, void*) {
  fluid_prefs.set("open_previous_file", openlast_button->value());
}

Fl_Check_Button *prevpos_button=(Fl_Check_Button *)0;

static void cb_prevpos_button(Fl_Check_Button*, void*) {
  fluid_prefs.set("prev_window_pos", prevpos_button->value());
}

static void cb_Close1(Fl_Button*, void*) {
  settings_window->hide();
}

Fl_Spinner *recent_spinner=(Fl_Spinner *)0;

static void cb_recent_spinner(Fl_Spinner*, void*) {
  fluid_prefs.set("recent_files", recent_spinner->value());
load_history();
}

Fl_Double_Window* make_settings_window() {
  Fl_Double_Window* w;
  { Fl_Double_Window* o = settings_window = new Fl_Double_Window(340, 225, _("GUI Settings"));
    w = o;
    { Fl_Choice* o = scheme_choice = new Fl_Choice(116, 10, 115, 25, _("Scheme:"));
      o->down_box(FL_BORDER_BOX);
      o->labelfont(1);
      o->callback((Fl_Callback*)scheme_cb);
      o->menu(menu_scheme_choice);
      int s;
      fluid_prefs.get("scheme", s, 0);
      scheme_choice->value(s);
      scheme_cb(0, 0);
    }
    { Fl_Group* o = new Fl_Group(116, 45, 215, 100, _("Options:\n\n\n\n\n"));
      o->labelfont(1);
      o->align(FL_ALIGN_LEFT);
      { Fl_Check_Button* o = tooltips_button = new Fl_Check_Button(116, 45, 113, 25, _("Show Tooltips"));
        o->down_box(FL_DOWN_BOX);
        o->callback((Fl_Callback*)cb_tooltips_button);
        int b;
        fluid_prefs.get("show_tooltips", b, 1);
        tooltips_button->value(b);
        Fl_Tooltip::enable(b);
      }
      { Fl_Check_Button* o = completion_button = new Fl_Check_Button(116, 70, 186, 25, _("Show Completion Dialogs"));
        o->down_box(FL_DOWN_BOX);
        o->callback((Fl_Callback*)cb_completion_button);
        int b;
        fluid_prefs.get("show_completion_dialogs", b, 1);
        completion_button->value(b);
      }
      { Fl_Check_Button* o = openlast_button = new Fl_Check_Button(116, 95, 215, 25, _("Open Previous File on Startup"));
        o->down_box(FL_DOWN_BOX);
        o->callback((Fl_Callback*)cb_openlast_button);
        int b;
        fluid_prefs.get("open_previous_file", b, 0);
        openlast_button->value(b);
      }
      { Fl_Check_Button* o = prevpos_button = new Fl_Check_Button(116, 120, 210, 25, _("Remember Window Positions"));
        o->down_box(FL_DOWN_BOX);
        o->callback((Fl_Callback*)cb_prevpos_button);
        int b;
        fluid_prefs.get("prev_window_pos", b, 1);
        prevpos_button->value(b);
      }
      o->end();
    }
    { Fl_Button* o = new Fl_Button(266, 190, 64, 25, _("Close"));
      o->tooltip(_("Close this dialog."));
      o->callback((Fl_Callback*)cb_Close1);
    }
    { Fl_Spinner* o = recent_spinner = new Fl_Spinner(116, 155, 40, 25, _("# Recent Files:"));
      o->labelfont(1);
      o->callback((Fl_Callback*)cb_recent_spinner);
      o->when(FL_WHEN_CHANGED);
      int c;
      fluid_prefs.get("recent_files", c, 5);
      recent_spinner->maximum(10);
      recent_spinner->value(c);
    }
    o->set_non_modal();
    o->end();
  }
  return w;
}

Fl_Double_Window *shell_window=(Fl_Double_Window *)0;

Fl_Input *shell_command_input=(Fl_Input *)0;

static void cb_shell_command_input(Fl_Input*, void*) {
  fluid_prefs.set("shell_command", shell_command_input->value());
}

Fl_Check_Button *shell_writecode_button=(Fl_Check_Button *)0;

static void cb_shell_writecode_button(Fl_Check_Button*, void*) {
  fluid_prefs.set("shell_writecode", shell_writecode_button->value());
}

Fl_Check_Button *shell_writemsgs_button=(Fl_Check_Button *)0;

static void cb_shell_writemsgs_button(Fl_Check_Button*, void*) {
  fluid_prefs.set("shell_writemsgs", shell_writemsgs_button->value());
}

Fl_Check_Button *shell_savefl_button=(Fl_Check_Button *)0;

static void cb_shell_savefl_button(Fl_Check_Button*, void*) {
  fluid_prefs.set("shell_savefl", shell_savefl_button->value());
}

static void cb_Cancel(Fl_Button*, void*) {
  shell_window->hide();
}

Fl_Double_Window *shell_run_window=(Fl_Double_Window *)0;

Fl_Text_Display *shell_run_display=(Fl_Text_Display *)0;

Fl_Return_Button *shell_run_button=(Fl_Return_Button *)0;

static void cb_shell_run_button(Fl_Return_Button*, void*) {
  shell_run_window->hide();
}

Fl_Double_Window* make_shell_window() {
  Fl_Double_Window* w;
  { Fl_Double_Window* o = shell_window = new Fl_Double_Window(365, 125, _("Shell Command"));
    w = o;
    { Fl_Input* o = shell_command_input = new Fl_Input(10, 27, 347, 25, _("Command:"));
      o->labelfont(1);
      o->callback((Fl_Callback*)cb_shell_command_input);
      o->align(FL_ALIGN_TOP_LEFT);
      char buf[1024];
      fluid_prefs.get("shell_command", buf, "", sizeof(buf));
      shell_command_input->value(buf);
    }
    { Fl_Check_Button* o = shell_writecode_button = new Fl_Check_Button(128, 61, 93, 19, _("Write Code"));
      o->down_box(FL_DOWN_BOX);
      o->callback((Fl_Callback*)cb_shell_writecode_button);
      int b;
      fluid_prefs.get("shell_writecode", b, 1);
      shell_writecode_button->value(b);
    }
    { Fl_Check_Button* o = shell_writemsgs_button = new Fl_Check_Button(231, 61, 126, 19, _("Write Messages"));
      o->down_box(FL_DOWN_BOX);
      o->callback((Fl_Callback*)cb_shell_writemsgs_button);
      int b;
      fluid_prefs.get("shell_writemsgs", b, 0);
      shell_writemsgs_button->value(b);
    }
    { Fl_Check_Button* o = shell_savefl_button = new Fl_Check_Button(10, 62, 108, 19, _("Save .FL File"));
      o->down_box(FL_DOWN_BOX);
      o->callback((Fl_Callback*)cb_shell_savefl_button);
      int b;
      fluid_prefs.get("shell_savefl", b, 1);
      shell_savefl_button->value(b);
    }
    { Fl_Return_Button* o = new Fl_Return_Button(132, 90, 143, 25, _("Run Command"));
      o->callback((Fl_Callback*)do_shell_command);
    }
    { Fl_Button* o = new Fl_Button(285, 90, 72, 25, _("Cancel"));
      o->callback((Fl_Callback*)cb_Cancel);
    }
    o->end();
  }
  { Fl_Double_Window* o = shell_run_window = new Fl_Double_Window(555, 430, _("Shell Command Output"));
    w = o;
    { Fl_Text_Display* o = shell_run_display = new Fl_Text_Display(10, 10, 535, 375);
      o->box(FL_DOWN_BOX);
      o->textfont(4);
      Fl_Group::current()->resizable(o);
      shell_run_buffer = new Fl_Text_Buffer();
      shell_run_display->buffer(shell_run_buffer);
    }
    { Fl_Return_Button* o = shell_run_button = new Fl_Return_Button(468, 395, 77, 25, _("Close"));
      o->callback((Fl_Callback*)cb_shell_run_button);
    }
    o->end();
  }
  return w;
}

Fl_Double_Window *grid_window=(Fl_Double_Window *)0;

Fl_Input *horizontal_input=(Fl_Input *)0;

Fl_Input *vertical_input=(Fl_Input *)0;

Fl_Input *snap_input=(Fl_Input *)0;

Fl_Check_Button *guides_toggle=(Fl_Check_Button *)0;

static void cb_Close2(Fl_Button*, void*) {
  grid_window->hide();
}

Fl_Round_Button *def_widget_size[6]={(Fl_Round_Button *)0};

Fl_Double_Window* make_layout_window() {
  Fl_Double_Window* w;
  { Fl_Double_Window* o = grid_window = new Fl_Double_Window(285, 245, _("Layout Settings"));
    w = o;
    { Fl_Input* o = horizontal_input = new Fl_Input(106, 10, 50, 25, _("x"));
      o->tooltip(_("Horizontal grid spacing."));
      o->type(2);
      o->box(FL_THIN_DOWN_BOX);
      o->callback((Fl_Callback*)grid_cb, (void*)(1));
      o->align(FL_ALIGN_RIGHT);
      o->when(FL_WHEN_RELEASE|FL_WHEN_ENTER_KEY);
    }
    { Fl_Input* o = vertical_input = new Fl_Input(166, 10, 50, 25, _("pixels"));
      o->tooltip(_("Vertical grid spacing."));
      o->type(2);
      o->box(FL_THIN_DOWN_BOX);
      o->callback((Fl_Callback*)grid_cb, (void*)(2));
      o->align(FL_ALIGN_RIGHT);
      o->when(FL_WHEN_RELEASE|FL_WHEN_ENTER_KEY);
    }
    { Fl_Input* o = snap_input = new Fl_Input(106, 45, 50, 25, _("pixel snap"));
      o->tooltip(_("Snap to grid within this many pixels."));
      o->type(2);
      o->box(FL_THIN_DOWN_BOX);
      o->callback((Fl_Callback*)grid_cb, (void*)(3));
      o->align(FL_ALIGN_RIGHT);
      o->when(FL_WHEN_RELEASE|FL_WHEN_ENTER_KEY);
    }
    { Fl_Check_Button* o = guides_toggle = new Fl_Check_Button(106, 80, 110, 25, _("Show Guides"));
      o->tooltip(_("Show distance and alignment guides in overlay"));
      o->down_box(FL_DOWN_BOX);
      o->callback((Fl_Callback*)guides_cb, (void*)(4));
    }
    { Fl_Button* o = new Fl_Button(215, 210, 60, 25, _("Close"));
      o->tooltip(_("Close this dialog."));
      o->callback((Fl_Callback*)cb_Close2);
    }
    { Fl_Box* o = new Fl_Box(26, 10, 70, 25, _("Grid:"));
      o->labelfont(1);
      o->align(FL_ALIGN_RIGHT|FL_ALIGN_INSIDE);
    }
    { Fl_Box* o = new Fl_Box(-1, 115, 97, 25, _("Widget Size:"));
      o->labelfont(1);
      o->align(FL_ALIGN_RIGHT|FL_ALIGN_INSIDE);
    }
    { Fl_Group* o = new Fl_Group(105, 115, 170, 75);
      { Fl_Round_Button* o = def_widget_size[0] = new Fl_Round_Button(105, 115, 70, 25);
        o->type(102);
        o->down_box(FL_ROUND_DOWN_BOX);
        o->callback((Fl_Callback*)default_widget_size_cb, (void*)(8));
      }
      { Fl_Box* o = new Fl_Box(120, 115, 50, 25, _("tiny"));
        o->labelsize(8);
        o->align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
      }
      { Fl_Round_Button* o = def_widget_size[1] = new Fl_Round_Button(180, 115, 70, 25);
        o->type(102);
        o->down_box(FL_ROUND_DOWN_BOX);
        o->callback((Fl_Callback*)default_widget_size_cb, (void*)(11));
      }
      { Fl_Box* o = new Fl_Box(195, 115, 50, 25, _("small"));
        o->labelsize(11);
        o->align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
      }
      { Fl_Round_Button* o = def_widget_size[2] = new Fl_Round_Button(105, 140, 70, 25);
        o->type(102);
        o->down_box(FL_ROUND_DOWN_BOX);
        o->callback((Fl_Callback*)default_widget_size_cb, (void*)(14));
      }
      { Fl_Box* o = new Fl_Box(120, 140, 50, 25, _("normal"));
        o->align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
      }
      { Fl_Round_Button* o = def_widget_size[3] = new Fl_Round_Button(180, 140, 90, 25);
        o->type(102);
        o->down_box(FL_ROUND_DOWN_BOX);
        o->callback((Fl_Callback*)default_widget_size_cb, (void*)(18));
      }
      { Fl_Box* o = new Fl_Box(195, 140, 68, 25, _("medium"));
        o->labelsize(18);
        o->align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
      }
      { Fl_Round_Button* o = def_widget_size[4] = new Fl_Round_Button(105, 165, 75, 25);
        o->type(102);
        o->down_box(FL_ROUND_DOWN_BOX);
        o->callback((Fl_Callback*)default_widget_size_cb, (void*)(24));
      }
      { Fl_Box* o = new Fl_Box(120, 165, 64, 25, _("large"));
        o->labelsize(24);
        o->align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
      }
      { Fl_Round_Button* o = def_widget_size[5] = new Fl_Round_Button(180, 165, 95, 25);
        o->type(102);
        o->down_box(FL_ROUND_DOWN_BOX);
        o->callback((Fl_Callback*)default_widget_size_cb, (void*)(32));
      }
      { Fl_Box* o = new Fl_Box(195, 165, 76, 25, _("huge"));
        o->labelsize(32);
        o->align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
      }
      o->end();
    }
    o->set_non_modal();
    o->end();
  }
  return w;
}

//
// End of "$Id: alignment_panel.cxx 4632 2005-11-03 22:16:52Z mike $".
//
