############################ -*- Mode: Makefile -*- ###########################
## local.mk --- 
## Author           : Manoj Srivastava ( srivasta@glaurung.green-gryphon.com ) 
## Created On       : Sat Nov 15 10:42:10 2003
## Created On Node  : glaurung.green-gryphon.com
## Last Modified By : Manoj Srivastava
## Last Modified On : Fri Oct 20 14:14:16 2006
## Last Machine Used: glaurung.internal.golden-gryphon.com
## Update Count     : 48
## Status           : Unknown, Use with caution!
## HISTORY          : 
## Description      : 
## 
## arch-tag: b07b1015-30ba-4b46-915f-78c776a808f4
## 
###############################################################################

testdir:
	$(testdir)

CONFIG-common:: stamp-conf/flex

BUILD/flex:: build/flex
INST/flex:: install/flex
BIN/flex:: binary/flex

BUILD/flex-doc:: build/flex-doc
INST/flex-doc:: install/flex-doc
BIN/flex-doc:: binary/flex-doc

CLN-common::
	$(REASON)
	$(MAKE) clean -C po || true

CLEAN/flex::
	-rm -rf $(TMPTOP)
	$(CREATE_COMPATIBLE_TEMPLATE)

CLEAN/flex-doc::
	-rm -rf $(TMPTOP)

stamp-conf/flex:
	$(checkdir)
	$(REASON)
	if ! which flex >/dev/null 2>&1; then                              \
           if [ -e debian/scan.l.md5sum ] &&                               \
              [ "`md5sum scan.l`" = "`cat debian/scan.l.md5sum`" ]; then   \
                if [ scan.l -nt scan.c ]; then                             \
                   echo "scan.l newer than scan.c";                        \
                fi;                                                        \
                touch scan.c;                                              \
           fi;                                                             \
        fi
	test -f stamp-conf ||                                              \
            ac_cv_lib_util_getloadavg=no ./configure   --verbose           \
                --prefix=$(PREFIX) $(confflags) && touch stamp-conf

STAMPS_TO_CLEAN += stamp-conf

build/flex: checkpo
	$(checkdir)
	$(REASON)
	bash -n debian/doc.postinst
	bash -n debian/doc.postrm
	bash -n debian/doc.prerm
	bash -n debian/postinst
	bash -n debian/prerm
	bash -n debian/preinst
	bash -n debian/postrm
	bash -n debian/config
	test -f stamp-build-flex || $(MAKE) CC="$(CC)" CFLAGS="$(CFLAGS)" LDFLAGS="$(LDFLAGS)"
	test -f stamp-build-flex || $(MAKE) -C po
ifeq ($(DEB_BUILD_GNU_TYPE),$(DEB_HOST_GNU_TYPE))
	test -f stamp-build-flex || $(MAKE) check
endif
	touch stamp-build-flex

STAMPS_TO_CLEAN += stamp-build-flex

build/flex-doc:
	$(checkdir)
	$(REASON)
	test -d debian/html || mkdir debian/html
	(cd debian/html; \
	 texi2html -doctype html2 -expandinfo -glossary -menu \
	           -split_chapter -o . -verbose  \
                                        ../../doc/flex.texi)
	touch stamp-build-flex-doc

STAMPS_TO_CLEAN += stamp-build-flex-doc

install/flex-doc: testroot
	$(checkdir)
	$(REASON)
	rm -rf              $(TMPTOP)
	$(make_directory)   $(TMPTOP)
	$(make_directory)   $(DOCDIR)
	$(make_directory)   $(DOCBASEDIR)
	$(install_file)     README                  $(DOCDIR)/README
	$(install_file)     NEWS                    $(DOCDIR)/NEWS
	$(install_file)     debian/changelog        $(DOCDIR)/changelog.Debian
	gzip -9fqr          $(DOCDIR)/
# Make sure the copyright file is not compressed
	$(install_file)     debian/copyright        $(DOCDIR)/copyright
	$(install_file)     debian/html/flex*.html  $(DOCDIR)/
	ln -s 		  flex_toc.html           $(DOCDIR)/index.html;
	ln -s               NEWS.gz                 $(DOCDIR)/changelog.gz 
	$(install_file)     debian/docentry         $(DOCBASEDIR)/$(package)

install/flex: testroot
	$(checkdir)
	$(REASON)
	rm -rf               $(TMPTOP)
	$(make_directory)    $(TMPTOP)
	$(make_directory)    $(BINDIR)
	$(make_directory)    $(LIBDIR)
	$(make_directory)    $(INFODIR)
	$(make_directory)    $(MAN1DIR)
	$(make_directory)    $(DOCDIR)
	$(make_directory)    $(LINTIANDIR)
	echo 'flex: description-synopsis-might-not-be-phrased-properly'>> \
                              $(LINTIANDIR)/$(package)
	$(MAKE)              $(INT_INSTALL_TARGET)  prefix=$(TMPTOP)/usr \
	                     infodir=$(INFODIR)     mandir=$(MANDIR)     \
                              INSTALL_PROGRAM="$(install_program)"
	$(install_file)      debian/libfl.so        $(LIBDIR)/
	$(MAKE) install      -C po                  prefix=$(TMPTOP)/usr
	ln -s                flex                   $(BINDIR)/flex++
	#(cd doc &&  makeinfo               --no-split flex.texi;)
	$(install_file)      doc/flex.info          $(INFODIR)
	-$(install_file)     doc/flex.info-*        $(INFODIR)
	test ! -e            $(INFODIR)/dir         || rm -f $(INFODIR)/dir
	test ! -e            $(INFODIR)/dir.old     || rm -f $(INFODIR)/dir.old
	$(install_file)      README                 $(DOCDIR)/README
	$(install_file)      debian/README          $(DOCDIR)/README.Debian 
	$(install_file)      debian/NEWS.Debian     $(DOCDIR)/NEWS.Debian 
	$(install_file)      NEWS                   $(DOCDIR)/NEWS
	$(install_file)      debian/changelog       $(DOCDIR)/changelog.Debian
	gzip -9frq           $(DOCDIR)/
# Make sure the copyright file is not compressed
	$(install_file)      debian/copyright       $(DOCDIR)/copyright
	gzip -9fqr           $(MANDIR)/
	gzip -9fq            $(INFODIR)/flex.info*
	test ! -e            $(INFODIR)/dir        || rm -f $(INFODIR)/dir
	test ! -e            $(INFODIR)/dir.old    || rm -f $(INFODIR)/dir.old
	if [ ! -e debian/scan.l.md5sum ] ||                                              \
           [ "`md5sum scan.l`" != "`cat debian/scan.l.md5sum`" ]; then                   \
              md5sum scan.l >      debian/scan.l.md5sum;                                 \
        fi
ifeq (,$(findstring nostrip,$(DEB_BUILD_OPTIONS)))
	find $(TMPTOP) -type f | while read i; do                                        \
           if file -b $$i | egrep -q "^ELF.*executable"; then                             \
             strip --strip-all --remove-section=.comment --remove-section=.note $$i;      \
           fi;                                                                            \
         done
	find $(TMPTOP) -type f | while read i; do                                        \
           if file -b $$i | egrep -q "^ELF.*shared object"; then                          \
             strip --strip-unneeded --remove-section=.comment --remove-section=.note $$i; \
           fi;                                                                            \
         done
endif
	ln -s 	             NEWS.gz               $(DOCDIR)/changelog.gz
	ln -s                flex.1.gz              $(MAN1DIR)/lex.1.gz
	ln -s                flex.1.gz              $(MAN1DIR)/flex++.1.gz
	ln -s                flex                   $(BINDIR)/lex
	ln -s                libfl.a                $(LIBDIR)/libl.a

binary/flex-doc: testroot
	$(checkdir)
	$(REASON)
	$(make_directory)   $(TMPTOP)/DEBIAN
	$(install_script)    debian/doc.postinst     $(TMPTOP)/DEBIAN/postinst
	$(install_script)    debian/doc.postrm       $(TMPTOP)/DEBIAN/postrm
	$(install_script)    debian/doc.prerm        $(TMPTOP)/DEBIAN/prerm
	dpkg-gencontrol      -p$(package) -isp       -P$(TMPTOP)
	$(create_md5sum)     $(TMPTOP)
	chown -R root:root   $(TMPTOP)
	chmod -R u+w,go=rX   $(TMPTOP)
	dpkg --build         $(TMPTOP) ..

binary/flex: testroot
	$(checkdir)
	$(REASON)
	$(make_directory)    $(TMPTOP)/DEBIAN
	$(install_script)    debian/preinst         $(TMPTOP)/DEBIAN/preinst
	$(install_script)    debian/postinst        $(TMPTOP)/DEBIAN/postinst
	$(install_script)    debian/prerm           $(TMPTOP)/DEBIAN/prerm
	$(install_script)    debian/postrm          $(TMPTOP)/DEBIAN/postrm
	$(install_script)    debian/config          $(TMPTOP)/DEBIAN/config
	$(INSTALL_TEMPLATE)
	$(install_file)      debian/templates       $(TMPTOP)/DEBIAN/templates
	k=`find $(TMPTOP) -type f | ( while read i; do          \
            if file -b $$i | egrep -q "^ELF.*executable.*dynamically linked" ; then   \
                j="$$j $$i";                                     \
            fi;                                                  \
         done; echo $$j; )`; if [ -n "$$k" ]; then dpkg-shlibdeps $$k; fi
	dpkg-gencontrol      -V'debconf-depends=debconf (>= $(MINDEBCONFVER))' \
                              -p$(package) -isp      -P$(TMPTOP)
	$(create_md5sum)     $(TMPTOP)
	chown -R root:root   $(TMPTOP)
	chmod -R u+w,go=rX   $(TMPTOP)
	dpkg --build         $(TMPTOP) ..
