.TH "ecatools" "1" "12\&.11\&.2005" "" "Multimedia software" 
.PP 
.SH "NAME" 
ecatools \- audio processing utils based on ecasound
.PP 
.SH "SYNOPSIS" 
\fBecaconvert\fP \&.extension file1 [ file2 \&.\&.\&. fileN ]
.PP 
\fBecafixdc\fP file1 [ file2 \&.\&.\&. fileN ]
.PP 
\fBecalength\fP file1 [ file2 \&.\&.\&. fileN ]
.PP 
\fBecamonitor\fP [host][:port]
.PP 
\fBecanormalize\fP file1 [ file2 \&.\&.\&. fileN ]
.PP 
\fBecaplay\fP [-dfhklopq] [ file1 file2 \&.\&.\&. fileN ]
.PP 
\fBecasignalview\fP [ options ] [ input ] [ output ]
.PP 
.SH "DESCRIPTION" 
.PP 
Ecatools are simple command line utils for audio file processing\&.
Each tool is designed to perform one specific operation\&. Most of 
the tools also support batch processing\&.
.PP 
\fBECACONVERT\fP
.PP 
A tool for converting a set of files to a common target format\&.
This target format is given as the first command line
argument, and its syntax is \fI\&.ext\fP\&.
.PP 
\fBECAFIXDC\fP
.PP 
A simple command-line tool for fixing DC-offset\&.
.PP 
\fBECALENGTH\fP
.PP 
See the separate ecalength(1) man page\&.
.PP 
\fBECAMONITOR\fP
.PP 
Ecamonitor is a util program that can be used 
to monitor an active ecasound session\&. Ecamonitor 
is able to show information about the current 
chainsetup such as list of inputs, outputs, 
current position, effects, the engine status 
and numerous other things\&.
.PP 
By default ecamonitor will try to connect 
to IP4 address "localhost", to port "2868"\&. 
A different address can be specified when 
starting ecamonitor, for example 
"ecamonitor foo\&.mynetwork\&.com" or
"ecamonitor foo\&.mynetwork\&.com:4500"\&.
.PP 
To enable inbound connections, ecasound has to be 
started with the \fI--daemon\fP option\&. Ecamonitor is 
implemented in Python using the NetECI API\&.
.PP 
\fBECANORMALIZE\fP
.PP 
Ecanormalize is a command-line tool for normalizing audio
files to utilize the full available sample resolution\&. Ecanormalize
first finds out how much the input file can be amplified without 
clipping and if there is room for increase, a static gain will 
be applied to the file\&.
.PP 
\fBECAPLAY\fP
.PP 
Ecaplay is a command-line tool for playing audio files\&. Ecaplay 
uses the libecasound engine and is thus able to handle all audio formats
supported by the library\&. 
.PP 
Files can be selected for playback either by specifying the 
filenames on the command-line, or by using the playlist 
mechanism\&. In playlist mode, files can be added to the playlist
using the \fI-q\fP option\&. The \fI-p\fP option can then be used
to play all tracks on the playlist\&. Ecaplay will repeat the
playlist tracks until explicitly stopped (with double Ctrl-C)\&.
Playlist can be flushed with \fI-f\fP and its contents listed
with \fI-l\fP option\&.
.PP 
If not otherwise specified, ecaplay will use the audio output device 
specified in \fI~/\&.ecasound/ecasoundrc\fP for playback\&. A different 
output device can be selected with \fIECAPLAY_OUTPUT_DEVICE\fP shell 
environment variable or with the \fI-o:output_device\fP command-line
option\&.
.PP 
Playback can be stopped at any time with Ctrl-C\&. If multiple
files are played, first Ctrl-C will stop the current file and move
on to play the next one\&. Issuing Ctrl-C twice (within one second), 
will cause ecaplay to exit\&.
.PP 
.IP "-d:debuglevel" 
Set libecasound debug level\&. See ecasound(1)\&.
.IP 
.IP "-f" 
Flush the playlist contents\&. See also 
options \fI-l, -p and -q\fP\&.
.IP 
.IP "-h" 
Print usage information and exit\&.
.IP 
.IP "-k:number" 
Skip \&'number\&' of files\&.
.IP 
.IP "-l" 
List the current playlist contents to stdout\&. See also 
options \fI-f, -p and -q\fP\&.
.IP 
.IP "-o:output_device" 
Use \&'output_device\&' instead of the default output device 
(as specified in \fI~/\&.ecasound/ecasoundrc\fP)\&. Syntax is same
as used by "-o" ecasound option (see ecasound(1) man page)\&.
This option overrides the \fIECAPLAY_OUTPUT_DEVICE\fP environment
variable (more info below)\&.
.IP 
.IP "-p" 
Play tracks in the playlist (in looped mode)\&. See also 
options \fI-f, -l and -q\fP\&.
.IP 
.IP "-q" 
Queue new tracks to the playlist\&. All filenames given on
the command-line will be added to the the playlist\&. It is 
possible to queue new tracks while another instance of 
ecaplay is using the playlist\&. See also options \fI-f, -l 
and -p\fP\&.
.IP 
.PP 
\fBECASIGNALVIEW\fP
.PP 
Ecasignalview is meant for monitoring signal amplitude and peak 
statistics\&. It accepts the following options:
.PP 
.IP "input" 
The first option not starting with a \&'-\&' is interpreted 
as an input string\&. This can be a device or a filename\&. All formats
supported by libecasound are accepted\&. Defaults to \&'/dev/dsp\&'\&.
.IP 
.IP "output" 
Similarly to input, second option not starting with a \&'-\&'
is interpreted as output\&. Defaults to \&'null\&'\&.
.IP 
.IP "-b:buffersize" 
Buffersize in sample frames\&. Defaults to 128\&.
.IP 
.IP "-c" 
Enable cumulative mode\&. Counters are not reseted after refresh\&.
\fI*deprecated*\fP
.IP 
.IP "-d" 
Enable debug mode\&.
.IP 
.IP "-f:format_string" 
Specify default audio format\&. See ecasound(1) for details\&.
.IP 
.IP "-r:rate_msec" 
Specify screen refresh rate in milliseconds\&.
.IP 
.IP "-I" 
Use linear scale for showing audio sample amplitude\&.
.IP 
.IP "-L" 
Use logarithmic scale for showing audio sample amplitude\&.
.IP 
.IP "-G, -B, -M*, -r, -z" 
Ecasound options use to modify the engine behaviour, see 
ecasound(1) manpage for details\&.
.IP 
.PP 
When ecasignalview is running, the following keyboard 
commands can be used to control the operation (requires 
system support for UNIX terminal interface control):
.PP 
.IP "spacebar" 
Reset statistics (max-peak, avg-amplitude and clipped
samples count)\&.
.IP 
.IP "q or Q or Esc" 
Quit ecasignalview\&.
.IP 
.PP 
It is also possible to reset the max-peak and clipped-samples 
counters by sending a SIGHUP signal to the process (i\&.e\&.
from another console: "killall -v -HUP ecasignalview")\&.
.PP 
More complete documentation for ecasignalview can be found 
from "Ecasound User\&'s Guide" (see \&'\&'http://www\&.eca\&.cx/ecasound 
-> Documentation\&'\&')\&.
.PP 
.SH "ENVIRONMENT" 
.PP 
\fIECASOUND\fP
Path to the ecasound executable\&. Used by many ecatools\&.
.PP 
\fIECAPLAY_OUTPUT_DEVICE\fP
Device ecaplay should use for audio output\&. Same syntax
as for ecaplay/ecasound "-o" option\&.
.PP 
.SH "FILES" 
.PP 
\fI~/\&.ecasound/ecasoundrc\fP
The default ecasound resource file\&. See ecasoundrc(5)
for details\&.
.PP 
\fI~/\&.ecasound/ecaplay_queue\fP
File used to store the ecaplay playlist (one track per
line with full path)\&.
.PP 
.SH "SEE ALSO" 
.PP 
ecasound (1), ecalength(1), "HTML docs in the Documentation subdirectory"
.PP 
.SH "AUTHOR" 
.PP 
Kai Vehmanen, <kvehmanen -at- eca -dot- cx>
