.TH "ecasoundrc" "5" "22\&.12\&.2004" "" "Multimedia software" 
.PP 
.SH "NAME" 
ecasoundrc \- ecasound rcfile
.PP 
.SH "SYNOPSIS" 
{prefix}/share/ecasound/ecasoundrc (for instance \&'/usr/local/share/ecasound/ecasoundrc\&')
$HOME/\&.ecasound/ecasoundrc
.PP 
.SH "DESCRIPTION" 
.PP 
\fBecasoundrc\fP is the main configuration file for ecasound\&. 
Any user-specific modification should be done to 
$HOME/\&.ecasound/ecasoundrc, not to the global resource file\&.
.PP 
The format is quite simple\&. One line consists of 
a configuration variable and its value\&. Variable and value 
are separated with either \&'=\&' or \&' \&'\&. Lines beginning with a
"#" are ignored (comment lines)\&. 
.PP 
.SH "VARIABLES" 
.PP 
.IP 
.IP "midi-device" 
MIDI-device\&. If the device name is given in \fIrawmidi,/dev/midi*\fP 
format, OSS/Linux or OSS/Lite drivers are used\&. 
Device \fIrawmidi,/dev/snd/midiCxDy\fP opens an ALSA raw-MIDI 
device with card number \&'x\&' and device number \&'y\&'\&. 
See ecasound(5) man page (the \&'-Md option) for more info\&.
Defaults to \fIrawmidi,/dev/midi\fP\&.
.IP 
.IP "default-output" 
Output device to use by default\&. If a chainsetup with zero
outputs, but with one or more inputs, is connected, a default output
is added and all the chains are connected to it\&. If the special-case
value \&'autodetect\&' is specified, ecasound will try to auto-detect 
a suitable device (JACK -> ALSA -> OSS -> rtnull)\&. 
Defaults to \fIautodetect\fP\&.
.IP 
.IP "default-audio-format" 
Default values for sample format, channel count, sampling rate
and channel interleaving\&. Syntax is the same as used by
ecasound\&'s \fI-f\fP option (see ecasound(1))\&. 
Defaults to \fIs16_le,2,44100,i\fP\&.
.IP 
.IP "default-to-precise-sample-rates" 
Whether to ignore sample rate differences (and possibly avoid 
resampling)\&. Currently only affects OSS-devices\&. Defaults to \fIfalse\fP\&.
.IP 
.IP "default-mix-mode" 
If \fIdefault-mix-mode\fP is \fIsum\fP, engine will mix multiple channels into
one output channel by summing all input channels\&. In mode \fIavg\fP, 
mixing is done by taking the average of all input channels\&. The
\fIavg\fP mode is safe from clipping, while \fIsum\fP is closer
to the way analog mixers work\&. Defaults to \fIavg\fP\&.
.IP 
.IP "bmode-defaults-nonrt" 
Selects the default parameters to use with buffering 
mode \&'nonrt\&' (other modes are \&'rt\&' and \&'rtlowlatency)\&. 
Parameters are given as a comma-separated tuple of values:
1) buffersize (number,-b), 2) raised priority (true/false,-r), 
3) sched_priority (number,-r:X), 4) double buffering
(true/false,-z:db), 5) db-bufsize (number,-z:db,X), and
6) max intbuf (true/false,-z:intbuf)\&. Defaults to
\fI1024,false,50,false,100000,true\fP\&.
.IP 
.IP "bmode-defaults-rt" 
See \&'bmode-defaults-nonrt\&'\&. Defaults to 
\fI1024,true,50,true,100000,true\fP\&.
.IP 
.IP "bmode-defaults-rtlowlatency" 
See \&'bmode-defaults-nonrt\&'\&. Defaults to 
\fI256,true,50,true,100000,false\fP\&.
.IP 
.IP "resource-directory" 
Directory for global ecasound configuration files\&. 
Defaults to \fI{prefix-dir}/share/ecasound\fP\&.
Note! User-specific resource files can be be stored 
to \&'$(HOME)/\&.ecasound/\&'\&. For instance you can 
add your own presets definitions to 
\&'$(HOME)/\&.ecasound/effect_presets\&'\&.
.IP 
.IP "resource-file-genosc-envelopes" 
Configuration file for generic oscillators\&. Is located in the 
resource directory\&. Defaults to \fIgeneric_oscillators\fP\&.
.IP 
.IP "resource-file-effect-presets" 
Configuration file for effect presets\&. Is located in the 
resource directory\&. Defaults to \fIeffect_presets\fP\&.
.IP 
.IP "ladspa-plugin-directory" 
Directory containing LADSPA effect plugins\&. Defaults to \fI{prefix-dir}/lib/ladspa\fP\&.
If environment variable \fILADSPA_PATH\fP exists, directories
specified in it are automatically searched for plugins\&.
Note! To match the syntax of the \fILADSPA_PATH\fP environment 
variable, \&'ladspa-plugin-directory\&' can contain multiple
directories, separated by \&':\&' characters\&.
.IP 
.IP "ext-cmd-text-editor" 
If \fIext-cmd-text-editor-use-getenv\fP is \fIfalse\fP or "EDITOR" 
is null, value of this field is used\&. Defaults to \fIpico\fP\&.
.IP 
.IP "ext-cmd-text-editor-use-getenv" 
Should ecasound try to query environment variable "EDITOR"\&.
Defaults to \fItrue\fP\&.
.IP 
.IP "ext-cmd-wave-editor" 
Command line for executing an external wave editor\&. Defaults
to \fIsnd\fP\&.
.IP 
.IP "ext-cmd-mp3-input" 
Command for starting mp3 input\&. Ecasound expects that signed,
16bit, stereo audio samples are written to standard output\&.
Ecasound will query other audio	format parameters by parsing 
the mp3 file header\&. Before execution, %f is replaced with
path to the input mp3\&. If exists, "%o" is replaced with he
start offset in mp3 frames\&. Double-quotes and backslash-espacing 
can be used to include white-space to individual parameters\&.
Defaults to \fImpg123 --stereo -r -b 0 -q -s -k %o %f\fP\&.
.IP 
.IP "ext-cmd-mp3-output" 
Command for starting mp3 output\&. Ecasound will write stereo, 
signed, 16bit, little-endian samples to standard output\&. Sample
rate is configurable\&. Before execution, %f is replaced with 
path to the output mp3, %S with sample rate in kHz, and 
%B with encoding bitrate in kbps\&. Double-quotes and 
backslash-espacing can be used to include white-space to 
individual parameters\&.Defaults to \fIlame -b %B -s %S -x -S - %f\fP\&.
.IP 
.IP "ext-cmd-ogg-input" 
Command for starting Ogg Vorbis input\&. Ecasound expects that audio samples
are written to standard output\&. It should be noted that
Ecasound is not able to query the audio format parameters from
ogg files, so these need to be set manually by the user\&.
Before execution, %f is replaced with path to the input ogg\&. 
Double-quotes and backslash-espacing can be used to include white-space 
to individual parameters\&. Defaults to 
\fIogg123 -d raw -o byteorder:%E --file=- %f\fP\&.
.IP 
.IP "ext-cmd-ogg-output" 
Command for starting Ogg Vorbis output\&. Ecasound will write
samples in little-endian format to standard output\&. Other 
audio parameters are configurable\&. Before execution, %f is
replaced with path to the output ogg, %c, %s and %b with matching audio
format parameters, and %B with encoding bitrate in kbps\&.
Double-quotes and backslash-espacing can be used to include white-space to 
individual parameters\&. Defaults to 
\fIoggenc -b %B --raw --raw-bits=%b --raw-chan=%c --raw-rate=%s --raw-endianness 0 --output=%f -\fP\&.
.IP 
.IP "ext-cmd-mikmod" 
Command for starting mikmod input\&. Ecasound expects that 
signed, 16bit, stereo audio samples are written to standard 
output\&. Before execution, %f is replaced with 
file path, and %s with selected sample rate\&. Double-quotes 
and backslash-espacing can be used to include white-space to 
individual parameters\&. Defaults to \fImikmod -d stdout -o 16s -q -f %s -p 0 --noloops %f\fP\&.
.IP 
.IP "ext-cmd-timidity" 
Command for starting timidity++ input\&. Ecasound expects that
signed, 16bit, stereo audio samples are written to standard
output\&. Before execution, %f is replaced with file path, and
%s with sample rate\&. Double-quotes and backslash-espacing can 
be used to include white-space to individual parameters\&.
Defaults to \fItimidity -Or1S -id -s %s -o - %f\fP\&.
.IP 
.IP "ext-cmd-flac-input" 
Command for starting FLAC input\&. Ecasound expects that audio samples
are written to standard output\&. It should be noted that
Ecasound is not able to query the audio format parameters from
FLAC files, so these need to be set manually by the user\&. 
Before execution, %f is replaced with path to the input FLAC
file\&. Double-quotes and backslash-espacing can be used to include 
white-space to individual parameters\&.Defaults to \fIflac -d -c %f\fP\&.
.IP 
.IP "ext-cmd-flac-output" 
Command for starting FLAC output\&. Ecasound will write
samples to standard output\&. All audio parameters are
configurable\&. Before execution, %f is replaced with path to
the output flac, %c, %b and %s with matching audio
format parameters, %I with either \&'signed\&' or \&'unsigned\&', and
%E with either \&'little\&' or \&'big\&'\&. Double-quotes and backslash-espacing 
can be used to include white-space to individual parameters\&. Defaults 
to \fIflac -o %f --force-raw-format --channels=%c --bps=%b --sample-rate=%s --sign=%I --endian=%E -\fP\&.
.IP 
.IP "ext-cmd-aac-input" 
Command for starting AAC input\&. Ecasound expects that signed,
16bit, stereo, big-endian audio samplesare written to standard 
output\&. It should be noted that	Ecasound is not able to query 
the input sample rate, so this needs to be set manually by the user\&. 
Before execution, %f is replaced with path to the input AAC
file\&. Note! FAAC must be compiled with MP4 support\&. Double-quotes 
and backslash-espacing can be used to include white-space to 
individual parameters\&. Defaults to \fIfaad -w -b 1 -f 2 -d %f\fP\&.
.IP 
.IP "ext-cmd-aac-output" 
Command for starting AAC output\&. Ecasound will write big-endian
audio samples to standard output\&. All other audio parameters are
configurable\&. Before execution, %f is replaced with path to
the output AAC file, %c, %b and %s with matching audio format 
parameters\&. Note! FAAC must be compiled with MP4 support\&. Double-quotes 
and backslash-espacing can be used to include white-space to 
individual parameters\&. Defaults to \fIfaac -P -o %f -R %s -B %b -C %c -\fP\&.
.IP 
.PP 
.SH "SEE ALSO" 
.PP 
ecasound(1), ecatools (1), ecasound-iam(1)
.PP 
.SH "AUTHOR" 
.PP 
Kai Vehmanen, <kvehmanen -at- eca -dot- cx>
