/*
    Copyright (C) 2003-2006 Fons Adriaensen <fons.adriaensen@skynet.be>
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <sys/mman.h>
#include <clthreads.h>
#include <clalsadrv.h>


char          name [64];
unsigned long fsamp;
unsigned long frsize;
unsigned long nfrags;


class Testthr : public P_thread
{
public:
 
    virtual void thr_main (void);

private:

    float *buf0;
    float *buf1;

};


void Testthr::thr_main (void)
{
    Alsa_driver *D;
    unsigned long k;

    buf0 = new float [frsize];
    buf1 = new float [frsize];

    D = new Alsa_driver (name, fsamp, frsize, nfrags, true, true, true);
    if (D->stat ()) 
    {
        delete D;
        return;
    }
    D->printinfo ();

    D->pcm_start ();
    while (1)
    {
	k = D->pcm_wait ();  

        while (k >= frsize)
       	{
            D->capt_init (frsize);
            D->capt_chan (0, buf0, frsize);
            D->capt_chan (1, buf1, frsize);              
            D->capt_done (frsize);

            D->play_init (frsize);
            D->play_chan (0, buf0, frsize);
            D->play_chan (1, buf1, frsize);              
            D->play_done (frsize);

            k -= frsize;
	}
    }
    D->pcm_stop ();

    delete D;
}


int main (int ac, char *av [])
{
    Testthr T;

    if (ac < 5)
    {
	fprintf (stderr, "loopback <device><fsamp><frsize><nfrags>\n");
        return 1;
    }

    mlockall (MCL_CURRENT | MCL_FUTURE);

    strcpy (name, av [1]);
    fsamp  = atoi (av [2]);
    frsize = atoi (av [3]);
    nfrags = atoi (av [4]);

    T.thr_start (SCHED_FIFO, 0);
    pthread_exit (0);

    return 0;
}

