#!/bin/sh
set -e

# only run this script if the system is going into suspend
if [ "$1" != "suspend" ]; then
	exit 0
fi

# Expire any automounted file systems when suspending. We don't stop autofs,
# since there might still be lots of active files on these filesystems (so
# stopping might easily fail).

# Each automount daemon leaves its pid in one of these files
for i in /var/run/autofs/*.pid; do
    pid=`head -n 1 $i 2>/dev/null`
    [ "$pid" = "" ] && continue
    # SIGUSR1 makes the daemon unmount any unused filesystems without
    # quitting
    kill -USR1 $pid
done
