/*
  span-arpeggio-engraver.cc -- implement Span_arpeggio_engraver

  source file of the GNU LilyPond music typesetter

  (c) 2000--2005 Jan Nieuwenhuizen <janneke@gnu.org>

  Han-Wen Nienhuys <hanwen@xs4all.nl>
*/

#include "engraver.hh"
#include "arpeggio.hh"
#include "pointer-group-interface.hh"
#include "side-position-interface.hh"
#include "staff-symbol-referencer.hh"

/**
   Make arpeggios that span multiple staves.  Catch arpeggios, and span a
   Span_arpeggio over them if we find more than two arpeggios.
*/
class Span_arpeggio_engraver : public Engraver
{
public:
  TRANSLATOR_DECLARATIONS (Span_arpeggio_engraver);
  DECLARE_ACKNOWLEDGER (arpeggio);

protected:
  void process_acknowledged ();
  void stop_translation_timestep ();

private:
  Item *span_arpeggio_;
  Link_array<Grob> arpeggios_;
};

Span_arpeggio_engraver::Span_arpeggio_engraver ()
{
  span_arpeggio_ = 0;
}

void
Span_arpeggio_engraver::acknowledge_arpeggio (Grob_info info)
{
  if (info.origin_contexts (this).size ()) // huh? what's this test for? 
    {
      arpeggios_.push (info.grob ());
    }
}

void
Span_arpeggio_engraver::process_acknowledged ()
{
  /*
    connectArpeggios is slightly brusque; we should really read a grob
    property of the caught non-span arpeggios. That way, we can have

    both non-connected and connected arps in one pianostaff.

  */
  if (!span_arpeggio_ && arpeggios_.size () > 1
      && to_boolean (get_property ("connectArpeggios")))
    {
      span_arpeggio_ = make_item ("Arpeggio", SCM_EOL);
    }
}

void
Span_arpeggio_engraver::stop_translation_timestep ()
{
  if (span_arpeggio_)
    {
      /*
	we do this very late, to make sure we also catch `extra'
	side-pos support like accidentals.
      */
      for (int j = 0; j < arpeggios_.size (); j++)
	{
	  extract_grob_set (arpeggios_[j], "stems", stems);
	  for (int i = stems.size() ; i--;)
	    Pointer_group_interface::add_grob (span_arpeggio_, ly_symbol2scm ("stems"),
					       stems[i]);

	  extract_grob_set (arpeggios_[j], "side-support-elements", sses);
	  for (int i = sses.size() ; i--;)
	    Pointer_group_interface::add_grob (span_arpeggio_, ly_symbol2scm ("side-support-elements"),
					       sses[i]);

	  /*
	    we can't kill the children, since we don't want to the
	    previous note to bump into the span arpeggio; so we make
	    it transparent.  */
	  arpeggios_[j]->set_property ("print-function", SCM_EOL);
	}

      span_arpeggio_ = 0;
    }
  arpeggios_.clear ();
}

#include "translator.icc"

ADD_ACKNOWLEDGER (Span_arpeggio_engraver,arpeggio);
ADD_TRANSLATOR (Span_arpeggio_engraver,
		/* descr */ "",
		/* creats*/ "Arpeggio",
		/* accepts */ "",
		/* reads */ "connectArpeggios",
		/* write */ "");
