/* A Bison parser, made by GNU Bison 2.0a.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003, 2004 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Using locations.  */
#define YYLSP_NEEDED 1



/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     ADDLYRICS = 258,
     ACCEPTS = 259,
     ADDQUOTE = 260,
     ALIAS = 261,
     ALTERNATIVE = 262,
     BAR = 263,
     BOOK = 264,
     CHANGE = 265,
     CHORDMODE = 266,
     CHORDS = 267,
     CLEF = 268,
     CONSISTS = 269,
     CONTEXT = 270,
     DEFAULT = 271,
     DEFAULTCHILD = 272,
     DENIES = 273,
     DESCRIPTION = 274,
     DRUMMODE = 275,
     DRUMS = 276,
     FIGUREMODE = 277,
     FIGURES = 278,
     GROBDESCRIPTIONS = 279,
     HEADER = 280,
     INVALID = 281,
     KEY = 282,
     LAYOUT = 283,
     LYRICMODE = 284,
     LYRICS = 285,
     LYRICSTO = 286,
     MARK = 287,
     MARKUP = 288,
     MIDI = 289,
     NAME = 290,
     NOTEMODE = 291,
     OBJECTID = 292,
     OCTAVE = 293,
     ONCE = 294,
     OVERRIDE = 295,
     PAPER = 296,
     PARTIAL = 297,
     RELATIVE = 298,
     REMOVE = 299,
     REPEAT = 300,
     REST = 301,
     REVERT = 302,
     SCORE = 303,
     SEQUENTIAL = 304,
     SET = 305,
     SIMULTANEOUS = 306,
     SKIP = 307,
     TAG = 308,
     TEMPO = 309,
     TIMES = 310,
     TRANSPOSE = 311,
     TRANSPOSITION = 312,
     TYPE = 313,
     UNSET = 314,
     WITH = 315,
     TIME_T = 316,
     NEWCONTEXT = 317,
     CHORD_BASS = 318,
     CHORD_CARET = 319,
     CHORD_COLON = 320,
     CHORD_MINUS = 321,
     CHORD_SLASH = 322,
     DOUBLE_ANGLE_CLOSE = 323,
     DOUBLE_ANGLE_OPEN = 324,
     E_BACKSLASH = 325,
     E_ANGLE_CLOSE = 326,
     E_CHAR = 327,
     E_CLOSE = 328,
     E_EXCLAMATION = 329,
     E_BRACKET_OPEN = 330,
     E_OPEN = 331,
     E_BRACKET_CLOSE = 332,
     E_ANGLE_OPEN = 333,
     E_TILDE = 334,
     EXTENDER = 335,
     FIGURE_CLOSE = 336,
     FIGURE_OPEN = 337,
     FIGURE_SPACE = 338,
     HYPHEN = 339,
     CHORDMODIFIERS = 340,
     LYRIC_MARKUP = 341,
     MULTI_MEASURE_REST = 342,
     SCM_T = 343,
     DIGIT = 344,
     E_UNSIGNED = 345,
     UNSIGNED = 346,
     IDENTIFIER = 347,
     CHORDMODIFIER_PITCH = 348,
     CHORD_MODIFIER = 349,
     CONTEXT_DEF_IDENTIFIER = 350,
     DRUM_PITCH = 351,
     DURATION_IDENTIFIER = 352,
     EVENT_IDENTIFIER = 353,
     FRACTION = 354,
     LYRICS_STRING = 355,
     LYRIC_MARKUP_IDENTIFIER = 356,
     MARKUP_HEAD_EMPTY = 357,
     MARKUP_HEAD_LIST0 = 358,
     MARKUP_HEAD_MARKUP0 = 359,
     MARKUP_HEAD_MARKUP0_MARKUP1 = 360,
     MARKUP_HEAD_SCM0 = 361,
     MARKUP_HEAD_SCM0_MARKUP1 = 362,
     MARKUP_HEAD_SCM0_SCM1 = 363,
     MARKUP_HEAD_SCM0_SCM1_MARKUP2 = 364,
     MARKUP_HEAD_SCM0_SCM1_SCM2 = 365,
     MARKUP_IDENTIFIER = 366,
     MUSIC_FUNCTION = 367,
     MUSIC_FUNCTION_MARKUP = 368,
     MUSIC_FUNCTION_MARKUP_MARKUP = 369,
     MUSIC_FUNCTION_MARKUP_MARKUP_MUSIC = 370,
     MUSIC_FUNCTION_MARKUP_MUSIC = 371,
     MUSIC_FUNCTION_MARKUP_MUSIC_MUSIC = 372,
     MUSIC_FUNCTION_MUSIC = 373,
     MUSIC_FUNCTION_MUSIC_MUSIC = 374,
     MUSIC_FUNCTION_SCM = 375,
     MUSIC_FUNCTION_SCM_MUSIC = 376,
     MUSIC_FUNCTION_SCM_MUSIC_MUSIC = 377,
     MUSIC_FUNCTION_SCM_SCM = 378,
     MUSIC_FUNCTION_SCM_SCM_MUSIC = 379,
     MUSIC_IDENTIFIER = 380,
     NOTENAME_PITCH = 381,
     NUMBER_IDENTIFIER = 382,
     OUTPUT_DEF_IDENTIFIER = 383,
     REAL = 384,
     RESTNAME = 385,
     SCM_IDENTIFIER = 386,
     SCORE_IDENTIFIER = 387,
     STRING = 388,
     STRING_IDENTIFIER = 389,
     TONICNAME_PITCH = 390,
     UNARY_MINUS = 391
   };
#endif
#define ADDLYRICS 258
#define ACCEPTS 259
#define ADDQUOTE 260
#define ALIAS 261
#define ALTERNATIVE 262
#define BAR 263
#define BOOK 264
#define CHANGE 265
#define CHORDMODE 266
#define CHORDS 267
#define CLEF 268
#define CONSISTS 269
#define CONTEXT 270
#define DEFAULT 271
#define DEFAULTCHILD 272
#define DENIES 273
#define DESCRIPTION 274
#define DRUMMODE 275
#define DRUMS 276
#define FIGUREMODE 277
#define FIGURES 278
#define GROBDESCRIPTIONS 279
#define HEADER 280
#define INVALID 281
#define KEY 282
#define LAYOUT 283
#define LYRICMODE 284
#define LYRICS 285
#define LYRICSTO 286
#define MARK 287
#define MARKUP 288
#define MIDI 289
#define NAME 290
#define NOTEMODE 291
#define OBJECTID 292
#define OCTAVE 293
#define ONCE 294
#define OVERRIDE 295
#define PAPER 296
#define PARTIAL 297
#define RELATIVE 298
#define REMOVE 299
#define REPEAT 300
#define REST 301
#define REVERT 302
#define SCORE 303
#define SEQUENTIAL 304
#define SET 305
#define SIMULTANEOUS 306
#define SKIP 307
#define TAG 308
#define TEMPO 309
#define TIMES 310
#define TRANSPOSE 311
#define TRANSPOSITION 312
#define TYPE 313
#define UNSET 314
#define WITH 315
#define TIME_T 316
#define NEWCONTEXT 317
#define CHORD_BASS 318
#define CHORD_CARET 319
#define CHORD_COLON 320
#define CHORD_MINUS 321
#define CHORD_SLASH 322
#define DOUBLE_ANGLE_CLOSE 323
#define DOUBLE_ANGLE_OPEN 324
#define E_BACKSLASH 325
#define E_ANGLE_CLOSE 326
#define E_CHAR 327
#define E_CLOSE 328
#define E_EXCLAMATION 329
#define E_BRACKET_OPEN 330
#define E_OPEN 331
#define E_BRACKET_CLOSE 332
#define E_ANGLE_OPEN 333
#define E_TILDE 334
#define EXTENDER 335
#define FIGURE_CLOSE 336
#define FIGURE_OPEN 337
#define FIGURE_SPACE 338
#define HYPHEN 339
#define CHORDMODIFIERS 340
#define LYRIC_MARKUP 341
#define MULTI_MEASURE_REST 342
#define SCM_T 343
#define DIGIT 344
#define E_UNSIGNED 345
#define UNSIGNED 346
#define IDENTIFIER 347
#define CHORDMODIFIER_PITCH 348
#define CHORD_MODIFIER 349
#define CONTEXT_DEF_IDENTIFIER 350
#define DRUM_PITCH 351
#define DURATION_IDENTIFIER 352
#define EVENT_IDENTIFIER 353
#define FRACTION 354
#define LYRICS_STRING 355
#define LYRIC_MARKUP_IDENTIFIER 356
#define MARKUP_HEAD_EMPTY 357
#define MARKUP_HEAD_LIST0 358
#define MARKUP_HEAD_MARKUP0 359
#define MARKUP_HEAD_MARKUP0_MARKUP1 360
#define MARKUP_HEAD_SCM0 361
#define MARKUP_HEAD_SCM0_MARKUP1 362
#define MARKUP_HEAD_SCM0_SCM1 363
#define MARKUP_HEAD_SCM0_SCM1_MARKUP2 364
#define MARKUP_HEAD_SCM0_SCM1_SCM2 365
#define MARKUP_IDENTIFIER 366
#define MUSIC_FUNCTION 367
#define MUSIC_FUNCTION_MARKUP 368
#define MUSIC_FUNCTION_MARKUP_MARKUP 369
#define MUSIC_FUNCTION_MARKUP_MARKUP_MUSIC 370
#define MUSIC_FUNCTION_MARKUP_MUSIC 371
#define MUSIC_FUNCTION_MARKUP_MUSIC_MUSIC 372
#define MUSIC_FUNCTION_MUSIC 373
#define MUSIC_FUNCTION_MUSIC_MUSIC 374
#define MUSIC_FUNCTION_SCM 375
#define MUSIC_FUNCTION_SCM_MUSIC 376
#define MUSIC_FUNCTION_SCM_MUSIC_MUSIC 377
#define MUSIC_FUNCTION_SCM_SCM 378
#define MUSIC_FUNCTION_SCM_SCM_MUSIC 379
#define MUSIC_IDENTIFIER 380
#define NOTENAME_PITCH 381
#define NUMBER_IDENTIFIER 382
#define OUTPUT_DEF_IDENTIFIER 383
#define REAL 384
#define RESTNAME 385
#define SCM_IDENTIFIER 386
#define SCORE_IDENTIFIER 387
#define STRING 388
#define STRING_IDENTIFIER 389
#define TONICNAME_PITCH 390
#define UNARY_MINUS 391




/* Copy the first part of user declarations.  */
#line 1 "parser.yy"
 // -*-Fundamental-*-

/*
  parser.yy -- Bison/C++ parser for LilyPond

  source file of the GNU LilyPond music typesetter

  (c) 1997--2005 Han-Wen Nienhuys <hanwen@cs.uu.nl>
                 Jan Nieuwenhuizen <janneke@gnu.org>
*/

/*
FIXME:

   * The rules for who is protecting what are very shady.  Uniformise
     this.

   * There are too many lexical modes?
*/

#include "config.hh"

#include <cctype>
#include <cstdlib>
#include <cstdio>
using namespace std;

#include "book.hh"
#include "context-def.hh"
#include "dimensions.hh"
#include "music.hh"
#include "file-path.hh"
#include "input-smob.hh"
#include "input.hh"
#include "lily-guile.hh"
#include "lilypond-input-version.hh"
#include "main.hh"
#include "misc.hh"
#include "lily-lexer.hh"
#include "lily-parser.hh"
#include "paper-book.hh"
#include "output-def.hh"
#include "scm-hash.hh"
#include "program-option.hh"
#include "score.hh"
#include "text-interface.hh"
#include "warn.hh"
#include "music.hh"

#define MY_MAKE_MUSIC(x)  make_music_by_name (ly_symbol2scm (x))

Music *property_op_to_music (SCM op);
Music *context_spec_music (SCM type, SCM id, Music *m, SCM ops);
SCM get_next_unique_context_id ();
SCM get_next_unique_lyrics_context_id ();

#undef _
#if !HAVE_GETTEXT
#define _(x) x
#else
#include <libintl.h>
#define _(x) gettext (x)
#endif

#define YYERROR_VERBOSE 1

#define YYPARSE_PARAM my_lily_parser
#define YYLEX_PARAM my_lily_parser
#define THIS\
	((Lily_parser *) my_lily_parser)

#define yyerror THIS->parser_error

/* We use custom location type: Input objects */
#define YYLTYPE Input
#define YYLLOC_DEFAULT(Current,Rhs,N) \
	((Current).set_location ((Rhs)[1], (Rhs)[N]))


/* Add symbols to the TAGS field of a music object.  */

void
tag_music (Music *m, SCM tag, Input ip)
{
	SCM tags = m->get_property ("tags");
	if (scm_is_symbol (tag))
		tags = scm_cons (tag, tags);
	else if (ly_is_list (tag))
		tags = ly_append2 (tag, tags);
	else
		ip.warning (_ ("tag must be symbol or list of symbols"));

	m->set_property ("tags", tags);
}

bool
is_regular_identifier (SCM id)
{
  String str = ly_scm2string (id);
  char const *s = str.to_str0 ();

  bool v = true;
#if 0
  isalpha (*s);
  s++;
#endif
  while (*s && v)
   {
        v = v && isalnum (*s);
        s++;
   }
  return v;
}


SCM
get_first_context_id (SCM type, Music *m)
{
	SCM id = m->get_property ("context-id");
	if (SCM_BOOL_T == scm_equal_p (m->get_property ("context-type"), type)
	    && scm_is_string (m->get_property ("context-id"))
	    && scm_c_string_length (id) > 0)
	{
		return id;
	}
	return SCM_EOL;
}

SCM
make_simple_markup (SCM a)
{
	return a;
}

bool
is_duration (int t)
{
  return t && t == 1 << intlog2 (t);
}

void
set_music_properties (Music *p, SCM a)
{
  for (SCM k = a; scm_is_pair (k); k = scm_cdr (k))
 	p->internal_set_property (scm_caar (k), scm_cdar (k));
}

SCM
make_chord_step (int step, int alter)
{
	if (step == 7)
		alter += FLAT;

	while (step < 0)
		step += 7;
	Pitch m ((step -1) / 7, (step - 1) % 7, alter);
	return m.smobbed_copy ();
}


SCM
make_chord (SCM pitch, SCM dur, SCM modification_list)
{
	SCM chord_ctor = ly_lily_module_constant ("construct-chord");
	SCM ch = scm_call_3 (chord_ctor, pitch, dur, modification_list);

	unsmob_music (ch)->protect();	
	return ch;
}

/* Todo: actually also use apply iso. call too ...  */
bool
ly_input_procedure_p (SCM x)
{
	return ly_is_procedure (x)
		|| (scm_is_pair (x) && ly_is_procedure (scm_car (x)));
}

Music*
set_property_music (SCM sym, SCM value)
{
	Music *p = MY_MAKE_MUSIC ("PropertySet");
	p->set_property ("symbol", sym);
	p->set_property ("value", value);
	return p;
}

Music*
make_music_relative (Pitch start, Music *music)
{
	Music *relative = MY_MAKE_MUSIC ("RelativeOctaveMusic");
 	relative->set_property ("element", music->self_scm ());
	
 	Pitch last = music->to_relative_octave (start);
 	if (lily_1_8_relative)
 		music->set_property ("last-pitch", last.smobbed_copy ());
	return relative;
}

Music*
make_lyric_combine_music (SCM name, Music *music)
{
	Music *combine = MY_MAKE_MUSIC ("LyricCombineMusic");
	combine->set_property ("element", music->self_scm ());
 	combine->set_property ("associated-context", name);
	return combine;
}



/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 217 "parser.yy"
typedef union YYSTYPE {
	Book *book;
	Output_def *outputdef;
	SCM scm;
	String *string;
 	Music *music;
 	Score *score;
 	int i;
} YYSTYPE;
/* Line 191 of yacc.c.  */
#line 568 "out/parser.cc"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif

#if ! defined (YYLTYPE) && ! defined (YYLTYPE_IS_DECLARED)
typedef struct YYLTYPE
{
  int first_line;
  int first_column;
  int last_line;
  int last_column;
} YYLTYPE;
# define yyltype YYLTYPE /* obsolescent; will be withdrawn */
# define YYLTYPE_IS_DECLARED 1
# define YYLTYPE_IS_TRIVIAL 1
#endif


/* Copy the second part of user declarations.  */
#line 226 "parser.yy"


int
yylex (YYSTYPE *s, YYLTYPE *loc, void *v)
{
	Lily_parser *pars = (Lily_parser*) v;
	Lily_lexer *lex = pars->lexer_;

	lex->lexval = (void*) s;
	lex->lexloc = loc;
	lex->prepare_for_next_token ();
	return lex->yylex ();
}




/* Line 214 of yacc.c.  */
#line 608 "out/parser.cc"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

# ifndef YYFREE
#  define YYFREE free
# endif
# ifndef YYMALLOC
#  define YYMALLOC malloc
# endif

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   else
#    define YYSTACK_ALLOC alloca
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2005 */
#  endif
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  else
#   define YYSIZE_T unsigned long int
#  endif
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM ((YYSIZE_T) -1)
#  endif
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (defined (YYLTYPE_IS_TRIVIAL) && YYLTYPE_IS_TRIVIAL \
             && defined (YYSTYPE_IS_TRIVIAL) && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short int yyss;
  YYSTYPE yyvs;
    YYLTYPE yyls;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short int) + sizeof (YYSTYPE) + sizeof (YYLTYPE))	\
      + 2 * YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined (__GNUC__) && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  YYSIZE_T yyi;				\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short int yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  2
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   2033

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  160
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  128
/* YYNRULES -- Number of rules. */
#define YYNRULES  371
/* YYNRULES -- Number of states. */
#define YYNSTATES  547

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   391

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned char yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   158,     2,     2,     2,     2,     2,   151,
     149,   150,   155,   137,   152,   136,   142,   156,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   157,     2,
     143,   141,   144,   159,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   146,     2,   147,   153,   154,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   139,   145,   140,   148,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   138
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short int yyprhs[] =
{
       0,     0,     3,     4,     7,    10,    13,    16,    19,    21,
      23,    25,    27,    29,    31,    33,    35,    37,    39,    40,
      43,    48,    50,    52,    56,    58,    60,    62,    64,    66,
      68,    70,    72,    74,    76,    78,    83,    84,    86,    90,
      93,    98,    99,   102,   105,   108,   111,   114,   117,   122,
     124,   126,   129,   132,   135,   138,   140,   143,   145,   147,
     149,   152,   156,   159,   162,   165,   168,   173,   174,   177,
     180,   183,   185,   187,   188,   193,   199,   204,   208,   213,
     217,   219,   221,   223,   225,   226,   227,   233,   234,   237,
     239,   241,   243,   245,   247,   250,   253,   256,   260,   264,
     269,   273,   277,   281,   286,   291,   293,   295,   302,   307,
     312,   316,   318,   323,   326,   330,   332,   334,   338,   340,
     342,   344,   346,   348,   350,   352,   354,   356,   360,   363,
     364,   368,   369,   374,   377,   378,   383,   388,   392,   395,
     401,   405,   407,   409,   411,   413,   415,   417,   419,   421,
     423,   425,   428,   430,   434,   440,   444,   449,   452,   455,
     457,   459,   463,   465,   467,   469,   471,   473,   475,   477,
     479,   481,   482,   486,   488,   490,   494,   496,   498,   500,
     502,   506,   507,   510,   516,   519,   523,   525,   528,   531,
     533,   535,   537,   539,   542,   545,   548,   551,   554,   557,
     559,   562,   564,   567,   571,   572,   575,   578,   583,   585,
     587,   589,   592,   595,   597,   599,   601,   603,   605,   607,
     609,   611,   613,   615,   617,   619,   621,   623,   625,   627,
     629,   630,   632,   635,   638,   640,   643,   645,   648,   650,
     653,   656,   658,   661,   664,   666,   668,   670,   672,   674,
     676,   678,   680,   682,   684,   686,   688,   690,   692,   694,
     696,   698,   700,   701,   703,   706,   709,   711,   715,   719,
     721,   725,   726,   729,   731,   734,   736,   738,   740,   742,
     744,   746,   748,   750,   752,   755,   758,   760,   763,   764,
     767,   771,   772,   774,   781,   784,   787,   790,   793,   796,
     798,   800,   802,   805,   810,   811,   814,   816,   818,   821,
     824,   826,   828,   830,   832,   836,   838,   841,   844,   848,
     852,   854,   856,   860,   864,   867,   869,   871,   873,   875,
     878,   881,   883,   885,   886,   889,   890,   893,   895,   896,
     900,   902,   903,   907,   909,   912,   914,   916,   918,   921,
     925,   926,   929,   932,   934,   937,   941,   943,   946,   948,
     950,   952,   954,   955,   961,   964,   969,   973,   975,   978,
     982,   985
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const short int yyrhs[] =
{
     161,     0,    -1,    -1,   161,   163,    -1,   161,   169,    -1,
     161,     1,    -1,   161,    26,    -1,    37,   133,    -1,   167,
      -1,   224,    -1,   173,    -1,   175,    -1,   164,    -1,   276,
      -1,   178,    -1,   192,    -1,    88,    -1,   131,    -1,    -1,
     166,   169,    -1,    25,   139,   166,   140,    -1,   133,    -1,
     100,    -1,   168,   141,   170,    -1,   165,    -1,   175,    -1,
     178,    -1,   171,    -1,   183,    -1,   229,    -1,   267,    -1,
     211,    -1,   165,    -1,   276,    -1,    89,    -1,    15,   139,
     172,   140,    -1,    -1,    95,    -1,   172,    24,   165,    -1,
     172,   208,    -1,     9,   139,   174,   140,    -1,    -1,   174,
     177,    -1,   174,   175,    -1,   174,   276,    -1,   174,   167,
      -1,   174,     1,    -1,   174,   162,    -1,    48,   139,   176,
     140,    -1,   183,    -1,   132,    -1,   176,   162,    -1,   176,
     167,    -1,   176,   178,    -1,   176,     1,    -1,   178,    -1,
     180,   140,    -1,    41,    -1,    34,    -1,    28,    -1,   179,
     139,    -1,   179,   139,   128,    -1,   180,   169,    -1,   180,
     171,    -1,   180,   181,    -1,   180,     1,    -1,    54,   247,
     141,   271,    -1,    -1,   182,   183,    -1,   182,   165,    -1,
     182,     1,    -1,   188,    -1,   192,    -1,    -1,     7,   139,
     182,   140,    -1,    45,   212,   271,   183,   184,    -1,    49,
     139,   182,   140,    -1,   139,   182,   140,    -1,    51,   139,
     182,   140,    -1,   219,   182,   220,    -1,   215,    -1,   125,
      -1,   210,    -1,   205,    -1,    -1,    -1,    60,   190,   139,
     191,   140,    -1,    -1,   191,   208,    -1,   196,    -1,   193,
      -1,   187,    -1,   186,    -1,   112,    -1,   120,   165,    -1,
     113,   276,    -1,   118,   183,    -1,   121,   165,   183,    -1,
     123,   165,   165,    -1,   124,   165,   165,   183,    -1,   116,
     276,   183,    -1,   114,   276,   276,    -1,   119,   183,   183,
      -1,   122,   165,   183,   183,    -1,   117,   276,   183,   183,
      -1,   194,    -1,   195,    -1,    15,   212,   141,   212,   189,
     183,    -1,    15,   212,   189,   183,    -1,    62,   212,   189,
     183,    -1,    55,   249,   183,    -1,   185,    -1,    56,   240,
     240,   183,    -1,   197,   193,    -1,   198,   189,   193,    -1,
     199,    -1,   203,    -1,    53,   165,   183,    -1,    36,    -1,
      20,    -1,    22,    -1,    11,    -1,    29,    -1,    21,    -1,
      23,    -1,    12,    -1,    30,    -1,    43,   244,   183,    -1,
      43,   192,    -1,    -1,     3,   201,   193,    -1,    -1,   200,
       3,   202,   193,    -1,   193,   200,    -1,    -1,    31,   212,
     204,   183,    -1,    10,   133,   141,   133,    -1,   133,   141,
     213,    -1,    59,   212,    -1,    40,   212,   165,   141,   165,
      -1,    47,   212,   165,    -1,    14,    -1,    44,    -1,     4,
      -1,    17,    -1,    18,    -1,     6,    -1,    58,    -1,    19,
      -1,    35,    -1,   206,    -1,   207,   133,    -1,   212,    -1,
     212,   142,   212,    -1,    40,   209,   165,   141,   213,    -1,
      47,   209,   165,    -1,    50,   209,   141,   213,    -1,    59,
     209,    -1,    39,   210,    -1,   133,    -1,   134,    -1,   211,
     137,   211,    -1,   133,    -1,   100,    -1,   134,    -1,   211,
      -1,   100,    -1,   270,    -1,   165,    -1,   276,    -1,    89,
      -1,    -1,   214,   259,   227,    -1,   225,    -1,   216,    -1,
     221,   246,   227,    -1,   143,    -1,   144,    -1,    69,    -1,
      68,    -1,   217,   222,   218,    -1,    -1,   222,   223,    -1,
     239,   272,   273,   234,   227,    -1,    96,   227,    -1,     5,
     211,   183,    -1,   226,    -1,    52,   245,    -1,    38,   239,
      -1,    75,    -1,    77,    -1,    70,    -1,   145,    -1,    57,
     239,    -1,     8,   133,    -1,    42,   245,    -1,    13,   133,
      -1,    61,   249,    -1,    32,   213,    -1,    79,    -1,    32,
      16,    -1,   181,    -1,    27,    16,    -1,    27,   126,   131,
      -1,    -1,   227,   229,    -1,   227,   228,    -1,   136,    53,
     165,   229,    -1,   232,    -1,    84,    -1,    80,    -1,   243,
     233,    -1,   243,   232,    -1,   230,    -1,    90,    -1,   146,
      -1,   147,    -1,   148,    -1,   149,    -1,   150,    -1,    74,
      -1,    76,    -1,    73,    -1,    71,    -1,    78,    -1,   231,
      -1,    98,    -1,   251,    -1,   241,    -1,   242,    -1,    -1,
     141,    -1,   141,   236,    -1,   141,   235,    -1,   151,    -1,
     235,   151,    -1,   152,    -1,   236,   152,    -1,   126,    -1,
     126,   235,    -1,   126,   236,    -1,   135,    -1,   135,   235,
      -1,   135,   236,    -1,   237,    -1,   239,    -1,   238,    -1,
     276,    -1,   211,    -1,    89,    -1,   153,    -1,   137,    -1,
     136,    -1,   145,    -1,   144,    -1,   142,    -1,   154,    -1,
     154,    -1,   153,    -1,   136,    -1,   237,    -1,   248,    -1,
      -1,   248,    -1,   271,   250,    -1,    97,   250,    -1,   247,
      -1,   248,   155,   271,    -1,   248,   155,    99,    -1,    99,
      -1,    91,   156,    91,    -1,    -1,   250,   142,    -1,   157,
      -1,   157,   271,    -1,    89,    -1,    91,    -1,   133,    -1,
     276,    -1,   136,    -1,   137,    -1,   158,    -1,    83,    -1,
     252,    -1,   254,   253,    -1,   146,   254,    -1,   254,    -1,
     255,   147,    -1,    -1,   256,   255,    -1,    82,   256,    81,
      -1,    -1,    46,    -1,   239,   272,   273,   234,   246,   258,
      -1,    96,   246,    -1,   257,   246,    -1,   130,   246,    -1,
      87,   246,    -1,   260,   246,    -1,   261,    -1,   274,    -1,
     100,    -1,   238,   246,    -1,   238,   246,   263,   262,    -1,
      -1,   262,   264,    -1,    65,    -1,    64,    -1,    67,   238,
      -1,    63,   238,    -1,   263,    -1,   265,    -1,    94,    -1,
     266,    -1,   265,   142,   266,    -1,   271,    -1,   271,   137,
      -1,   271,    66,    -1,   267,   137,   268,    -1,   267,   136,
     268,    -1,   268,    -1,   269,    -1,   269,   155,   269,    -1,
     269,   156,   269,    -1,   136,   269,    -1,   270,    -1,    91,
      -1,   129,    -1,   127,    -1,   129,   127,    -1,    91,   127,
      -1,    91,    -1,    89,    -1,    -1,   272,   158,    -1,    -1,
     273,   159,    -1,   101,    -1,    -1,    86,   275,   278,    -1,
     111,    -1,    -1,    33,   277,   278,    -1,   279,    -1,   284,
     285,    -1,   285,    -1,   280,    -1,   281,    -1,   284,   281,
      -1,   139,   282,   140,    -1,    -1,   282,   287,    -1,   282,
     279,    -1,   104,    -1,   107,   165,    -1,   109,   165,   165,
      -1,   283,    -1,   284,   283,    -1,   133,    -1,   111,    -1,
     101,    -1,   134,    -1,    -1,    48,   286,   139,   176,   140,
      -1,   106,   165,    -1,   110,   165,   165,   165,    -1,   108,
     165,   165,    -1,   102,    -1,   103,   279,    -1,   105,   287,
     287,    -1,   284,   285,    -1,   285,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short int yyrline[] =
{
       0,   551,   551,   552,   554,   556,   559,   566,   570,   573,
     576,   582,   589,   595,   599,   616,   621,   622,   627,   631,
     637,   646,   647,   651,   667,   672,   676,   680,   683,   687,
     691,   694,   697,   700,   703,   709,   716,   720,   724,   735,
     743,   752,   759,   763,   768,   771,   774,   778,   784,   790,
     801,   805,   808,   811,   823,   834,   846,   855,   860,   865,
     875,   880,   889,   892,   895,   905,   911,   926,   929,   940,
     943,   960,   961,   965,   968,   975,  1034,  1039,  1047,  1053,
    1061,  1062,  1065,  1066,  1071,  1072,  1072,  1081,  1082,  1089,
    1090,  1094,  1095,  1099,  1102,  1105,  1108,  1112,  1116,  1119,
    1122,  1126,  1129,  1134,  1139,  1147,  1184,  1187,  1191,  1194,
    1199,  1215,  1216,  1226,  1240,  1252,  1253,  1254,  1261,  1267,
    1274,  1279,  1287,  1294,  1300,  1305,  1312,  1320,  1326,  1336,
    1336,  1345,  1345,  1354,  1382,  1382,  1394,  1405,  1409,  1413,
    1417,  1424,  1425,  1427,  1428,  1429,  1431,  1432,  1433,  1434,
    1438,  1439,  1445,  1454,  1461,  1468,  1476,  1483,  1489,  1499,
    1502,  1505,  1510,  1513,  1516,  1521,  1524,  1527,  1530,  1533,
    1536,  1560,  1564,  1577,  1578,  1583,  1599,  1602,  1605,  1608,
    1612,  1622,  1623,  1630,  1658,  1673,  1682,  1690,  1696,  1702,
    1712,  1722,  1726,  1736,  1745,  1754,  1764,  1771,  1778,  1788,
    1791,  1795,  1798,  1802,  1820,  1823,  1828,  1837,  1845,  1848,
    1853,  1858,  1863,  1868,  1872,  1881,  1884,  1887,  1890,  1893,
    1896,  1899,  1902,  1905,  1908,  1914,  1928,  1931,  1940,  1943,
    1954,  1955,  1956,  1957,  1961,  1964,  1970,  1973,  1979,  1982,
    1987,  1999,  2002,  2007,  2016,  2022,  2023,  2027,  2033,  2041,
    2050,  2053,  2056,  2059,  2062,  2065,  2068,  2074,  2075,  2076,
    2081,  2087,  2093,  2097,  2104,  2113,  2122,  2125,  2128,  2136,
    2137,  2143,  2146,  2152,  2155,  2163,  2168,  2173,  2174,  2178,
    2179,  2180,  2184,  2189,  2196,  2210,  2214,  2217,  2224,  2227,
    2233,  2243,  2244,  2248,  2280,  2293,  2302,  2322,  2329,  2342,
    2350,  2353,  2359,  2362,  2369,  2372,  2378,  2381,  2384,  2387,
    2393,  2396,  2399,  2405,  2406,  2412,  2415,  2418,  2430,  2433,
    2436,  2440,  2443,  2446,  2452,  2455,  2460,  2463,  2466,  2469,
    2472,  2479,  2482,  2488,  2489,  2493,  2494,  2502,  2506,  2505,
    2514,  2518,  2517,  2526,  2529,  2532,  2538,  2541,  2547,  2554,
    2560,  2561,  2564,  2570,  2573,  2576,  2582,  2585,  2591,  2594,
    2597,  2600,  2603,  2603,  2612,  2615,  2618,  2621,  2624,  2627,
    2633,  2637
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "\\addlyrics", "\\accepts", "\\addquote",
  "\\alias", "\\alternative", "\\bar", "\book", "\\change", "\\chordmode",
  "\\chords", "\\clef", "\\consists", "\\context", "\\default",
  "\\defaultchild", "\\denies", "\\description", "\\drummode", "\\drums",
  "\\figuremode", "\\figures", "\\grobdescriptions", "\\header",
  "\\invalid", "\\key", "\\layout", "\\lyricmode", "\\lyrics",
  "\\lyricsto", "\\mark", "\\markup", "\\midi", "\\name", "\\notemode",
  "\\objectid", "\\octave", "\\once", "\\override", "\\paper", "\\partial",
  "\\relative", "\\remove", "\\repeat", "\\rest", "\\revert", "\\score",
  "\\sequential", "\\set", "\\simultaneous", "\\skip", "\\tag", "\\tempo",
  "\\times", "\\transpose", "\\transposition", "\\type", "\\unset",
  "\\with", "\\time", "\\new", "/+", "^", ":", "-", "/", ">>", "<<", "\\",
  "\\>", "\\C[haracter]", "\\)", "\\!", "\\[", "\\(", "\\]", "\\<", "\\~",
  "__", "FIGURE_CLOSE", "FIGURE_OPEN", "_", "--", "CHORDMODIFIERS",
  "LYRIC_MARKUP", "MULTI_MEASURE_REST", "SCM_T", "DIGIT", "E_UNSIGNED",
  "UNSIGNED", "IDENTIFIER", "CHORDMODIFIER_PITCH", "CHORD_MODIFIER",
  "CONTEXT_DEF_IDENTIFIER", "DRUM_PITCH", "DURATION_IDENTIFIER",
  "EVENT_IDENTIFIER", "FRACTION", "LYRICS_STRING",
  "LYRIC_MARKUP_IDENTIFIER", "MARKUP_HEAD_EMPTY", "MARKUP_HEAD_LIST0",
  "MARKUP_HEAD_MARKUP0", "MARKUP_HEAD_MARKUP0_MARKUP1", "MARKUP_HEAD_SCM0",
  "MARKUP_HEAD_SCM0_MARKUP1", "MARKUP_HEAD_SCM0_SCM1",
  "MARKUP_HEAD_SCM0_SCM1_MARKUP2", "MARKUP_HEAD_SCM0_SCM1_SCM2",
  "MARKUP_IDENTIFIER", "MUSIC_FUNCTION", "MUSIC_FUNCTION_MARKUP",
  "MUSIC_FUNCTION_MARKUP_MARKUP", "MUSIC_FUNCTION_MARKUP_MARKUP_MUSIC",
  "MUSIC_FUNCTION_MARKUP_MUSIC", "MUSIC_FUNCTION_MARKUP_MUSIC_MUSIC",
  "MUSIC_FUNCTION_MUSIC", "MUSIC_FUNCTION_MUSIC_MUSIC",
  "MUSIC_FUNCTION_SCM", "MUSIC_FUNCTION_SCM_MUSIC",
  "MUSIC_FUNCTION_SCM_MUSIC_MUSIC", "MUSIC_FUNCTION_SCM_SCM",
  "MUSIC_FUNCTION_SCM_SCM_MUSIC", "MUSIC_IDENTIFIER", "NOTENAME_PITCH",
  "NUMBER_IDENTIFIER", "OUTPUT_DEF_IDENTIFIER", "REAL", "RESTNAME",
  "SCM_IDENTIFIER", "SCORE_IDENTIFIER", "STRING", "STRING_IDENTIFIER",
  "TONICNAME_PITCH", "'-'", "'+'", "UNARY_MINUS", "'{'", "'}'", "'='",
  "'.'", "'<'", "'>'", "'|'", "'['", "']'", "'~'", "'('", "')'", "'''",
  "','", "'^'", "'_'", "'*'", "'/'", "':'", "'!'", "'?'", "$accept",
  "lilypond", "object_id_setting", "toplevel_expression", "toplevel_music",
  "embedded_scm", "lilypond_header_body", "lilypond_header",
  "assignment_id", "assignment", "identifier_init",
  "context_def_spec_block", "context_def_spec_body", "book_block",
  "book_body", "score_block", "score_body", "paper_block", "output_def",
  "output_def_head", "output_def_body", "tempo_event", "Music_list",
  "Music", "Alternative_music", "Repeated_music", "Sequential_music",
  "Simultaneous_music", "Simple_music", "optional_context_mod", "@1",
  "context_mod_list", "Composite_music", "Grouped_music_list",
  "Generic_prefix_music_scm", "Generic_prefix_music",
  "Prefix_composite_music", "mode_changing_head",
  "mode_changing_head_with_context", "relative_music", "new_lyrics", "@2",
  "@3", "re_rhythmed_music", "@4", "context_change", "property_operation",
  "context_def_mod", "context_mod", "context_prop_spec",
  "music_property_def", "string", "simple_string", "scalar", "pre_events",
  "event_chord", "note_chord_element", "chord_open", "chord_close",
  "simul_open", "simul_close", "chord_body", "chord_body_elements",
  "chord_body_element", "add_quote", "command_element", "command_event",
  "post_events", "tagged_post_event", "post_event", "string_number_event",
  "direction_less_char", "direction_less_event", "direction_reqd_event",
  "octave_check", "sup_quotes", "sub_quotes", "steno_pitch",
  "steno_tonic_pitch", "pitch", "pitch_also_in_chords", "gen_text_def",
  "script_abbreviation", "script_dir", "absolute_pitch", "duration_length",
  "optional_notemode_duration", "steno_duration", "multiplied_duration",
  "fraction", "dots", "tremolo_type", "bass_number", "bass_mod",
  "bass_figure", "br_bass_figure", "figure_list", "figure_spec",
  "optional_rest", "simple_element", "lyric_element", "new_chord",
  "chord_items", "chord_separator", "chord_item", "step_numbers",
  "step_number", "number_expression", "number_term", "number_factor",
  "bare_number", "bare_unsigned", "exclamations", "questions",
  "lyric_markup", "@5", "full_markup", "@6", "markup_top", "markup_list",
  "markup_composed_list", "markup_braced_list", "markup_braced_list_body",
  "markup_head_1_item", "markup_head_1_list", "simple_markup", "@7",
  "markup", 0
};
#endif

/* INFRINGES ON USER NAME SPACE */
#ifndef _
# define _(msgid) msgid
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short int yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,    45,    43,   391,   123,
     125,    61,    46,    60,    62,   124,    91,    93,   126,    40,
      41,    39,    44,    94,    95,    42,    47,    58,    33,    63
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned short int yyr1[] =
{
       0,   160,   161,   161,   161,   161,   161,   162,   163,   163,
     163,   163,   163,   163,   163,   164,   165,   165,   166,   166,
     167,   168,   168,   169,   169,   170,   170,   170,   170,   170,
     170,   170,   170,   170,   170,   171,   172,   172,   172,   172,
     173,   174,   174,   174,   174,   174,   174,   174,   175,   176,
     176,   176,   176,   176,   176,   177,   178,   179,   179,   179,
     180,   180,   180,   180,   180,   180,   181,   182,   182,   182,
     182,   183,   183,   184,   184,   185,   186,   186,   187,   187,
     188,   188,   188,   188,   189,   190,   189,   191,   191,   192,
     192,   193,   193,   194,   194,   194,   194,   194,   194,   194,
     194,   194,   194,   194,   194,   195,   196,   196,   196,   196,
     196,   196,   196,   196,   196,   196,   196,   196,   197,   197,
     197,   197,   197,   198,   198,   198,   198,   199,   199,   201,
     200,   202,   200,   203,   204,   203,   205,   206,   206,   206,
     206,   207,   207,   207,   207,   207,   207,   207,   207,   207,
     208,   208,   209,   209,   210,   210,   210,   210,   210,   211,
     211,   211,   212,   212,   212,   213,   213,   213,   213,   213,
     213,   214,   215,   215,   215,   216,   217,   218,   219,   220,
     221,   222,   222,   223,   223,   224,   225,   225,   225,   225,
     225,   225,   225,   225,   225,   225,   225,   225,   225,   226,
     226,   226,   226,   226,   227,   227,   227,   228,   229,   229,
     229,   229,   229,   229,   230,   231,   231,   231,   231,   231,
     231,   231,   231,   231,   231,   232,   232,   232,   233,   233,
     234,   234,   234,   234,   235,   235,   236,   236,   237,   237,
     237,   238,   238,   238,   239,   240,   240,   241,   241,   241,
     242,   242,   242,   242,   242,   242,   242,   243,   243,   243,
     244,   245,   246,   246,   247,   247,   248,   248,   248,   249,
     249,   250,   250,   251,   251,   252,   252,   252,   252,   253,
     253,   253,   254,   254,   254,   255,   255,   255,   256,   256,
     257,   258,   258,   259,   259,   259,   259,   259,   259,   259,
     260,   260,   261,   261,   262,   262,   263,   263,   263,   263,
     264,   264,   264,   265,   265,   266,   266,   266,   267,   267,
     267,   268,   268,   268,   269,   269,   270,   270,   270,   270,
     270,   271,   271,   272,   272,   273,   273,   274,   275,   274,
     276,   277,   276,   278,   278,   278,   279,   279,   280,   281,
     282,   282,   282,   283,   283,   283,   284,   284,   285,   285,
     285,   285,   286,   285,   285,   285,   285,   285,   285,   285,
     287,   287
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     0,     2,     2,     2,     2,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     0,     2,
       4,     1,     1,     3,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     4,     0,     1,     3,     2,
       4,     0,     2,     2,     2,     2,     2,     2,     4,     1,
       1,     2,     2,     2,     2,     1,     2,     1,     1,     1,
       2,     3,     2,     2,     2,     2,     4,     0,     2,     2,
       2,     1,     1,     0,     4,     5,     4,     3,     4,     3,
       1,     1,     1,     1,     0,     0,     5,     0,     2,     1,
       1,     1,     1,     1,     2,     2,     2,     3,     3,     4,
       3,     3,     3,     4,     4,     1,     1,     6,     4,     4,
       3,     1,     4,     2,     3,     1,     1,     3,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     3,     2,     0,
       3,     0,     4,     2,     0,     4,     4,     3,     2,     5,
       3,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     2,     1,     3,     5,     3,     4,     2,     2,     1,
       1,     3,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     0,     3,     1,     1,     3,     1,     1,     1,     1,
       3,     0,     2,     5,     2,     3,     1,     2,     2,     1,
       1,     1,     1,     2,     2,     2,     2,     2,     2,     1,
       2,     1,     2,     3,     0,     2,     2,     4,     1,     1,
       1,     2,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       0,     1,     2,     2,     1,     2,     1,     2,     1,     2,
       2,     1,     2,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     0,     1,     2,     2,     1,     3,     3,     1,
       3,     0,     2,     1,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     2,     2,     1,     2,     0,     2,
       3,     0,     1,     6,     2,     2,     2,     2,     2,     1,
       1,     1,     2,     4,     0,     2,     1,     1,     2,     2,
       1,     1,     1,     1,     3,     1,     2,     2,     3,     3,
       1,     1,     3,     3,     2,     1,     1,     1,     1,     2,
       2,     1,     1,     0,     2,     0,     2,     1,     0,     3,
       1,     0,     3,     1,     2,     1,     1,     1,     2,     3,
       0,     2,     2,     1,     2,     3,     1,     2,     1,     1,
       1,     1,     0,     5,     2,     4,     3,     1,     2,     3,
       2,     1
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned short int yydefact[] =
{
       2,     0,     1,     5,     0,     0,   121,   125,     0,   119,
     123,   120,   124,     0,     6,    59,   122,   126,     0,   341,
      58,   118,    57,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   178,    16,    22,   340,    93,     0,     0,     0,
       0,   171,   171,     0,     0,     0,     0,     0,    17,    21,
      67,     3,    12,    24,     8,     0,     4,    10,    11,    14,
       0,     0,   111,    92,    91,    15,    90,   105,   106,    89,
       0,    84,   115,   116,    67,     9,    13,   159,   160,   171,
      41,   163,   162,   164,    84,    18,   134,     0,   238,   128,
     260,   171,     0,   171,    67,    67,   171,     0,   269,   171,
     241,   244,   246,   245,     0,    84,    95,     0,   171,   171,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   191,   189,   190,   199,
      81,   176,   192,   201,    96,    71,    72,    83,    82,     0,
      80,   174,   181,   262,   173,   186,   171,    94,   171,   171,
       0,     0,     0,   171,    60,    65,     0,    56,    62,    63,
      64,   129,   133,   113,    85,     0,     0,     0,   185,     0,
       0,   171,     0,   171,   362,   360,   367,     0,   353,     0,
       0,     0,     0,     0,     0,   359,   358,   361,   350,   342,
     343,   346,   347,   356,     0,   345,   234,   236,   239,   240,
     127,   332,   331,   171,    50,     0,    49,     0,     0,   117,
       0,   110,   242,   243,   171,   171,   101,   100,   171,   194,
       0,   196,   202,     0,   200,   170,   326,   166,   328,   327,
     168,   165,   198,   167,   169,   188,   158,     0,   152,   271,
     195,   266,   261,   271,     0,     0,   187,     0,   193,   157,
     197,   288,   338,   262,   262,   301,   337,   262,   262,   333,
     262,   204,   262,   299,   300,     0,   204,   263,   102,    97,
     171,    98,   171,    70,    77,    69,    68,     0,   223,   222,
     220,   221,   224,   210,   209,    34,   214,   226,   259,   215,
     216,   217,   218,   219,   258,   257,   273,    32,    23,    27,
      25,    26,    28,    31,    29,   213,   225,   208,     0,   227,
      30,   320,   321,   325,    33,    61,    36,     0,   131,     0,
     114,   179,    79,   161,    46,     0,    40,    47,    45,    43,
      42,    55,    44,    84,   108,    20,    19,   135,     0,   368,
       0,     0,   371,     0,   364,   354,     0,     0,     0,     0,
     348,   357,   344,   235,   237,    73,    54,    48,    51,    52,
      53,    76,    78,   270,   112,   109,   104,     0,   203,   330,
     329,     0,     0,   265,     0,   264,   155,     0,     0,     0,
       0,   297,   294,   296,   302,   335,   295,   172,   298,   204,
     177,   180,   182,   333,   175,   103,    99,     0,   324,   274,
     249,   252,   251,   255,   254,   253,   250,   256,   248,   212,
     211,   228,   229,   247,     0,     0,     0,     0,    37,     0,
     130,     0,    87,     7,   171,   171,   370,   369,   366,   355,
       0,   349,   352,     0,   351,     0,    75,   136,     0,   153,
     272,   268,   267,   156,    66,   290,   282,   275,   276,   277,
       0,   283,   286,   289,   278,   339,     0,   307,   306,     0,
     304,   334,   230,   259,   206,   205,   184,   335,   319,   318,
     322,   323,   143,   146,   141,   144,   145,   148,     0,   149,
       0,   142,     0,   147,     0,     0,    35,   150,     0,    39,
     132,     0,   107,     0,   365,    67,   154,   285,   279,   280,
     281,   284,   287,   309,   308,   303,   231,   336,   262,     0,
     230,    38,     0,     0,   138,     0,   151,    86,    88,   363,
       0,   312,   310,   305,   311,   313,   315,   233,   232,   291,
       0,   204,     0,   140,   137,    74,     0,   317,   316,   292,
     293,   259,   207,   183,     0,   314,   139
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short int yydefgoto[] =
{
      -1,     1,   358,    51,    52,   275,   172,   359,    55,    56,
     298,   159,   419,    57,   169,    58,   205,   330,   360,    60,
      61,   133,   152,   276,   436,    62,    63,    64,   135,   165,
     319,   491,   136,    66,    67,    68,    69,    70,    71,    72,
     162,   317,   421,    73,   173,   137,   487,   488,   489,   237,
     138,   231,   238,   232,   139,   140,   141,   142,   391,    74,
     322,   143,   265,   392,    75,   144,   145,   387,   464,   465,
     305,   306,   307,   410,   508,   198,   199,   101,   102,   103,
     104,   411,   412,   308,    91,   240,   266,   241,   267,    99,
     373,   309,   451,   501,   452,   453,   379,   260,   540,   261,
     262,   263,   505,   460,   523,   524,   525,   310,   311,   312,
     313,   243,   385,   462,   264,   380,   234,    87,   189,   190,
     191,   192,   349,   193,   194,   342,   338,   343
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -324
static const short int yypact[] =
{
    -324,  1339,  -324,  -324,    -3,   -78,  -324,  -324,     6,  -324,
    -324,  -324,  -324,   -20,  -324,  -324,  -324,  -324,     6,  -324,
    -324,  -324,  -324,  1867,     6,   -16,    18,    29,   -31,   -29,
     -48,     6,  -324,  -324,  -324,  -324,  -324,    16,    16,    16,
      16,  1741,  1741,   -31,   -31,   -31,   -31,   -31,  -324,  -324,
    -324,  -324,  -324,  -324,  -324,   -50,  -324,  -324,  -324,  -324,
      35,    97,  -324,  -324,  -324,  -324,   108,  -324,  -324,  -324,
      15,    99,  -324,  -324,  -324,  -324,  -324,  -324,  -324,  1469,
    -324,  -324,  -324,  -324,   -13,  -324,  -324,   114,    87,  -324,
    -324,  1741,   121,  1605,  -324,  -324,  1741,    -9,  -324,  1741,
      87,  -324,  -324,  -324,   -48,    99,  -324,    16,  1741,  1741,
      78,    80,    94,    20,   244,   107,   301,     6,   143,     6,
       6,   143,   143,   107,     6,   -29,  -324,  -324,  -324,  -324,
    -324,  -324,  -324,  -324,  -324,  -324,  -324,  -324,  -324,   305,
    -324,  -324,  -324,   143,  -324,  -324,  1741,  -324,  1741,  1741,
     -31,   -31,   658,   508,   113,  -324,    96,  -324,  -324,  -324,
    -324,  -324,   255,  -324,  -324,    15,   794,    -3,  -324,    49,
       6,  1741,     1,  1741,  -324,  -324,  -324,   122,  -324,  1462,
     -31,   -31,   -31,   -31,   -31,  -324,  -324,  -324,  -324,  -324,
    -324,  -324,  -324,  -324,   114,  -324,  -324,  -324,   112,   116,
    -324,  -324,  -324,  1741,  -324,    51,  -324,   930,  1066,  -324,
     182,  -324,   112,   116,  1741,  1741,  -324,  -324,  1741,  -324,
     137,  -324,  -324,   151,  -324,  -324,   160,  -324,  -324,   166,
    -324,   159,  -324,  -324,  -324,  -324,  -324,   -31,   158,  -324,
    -324,  -324,   147,  -324,   -31,   171,  -324,   175,  -324,  -324,
    -324,  -324,  -324,   143,   143,  -324,  -324,   143,   143,  -324,
     143,  -324,   143,  -324,  -324,    -2,  -324,   147,  -324,  -324,
    1741,  -324,  1741,  -324,  -324,  -324,  -324,    22,  -324,  -324,
    -324,  -324,  -324,  -324,  -324,  -324,  -324,  -324,    38,  -324,
    -324,  -324,  -324,  -324,  -324,  -324,   121,  -324,  -324,  -324,
    -324,  -324,  -324,   159,  -324,  -324,  -324,  -324,   350,  -324,
     139,  -324,   135,  -324,  -324,  -324,   222,    15,  -324,   179,
    -324,  -324,  -324,  -324,  -324,   186,  -324,  -324,  -324,  -324,
    -324,  -324,  -324,    99,  -324,  -324,  -324,  -324,   183,  -324,
     122,  1462,  -324,  1462,  -324,  -324,   -31,   -31,   -31,  1308,
    -324,  -324,  -324,  -324,  -324,   314,  -324,  -324,  -324,  -324,
    -324,  -324,  -324,  -324,  -324,  -324,  -324,   190,  -324,  -324,
    -324,   185,     6,   187,   115,   187,  -324,  1609,   121,   168,
     114,  -324,  -324,  -324,   246,   176,  -324,  1861,  -324,  -324,
    -324,  -324,  -324,  -324,  1861,  -324,  -324,     8,  -324,  -324,
    -324,  -324,  -324,  -324,  -324,  -324,  -324,  -324,   159,  -324,
    -324,  -324,  -324,  -324,     8,     8,     8,     8,  -324,   248,
    -324,    15,  -324,  -324,  1741,  1605,  -324,  -324,  -324,  -324,
     -31,  -324,  -324,   114,  -324,   197,  -324,  -324,  1609,  -324,
    -324,  -324,  -324,  -324,  -324,  -324,  -324,  -324,  -324,  -324,
      25,  -324,    36,   195,  -324,  -324,   202,  -324,  -324,   202,
    -324,  -324,     7,   290,  -324,  -324,  1861,   176,  -324,  -324,
    -324,  -324,  -324,  -324,  -324,  -324,  -324,  -324,   -31,  -324,
       6,  -324,     6,  -324,     6,   208,  -324,  -324,   217,  -324,
    -324,   280,  -324,    68,  -324,  -324,  -324,    36,  -324,  -324,
    -324,  -324,  -324,  -324,  -324,   369,    87,  -324,   143,   -31,
       7,  -324,   -31,   -31,  -324,  1609,  -324,  -324,  -324,  -324,
    1202,  -324,  -324,  -324,   210,  -324,   -11,   112,   116,   307,
    1876,  -324,   213,  -324,  -324,  -324,   121,  -324,  -324,  -324,
    -324,  -324,  -324,  1861,   -31,  -324,  -324
};

/* YYPGOTO[NTERM-NUM].  */
static const short int yypgoto[] =
{
    -324,  -324,   188,  -324,  -324,    -1,  -324,    33,  -324,   -39,
    -324,   205,  -324,  -324,  -324,   -94,   -64,  -324,    40,  -324,
    -324,   302,   -65,   -28,  -324,  -324,  -324,  -324,  -324,   -52,
    -324,  -324,    72,   -62,  -324,  -324,  -324,  -324,  -324,  -324,
    -324,  -324,  -324,  -324,  -324,  -324,  -324,  -324,  -129,   126,
     249,    17,    -6,  -323,  -324,  -324,  -324,  -324,  -324,  -324,
    -324,  -324,  -324,  -324,  -324,  -324,  -324,  -251,  -324,  -146,
    -324,  -324,    56,  -324,  -143,   -96,   -95,   345,  -128,   -67,
     265,  -324,  -324,  -324,  -324,   251,  -234,   252,    82,   245,
     142,  -324,  -324,  -324,   -70,  -324,  -324,  -324,  -324,  -324,
    -324,  -324,  -324,  -123,  -324,  -324,  -150,  -324,  -110,  -221,
    -108,   -89,    -4,   -74,  -324,  -324,     0,  -324,    10,  -161,
    -324,  -177,  -324,  -163,  -144,   -77,  -324,  -239
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -172
static const short int yytable[] =
{
      53,    76,    84,   203,   212,   213,   233,   304,   163,   166,
     195,   258,    86,   134,   146,   394,   339,   350,    92,   381,
     382,    79,   158,   383,   384,   105,   386,    96,   388,   207,
     208,   351,   171,   340,    54,   341,   222,   106,   107,   108,
     109,    59,   147,   148,   149,   150,   151,   164,   235,    19,
     324,   168,   356,   215,   443,   537,   248,    33,    19,   300,
      53,    80,    97,   200,    26,   206,    27,   398,   209,   356,
      98,   211,   259,    65,    13,   329,    13,    15,    88,    15,
     217,   218,    19,    20,    32,    20,   325,   100,   325,    33,
      22,   153,    22,    13,   389,    89,    15,    25,   155,   226,
      48,    34,    20,   320,   427,   325,    81,   216,   446,    22,
     434,   161,   156,   230,   447,   496,   448,   352,   268,    85,
     269,   270,    81,    93,    88,   302,   538,    35,   170,   226,
      77,    78,    48,   336,    49,   228,    35,   229,   466,    82,
      83,   335,   390,   334,   397,   337,   223,   210,   506,   271,
     272,   122,   297,   314,    50,    82,    83,    94,   449,   164,
      35,   316,   174,   350,   333,   228,   507,   229,    95,   332,
     303,    53,   498,   499,   154,   355,   398,   351,   351,   344,
     345,   346,   347,   348,   323,    33,   364,   365,   432,   326,
     366,   357,   534,   301,   500,   470,   471,    34,   393,   341,
     242,    19,   328,   242,   201,   433,   202,   399,   519,   331,
     201,   219,   202,   220,   441,   175,   176,   177,   178,   179,
     180,   181,   182,   183,   184,   185,   178,   221,    48,   181,
      49,   183,   201,    88,   202,   316,   371,   157,   196,   197,
     239,   315,   395,   376,   396,   244,   245,   186,   187,   445,
     249,   446,   472,   188,   473,   420,   350,   447,   318,   448,
     224,   188,   474,   353,   426,   475,   476,   477,   354,   233,
     351,    84,   478,   363,   529,   414,   415,    19,   367,    35,
     543,   424,   368,   479,   472,   442,   473,   369,   480,   444,
     416,   417,   481,   370,   474,   482,   167,   475,   476,   477,
     372,   449,   374,   195,   468,   469,   483,   484,   413,   456,
     457,   458,   377,   459,   450,   479,   378,   418,   422,   423,
     480,   435,   425,   437,   481,   408,   438,   482,   503,   440,
     233,   504,    33,   225,   461,   226,   495,   100,   483,   484,
     116,   117,   502,   509,   227,   428,   429,   430,   119,   515,
     516,   120,   536,   539,   544,    35,   426,   327,   299,   490,
     124,   493,   518,   160,   409,   236,   439,   531,    90,   214,
     250,   228,   246,   229,   247,    48,   230,    77,    78,   454,
     497,   485,   522,    19,   542,   375,   545,   251,   486,   467,
     455,   252,   253,   510,     0,     0,   492,   206,     0,     0,
       0,   254,     0,     0,     0,   255,   256,   233,     0,     0,
     527,   528,     0,   485,     0,     0,   526,     0,     0,     0,
     517,   278,     0,   279,   280,     0,   281,     0,   282,   494,
     520,    88,   456,   457,   458,   257,   459,   230,     0,   400,
     100,     0,     0,     0,     0,     0,     0,   526,   287,     0,
     454,     0,     0,     0,     0,     0,     0,     0,   201,     0,
     202,    35,     0,   521,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   512,     0,   513,   511,   514,     0,
       0,     0,     0,    77,    78,     0,   401,   402,     0,     0,
       0,     0,   403,     0,   404,   405,   289,   290,   291,   292,
     293,     0,     0,   406,   407,     0,     0,   296,   530,     0,
       0,   532,   533,     0,   230,     0,   110,     0,   111,     6,
       7,   112,     0,   277,     0,     0,     0,     0,     9,    10,
      11,    12,     0,     0,     0,   113,    15,    16,    17,    18,
     114,    19,    20,   546,    21,     0,   115,   116,   117,    22,
     118,    23,     0,    24,     0,   119,    25,    26,   120,    27,
     121,    28,   122,    29,    30,   123,     0,   124,     0,   125,
      31,     0,     0,     0,     0,     0,     0,    32,   126,   278,
       0,   279,   280,   127,   281,   128,   282,   129,   283,     0,
       0,     0,   284,     0,     0,     0,    33,   285,   286,   226,
       0,     0,     0,     0,     0,     0,   287,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    35,
      36,    37,    38,     0,    39,    40,    41,    42,    43,    44,
      45,    46,    47,   130,     0,   228,     0,   229,     0,    48,
       0,    77,    78,     0,   288,     0,     0,    50,     0,     0,
       0,   131,     0,   132,   289,   290,   291,   292,   293,   273,
       0,   294,   295,     0,     0,   296,   110,     0,   111,     6,
       7,   112,     0,     8,     0,     0,     0,     0,     9,    10,
      11,    12,     0,     0,     0,   113,     0,    16,    17,    18,
     114,     0,     0,     0,    21,     0,   115,   116,   117,     0,
     118,    23,     0,    24,     0,   119,     0,    26,   120,    27,
     121,    28,   122,    29,    30,   123,     0,   124,     0,   125,
      31,     0,     0,     0,     0,     0,     0,    32,   126,     0,
       0,     0,     0,   127,     0,   128,     0,   129,     0,     0,
    -171,     0,     0,     0,  -171,  -171,    33,     0,     0,     0,
       0,     0,     0,     0,  -171,     0,     0,     0,  -171,  -171,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      36,    37,    38,     0,    39,    40,    41,    42,    43,    44,
      45,    46,    47,   130,  -171,     0,     0,     0,  -171,    48,
       0,     0,     0,  -171,     0,   273,     0,    50,   274,     0,
       0,   131,   110,   132,   111,     6,     7,   112,     0,     8,
       0,     0,     0,     0,     9,    10,    11,    12,     0,     0,
       0,   113,     0,    16,    17,    18,   114,     0,     0,     0,
      21,     0,   115,   116,   117,     0,   118,    23,     0,    24,
       0,   119,     0,    26,   120,    27,   121,    28,   122,    29,
      30,   123,     0,   124,     0,   125,    31,     0,     0,     0,
       0,     0,   321,    32,   126,     0,     0,     0,     0,   127,
       0,   128,     0,   129,     0,     0,  -171,     0,     0,     0,
    -171,  -171,    33,     0,     0,     0,     0,     0,     0,     0,
    -171,     0,     0,     0,  -171,  -171,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    36,    37,    38,     0,
      39,    40,    41,    42,    43,    44,    45,    46,    47,   130,
    -171,     0,     0,     0,  -171,    48,     0,     0,     0,  -171,
       0,   273,     0,    50,     0,     0,     0,   131,   110,   132,
     111,     6,     7,   112,     0,     8,     0,     0,     0,     0,
       9,    10,    11,    12,     0,     0,     0,   113,     0,    16,
      17,    18,   114,     0,     0,     0,    21,     0,   115,   116,
     117,     0,   118,    23,     0,    24,     0,   119,     0,    26,
     120,    27,   121,    28,   122,    29,    30,   123,     0,   124,
       0,   125,    31,     0,     0,     0,     0,     0,     0,    32,
     126,     0,     0,     0,     0,   127,     0,   128,     0,   129,
       0,     0,  -171,     0,     0,     0,  -171,  -171,    33,     0,
       0,     0,     0,     0,     0,     0,  -171,     0,     0,     0,
    -171,  -171,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    36,    37,    38,     0,    39,    40,    41,    42,
      43,    44,    45,    46,    47,   130,  -171,     0,     0,     0,
    -171,    48,     0,     0,     0,  -171,     0,   273,     0,    50,
     361,     0,     0,   131,   110,   132,   111,     6,     7,   112,
       0,     8,     0,     0,     0,     0,     9,    10,    11,    12,
       0,     0,     0,   113,     0,    16,    17,    18,   114,     0,
       0,     0,    21,     0,   115,   116,   117,     0,   118,    23,
       0,    24,     0,   119,     0,    26,   120,    27,   121,    28,
     122,    29,    30,   123,     0,   124,     0,   125,    31,     0,
       0,     0,     0,     0,     0,    32,   126,     0,     0,     0,
       0,   127,     0,   128,     0,   129,     0,     0,  -171,     0,
       0,     0,  -171,  -171,    33,     0,     0,     0,     0,     0,
       0,     0,  -171,     0,     0,     0,  -171,  -171,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    36,    37,
      38,     0,    39,    40,    41,    42,    43,    44,    45,    46,
      47,   130,  -171,     0,     0,     0,  -171,    48,     0,     0,
       0,  -171,     0,   273,     0,    50,   362,     0,     0,   131,
     110,   132,   111,     6,     7,   112,     0,     8,     0,     0,
       0,     0,     9,    10,    11,    12,     0,     0,     0,   113,
       0,    16,    17,    18,   114,     0,     0,     0,    21,     0,
     115,   116,   117,     0,   118,    23,     0,    24,     0,   119,
       0,    26,   120,    27,   121,    28,   122,    29,    30,   123,
       0,   124,     0,   125,    31,     0,     0,     0,     0,     0,
       0,    32,   126,     0,     0,     0,     0,   127,     0,   128,
       0,   129,     0,     0,  -171,     0,     0,     0,  -171,  -171,
      33,     0,     0,     0,     0,     0,     0,     0,  -171,     0,
       0,     0,  -171,  -171,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    36,    37,    38,     0,    39,    40,
      41,    42,    43,    44,    45,    46,    47,   130,  -171,     0,
       0,     0,  -171,    48,     0,     0,     0,  -171,     0,     2,
       3,    50,   535,     0,     4,   131,     0,   132,     5,     0,
       6,     7,     0,     0,     8,     0,   174,     0,     0,     9,
      10,    11,    12,     0,    13,    14,     0,    15,    16,    17,
      18,     0,    19,    20,     0,    21,     0,     0,     0,     0,
      22,     0,    23,     0,    24,     0,     0,    25,    26,     0,
      27,     0,    28,     0,    29,    30,     0,     0,     0,     0,
       0,    31,     0,     0,     0,     0,     0,     0,    32,   175,
     176,   177,   178,   179,   180,   181,   182,   183,   184,   185,
       0,     0,     0,     0,     0,     0,     0,    33,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    34,
       0,   186,   187,     0,     0,     0,     0,   188,   431,     0,
      35,    36,    37,    38,     0,    39,    40,    41,    42,    43,
      44,    45,    46,    47,     0,     0,     0,     0,     0,     0,
      48,     0,    49,     0,     0,     0,     0,   110,    50,   111,
       6,     7,   112,     0,     8,     0,     0,     0,     0,     9,
      10,    11,    12,     0,     0,     0,   113,     0,    16,    17,
      18,   114,     0,     0,     0,    21,     0,   115,   116,   117,
     174,   118,    23,     0,    24,     0,   119,     0,    26,   120,
      27,   121,    28,   122,    29,    30,   123,     0,   124,     0,
     125,    31,     0,     0,     0,     0,     0,     0,    32,   126,
       0,     0,     0,     0,   127,     0,   128,     0,   129,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   175,   176,   177,   178,   179,   180,   181,
     182,   183,   184,   185,     0,     0,     0,     0,     0,     0,
       0,    36,    37,    38,     0,    39,    40,    41,    42,    43,
      44,    45,    46,    47,   130,   186,   187,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   167,     0,    50,     0,
       0,     0,   131,   110,   132,   111,     6,     7,   112,     0,
       8,     0,     0,     0,     0,     9,    10,    11,    12,     0,
       0,     0,   113,     0,    16,    17,    18,   114,     0,     0,
       0,    21,    19,   115,   116,   117,     0,   118,    23,     0,
      24,     0,   119,     0,    26,   120,    27,   121,    28,   122,
      29,    30,   123,     0,   124,     0,   125,    31,     0,     0,
       0,     0,     0,     0,    32,   126,     0,     0,     0,     0,
     127,     0,   128,     0,   129,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    33,   225,     0,
     226,     0,     0,     0,     0,     0,     0,     0,     0,   227,
       0,     0,     0,     0,     0,     0,     0,    36,    37,    38,
      35,    39,    40,    41,    42,    43,    44,    45,    46,    47,
     130,     0,     0,     0,     0,     0,   228,   204,   229,     0,
      48,     0,    77,    78,    50,     0,     0,     0,   131,   110,
     132,   111,     6,     7,   112,     0,     8,     0,     0,     0,
       0,     9,    10,    11,    12,     0,     0,     0,   113,     0,
      16,    17,    18,   114,     0,     0,     0,    21,     0,   115,
     116,   117,     0,   118,    23,     0,    24,     0,   119,     0,
      26,   120,    27,   121,    28,   122,    29,    30,   123,     0,
     124,     0,   125,    31,     0,     0,     0,     0,     0,     0,
      32,   126,     0,     0,     0,     0,   127,     0,   128,     0,
     129,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    36,    37,    38,     0,    39,    40,    41,
      42,    43,    44,    45,    46,    47,   130,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     6,     7,
      50,     0,     8,     0,   131,     0,   132,     9,    10,    11,
      12,     0,     0,     0,     0,     0,    16,    17,    18,     0,
       0,     0,     0,    21,     0,     0,     0,     0,     0,     0,
      23,     0,    24,     0,     0,     0,    26,     0,    27,     0,
      28,     0,    29,    30,     0,     0,     0,     0,     0,    31,
       0,     0,   278,     0,   279,   280,    32,   281,     0,   282,
       0,   283,     0,     0,     0,   284,     0,   278,     0,   279,
     280,   286,   281,     0,   282,     0,   283,     0,     0,   287,
     284,     0,     0,     0,     0,     0,   286,     0,     0,     0,
       0,     0,     0,     0,   287,     0,     0,     0,     0,    36,
      37,    38,     0,    39,    40,    41,    42,    43,    44,    45,
      46,    47,     0,    88,     0,     0,     0,   463,     0,     0,
       0,     0,     0,     0,     0,     0,    50,   289,   290,   291,
     292,   293,   541,     0,   294,   295,     0,     0,   296,     0,
       0,     0,   289,   290,   291,   292,   293,     0,     0,   294,
     295,     0,     0,   296
};

static const short int yycheck[] =
{
       1,     1,     8,    92,   100,   100,   114,   153,    70,    74,
      87,   139,    18,    41,    42,   266,   177,   194,    24,   253,
     254,     4,    61,   257,   258,    31,   260,    28,   262,    94,
      95,   194,    84,   177,     1,   179,    16,    37,    38,    39,
      40,     1,    43,    44,    45,    46,    47,    60,   115,    33,
       1,    79,     1,   105,   377,    66,   123,    88,    33,   153,
      61,   139,    91,    91,    49,    93,    51,   288,    96,     1,
      99,    99,   139,     1,    25,   169,    25,    28,   126,    28,
     108,   109,    33,    34,    69,    34,    37,   135,    37,    88,
      41,   141,    41,    25,    96,    23,    28,    48,     1,    91,
     131,   100,    34,   165,   343,    37,   100,   107,    83,    41,
     349,     3,    15,   114,    89,   438,    91,   194,   146,   139,
     148,   149,   100,   139,   126,   153,   137,   111,   141,    91,
     133,   134,   131,   172,   133,   127,   111,   129,   389,   133,
     134,   140,   144,   171,   136,   173,   126,   156,   141,   150,
     151,    54,   153,   153,   139,   133,   134,   139,   133,    60,
     111,   139,    48,   340,   170,   127,   159,   129,   139,   169,
     153,   172,   136,   137,   139,   203,   397,   340,   341,   180,
     181,   182,   183,   184,   167,    88,   214,   215,   349,   140,
     218,   140,   515,   153,   158,   416,   417,   100,   265,   343,
     118,    33,   169,   121,    89,   349,    91,   296,   140,   169,
      89,   133,    91,   133,    99,   101,   102,   103,   104,   105,
     106,   107,   108,   109,   110,   111,   104,   133,   131,   107,
     133,   109,    89,   126,    91,   139,   237,   140,   151,   152,
      97,   128,   270,   244,   272,   119,   120,   133,   134,    81,
     124,    83,     4,   139,     6,   317,   433,    89,     3,    91,
      16,   139,    14,   151,   341,    17,    18,    19,   152,   377,
     433,   277,    24,    91,   508,   136,   137,    33,   141,   111,
     531,   333,   131,    35,     4,   374,     6,   127,    40,   378,
     155,   156,    44,   127,    14,    47,   137,    17,    18,    19,
     142,   133,   155,   380,   414,   415,    58,    59,   308,    63,
      64,    65,   141,    67,   146,    35,   141,    95,   139,   133,
      40,     7,   139,   133,    44,   308,   141,    47,   456,   142,
     438,   459,    88,    89,   158,    91,   139,   135,    58,    59,
      39,    40,   147,    53,   100,   346,   347,   348,    47,   141,
     133,    50,   142,    46,   141,   111,   433,   169,   153,   421,
      59,   425,   491,    61,   308,   116,   372,   510,    23,   104,
     125,   127,   121,   129,   122,   131,   377,   133,   134,   379,
     450,   133,   505,    33,   530,   243,   536,    82,   140,   393,
     380,    86,    87,   467,    -1,    -1,   424,   425,    -1,    -1,
      -1,    96,    -1,    -1,    -1,   100,   101,   515,    -1,    -1,
     506,   506,    -1,   133,    -1,    -1,   505,    -1,    -1,    -1,
     140,    71,    -1,    73,    74,    -1,    76,    -1,    78,   430,
     495,   126,    63,    64,    65,   130,    67,   438,    -1,    89,
     135,    -1,    -1,    -1,    -1,    -1,    -1,   536,    98,    -1,
     450,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    89,    -1,
      91,   111,    -1,    94,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   480,    -1,   482,   478,   484,    -1,
      -1,    -1,    -1,   133,   134,    -1,   136,   137,    -1,    -1,
      -1,    -1,   142,    -1,   144,   145,   146,   147,   148,   149,
     150,    -1,    -1,   153,   154,    -1,    -1,   157,   509,    -1,
      -1,   512,   513,    -1,   515,    -1,     8,    -1,    10,    11,
      12,    13,    -1,    15,    -1,    -1,    -1,    -1,    20,    21,
      22,    23,    -1,    -1,    -1,    27,    28,    29,    30,    31,
      32,    33,    34,   544,    36,    -1,    38,    39,    40,    41,
      42,    43,    -1,    45,    -1,    47,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    -1,    59,    -1,    61,
      62,    -1,    -1,    -1,    -1,    -1,    -1,    69,    70,    71,
      -1,    73,    74,    75,    76,    77,    78,    79,    80,    -1,
      -1,    -1,    84,    -1,    -1,    -1,    88,    89,    90,    91,
      -1,    -1,    -1,    -1,    -1,    -1,    98,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   111,
     112,   113,   114,    -1,   116,   117,   118,   119,   120,   121,
     122,   123,   124,   125,    -1,   127,    -1,   129,    -1,   131,
      -1,   133,   134,    -1,   136,    -1,    -1,   139,    -1,    -1,
      -1,   143,    -1,   145,   146,   147,   148,   149,   150,     1,
      -1,   153,   154,    -1,    -1,   157,     8,    -1,    10,    11,
      12,    13,    -1,    15,    -1,    -1,    -1,    -1,    20,    21,
      22,    23,    -1,    -1,    -1,    27,    -1,    29,    30,    31,
      32,    -1,    -1,    -1,    36,    -1,    38,    39,    40,    -1,
      42,    43,    -1,    45,    -1,    47,    -1,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    -1,    59,    -1,    61,
      62,    -1,    -1,    -1,    -1,    -1,    -1,    69,    70,    -1,
      -1,    -1,    -1,    75,    -1,    77,    -1,    79,    -1,    -1,
      82,    -1,    -1,    -1,    86,    87,    88,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    96,    -1,    -1,    -1,   100,   101,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     112,   113,   114,    -1,   116,   117,   118,   119,   120,   121,
     122,   123,   124,   125,   126,    -1,    -1,    -1,   130,   131,
      -1,    -1,    -1,   135,    -1,     1,    -1,   139,   140,    -1,
      -1,   143,     8,   145,    10,    11,    12,    13,    -1,    15,
      -1,    -1,    -1,    -1,    20,    21,    22,    23,    -1,    -1,
      -1,    27,    -1,    29,    30,    31,    32,    -1,    -1,    -1,
      36,    -1,    38,    39,    40,    -1,    42,    43,    -1,    45,
      -1,    47,    -1,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    -1,    59,    -1,    61,    62,    -1,    -1,    -1,
      -1,    -1,    68,    69,    70,    -1,    -1,    -1,    -1,    75,
      -1,    77,    -1,    79,    -1,    -1,    82,    -1,    -1,    -1,
      86,    87,    88,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    -1,    -1,    -1,   100,   101,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   112,   113,   114,    -1,
     116,   117,   118,   119,   120,   121,   122,   123,   124,   125,
     126,    -1,    -1,    -1,   130,   131,    -1,    -1,    -1,   135,
      -1,     1,    -1,   139,    -1,    -1,    -1,   143,     8,   145,
      10,    11,    12,    13,    -1,    15,    -1,    -1,    -1,    -1,
      20,    21,    22,    23,    -1,    -1,    -1,    27,    -1,    29,
      30,    31,    32,    -1,    -1,    -1,    36,    -1,    38,    39,
      40,    -1,    42,    43,    -1,    45,    -1,    47,    -1,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    -1,    59,
      -1,    61,    62,    -1,    -1,    -1,    -1,    -1,    -1,    69,
      70,    -1,    -1,    -1,    -1,    75,    -1,    77,    -1,    79,
      -1,    -1,    82,    -1,    -1,    -1,    86,    87,    88,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    -1,    -1,    -1,
     100,   101,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   112,   113,   114,    -1,   116,   117,   118,   119,
     120,   121,   122,   123,   124,   125,   126,    -1,    -1,    -1,
     130,   131,    -1,    -1,    -1,   135,    -1,     1,    -1,   139,
     140,    -1,    -1,   143,     8,   145,    10,    11,    12,    13,
      -1,    15,    -1,    -1,    -1,    -1,    20,    21,    22,    23,
      -1,    -1,    -1,    27,    -1,    29,    30,    31,    32,    -1,
      -1,    -1,    36,    -1,    38,    39,    40,    -1,    42,    43,
      -1,    45,    -1,    47,    -1,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    -1,    59,    -1,    61,    62,    -1,
      -1,    -1,    -1,    -1,    -1,    69,    70,    -1,    -1,    -1,
      -1,    75,    -1,    77,    -1,    79,    -1,    -1,    82,    -1,
      -1,    -1,    86,    87,    88,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    96,    -1,    -1,    -1,   100,   101,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   112,   113,
     114,    -1,   116,   117,   118,   119,   120,   121,   122,   123,
     124,   125,   126,    -1,    -1,    -1,   130,   131,    -1,    -1,
      -1,   135,    -1,     1,    -1,   139,   140,    -1,    -1,   143,
       8,   145,    10,    11,    12,    13,    -1,    15,    -1,    -1,
      -1,    -1,    20,    21,    22,    23,    -1,    -1,    -1,    27,
      -1,    29,    30,    31,    32,    -1,    -1,    -1,    36,    -1,
      38,    39,    40,    -1,    42,    43,    -1,    45,    -1,    47,
      -1,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      -1,    59,    -1,    61,    62,    -1,    -1,    -1,    -1,    -1,
      -1,    69,    70,    -1,    -1,    -1,    -1,    75,    -1,    77,
      -1,    79,    -1,    -1,    82,    -1,    -1,    -1,    86,    87,
      88,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    96,    -1,
      -1,    -1,   100,   101,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   112,   113,   114,    -1,   116,   117,
     118,   119,   120,   121,   122,   123,   124,   125,   126,    -1,
      -1,    -1,   130,   131,    -1,    -1,    -1,   135,    -1,     0,
       1,   139,   140,    -1,     5,   143,    -1,   145,     9,    -1,
      11,    12,    -1,    -1,    15,    -1,    48,    -1,    -1,    20,
      21,    22,    23,    -1,    25,    26,    -1,    28,    29,    30,
      31,    -1,    33,    34,    -1,    36,    -1,    -1,    -1,    -1,
      41,    -1,    43,    -1,    45,    -1,    -1,    48,    49,    -1,
      51,    -1,    53,    -1,    55,    56,    -1,    -1,    -1,    -1,
      -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    69,   101,
     102,   103,   104,   105,   106,   107,   108,   109,   110,   111,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    88,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   100,
      -1,   133,   134,    -1,    -1,    -1,    -1,   139,   140,    -1,
     111,   112,   113,   114,    -1,   116,   117,   118,   119,   120,
     121,   122,   123,   124,    -1,    -1,    -1,    -1,    -1,    -1,
     131,    -1,   133,    -1,    -1,    -1,    -1,     8,   139,    10,
      11,    12,    13,    -1,    15,    -1,    -1,    -1,    -1,    20,
      21,    22,    23,    -1,    -1,    -1,    27,    -1,    29,    30,
      31,    32,    -1,    -1,    -1,    36,    -1,    38,    39,    40,
      48,    42,    43,    -1,    45,    -1,    47,    -1,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    -1,    59,    -1,
      61,    62,    -1,    -1,    -1,    -1,    -1,    -1,    69,    70,
      -1,    -1,    -1,    -1,    75,    -1,    77,    -1,    79,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   101,   102,   103,   104,   105,   106,   107,
     108,   109,   110,   111,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   112,   113,   114,    -1,   116,   117,   118,   119,   120,
     121,   122,   123,   124,   125,   133,   134,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   137,    -1,   139,    -1,
      -1,    -1,   143,     8,   145,    10,    11,    12,    13,    -1,
      15,    -1,    -1,    -1,    -1,    20,    21,    22,    23,    -1,
      -1,    -1,    27,    -1,    29,    30,    31,    32,    -1,    -1,
      -1,    36,    33,    38,    39,    40,    -1,    42,    43,    -1,
      45,    -1,    47,    -1,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    -1,    59,    -1,    61,    62,    -1,    -1,
      -1,    -1,    -1,    -1,    69,    70,    -1,    -1,    -1,    -1,
      75,    -1,    77,    -1,    79,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    88,    89,    -1,
      91,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   100,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   112,   113,   114,
     111,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,    -1,    -1,    -1,    -1,    -1,   127,   132,   129,    -1,
     131,    -1,   133,   134,   139,    -1,    -1,    -1,   143,     8,
     145,    10,    11,    12,    13,    -1,    15,    -1,    -1,    -1,
      -1,    20,    21,    22,    23,    -1,    -1,    -1,    27,    -1,
      29,    30,    31,    32,    -1,    -1,    -1,    36,    -1,    38,
      39,    40,    -1,    42,    43,    -1,    45,    -1,    47,    -1,
      49,    50,    51,    52,    53,    54,    55,    56,    57,    -1,
      59,    -1,    61,    62,    -1,    -1,    -1,    -1,    -1,    -1,
      69,    70,    -1,    -1,    -1,    -1,    75,    -1,    77,    -1,
      79,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   112,   113,   114,    -1,   116,   117,   118,
     119,   120,   121,   122,   123,   124,   125,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    11,    12,
     139,    -1,    15,    -1,   143,    -1,   145,    20,    21,    22,
      23,    -1,    -1,    -1,    -1,    -1,    29,    30,    31,    -1,
      -1,    -1,    -1,    36,    -1,    -1,    -1,    -1,    -1,    -1,
      43,    -1,    45,    -1,    -1,    -1,    49,    -1,    51,    -1,
      53,    -1,    55,    56,    -1,    -1,    -1,    -1,    -1,    62,
      -1,    -1,    71,    -1,    73,    74,    69,    76,    -1,    78,
      -1,    80,    -1,    -1,    -1,    84,    -1,    71,    -1,    73,
      74,    90,    76,    -1,    78,    -1,    80,    -1,    -1,    98,
      84,    -1,    -1,    -1,    -1,    -1,    90,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    98,    -1,    -1,    -1,    -1,   112,
     113,   114,    -1,   116,   117,   118,   119,   120,   121,   122,
     123,   124,    -1,   126,    -1,    -1,    -1,   136,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   139,   146,   147,   148,
     149,   150,   136,    -1,   153,   154,    -1,    -1,   157,    -1,
      -1,    -1,   146,   147,   148,   149,   150,    -1,    -1,   153,
     154,    -1,    -1,   157
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const unsigned short int yystos[] =
{
       0,   161,     0,     1,     5,     9,    11,    12,    15,    20,
      21,    22,    23,    25,    26,    28,    29,    30,    31,    33,
      34,    36,    41,    43,    45,    48,    49,    51,    53,    55,
      56,    62,    69,    88,   100,   111,   112,   113,   114,   116,
     117,   118,   119,   120,   121,   122,   123,   124,   131,   133,
     139,   163,   164,   165,   167,   168,   169,   173,   175,   178,
     179,   180,   185,   186,   187,   192,   193,   194,   195,   196,
     197,   198,   199,   203,   219,   224,   276,   133,   134,   211,
     139,   100,   133,   134,   212,   139,   212,   277,   126,   192,
     237,   244,   212,   139,   139,   139,   165,    91,    99,   249,
     135,   237,   238,   239,   240,   212,   276,   276,   276,   276,
       8,    10,    13,    27,    32,    38,    39,    40,    42,    47,
      50,    52,    54,    57,    59,    61,    70,    75,    77,    79,
     125,   143,   145,   181,   183,   188,   192,   205,   210,   214,
     215,   216,   217,   221,   225,   226,   183,   165,   165,   165,
     165,   165,   182,   141,   139,     1,    15,   140,   169,   171,
     181,     3,   200,   193,    60,   189,   182,   137,   183,   174,
     141,   189,   166,   204,    48,   101,   102,   103,   104,   105,
     106,   107,   108,   109,   110,   111,   133,   134,   139,   278,
     279,   280,   281,   283,   284,   285,   151,   152,   235,   236,
     183,    89,    91,   271,   132,   176,   183,   182,   182,   183,
     156,   183,   235,   236,   240,   189,   276,   183,   183,   133,
     133,   133,    16,   126,    16,    89,    91,   100,   127,   129,
     165,   211,   213,   270,   276,   239,   210,   209,   212,    97,
     245,   247,   248,   271,   209,   209,   245,   247,   239,   209,
     249,    82,    86,    87,    96,   100,   101,   130,   238,   239,
     257,   259,   260,   261,   274,   222,   246,   248,   183,   183,
     183,   165,   165,     1,   140,   165,   183,    15,    71,    73,
      74,    76,    78,    80,    84,    89,    90,    98,   136,   146,
     147,   148,   149,   150,   153,   154,   157,   165,   170,   171,
     175,   178,   183,   211,   229,   230,   231,   232,   243,   251,
     267,   268,   269,   270,   276,   128,   139,   201,     3,   190,
     193,    68,   220,   211,     1,    37,   140,   162,   167,   175,
     177,   178,   276,   212,   183,   140,   169,   183,   286,   279,
     284,   284,   285,   287,   165,   165,   165,   165,   165,   282,
     281,   283,   285,   151,   152,   183,     1,   140,   162,   167,
     178,   140,   140,    91,   183,   183,   183,   141,   131,   127,
     127,   165,   142,   250,   155,   250,   165,   141,   141,   256,
     275,   246,   246,   246,   246,   272,   246,   227,   246,    96,
     144,   218,   223,   239,   227,   183,   183,   136,   269,   271,
      89,   136,   137,   142,   144,   145,   153,   154,   211,   232,
     233,   241,   242,   276,   136,   137,   155,   156,    95,   172,
     193,   202,   139,   133,   189,   139,   285,   287,   165,   165,
     165,   140,   279,   284,   287,     7,   184,   133,   141,   212,
     142,    99,   271,   213,   271,    81,    83,    89,    91,   133,
     146,   252,   254,   255,   276,   278,    63,    64,    65,    67,
     263,   158,   273,   136,   228,   229,   227,   272,   268,   268,
     269,   269,     4,     6,    14,    17,    18,    19,    24,    35,
      40,    44,    47,    58,    59,   133,   140,   206,   207,   208,
     193,   191,   183,   176,   165,   139,   213,   254,   136,   137,
     158,   253,   147,   238,   238,   262,   141,   159,   234,    53,
     273,   165,   212,   212,   212,   141,   133,   140,   208,   140,
     182,    94,   263,   264,   265,   266,   271,   235,   236,   246,
     165,   234,   165,   165,   213,   140,   142,    66,   137,    46,
     258,   136,   229,   227,   141,   266,   165
};

#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrorlab


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { 								\
      yyerror (_("syntax error: cannot back up")); \
      YYERROR;							\
    }								\
while (0)


#define YYTERROR	1
#define YYERRCODE	256


/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#define YYRHSLOC(Rhs, K) ((Rhs)[K])
#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)				\
    do									\
      if (N)								\
	{								\
	  (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;	\
	  (Current).first_column = YYRHSLOC (Rhs, 1).first_column;	\
	  (Current).last_line    = YYRHSLOC (Rhs, N).last_line;		\
	  (Current).last_column  = YYRHSLOC (Rhs, N).last_column;	\
	}								\
      else								\
	{								\
	  (Current).first_line   = (Current).last_line   =		\
	    YYRHSLOC (Rhs, 0).last_line;				\
	  (Current).first_column = (Current).last_column =		\
	    YYRHSLOC (Rhs, 0).last_column;				\
	}								\
    while (0)
#endif


/* YY_LOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

#ifndef YY_LOCATION_PRINT
# if YYLTYPE_IS_TRIVIAL
#  define YY_LOCATION_PRINT(File, Loc)			\
     fprintf (File, "%d.%d-%d.%d",			\
              (Loc).first_line, (Loc).first_column,	\
              (Loc).last_line,  (Loc).last_column)
# else
#  define YY_LOCATION_PRINT(File, Loc) ((void) 0)
# endif
#endif


/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (&yylval, &yylloc, YYLEX_PARAM)
#else
# define YYLEX yylex (&yylval, &yylloc)
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (0)

# define YY_SYMBOL_PRINT(Title, Type, Value, Location)		\
do {								\
  if (yydebug)							\
    {								\
      YYFPRINTF (stderr, "%s ", Title);				\
      yysymprint (stderr, 					\
                  Type, Value, Location);	\
      YYFPRINTF (stderr, "\n");					\
    }								\
} while (0)

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_stack_print (short int *bottom, short int *top)
#else
static void
yy_stack_print (bottom, top)
    short int *bottom;
    short int *top;
#endif
{
  YYFPRINTF (stderr, _("Stack now"));
  for (/* Nothing. */; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_reduce_print (int yyrule)
#else
static void
yy_reduce_print (yyrule)
    int yyrule;
#endif
{
  int yyi;
  unsigned int yylno = yyrline[yyrule];
  YYFPRINTF (stderr, _("Reducing stack by rule %d (line %u), "),
             yyrule - 1, yylno);
  /* Print the symbols being reduced, and their result.  */
  for (yyi = yyprhs[yyrule]; 0 <= yyrhs[yyi]; yyi++)
    YYFPRINTF (stderr, "%s ", yytname [yyrhs[yyi]]);
  YYFPRINTF (stderr, "-> %s\n", yytname [yyr1[yyrule]]);
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (Rule);		\
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
yystrlen (const char *yystr)
#   else
yystrlen (yystr)
     const char *yystr;
#   endif
{
  const char *yys = yystr;

  while (*yys++ != '\0')
    continue;

  return yys - yystr - 1;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
yystpcpy (char *yydest, const char *yysrc)
#   else
yystpcpy (yydest, yysrc)
     char *yydest;
     const char *yysrc;
#   endif
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

#endif /* !YYERROR_VERBOSE */



#if YYDEBUG
/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yysymprint (FILE *yyoutput, int yytype, YYSTYPE *yyvaluep, YYLTYPE *yylocationp)
#else
static void
yysymprint (yyoutput, yytype, yyvaluep, yylocationp)
    FILE *yyoutput;
    int yytype;
    YYSTYPE *yyvaluep;
    YYLTYPE *yylocationp;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;
  (void) yylocationp;

  if (yytype < YYNTOKENS)
    YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  YY_LOCATION_PRINT (yyoutput, *yylocationp);
  fprintf (yyoutput, ": ");

# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
  switch (yytype)
    {
      default:
        break;
    }
  YYFPRINTF (yyoutput, ")");
}

#endif /* ! YYDEBUG */
/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep, YYLTYPE *yylocationp)
#else
static void
yydestruct (yymsg, yytype, yyvaluep, yylocationp)
    const char *yymsg;
    int yytype;
    YYSTYPE *yyvaluep;
    YYLTYPE *yylocationp;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;
  (void) yylocationp;

  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  switch (yytype)
    {

      default:
        break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM);
# else
int yyparse ();
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */






/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM)
# else
int yyparse (YYPARSE_PARAM)
  void *YYPARSE_PARAM;
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
  /* The look-ahead symbol.  */
int yychar;

/* The semantic value of the look-ahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;
/* Location data for the look-ahead symbol.  */
YYLTYPE yylloc;

  int yystate;
  int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Look-ahead token as an internal (translated) token number.  */
  int yytoken = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  short int yyssa[YYINITDEPTH];
  short int *yyss = yyssa;
  short int *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  YYSTYPE *yyvsp;

  /* The location stack.  */
  YYLTYPE yylsa[YYINITDEPTH];
  YYLTYPE *yyls = yylsa;
  YYLTYPE *yylsp;
  /* The locations where the error started and ended. */
  YYLTYPE yyerror_range[2];

#define YYPOPSTACK   (yyvsp--, yyssp--, yylsp--)

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;
  YYLTYPE yyloc;

  /* When reducing, the number of symbols on the RHS of the reduced
     rule.  */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;
  yylsp = yyls;
#if YYLTYPE_IS_TRIVIAL
  /* Initialize the default location before parsing starts.  */
  yylloc.first_line   = yylloc.last_line   = 1;
  yylloc.first_column = yylloc.last_column = 0;
#endif


  yyvsp[0] = yylval;
    yylsp[0] = yylloc;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	short int *yyss1 = yyss;
	YYLTYPE *yyls1 = yyls;

	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow (_("parser stack overflow"),
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),
		    &yyls1, yysize * sizeof (*yylsp),
		    &yystacksize);
	yyls = yyls1;
	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyoverflowlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyoverflowlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	short int *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyoverflowlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);
	YYSTACK_RELOCATE (yyls);
#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;
      yylsp = yyls + yysize - 1;

      YYDPRINTF ((stderr, _("Stack size increased to %lu\n"),
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, _("Entering state %d\n"), yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a look-ahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to look-ahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a look-ahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid look-ahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, _("Reading a token: ")));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, _("Now at end of input.\n")));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT (_("Next token is"), yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the look-ahead token.  */
  YY_SYMBOL_PRINT (_("Shifting"), yytoken, &yylval, &yylloc);

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;
  *++yylsp = yylloc;

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];

  /* Default location. */
  YYLLOC_DEFAULT (yyloc, yylsp - yylen, yylen);
  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 3:
#line 552 "parser.yy"
    {
	;}
    break;

  case 4:
#line 554 "parser.yy"
    {
	;}
    break;

  case 5:
#line 556 "parser.yy"
    {
		THIS->error_level_ = 1;
	;}
    break;

  case 6:
#line 559 "parser.yy"
    {
		THIS->error_level_ = 1;
	;}
    break;

  case 7:
#line 566 "parser.yy"
    { (yyval.scm) = (yyvsp[0].scm); ;}
    break;

  case 8:
#line 570 "parser.yy"
    {
		THIS->lexer_->set_identifier (ly_symbol2scm ("$defaultheader"), (yyvsp[0].scm));
	;}
    break;

  case 9:
#line 573 "parser.yy"
    {
	
	;}
    break;

  case 10:
#line 576 "parser.yy"
    {
		Book *book = (yyvsp[0].book);
		SCM proc = THIS->lexer_->lookup_identifier ("toplevel-book-handler");
		scm_call_2 (proc, THIS->self_scm (), book->self_scm ());
		book->unprotect ();
	;}
    break;

  case 11:
#line 582 "parser.yy"
    {
		Score *score = (yyvsp[0].score);
		
		SCM proc = THIS->lexer_->lookup_identifier ("toplevel-score-handler");
		scm_call_2 (proc, THIS->self_scm (), score->self_scm ());
		score->unprotect ();
	;}
    break;

  case 12:
#line 589 "parser.yy"
    {
		Music *music = (yyvsp[0].music);
		SCM proc = THIS->lexer_->lookup_identifier ("toplevel-music-handler");
		scm_call_2 (proc, THIS->self_scm (), music->self_scm ());
		music->unprotect (); 
	;}
    break;

  case 13:
#line 595 "parser.yy"
    {
		SCM proc = THIS->lexer_->lookup_identifier ("toplevel-text-handler");
		scm_call_2 (proc, THIS->self_scm (), (yyvsp[0].scm));
	;}
    break;

  case 14:
#line 599 "parser.yy"
    {
		SCM id = SCM_EOL;
		Output_def * od = (yyvsp[0].outputdef);

		if ((yyvsp[0].outputdef)->c_variable ("is-paper") == SCM_BOOL_T)
			id = ly_symbol2scm ("$defaultpaper");
		else if ((yyvsp[0].outputdef)->c_variable ("is-midi") == SCM_BOOL_T)
			id = ly_symbol2scm ("$defaultmidi");
		else if ((yyvsp[0].outputdef)->c_variable ("is-layout") == SCM_BOOL_T)
			id = ly_symbol2scm ("$defaultlayout");

		THIS->lexer_->set_identifier (id, od->self_scm ());
		od->unprotect();
	;}
    break;

  case 15:
#line 616 "parser.yy"
    {
	;}
    break;

  case 18:
#line 627 "parser.yy"
    {
		(yyval.scm) = get_header(THIS);
		THIS->lexer_->add_scope ((yyval.scm));
	;}
    break;

  case 19:
#line 631 "parser.yy"
    {
		
	;}
    break;

  case 20:
#line 637 "parser.yy"
    {
		(yyval.scm) = THIS->lexer_->remove_scope ();
	;}
    break;

  case 21:
#line 646 "parser.yy"
    { (yyval.scm) = (yyvsp[0].scm); ;}
    break;

  case 22:
#line 647 "parser.yy"
    { (yyval.scm) = (yyvsp[0].scm); ;}
    break;

  case 23:
#line 651 "parser.yy"
    {
		if (! is_regular_identifier ((yyvsp[-2].scm)))
		{
			(yylsp[-2]).warning (_ ("identifier should have alphabetic characters only"));
		}

	        THIS->lexer_->set_identifier ((yyvsp[-2].scm), (yyvsp[0].scm));

/*
 TODO: devise standard for protection in parser.

  The parser stack lives on the C-stack, which means that
all objects can be unprotected as soon as they're here.

*/
	;}
    break;

  case 24:
#line 667 "parser.yy"
    { ;}
    break;

  case 25:
#line 672 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].score)->self_scm ();
		(yyvsp[0].score)->unprotect ();
	;}
    break;

  case 26:
#line 676 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].outputdef)->self_scm ();
		(yyvsp[0].outputdef)->unprotect ();
	;}
    break;

  case 27:
#line 680 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 28:
#line 683 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].music)->self_scm ();
		(yyvsp[0].music)->unprotect();
	;}
    break;

  case 29:
#line 687 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].music)->self_scm ();
		(yyvsp[0].music)->unprotect();
	;}
    break;

  case 30:
#line 691 "parser.yy"
    {
 		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 31:
#line 694 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 32:
#line 697 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 33:
#line 700 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 34:
#line 703 "parser.yy"
    {
		(yyval.scm) = scm_from_int ((yyvsp[0].i));
	;}
    break;

  case 35:
#line 710 "parser.yy"
    {
		(yyval.scm) = (yyvsp[-1].scm);
	;}
    break;

  case 36:
#line 716 "parser.yy"
    {
		(yyval.scm) = Context_def::make_scm ();
		unsmob_context_def ((yyval.scm))->set_spot ((yyloc));
	;}
    break;

  case 37:
#line 720 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
		unsmob_context_def ((yyval.scm))->set_spot ((yyloc));
	;}
    break;

  case 38:
#line 724 "parser.yy"
    {
		Context_def*td = unsmob_context_def ((yyval.scm));

		for (SCM p = (yyvsp[0].scm); scm_is_pair (p); p = scm_cdr (p)) {
			SCM tag = scm_caar (p);

			/* TODO: should make new tag "grob-definition" ? */
			td->add_context_mod (scm_list_3 (ly_symbol2scm ("assign"),
							tag, scm_cons (scm_cdar (p), SCM_EOL)));
		}
	;}
    break;

  case 39:
#line 735 "parser.yy"
    {
		unsmob_context_def ((yyval.scm))->add_context_mod ((yyvsp[0].scm));		
	;}
    break;

  case 40:
#line 743 "parser.yy"
    {
		(yyval.book) = (yyvsp[-1].book);
	;}
    break;

  case 41:
#line 752 "parser.yy"
    {
		(yyval.book) = new Book;
		(yyval.book)->set_spot ((yyloc));
		(yyval.book)->paper_ = dynamic_cast<Output_def*> (unsmob_output_def (THIS->lexer_->lookup_identifier ("$defaultpaper"))->clone ());
		(yyval.book)->paper_->unprotect ();
		(yyval.book)->header_ = THIS->lexer_->lookup_identifier ("$defaultheader"); 
	;}
    break;

  case 42:
#line 759 "parser.yy"
    {
		(yyval.book)->paper_ = (yyvsp[0].outputdef);
		(yyvsp[0].outputdef)->unprotect ();
	;}
    break;

  case 43:
#line 763 "parser.yy"
    {
		SCM s = (yyvsp[0].score)->self_scm ();
		(yyval.book)->add_score (s);
		(yyvsp[0].score)->unprotect();
	;}
    break;

  case 44:
#line 768 "parser.yy"
    {
		(yyval.book)->add_score ((yyvsp[0].scm));
	;}
    break;

  case 45:
#line 771 "parser.yy"
    {
		(yyval.book)->header_ = (yyvsp[0].scm);
	;}
    break;

  case 46:
#line 774 "parser.yy"
    {
		(yyval.book)->paper_ = 0;
		(yyval.book)->scores_ = SCM_EOL;
	;}
    break;

  case 47:
#line 778 "parser.yy"
    {
		(yyval.book)->user_key_ = ly_scm2string ((yyvsp[0].scm));
	;}
    break;

  case 48:
#line 784 "parser.yy"
    {
		(yyval.score) = (yyvsp[-1].score);
	;}
    break;

  case 49:
#line 790 "parser.yy"
    {
		SCM m = (yyvsp[0].music)->self_scm ();
		(yyvsp[0].music)->unprotect();
		SCM scorify = ly_lily_module_constant ("scorify-music");
		SCM score = scm_call_2 (scorify, m, THIS->self_scm ());

		// pass ownernship to C++ again.
		(yyval.score) = unsmob_score (score);
		(yyval.score)->protect ();
		(yyval.score)->set_spot ((yyloc));
	;}
    break;

  case 50:
#line 801 "parser.yy"
    {
		(yyval.score) = unsmob_score ((yyvsp[0].scm));
		(yyval.score)->set_spot ((yyloc));
	;}
    break;

  case 51:
#line 805 "parser.yy"
    {
		(yyval.score)->user_key_ = ly_scm2string ((yyvsp[0].scm));
	;}
    break;

  case 52:
#line 808 "parser.yy"
    {
		(yyval.score)->header_ = (yyvsp[0].scm);
	;}
    break;

  case 53:
#line 811 "parser.yy"
    {
		if ((yyvsp[0].outputdef)->lookup_variable (ly_symbol2scm ("is-paper")) == SCM_BOOL_T)
		{
			THIS->parser_error ((yylsp[0]), _("\\paper cannot be used in \\score, use \\layout instead"));
		
		}
		else
		{
			(yyval.score)->defs_.push ((yyvsp[0].outputdef));
		}
		(yyvsp[0].outputdef)->unprotect ();
	;}
    break;

  case 54:
#line 823 "parser.yy"
    {
		(yyval.score)->error_found_ = true;
	;}
    break;

  case 55:
#line 834 "parser.yy"
    {
		(yyval.outputdef) = (yyvsp[0].outputdef);
		if ((yyval.outputdef)->lookup_variable (ly_symbol2scm ("is-paper")) != SCM_BOOL_T)
		{
			THIS->parser_error ((yylsp[0]), _ ("need \\paper for paper block"));
			(yyval.outputdef) = get_paper (THIS);
		}
	;}
    break;

  case 56:
#line 846 "parser.yy"
    {
		(yyval.outputdef) = (yyvsp[-1].outputdef);

		THIS->lexer_->remove_scope ();
		THIS->lexer_->pop_state ();
	;}
    break;

  case 57:
#line 855 "parser.yy"
    {
		(yyval.outputdef) = get_paper (THIS);
		(yyval.outputdef)->input_origin_ = (yyloc);
		THIS->lexer_->add_scope ((yyval.outputdef)->scope_);
	;}
    break;

  case 58:
#line 860 "parser.yy"
    {
		Output_def *p = get_midi (THIS);
		(yyval.outputdef) = p;
		THIS->lexer_->add_scope (p->scope_);
	;}
    break;

  case 59:
#line 865 "parser.yy"
    {
		Output_def *p = get_layout (THIS);

		THIS->lexer_->add_scope (p->scope_);
		(yyval.outputdef) = p;
	;}
    break;

  case 60:
#line 875 "parser.yy"
    {
		(yyval.outputdef) = (yyvsp[-1].outputdef);
		(yyval.outputdef)->input_origin_.set_spot ((yyloc));
		THIS->lexer_->push_initial_state ();
	;}
    break;

  case 61:
#line 880 "parser.yy"
    {
		(yyvsp[-2].outputdef)->unprotect ();
		Output_def *o = unsmob_output_def ((yyvsp[0].scm));
		o->input_origin_.set_spot ((yyloc));
		(yyval.outputdef) = o;
		THIS->lexer_->remove_scope ();
		THIS->lexer_->add_scope (o->scope_);
		THIS->lexer_->push_initial_state ();
	;}
    break;

  case 62:
#line 889 "parser.yy"
    {

	;}
    break;

  case 63:
#line 892 "parser.yy"
    {
		assign_context_def ((yyval.outputdef), (yyvsp[0].scm));
	;}
    break;

  case 64:
#line 895 "parser.yy"
    {
		/*
			junk this ? there already is tempo stuff in
			music.
		*/
		int m = scm_to_int ((yyvsp[0].music)->get_property ("metronome-count"));
		Duration *d = unsmob_duration ((yyvsp[0].music)->get_property ("tempo-unit"));
		set_tempo ((yyval.outputdef), d->get_length (), m);
		(yyvsp[0].music)->unprotect ();
	;}
    break;

  case 65:
#line 905 "parser.yy"
    {

	;}
    break;

  case 66:
#line 911 "parser.yy"
    {
		(yyval.music) = MY_MAKE_MUSIC ("MetronomeChangeEvent");
		(yyval.music)->set_property ("tempo-unit", (yyvsp[-2].scm));
		(yyval.music)->set_property ("metronome-count", scm_from_int ( (yyvsp[0].i)));
	;}
    break;

  case 67:
#line 926 "parser.yy"
    {
		(yyval.scm) = scm_cons (SCM_EOL, SCM_EOL);
	;}
    break;

  case 68:
#line 929 "parser.yy"
    {
		SCM s = (yyval.scm);
 		SCM c = scm_cons ((yyvsp[0].music)->self_scm (), SCM_EOL);
		(yyvsp[0].music)->unprotect (); /* UGH */

		if (scm_is_pair (scm_cdr (s)))
			scm_set_cdr_x (scm_cdr (s), c); /* append */
		else
			scm_set_car_x (s, c); /* set first cons */
		scm_set_cdr_x (s, c);  /* remember last cell */
	;}
    break;

  case 69:
#line 940 "parser.yy"
    {

	;}
    break;

  case 70:
#line 943 "parser.yy"
    {
		Music * m = MY_MAKE_MUSIC("Music");
		// ugh. code dup 
		m->set_property ("error-found", SCM_BOOL_T);
		SCM s = (yyval.scm);
 		SCM c = scm_cons (m->self_scm (), SCM_EOL);
		m->unprotect (); /* UGH */

		if (scm_is_pair (scm_cdr (s)))
			scm_set_cdr_x (scm_cdr (s), c); /* append */
		else
			scm_set_car_x (s, c); /* set first cons */
		scm_set_cdr_x (s, c);  /* remember last cell */
	;}
    break;

  case 73:
#line 965 "parser.yy"
    {
		(yyval.scm) = SCM_EOL;
	;}
    break;

  case 74:
#line 968 "parser.yy"
    {
		(yyval.scm) = (yyvsp[-1].scm);
	;}
    break;

  case 75:
#line 976 "parser.yy"
    {
		Music *beg = (yyvsp[-1].music);
		int times = (yyvsp[-2].i);
		SCM alts = scm_is_pair ((yyvsp[0].scm)) ? scm_car ((yyvsp[0].scm)) : SCM_EOL;
		if (times < scm_ilength (alts)) {
		  unsmob_music (scm_car (alts))
		    ->origin ()->warning (
		    _ ("more alternatives than repeats"));
		    warning ("junking excess alternatives");
		  alts = ly_truncate_list (times, alts);
		}


		SCM proc = ly_lily_module_constant ("make-repeated-music");

		SCM mus = scm_call_1 (proc, (yyvsp[-3].scm));
		Music *r = unsmob_music (mus);
		r->protect ();
		if (beg)
			{
			r-> set_property ("element", beg->self_scm ());
			beg->unprotect ();
			}
		r->set_property ("repeat-count", scm_from_int (max (times, 1)));

		r-> set_property ("elements",alts);
		if (ly_is_equal ((yyvsp[-3].scm), scm_makfrom0str ("tremolo"))) {
			/*
			TODO: move this code to Scheme.
			*/

			/* we cannot get durations and other stuff
			   correct down the line,
			   so we have to add to the duration log here. */
			SCM func = ly_lily_module_constant ("shift-duration-log");

			int dots = ((yyvsp[-2].i) % 3) ? 0 : 1;
			int shift = -intlog2 ((dots) ? ((yyvsp[-2].i)*2/3) : (yyvsp[-2].i));

			
			if ((yyvsp[-1].music)->is_mus_type ("sequential-music"))
			{
				int list_len = scm_ilength ((yyvsp[-1].music)->get_property ("elements"));
				if (list_len != 2)
					(yyvsp[-1].music)->origin ()->warning (_f ("expect 2 elements for Chord tremolo, found %d", list_len));
				shift -= 1;
				r->compress (Moment (Rational (1, list_len)));
			}
			scm_call_3 (func, r->self_scm (), scm_from_int (shift), scm_from_int (dots));

		}
		r->set_spot (*(yyvsp[-1].music)->origin ());

		(yyval.music) = r;
	;}
    break;

  case 76:
#line 1034 "parser.yy"
    {
		(yyval.music) = MY_MAKE_MUSIC ("SequentialMusic");
		(yyval.music)->set_property ("elements", scm_car ((yyvsp[-1].scm)));
		(yyval.music)->set_spot ((yyloc));
	;}
    break;

  case 77:
#line 1039 "parser.yy"
    {
		(yyval.music) = MY_MAKE_MUSIC ("SequentialMusic");
		(yyval.music)->set_property ("elements", scm_car ((yyvsp[-1].scm)));
		(yyval.music)->set_spot ((yyloc));
	;}
    break;

  case 78:
#line 1047 "parser.yy"
    {
		(yyval.music) = MY_MAKE_MUSIC ("SimultaneousMusic");
		(yyval.music)->set_property ("elements", scm_car ((yyvsp[-1].scm)));
		(yyval.music)->set_spot ((yyloc));

	;}
    break;

  case 79:
#line 1053 "parser.yy"
    {
		(yyval.music) = MY_MAKE_MUSIC ("SimultaneousMusic");
		(yyval.music)->set_property ("elements", scm_car ((yyvsp[-1].scm)));
		(yyval.music)->set_spot ((yyloc));
	;}
    break;

  case 80:
#line 1061 "parser.yy"
    { (yyval.music) = (yyvsp[0].music); ;}
    break;

  case 81:
#line 1062 "parser.yy"
    {
		(yyval.music) = unsmob_music ((yyvsp[0].scm));
	;}
    break;

  case 84:
#line 1071 "parser.yy"
    { (yyval.scm) = SCM_EOL; ;}
    break;

  case 85:
#line 1072 "parser.yy"
    { THIS->lexer_->push_initial_state (); ;}
    break;

  case 86:
#line 1074 "parser.yy"
    {
		THIS->lexer_->pop_state ();
		(yyval.scm) = (yyvsp[-1].scm);
	;}
    break;

  case 87:
#line 1081 "parser.yy"
    { (yyval.scm) = SCM_EOL; ;}
    break;

  case 88:
#line 1082 "parser.yy"
    {
		 (yyval.scm) = scm_cons ((yyvsp[0].scm), (yyvsp[-1].scm));
	;}
    break;

  case 89:
#line 1089 "parser.yy"
    { (yyval.music) = (yyvsp[0].music); ;}
    break;

  case 90:
#line 1090 "parser.yy"
    { (yyval.music) = (yyvsp[0].music); ;}
    break;

  case 91:
#line 1094 "parser.yy"
    { (yyval.music) = (yyvsp[0].music); ;}
    break;

  case 92:
#line 1095 "parser.yy"
    { (yyval.music) = (yyvsp[0].music); ;}
    break;

  case 93:
#line 1099 "parser.yy"
    {
		(yyval.scm) = scm_list_2 ((yyvsp[0].scm), make_input ((yyloc)));
	;}
    break;

  case 94:
#line 1102 "parser.yy"
    {
		(yyval.scm) = scm_list_3 ((yyvsp[-1].scm), make_input ((yyloc)), (yyvsp[0].scm));
	;}
    break;

  case 95:
#line 1105 "parser.yy"
    {
		(yyval.scm) = scm_list_3 ((yyvsp[-1].scm), make_input ((yyloc)), (yyvsp[0].scm));
	;}
    break;

  case 96:
#line 1108 "parser.yy"
    {
		(yyval.scm) = scm_list_3 ((yyvsp[-1].scm), make_input ((yyloc)), (yyvsp[0].music)->self_scm ());
		(yyvsp[0].music)->unprotect ();
	;}
    break;

  case 97:
#line 1112 "parser.yy"
    {
		(yyval.scm) = scm_list_4 ((yyvsp[-2].scm), make_input ((yyloc)), (yyvsp[-1].scm), (yyvsp[0].music)->self_scm ());
		(yyvsp[0].music)->unprotect ();
	;}
    break;

  case 98:
#line 1116 "parser.yy"
    {
		(yyval.scm) = scm_list_4 ((yyvsp[-2].scm), make_input ((yyloc)), (yyvsp[-1].scm), (yyvsp[0].scm));
	;}
    break;

  case 99:
#line 1119 "parser.yy"
    {
		(yyval.scm) = scm_list_5 ((yyvsp[-3].scm), make_input ((yyloc)), (yyvsp[-2].scm), (yyvsp[-1].scm), (yyvsp[0].music)->self_scm ());
	;}
    break;

  case 100:
#line 1122 "parser.yy"
    {
		(yyval.scm) = scm_list_4 ((yyvsp[-2].scm), make_input ((yyloc)), (yyvsp[-1].scm), (yyvsp[0].music)->self_scm ());
		(yyvsp[0].music)->unprotect ();
	;}
    break;

  case 101:
#line 1126 "parser.yy"
    {
		(yyval.scm) = scm_list_4 ((yyvsp[-2].scm), make_input ((yyloc)), (yyvsp[-1].scm), (yyvsp[0].scm));
	;}
    break;

  case 102:
#line 1129 "parser.yy"
    {
		(yyval.scm) = scm_list_4 ((yyvsp[-2].scm), make_input ((yyloc)), (yyvsp[-1].music)->self_scm (), (yyvsp[0].music)->self_scm ());
		(yyvsp[-1].music)->unprotect ();
		(yyvsp[0].music)->unprotect ();
	;}
    break;

  case 103:
#line 1134 "parser.yy"
    {
		(yyval.scm) = scm_list_5 ((yyvsp[-3].scm), make_input ((yyloc)), (yyvsp[-2].scm), (yyvsp[-1].music)->self_scm (), (yyvsp[0].music)->self_scm ());
		(yyvsp[0].music)->unprotect ();
		(yyvsp[-1].music)->unprotect ();
	;}
    break;

  case 104:
#line 1139 "parser.yy"
    {
		(yyval.scm) = scm_list_5 ((yyvsp[-3].scm), make_input ((yyloc)), (yyvsp[-2].scm), (yyvsp[-1].music)->self_scm (), (yyvsp[0].music)->self_scm ());
		(yyvsp[-1].music)->unprotect ();
		(yyvsp[0].music)->unprotect ();
	;}
    break;

  case 105:
#line 1147 "parser.yy"
    {
		SCM func = scm_car ((yyvsp[0].scm));
		Input *loc = unsmob_input (scm_cadr ((yyvsp[0].scm)));
		SCM args = scm_cddr ((yyvsp[0].scm));
		SCM sig = scm_object_property (func, ly_symbol2scm ("music-function-signature"));

		SCM type_check_proc = ly_lily_module_constant ("type-check-list");
		bool ok  = true;

		if (!to_boolean (scm_call_3  (type_check_proc, scm_cadr ((yyvsp[0].scm)), sig, args)))
		{
			THIS->error_level_ = 1;
			ok = false;
		}

		SCM m = SCM_EOL;
  		if (ok)
			m = scm_apply_0 (func, scm_cons (THIS->self_scm(),
							 scm_cdr ((yyvsp[0].scm))));

		if (unsmob_music (m))
			{
			(yyval.music) = unsmob_music (m);
			(yyval.music)->protect ();
			}
		else
			{
			if (ok)
 				loc->error (_ ("music head function must return Music object")); 
			(yyval.music) = MY_MAKE_MUSIC ("Music");
			}
		(yyval.music)->set_spot (*loc);
	;}
    break;

  case 106:
#line 1184 "parser.yy"
    {
		(yyval.music) = (yyvsp[0].music);
	;}
    break;

  case 107:
#line 1187 "parser.yy"
    {
		(yyval.music) = context_spec_music ((yyvsp[-4].scm), (yyvsp[-2].scm), (yyvsp[0].music), (yyvsp[-1].scm));

	;}
    break;

  case 108:
#line 1191 "parser.yy"
    {
		(yyval.music) = context_spec_music ((yyvsp[-2].scm), SCM_UNDEFINED, (yyvsp[0].music), (yyvsp[-1].scm));
	;}
    break;

  case 109:
#line 1194 "parser.yy"
    {
		(yyval.music) = context_spec_music ((yyvsp[-2].scm), get_next_unique_context_id (), (yyvsp[0].music),
			(yyvsp[-1].scm));
	;}
    break;

  case 110:
#line 1201 "parser.yy"
    {
		int n = scm_to_int (scm_car ((yyvsp[-1].scm))); int d = scm_to_int (scm_cdr ((yyvsp[-1].scm)));
		Music *mp = (yyvsp[0].music);

		(yyval.music)= MY_MAKE_MUSIC ("TimeScaledMusic");
		(yyval.music)->set_spot ((yyloc));

		(yyval.music)->set_property ("element", mp->self_scm ());
		mp->unprotect();
		(yyval.music)->set_property ("numerator", scm_from_int (n));
		(yyval.music)->set_property ("denominator", scm_from_int (d));
		(yyval.music)->compress (Moment (Rational (n,d)));

	;}
    break;

  case 111:
#line 1215 "parser.yy"
    { (yyval.music) = (yyvsp[0].music); ;}
    break;

  case 112:
#line 1216 "parser.yy"
    {
		(yyval.music) = MY_MAKE_MUSIC ("TransposedMusic");
		Music *p = (yyvsp[0].music);
		Pitch from = *unsmob_pitch ((yyvsp[-2].scm));
		Pitch to = *unsmob_pitch ((yyvsp[-1].scm));

		p->transpose (pitch_interval (from, to));
		(yyval.music)->set_property ("element", p->self_scm ());
		p->unprotect();
	;}
    break;

  case 113:
#line 1226 "parser.yy"
    {
		if ((yyvsp[-1].scm) == ly_symbol2scm ("chords"))
		{
		  Music *chm = MY_MAKE_MUSIC ("UnrelativableMusic");
		  chm->set_property ("element", (yyvsp[0].music)->self_scm ());
		  (yyval.music) = chm;
		  (yyvsp[0].music)->unprotect();
		}
		else
		{
		  (yyval.music) = (yyvsp[0].music);
		}
		THIS->lexer_->pop_state ();
	;}
    break;

  case 114:
#line 1240 "parser.yy"
    {
		(yyval.music) = context_spec_music ((yyvsp[-2].scm), get_next_unique_context_id (),
					 (yyvsp[0].music), (yyvsp[-1].scm));
		if ((yyvsp[-2].scm) == ly_symbol2scm ("ChordNames"))
		{
		  Music *chm = MY_MAKE_MUSIC ("UnrelativableMusic");
		  chm->set_property ("element", (yyval.music)->self_scm ());
		  (yyval.music)->unprotect();
		  (yyval.music) = chm;
		}
		THIS->lexer_->pop_state ();
	;}
    break;

  case 115:
#line 1252 "parser.yy"
    { (yyval.music) = (yyvsp[0].music); ;}
    break;

  case 116:
#line 1253 "parser.yy"
    { (yyval.music) = (yyvsp[0].music); ;}
    break;

  case 117:
#line 1254 "parser.yy"
    {
		tag_music ((yyvsp[0].music), (yyvsp[-1].scm), (yyloc));
		(yyval.music) = (yyvsp[0].music);
	;}
    break;

  case 118:
#line 1261 "parser.yy"
    {
		SCM nn = THIS->lexer_->lookup_identifier ("pitchnames");
		THIS->lexer_->push_note_state (alist_to_hashq (nn));

		(yyval.scm) = ly_symbol2scm ("notes");
	;}
    break;

  case 119:
#line 1268 "parser.yy"
    {
		SCM nn = THIS->lexer_->lookup_identifier ("drumPitchNames");
		THIS->lexer_->push_note_state (alist_to_hashq (nn));

		(yyval.scm) = ly_symbol2scm ("drums");
	;}
    break;

  case 120:
#line 1274 "parser.yy"
    {
		THIS->lexer_->push_figuredbass_state ();

		(yyval.scm) = ly_symbol2scm ("figures");
	;}
    break;

  case 121:
#line 1279 "parser.yy"
    {
		SCM nn = THIS->lexer_->lookup_identifier ("chordmodifiers");
		THIS->lexer_->chordmodifier_tab_ = alist_to_hashq (nn);
		nn = THIS->lexer_->lookup_identifier ("pitchnames");
		THIS->lexer_->push_chord_state (alist_to_hashq (nn));
		(yyval.scm) = ly_symbol2scm ("chords");

	;}
    break;

  case 122:
#line 1288 "parser.yy"
    { THIS->lexer_->push_lyric_state ();
		(yyval.scm) = ly_symbol2scm ("lyrics");
	;}
    break;

  case 123:
#line 1294 "parser.yy"
    {
		SCM nn = THIS->lexer_->lookup_identifier ("drumPitchNames");
		THIS->lexer_->push_note_state (alist_to_hashq (nn));

		(yyval.scm) = ly_symbol2scm ("DrumStaff");
	;}
    break;

  case 124:
#line 1300 "parser.yy"
    {
		THIS->lexer_->push_figuredbass_state ();

		(yyval.scm) = ly_symbol2scm ("FiguredBass");
	;}
    break;

  case 125:
#line 1305 "parser.yy"
    {
		SCM nn = THIS->lexer_->lookup_identifier ("chordmodifiers");
		THIS->lexer_->chordmodifier_tab_ = alist_to_hashq (nn);
		nn = THIS->lexer_->lookup_identifier ("pitchnames");
		THIS->lexer_->push_chord_state (alist_to_hashq (nn));
		(yyval.scm) = ly_symbol2scm ("ChordNames");
	;}
    break;

  case 126:
#line 1313 "parser.yy"
    { THIS->lexer_->push_lyric_state ();
		(yyval.scm) = ly_symbol2scm ("Lyrics");
	;}
    break;

  case 127:
#line 1320 "parser.yy"
    {
		Music *m = (yyvsp[0].music);
		Pitch start = *unsmob_pitch ((yyvsp[-1].scm));
		(yyval.music) = make_music_relative (start, m);
		m->unprotect();
	;}
    break;

  case 128:
#line 1326 "parser.yy"
    {
		Music *m = (yyvsp[0].music);

		Pitch middle_c (0, 0, 0);
		(yyval.music) = make_music_relative (middle_c, m);
		m->unprotect();
	;}
    break;

  case 129:
#line 1336 "parser.yy"
    { THIS->lexer_->push_lyric_state (); ;}
    break;

  case 130:
#line 1338 "parser.yy"
    {
	/* Can also use Music at the expensive of two S/Rs similar to
           \repeat \alternative */
		THIS->lexer_->pop_state ();

		(yyval.scm) = scm_cons ((yyvsp[0].music)->self_scm (), SCM_EOL);
	;}
    break;

  case 131:
#line 1345 "parser.yy"
    {
		THIS->lexer_->push_lyric_state ();
	;}
    break;

  case 132:
#line 1347 "parser.yy"
    {
		THIS->lexer_->pop_state ();
		(yyval.scm) = scm_cons ((yyvsp[0].music)->self_scm (), (yyvsp[-3].scm));
	;}
    break;

  case 133:
#line 1354 "parser.yy"
    {
		Music * voice = (yyvsp[-1].music);
		SCM name = get_first_context_id (scm_makfrom0str ("Voice"), voice); 
		if (!scm_is_string (name))
		{
			name = get_next_unique_lyrics_context_id ();
			voice = context_spec_music (scm_makfrom0str ("Voice"),
						    name,
						    voice, SCM_EOL);
		}

		SCM context = scm_makfrom0str ("Lyrics");
		Music *all = MY_MAKE_MUSIC ("SimultaneousMusic");

		SCM lst = SCM_EOL;
		for (SCM s = (yyvsp[0].scm); scm_is_pair (s); s = scm_cdr (s))
		{
			Music *music = unsmob_music (scm_car (s));
			Music *com = make_lyric_combine_music (name, music);
			Music *csm = context_spec_music (context,
				get_next_unique_context_id (), com, SCM_EOL);
			lst = scm_cons (csm->self_scm (), lst);
		}
		all->set_property ("elements", scm_cons (voice->self_scm (),
			lst));
		(yyval.music) = all;
		voice->unprotect ();
	;}
    break;

  case 134:
#line 1382 "parser.yy"
    {
		THIS->lexer_->push_lyric_state ();
	;}
    break;

  case 135:
#line 1384 "parser.yy"
    {
		THIS->lexer_->pop_state ();
		Music *music = (yyvsp[0].music);
		SCM name = (yyvsp[-2].scm);
		(yyval.music) = make_lyric_combine_music (name, music);
		music->unprotect();
	;}
    break;

  case 136:
#line 1394 "parser.yy"
    {
		Music*t = MY_MAKE_MUSIC ("ContextChange");
		t-> set_property ("change-to-type", scm_string_to_symbol ((yyvsp[-2].scm)));
		t-> set_property ("change-to-id", (yyvsp[0].scm));

		(yyval.music) = t;
		(yyval.music)->set_spot ((yyloc));
	;}
    break;

  case 137:
#line 1405 "parser.yy"
    {
		(yyval.scm) = scm_list_3 (ly_symbol2scm ("assign"),
			scm_string_to_symbol ((yyvsp[-2].scm)), (yyvsp[0].scm));
	;}
    break;

  case 138:
#line 1409 "parser.yy"
    {
		(yyval.scm) = scm_list_2 (ly_symbol2scm ("unset"),
			scm_string_to_symbol ((yyvsp[0].scm)));
	;}
    break;

  case 139:
#line 1413 "parser.yy"
    {
		(yyval.scm) = scm_list_4 (ly_symbol2scm ("push"),
			scm_string_to_symbol ((yyvsp[-3].scm)), (yyvsp[-2].scm), (yyvsp[0].scm));
	;}
    break;

  case 140:
#line 1417 "parser.yy"
    {
		(yyval.scm) = scm_list_3 (ly_symbol2scm ("pop"),
			scm_string_to_symbol ((yyvsp[-1].scm)), (yyvsp[0].scm));
	;}
    break;

  case 141:
#line 1424 "parser.yy"
    { (yyval.scm) = ly_symbol2scm ("consists"); ;}
    break;

  case 142:
#line 1425 "parser.yy"
    { (yyval.scm) = ly_symbol2scm ("remove"); ;}
    break;

  case 143:
#line 1427 "parser.yy"
    { (yyval.scm) = ly_symbol2scm ("accepts"); ;}
    break;

  case 144:
#line 1428 "parser.yy"
    { (yyval.scm) = ly_symbol2scm ("default-child"); ;}
    break;

  case 145:
#line 1429 "parser.yy"
    { (yyval.scm) = ly_symbol2scm ("denies"); ;}
    break;

  case 146:
#line 1431 "parser.yy"
    { (yyval.scm) = ly_symbol2scm ("alias"); ;}
    break;

  case 147:
#line 1432 "parser.yy"
    { (yyval.scm) = ly_symbol2scm ("translator-type"); ;}
    break;

  case 148:
#line 1433 "parser.yy"
    { (yyval.scm) = ly_symbol2scm ("description"); ;}
    break;

  case 149:
#line 1434 "parser.yy"
    { (yyval.scm) = ly_symbol2scm ("context-name"); ;}
    break;

  case 150:
#line 1438 "parser.yy"
    { (yyval.scm) = (yyvsp[0].scm); ;}
    break;

  case 151:
#line 1439 "parser.yy"
    {
		(yyval.scm) = scm_list_2 ((yyvsp[-1].scm), (yyvsp[0].scm));
	;}
    break;

  case 152:
#line 1445 "parser.yy"
    {
		if (!is_regular_identifier ((yyvsp[0].scm)))
		{
			(yyloc).error (_("Grob name should be alphanumeric"));
		}

		(yyval.scm) = scm_list_2 (ly_symbol2scm ("Bottom"),
			scm_string_to_symbol ((yyvsp[0].scm)));
	;}
    break;

  case 153:
#line 1454 "parser.yy"
    {
		(yyval.scm) = scm_list_2 (scm_string_to_symbol ((yyvsp[-2].scm)),
			scm_string_to_symbol ((yyvsp[0].scm)));
	;}
    break;

  case 154:
#line 1461 "parser.yy"
    {
		(yyval.music) = property_op_to_music (scm_list_4 (
			ly_symbol2scm ("poppush"),
			scm_cadr ((yyvsp[-3].scm)),
			(yyvsp[-2].scm), (yyvsp[0].scm)));
		(yyval.music)= context_spec_music (scm_car ((yyvsp[-3].scm)), SCM_UNDEFINED, (yyval.music), SCM_EOL);
	;}
    break;

  case 155:
#line 1468 "parser.yy"
    {
		(yyval.music) = property_op_to_music (scm_list_3 (
			ly_symbol2scm ("pop"),
			scm_cadr ((yyvsp[-1].scm)),
			(yyvsp[0].scm)));

		(yyval.music)= context_spec_music (scm_car ((yyvsp[-1].scm)), SCM_UNDEFINED, (yyval.music), SCM_EOL);
	;}
    break;

  case 156:
#line 1476 "parser.yy"
    {
		(yyval.music) = property_op_to_music (scm_list_3 (
			ly_symbol2scm ("assign"),
			scm_cadr ((yyvsp[-2].scm)),
			(yyvsp[0].scm)));
		(yyval.music)= context_spec_music (scm_car ((yyvsp[-2].scm)), SCM_UNDEFINED, (yyval.music), SCM_EOL);
	;}
    break;

  case 157:
#line 1483 "parser.yy"
    {
		(yyval.music) = property_op_to_music (scm_list_2 (
			ly_symbol2scm ("unset"),
			scm_cadr ((yyvsp[0].scm))));
		(yyval.music)= context_spec_music (scm_car ((yyvsp[0].scm)), SCM_UNDEFINED, (yyval.music), SCM_EOL);
	;}
    break;

  case 158:
#line 1489 "parser.yy"
    {
		SCM e = (yyvsp[0].music)->get_property ("element");
                unsmob_music (e)->set_property ("once", SCM_BOOL_T);
		(yyval.music) = (yyvsp[0].music);

	;}
    break;

  case 159:
#line 1499 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 160:
#line 1502 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 161:
#line 1505 "parser.yy"
    {
		(yyval.scm) = scm_string_append (scm_list_2 ((yyvsp[-2].scm), (yyvsp[0].scm)));
	;}
    break;

  case 162:
#line 1510 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 163:
#line 1513 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 164:
#line 1516 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 165:
#line 1521 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 166:
#line 1524 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 167:
#line 1527 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 168:
#line 1530 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 169:
#line 1533 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 170:
#line 1536 "parser.yy"
    {
		(yyval.scm) = scm_from_int ((yyvsp[0].i));
	;}
    break;

  case 172:
#line 1564 "parser.yy"
    {
		SCM elts = (yyvsp[-1].music)-> get_property ("elements");

		elts = ly_append2 (elts, scm_reverse_x ((yyvsp[0].scm), SCM_EOL));

		(yyvsp[-1].music)->set_property ("elements", elts);
		/* why is this giving wrong start location? -ns
		 * $2->set_spot (@$); */
		Input i;
		i.set_location ((yylsp[-1]), (yylsp[0]));
		(yyvsp[-1].music)->set_spot (i);
		(yyval.music) = (yyvsp[-1].music);
	;}
    break;

  case 175:
#line 1584 "parser.yy"
    {
		SCM dur = unsmob_duration ((yyvsp[-1].scm))->smobbed_copy ();
		SCM es = (yyvsp[-2].music)->get_property ("elements");
		SCM postevs = scm_reverse_x ((yyvsp[0].scm), SCM_EOL);

		for (SCM s = es; scm_is_pair (s); s = scm_cdr (s))
		  unsmob_music (scm_car (s))->set_property ("duration", dur);
		es = ly_append2 (es, postevs);

		(yyvsp[-2].music)-> set_property ("elements", es);
		(yyvsp[-2].music)->set_spot ((yyloc));
		(yyval.music) = (yyvsp[-2].music);
	;}
    break;

  case 180:
#line 1613 "parser.yy"
    {
		(yyval.music) = MY_MAKE_MUSIC ("EventChord");
		(yyval.music)->set_spot ((yyloc));
		(yyval.music)->set_property ("elements",
			scm_reverse_x ((yyvsp[-1].scm), SCM_EOL));
	;}
    break;

  case 181:
#line 1622 "parser.yy"
    { (yyval.scm) = SCM_EOL; ;}
    break;

  case 182:
#line 1623 "parser.yy"
    {
		(yyval.scm) = scm_cons ((yyvsp[0].music)->self_scm (), (yyvsp[-1].scm));
		(yyvsp[0].music)->unprotect ();
	;}
    break;

  case 183:
#line 1631 "parser.yy"
    {
		int q = (yyvsp[-2].i);
		int ex = (yyvsp[-3].i);
		SCM check = (yyvsp[-1].scm);
		SCM post = (yyvsp[0].scm);

		Music *n = MY_MAKE_MUSIC ("NoteEvent");
		n->set_property ("pitch", (yyvsp[-4].scm));
		n->set_spot ((yyloc));
		if (q % 2)
			n->set_property ("cautionary", SCM_BOOL_T);
		if (ex % 2 || q % 2)
			n->set_property ("force-accidental", SCM_BOOL_T);

		if (scm_is_pair (post)) {
			SCM arts = scm_reverse_x (post, SCM_EOL);
			n->set_property ("articulations", arts);
		}
		if (scm_is_number (check))
		{
			int q = scm_to_int (check);
			n->set_property ("absolute-octave", scm_from_int (q-1));
		}

		
		(yyval.music) = n;
	;}
    break;

  case 184:
#line 1658 "parser.yy"
    {
		Music *n = MY_MAKE_MUSIC ("NoteEvent");
		n->set_property ("duration", (yyvsp[0].scm));
		n->set_property ("drum-type", (yyvsp[-1].scm));
		n->set_spot ((yyloc));

		if (scm_is_pair ((yyvsp[0].scm))) {
			SCM arts = scm_reverse_x ((yyvsp[0].scm), SCM_EOL);
			n->set_property ("articulations", arts);
		}
		(yyval.music) = n;
	;}
    break;

  case 185:
#line 1673 "parser.yy"
    {
		SCM adder = ly_lily_module_constant ("add-quotable");
		
		scm_call_2 (adder, (yyvsp[-1].scm), (yyvsp[0].music)->self_scm ());
		(yyvsp[0].music)->unprotect();
	;}
    break;

  case 186:
#line 1682 "parser.yy"
    {
		(yyval.music) = MY_MAKE_MUSIC ("EventChord");
		(yyval.music)->set_property ("elements", scm_cons ((yyvsp[0].music)->self_scm (), SCM_EOL));
		(yyvsp[0].music)->unprotect();

		(yyval.music)-> set_spot ((yyloc));
		(yyvsp[0].music)-> set_spot ((yyloc));
	;}
    break;

  case 187:
#line 1690 "parser.yy"
    {
		Music *skip = MY_MAKE_MUSIC ("SkipMusic");
		skip->set_property ("duration", (yyvsp[0].scm));
		skip->set_spot ((yyloc));
		(yyval.music) = skip;
	;}
    break;

  case 188:
#line 1696 "parser.yy"
    {
		Music *m = MY_MAKE_MUSIC ("RelativeOctaveCheck");
		(yyval.music) = m;
		(yyval.music)->set_spot ((yyloc));
		(yyval.music)->set_property ("pitch", (yyvsp[0].scm));
	;}
    break;

  case 189:
#line 1702 "parser.yy"
    {
		Music *m = MY_MAKE_MUSIC ("LigatureEvent");
		m->set_property ("span-direction", scm_from_int (START));
		m->set_spot ((yyloc));

		(yyval.music) = MY_MAKE_MUSIC ("EventChord");
		(yyval.music)->set_property ("elements", scm_cons (m->self_scm (), SCM_EOL));
		m->unprotect();
		(yyval.music)->set_spot ((yyloc));
	;}
    break;

  case 190:
#line 1712 "parser.yy"
    {
		Music *m = MY_MAKE_MUSIC ("LigatureEvent");
		m->set_property ("span-direction", scm_from_int (STOP));
		m->set_spot ((yyloc));

		(yyval.music) = MY_MAKE_MUSIC ("EventChord");
		(yyval.music)->set_property ("elements", scm_cons (m->self_scm (), SCM_EOL));
		(yyval.music)->set_spot ((yyloc));
		m->unprotect ();
	;}
    break;

  case 191:
#line 1722 "parser.yy"
    {
		(yyval.music) = MY_MAKE_MUSIC ("VoiceSeparator");
		(yyval.music)->set_spot ((yyloc));
	;}
    break;

  case 192:
#line 1726 "parser.yy"
    {
		SCM pipe = THIS->lexer_->lookup_identifier ("pipeSymbol");

		if (Music * m = unsmob_music (pipe))
			(yyval.music) = m->clone ();
		else
			(yyval.music) = MY_MAKE_MUSIC ("BarCheck");

		(yyval.music)->set_spot ((yyloc));
	;}
    break;

  case 193:
#line 1736 "parser.yy"
    {
		Pitch middle_c;
		Pitch sounds_as_c = pitch_interval (*unsmob_pitch ((yyvsp[0].scm)), middle_c);
		(yyval.music) = set_property_music (ly_symbol2scm ("instrumentTransposition"),
					 sounds_as_c.smobbed_copy());
		(yyval.music)->set_spot ((yyloc));
		(yyval.music) = context_spec_music (ly_symbol2scm ("Staff"), SCM_UNDEFINED,
			(yyval.music), SCM_EOL);
	;}
    break;

  case 194:
#line 1745 "parser.yy"
    {
		Music *t = set_property_music (ly_symbol2scm ("whichBar"), (yyvsp[0].scm));

		Music *csm = context_spec_music (ly_symbol2scm ("Timing"), SCM_UNDEFINED,
					t, SCM_EOL);
		(yyval.music) = context_spec_music (ly_symbol2scm ("Score"), SCM_UNDEFINED, csm, SCM_EOL);
		(yyval.music)->set_spot ((yyloc));
		t->set_spot ((yyloc));
	;}
    break;

  case 195:
#line 1754 "parser.yy"
    {
		Moment m = - unsmob_duration ((yyvsp[0].scm))->get_length ();
		Music *p = set_property_music (ly_symbol2scm ( "measurePosition"),m.smobbed_copy ());
		p->set_spot ((yyloc));
		p = context_spec_music (ly_symbol2scm ("Timing"), SCM_UNDEFINED,
					p, SCM_EOL);
		p = context_spec_music (ly_symbol2scm ("Score"), SCM_UNDEFINED,
					p, SCM_EOL);
		(yyval.music) = p;
	;}
    break;

  case 196:
#line 1764 "parser.yy"
    {
		SCM proc = ly_lily_module_constant ("make-clef-set");

		SCM result = scm_call_1 (proc, (yyvsp[0].scm));
		(yyval.music) = unsmob_music (result);
		(yyval.music)->protect ();
	;}
    break;

  case 197:
#line 1771 "parser.yy"
    {
		SCM proc = ly_lily_module_constant ("make-time-signature-set");

		SCM result = scm_apply_2   (proc, scm_car ((yyvsp[0].scm)), scm_cdr ((yyvsp[0].scm)), SCM_EOL);
		(yyval.music) = unsmob_music (result);
		(yyval.music)->protect ();
	;}
    break;

  case 198:
#line 1778 "parser.yy"
    {
		SCM proc = ly_lily_module_constant ("make-mark-set");

		SCM result = scm_call_1 (proc, (yyvsp[0].scm));
		(yyval.music) = unsmob_music (result);
		(yyval.music)->protect ();
	;}
    break;

  case 199:
#line 1788 "parser.yy"
    {
		(yyval.music) = MY_MAKE_MUSIC ("PesOrFlexaEvent");
	;}
    break;

  case 200:
#line 1791 "parser.yy"
    {
		Music *m = MY_MAKE_MUSIC ("MarkEvent");
		(yyval.music) = m;
	;}
    break;

  case 201:
#line 1795 "parser.yy"
    {
		(yyval.music) = (yyvsp[0].music);
	;}
    break;

  case 202:
#line 1798 "parser.yy"
    {
		Music *key = MY_MAKE_MUSIC ("KeyChangeEvent");
		(yyval.music) = key;
	;}
    break;

  case 203:
#line 1802 "parser.yy"
    {

		Music *key = MY_MAKE_MUSIC ("KeyChangeEvent");
		if (scm_ilength ((yyvsp[0].scm)) > 0)
		{		
			key->set_property ("pitch-alist", (yyvsp[0].scm));
			key->set_property ("tonic", Pitch (0, 0, 0).smobbed_copy ());
			key->transpose (* unsmob_pitch ((yyvsp[-1].scm)));
		} else {
			THIS->parser_error ((yylsp[0]), _ ("second argument must be pitch list"));
		}

		(yyval.music) = key;
	;}
    break;

  case 204:
#line 1820 "parser.yy"
    {
		(yyval.scm) = SCM_EOL;
	;}
    break;

  case 205:
#line 1823 "parser.yy"
    {
		(yyvsp[0].music)->set_spot ((yylsp[0]));
		(yyval.scm) = scm_cons ((yyvsp[0].music)->self_scm (), (yyval.scm));
		(yyvsp[0].music)->unprotect ();
	;}
    break;

  case 206:
#line 1828 "parser.yy"
    {
		(yyvsp[0].music) -> set_spot ((yylsp[0]));
		(yyval.scm) = scm_cons ((yyvsp[0].music)->self_scm (), (yyval.scm));
		(yyvsp[0].music)->unprotect ();
	;}
    break;

  case 207:
#line 1837 "parser.yy"
    {
		tag_music ((yyvsp[0].music), (yyvsp[-1].scm), (yyloc));
		(yyval.music) = (yyvsp[0].music);
	;}
    break;

  case 208:
#line 1845 "parser.yy"
    {
		(yyval.music) = (yyvsp[0].music);
	;}
    break;

  case 209:
#line 1848 "parser.yy"
    {
		if (!THIS->lexer_->is_lyric_state ())
			THIS->parser_error ((yylsp[0]), _ ("have to be in Lyric mode for lyrics"));
		(yyval.music) = MY_MAKE_MUSIC ("HyphenEvent");
	;}
    break;

  case 210:
#line 1853 "parser.yy"
    {
		if (!THIS->lexer_->is_lyric_state ())
			THIS->parser_error ((yylsp[0]), _ ("have to be in Lyric mode for lyrics"));
		(yyval.music) = MY_MAKE_MUSIC ("ExtenderEvent");
	;}
    break;

  case 211:
#line 1858 "parser.yy"
    {
		if ((yyvsp[-1].i))
			(yyvsp[0].music)->set_property ("direction", scm_from_int ((yyvsp[-1].i)));
		(yyval.music) = (yyvsp[0].music);
	;}
    break;

  case 212:
#line 1863 "parser.yy"
    {
		if ((yyvsp[-1].i))
			(yyvsp[0].music)->set_property ("direction", scm_from_int ((yyvsp[-1].i)));
		(yyval.music) = (yyvsp[0].music);
	;}
    break;

  case 214:
#line 1872 "parser.yy"
    {
		Music *s = MY_MAKE_MUSIC ("StringNumberEvent");
		s->set_property ("string-number", scm_from_int ((yyvsp[0].i)));
		s->set_spot ((yyloc));
		(yyval.music) = s;
	;}
    break;

  case 215:
#line 1881 "parser.yy"
    {
		(yyval.scm) = ly_symbol2scm ("bracketOpenSymbol");
	;}
    break;

  case 216:
#line 1884 "parser.yy"
    {
		(yyval.scm) = ly_symbol2scm ("bracketCloseSymbol"); 
	;}
    break;

  case 217:
#line 1887 "parser.yy"
    {
		(yyval.scm) = ly_symbol2scm ("tildeSymbol");
	;}
    break;

  case 218:
#line 1890 "parser.yy"
    {
		(yyval.scm) = ly_symbol2scm ("parenthesisOpenSymbol");
	;}
    break;

  case 219:
#line 1893 "parser.yy"
    {
		(yyval.scm) = ly_symbol2scm ("parenthesisCloseSymbol");
	;}
    break;

  case 220:
#line 1896 "parser.yy"
    {
		(yyval.scm) = ly_symbol2scm ("escapedExclamationSymbol");
	;}
    break;

  case 221:
#line 1899 "parser.yy"
    {
		(yyval.scm) = ly_symbol2scm ("escapedParenthesisOpenSymbol");
	;}
    break;

  case 222:
#line 1902 "parser.yy"
    {
		(yyval.scm) = ly_symbol2scm ("escapedParenthesisCloseSymbol");
	;}
    break;

  case 223:
#line 1905 "parser.yy"
    {
		(yyval.scm) = ly_symbol2scm ("escapedBiggerSymbol");
	;}
    break;

  case 224:
#line 1908 "parser.yy"
    {
		(yyval.scm) = ly_symbol2scm ("escapedSmallerSymbol");
	;}
    break;

  case 225:
#line 1914 "parser.yy"
    {
		SCM predefd = THIS->lexer_->lookup_identifier_symbol ((yyvsp[0].scm));
		Music * m = 0;
		if (unsmob_music (predefd))
		{
			m = unsmob_music (predefd)->clone ();
		}
		else
		{
			m = MY_MAKE_MUSIC ("Music");
		}
		m->set_spot ((yyloc));
		(yyval.music) = m;		
	;}
    break;

  case 226:
#line 1928 "parser.yy"
    {
		(yyval.music) = unsmob_music ((yyvsp[0].scm));
	;}
    break;

  case 227:
#line 1931 "parser.yy"
    {
               Music *a = MY_MAKE_MUSIC ("TremoloEvent");
               a->set_spot ((yyloc));
               a->set_property ("tremolo-type", scm_from_int ((yyvsp[0].i)));
               (yyval.music) = a;
        ;}
    break;

  case 228:
#line 1940 "parser.yy"
    {
		(yyval.music) = (yyvsp[0].music);
	;}
    break;

  case 229:
#line 1943 "parser.yy"
    {
		SCM s = THIS->lexer_->lookup_identifier ("dash" + ly_scm2string ((yyvsp[0].scm)));
		Music *a = MY_MAKE_MUSIC ("ArticulationEvent");
		if (scm_is_string (s))
			a->set_property ("articulation-type", s);
		else THIS->parser_error ((yylsp[0]), _ ("expecting string as script definition"));
		(yyval.music) = a;
	;}
    break;

  case 230:
#line 1954 "parser.yy"
    { (yyval.scm) = SCM_EOL; ;}
    break;

  case 231:
#line 1955 "parser.yy"
    { (yyval.scm) = scm_from_int (0); ;}
    break;

  case 232:
#line 1956 "parser.yy"
    { (yyval.scm) = scm_from_int ((yyvsp[0].i)); ;}
    break;

  case 233:
#line 1957 "parser.yy"
    { (yyval.scm) = scm_from_int ((yyvsp[0].i)); ;}
    break;

  case 234:
#line 1961 "parser.yy"
    {
		(yyval.i) = 1;
	;}
    break;

  case 235:
#line 1964 "parser.yy"
    {
		(yyval.i) ++;
	;}
    break;

  case 236:
#line 1970 "parser.yy"
    {
		(yyval.i) = 1;
	;}
    break;

  case 237:
#line 1973 "parser.yy"
    {
		(yyval.i)++;
	;}
    break;

  case 238:
#line 1979 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 239:
#line 1982 "parser.yy"
    {
		Pitch p = *unsmob_pitch ((yyvsp[-1].scm));
		p = p.transposed (Pitch ((yyvsp[0].i),0,0));
		(yyval.scm) = p.smobbed_copy ();
	;}
    break;

  case 240:
#line 1987 "parser.yy"
    {
		Pitch p =* unsmob_pitch ((yyvsp[-1].scm));
		p = p.transposed (Pitch (-(yyvsp[0].i),0,0));
		(yyval.scm) = p.smobbed_copy ();
	;}
    break;

  case 241:
#line 1999 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 242:
#line 2002 "parser.yy"
    {
		Pitch p = *unsmob_pitch ((yyvsp[-1].scm));
		p = p.transposed (Pitch ((yyvsp[0].i),0,0));
		(yyval.scm) = p.smobbed_copy ();
	;}
    break;

  case 243:
#line 2007 "parser.yy"
    {
		Pitch p =* unsmob_pitch ((yyvsp[-1].scm));

		p = p.transposed (Pitch (-(yyvsp[0].i),0,0));
		(yyval.scm) = p.smobbed_copy ();
	;}
    break;

  case 244:
#line 2016 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 247:
#line 2027 "parser.yy"
    {
		Music *t = MY_MAKE_MUSIC ("TextScriptEvent");
		t->set_property ("text", (yyvsp[0].scm));
		t->set_spot ((yyloc));
		(yyval.music) = t;	
	;}
    break;

  case 248:
#line 2033 "parser.yy"
    {
		Music *t = MY_MAKE_MUSIC ("TextScriptEvent");
		t->set_property ("text",
			make_simple_markup ((yyvsp[0].scm)));
		t->set_spot ((yyloc));
		(yyval.music) = t;
	
	;}
    break;

  case 249:
#line 2041 "parser.yy"
    {
		Music *t = MY_MAKE_MUSIC ("FingerEvent");
		t->set_property ("digit", scm_from_int ((yyvsp[0].i)));
		t->set_spot ((yyloc));
		(yyval.music) = t;
	;}
    break;

  case 250:
#line 2050 "parser.yy"
    {
		(yyval.scm) = scm_makfrom0str ("Hat");
	;}
    break;

  case 251:
#line 2053 "parser.yy"
    {
		(yyval.scm) = scm_makfrom0str ("Plus");
	;}
    break;

  case 252:
#line 2056 "parser.yy"
    {
		(yyval.scm) = scm_makfrom0str ("Dash");
	;}
    break;

  case 253:
#line 2059 "parser.yy"
    {
		(yyval.scm) = scm_makfrom0str ("Bar");
	;}
    break;

  case 254:
#line 2062 "parser.yy"
    {
		(yyval.scm) = scm_makfrom0str ("Larger");
	;}
    break;

  case 255:
#line 2065 "parser.yy"
    {
		(yyval.scm) = scm_makfrom0str ("Dot");
	;}
    break;

  case 256:
#line 2068 "parser.yy"
    {
		(yyval.scm) = scm_makfrom0str ("Underscore");
	;}
    break;

  case 257:
#line 2074 "parser.yy"
    { (yyval.i) = DOWN; ;}
    break;

  case 258:
#line 2075 "parser.yy"
    { (yyval.i) = UP; ;}
    break;

  case 259:
#line 2076 "parser.yy"
    { (yyval.i) = CENTER; ;}
    break;

  case 260:
#line 2081 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 261:
#line 2087 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 262:
#line 2093 "parser.yy"
    {
		Duration dd = THIS->default_duration_;
		(yyval.scm) = dd.smobbed_copy ();
	;}
    break;

  case 263:
#line 2097 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
		THIS->default_duration_ = *unsmob_duration ((yyval.scm));
	;}
    break;

  case 264:
#line 2104 "parser.yy"
    {
		int len = 0;
		if (!is_duration ((yyvsp[-1].i)))
			THIS->parser_error ((yylsp[-1]), _f ("not a duration: %d", (yyvsp[-1].i)));
		else
			len = intlog2 ((yyvsp[-1].i));

		(yyval.scm) = Duration (len, (yyvsp[0].i)).smobbed_copy ();
	;}
    break;

  case 265:
#line 2113 "parser.yy"
    {
		Duration *d = unsmob_duration ((yyvsp[-1].scm));
		Duration k (d->duration_log (), d->dot_count () + (yyvsp[0].i));
		*d = k;
		(yyval.scm) = (yyvsp[-1].scm);
	;}
    break;

  case 266:
#line 2122 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 267:
#line 2125 "parser.yy"
    {
		(yyval.scm) = unsmob_duration ((yyval.scm))->compressed ( (yyvsp[0].i)) .smobbed_copy ();
	;}
    break;

  case 268:
#line 2128 "parser.yy"
    {
		Rational  m (scm_to_int (scm_car ((yyvsp[0].scm))), scm_to_int (scm_cdr ((yyvsp[0].scm))));

		(yyval.scm) = unsmob_duration ((yyval.scm))->compressed (m).smobbed_copy ();
	;}
    break;

  case 269:
#line 2136 "parser.yy"
    { (yyval.scm) = (yyvsp[0].scm); ;}
    break;

  case 270:
#line 2137 "parser.yy"
    {
		(yyval.scm) = scm_cons (scm_from_int ((yyvsp[-2].i)), scm_from_int ((yyvsp[0].i)));
	;}
    break;

  case 271:
#line 2143 "parser.yy"
    {
		(yyval.i) = 0;
	;}
    break;

  case 272:
#line 2146 "parser.yy"
    {
		(yyval.i) ++;
	;}
    break;

  case 273:
#line 2152 "parser.yy"
    {
		(yyval.i) = 0;
	;}
    break;

  case 274:
#line 2155 "parser.yy"
    {
		if (!is_duration ((yyvsp[0].i)))
			THIS->parser_error ((yylsp[0]), _f ("not a duration: %d", (yyvsp[0].i)));
		(yyval.i) = (yyvsp[0].i);
	;}
    break;

  case 275:
#line 2163 "parser.yy"
    {
		(yyval.scm) = scm_number_to_string (scm_from_int ((yyvsp[0].i)), scm_from_int (10));
		(yyval.scm) = scm_list_2 (ly_lily_module_constant ("number-markup"),
				(yyval.scm));
	;}
    break;

  case 276:
#line 2168 "parser.yy"
    {
		(yyval.scm) = scm_number_to_string (scm_from_int ((yyvsp[0].i)), scm_from_int (10));
		(yyval.scm) = scm_list_2 (ly_lily_module_constant ("number-markup"),
				(yyval.scm));
	;}
    break;

  case 277:
#line 2173 "parser.yy"
    { (yyval.scm) = (yyvsp[0].scm); ;}
    break;

  case 278:
#line 2174 "parser.yy"
    { (yyval.scm) = (yyvsp[0].scm); ;}
    break;

  case 279:
#line 2178 "parser.yy"
    { (yyval.i) = -2; ;}
    break;

  case 280:
#line 2179 "parser.yy"
    { (yyval.i) = 2; ;}
    break;

  case 281:
#line 2180 "parser.yy"
    { (yyval.i) = 0; ;}
    break;

  case 282:
#line 2184 "parser.yy"
    {
		Music *bfr = MY_MAKE_MUSIC ("BassFigureEvent");
		(yyval.scm) = bfr->self_scm ();
		bfr->unprotect ();
	;}
    break;

  case 283:
#line 2189 "parser.yy"
    {
		Music *bfr = MY_MAKE_MUSIC ("BassFigureEvent");
		(yyval.scm) = bfr->self_scm ();

		bfr->set_property ("figure", (yyvsp[0].scm));
		bfr->unprotect ();
	;}
    break;

  case 284:
#line 2196 "parser.yy"
    {
		Music *m = unsmob_music ((yyvsp[-1].scm));
		if ((yyvsp[0].i)) {
			SCM salter = m->get_property ("alteration");
			int alter = scm_is_number (salter) ? scm_to_int (salter) : 0;
			m->set_property ("alteration",
				scm_from_int (alter + (yyvsp[0].i)));
		} else {
			m->set_property ("alteration", scm_from_int (0));
		}
	;}
    break;

  case 285:
#line 2210 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
		unsmob_music ((yyval.scm))->set_property ("bracket-start", SCM_BOOL_T);
	;}
    break;

  case 286:
#line 2214 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 287:
#line 2217 "parser.yy"
    {
		(yyval.scm) = (yyvsp[-1].scm);
		unsmob_music ((yyvsp[-1].scm))->set_property ("bracket-stop", SCM_BOOL_T);
	;}
    break;

  case 288:
#line 2224 "parser.yy"
    {
		(yyval.scm) = SCM_EOL;
	;}
    break;

  case 289:
#line 2227 "parser.yy"
    {
		(yyval.scm) = scm_cons ((yyvsp[0].scm), (yyvsp[-1].scm));
	;}
    break;

  case 290:
#line 2233 "parser.yy"
    {
		Music *m = MY_MAKE_MUSIC ("EventChord");
		(yyvsp[-1].scm) = scm_reverse_x ((yyvsp[-1].scm), SCM_EOL);
		m->set_property ("elements", (yyvsp[-1].scm));
		(yyval.scm) = m->self_scm ();
	;}
    break;

  case 291:
#line 2243 "parser.yy"
    { (yyval.i) = 0; ;}
    break;

  case 292:
#line 2244 "parser.yy"
    { (yyval.i) = 1; ;}
    break;

  case 293:
#line 2248 "parser.yy"
    {
		if (!THIS->lexer_->is_note_state ())
			THIS->parser_error ((yylsp[-5]), _ ("have to be in Note mode for notes"));

		Music *n = 0;
		if ((yyvsp[0].i))
			n = MY_MAKE_MUSIC ("RestEvent");
		else
			n = MY_MAKE_MUSIC ("NoteEvent");
		
		n->set_property ("pitch", (yyvsp[-5].scm));
		n->set_property ("duration", (yyvsp[-1].scm));

		if (scm_is_number ((yyvsp[-2].scm)))
		{
			int q = scm_to_int ((yyvsp[-2].scm));
			n->set_property ("absolute-octave", scm_from_int (q-1));
		}

		if ((yyvsp[-3].i) % 2)
			n->set_property ("cautionary", SCM_BOOL_T);
		if ((yyvsp[-4].i) % 2 || (yyvsp[-3].i) % 2)
			n->set_property ("force-accidental", SCM_BOOL_T);

		Music *v = MY_MAKE_MUSIC ("EventChord");
		v->set_property ("elements", scm_list_1 (n->self_scm ()));
		n->unprotect ();

		v->set_spot ((yyloc));
		n->set_spot ((yyloc));
		(yyval.music) = v;
	;}
    break;

  case 294:
#line 2280 "parser.yy"
    {
		Music *n = MY_MAKE_MUSIC ("NoteEvent");
		n->set_property ("duration", (yyvsp[0].scm));
		n->set_property ("drum-type", (yyvsp[-1].scm));

		Music *v = MY_MAKE_MUSIC ("EventChord");
		v->set_property ("elements", scm_list_1 (n->self_scm ()));
		n->unprotect ();
		v->set_spot ((yyloc));
		n->set_spot ((yyloc));
		(yyval.music) = v;
		
	;}
    break;

  case 295:
#line 2293 "parser.yy"
    {
		Music *m = unsmob_music ((yyvsp[-1].scm));
		m->set_spot ((yyloc));
		for (SCM s = m->get_property ("elements"); scm_is_pair (s); s = scm_cdr (s))
		{
			unsmob_music (scm_car (s))->set_property ("duration", (yyvsp[0].scm));
		}
		(yyval.music) = m;
	;}
    break;

  case 296:
#line 2302 "parser.yy"
    {
		Music *ev = 0;
 		if (ly_scm2string ((yyvsp[-1].scm)) == "s") {
			/* Space */
			ev = MY_MAKE_MUSIC ("SkipEvent");
		  }
		else {
			ev = MY_MAKE_MUSIC ("RestEvent");
		
		    }
		ev->set_property ("duration", (yyvsp[0].scm));
		ev->set_spot ((yyloc));
 		Music *velt = MY_MAKE_MUSIC ("EventChord");
		velt->set_property ("elements", scm_list_1 (ev->self_scm ()));
		velt->set_spot ((yyloc));

		ev->unprotect();

 		(yyval.music) = velt;
	;}
    break;

  case 297:
#line 2322 "parser.yy"
    {
		SCM proc = ly_lily_module_constant ("make-multi-measure-rest");
		SCM mus = scm_call_2 (proc, (yyvsp[0].scm), make_input ((yyloc)));
		(yyval.music) = unsmob_music (mus);
		(yyval.music)->protect ();
	;}
    break;

  case 298:
#line 2329 "parser.yy"
    {
		if (!THIS->lexer_->is_lyric_state ())
			THIS->parser_error ((yylsp[-1]), _ ("have to be in Lyric mode for lyrics"));

		Music *levent = MY_MAKE_MUSIC ("LyricEvent");
		levent->set_property ("text", (yyvsp[-1].scm));
		levent->set_property ("duration",(yyvsp[0].scm));
		levent->set_spot ((yyloc));
		Music *velt = MY_MAKE_MUSIC ("EventChord");
		velt->set_property ("elements", scm_list_1 (levent->self_scm ()));

		(yyval.music)= velt;
	;}
    break;

  case 299:
#line 2342 "parser.yy"
    {
                if (!THIS->lexer_->is_chord_state ())
                        THIS->parser_error ((yylsp[0]), _ ("have to be in Chord mode for chords"));
                (yyval.music) = unsmob_music ((yyvsp[0].scm));
	;}
    break;

  case 300:
#line 2350 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 301:
#line 2353 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 302:
#line 2359 "parser.yy"
    {
		(yyval.scm) = make_chord ((yyvsp[-1].scm), (yyvsp[0].scm), SCM_EOL);
	;}
    break;

  case 303:
#line 2362 "parser.yy"
    {
		SCM its = scm_reverse_x ((yyvsp[0].scm), SCM_EOL);
		(yyval.scm) = make_chord ((yyvsp[-3].scm), (yyvsp[-2].scm), scm_cons ((yyvsp[-1].scm), its));
	;}
    break;

  case 304:
#line 2369 "parser.yy"
    {
		(yyval.scm) = SCM_EOL;		
	;}
    break;

  case 305:
#line 2372 "parser.yy"
    {
		(yyval.scm) = scm_cons ((yyvsp[0].scm), (yyval.scm));
	;}
    break;

  case 306:
#line 2378 "parser.yy"
    {
		(yyval.scm) = ly_symbol2scm ("chord-colon");
	;}
    break;

  case 307:
#line 2381 "parser.yy"
    {
		(yyval.scm) = ly_symbol2scm ("chord-caret");
	;}
    break;

  case 308:
#line 2384 "parser.yy"
    {
 		(yyval.scm) = scm_list_2 (ly_symbol2scm ("chord-slash"), (yyvsp[0].scm));
	;}
    break;

  case 309:
#line 2387 "parser.yy"
    {
		(yyval.scm) = scm_list_2 (ly_symbol2scm ("chord-bass"), (yyvsp[0].scm));
	;}
    break;

  case 310:
#line 2393 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 311:
#line 2396 "parser.yy"
    {
		(yyval.scm) = scm_reverse_x ((yyvsp[0].scm), SCM_EOL);
	;}
    break;

  case 312:
#line 2399 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 313:
#line 2405 "parser.yy"
    { (yyval.scm) = scm_cons ((yyvsp[0].scm), SCM_EOL); ;}
    break;

  case 314:
#line 2406 "parser.yy"
    {
		(yyval.scm) = scm_cons ((yyvsp[0].scm), (yyval.scm));
	;}
    break;

  case 315:
#line 2412 "parser.yy"
    {
		(yyval.scm) = make_chord_step ((yyvsp[0].i), 0);
        ;}
    break;

  case 316:
#line 2415 "parser.yy"
    {
		(yyval.scm) = make_chord_step ((yyvsp[-1].i), SHARP);
	;}
    break;

  case 317:
#line 2418 "parser.yy"
    {
		(yyval.scm) = make_chord_step ((yyvsp[-1].i), FLAT);
	;}
    break;

  case 318:
#line 2430 "parser.yy"
    {
		(yyval.scm) = scm_sum ((yyvsp[-2].scm), (yyvsp[0].scm));
	;}
    break;

  case 319:
#line 2433 "parser.yy"
    {
		(yyval.scm) = scm_difference ((yyvsp[-2].scm), (yyvsp[0].scm));
	;}
    break;

  case 321:
#line 2440 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 322:
#line 2443 "parser.yy"
    {
		(yyval.scm) = scm_product ((yyvsp[-2].scm), (yyvsp[0].scm));
	;}
    break;

  case 323:
#line 2446 "parser.yy"
    {
		(yyval.scm) = scm_divide ((yyvsp[-2].scm), (yyvsp[0].scm));
	;}
    break;

  case 324:
#line 2452 "parser.yy"
    { /* %prec UNARY_MINUS */
		(yyval.scm) = scm_difference ((yyvsp[0].scm), SCM_UNDEFINED);
	;}
    break;

  case 326:
#line 2460 "parser.yy"
    {
		(yyval.scm) = scm_from_int ((yyvsp[0].i));
	;}
    break;

  case 327:
#line 2463 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 328:
#line 2466 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 329:
#line 2469 "parser.yy"
    {
		(yyval.scm) = scm_from_double (scm_to_double ((yyvsp[-1].scm)) *scm_to_double ((yyvsp[0].scm)));
	;}
    break;

  case 330:
#line 2472 "parser.yy"
    {
		(yyval.scm) = scm_from_double ((yyvsp[-1].i) *scm_to_double ((yyvsp[0].scm)));
	;}
    break;

  case 331:
#line 2479 "parser.yy"
    {
			(yyval.i) = (yyvsp[0].i);
	;}
    break;

  case 332:
#line 2482 "parser.yy"
    {
		(yyval.i) = (yyvsp[0].i);
	;}
    break;

  case 333:
#line 2488 "parser.yy"
    { (yyval.i) = 0; ;}
    break;

  case 334:
#line 2489 "parser.yy"
    { (yyval.i) ++; ;}
    break;

  case 335:
#line 2493 "parser.yy"
    { (yyval.i) = 0; ;}
    break;

  case 336:
#line 2494 "parser.yy"
    { (yyval.i) ++; ;}
    break;

  case 337:
#line 2502 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 338:
#line 2506 "parser.yy"
    { THIS->lexer_->push_markup_state (); ;}
    break;

  case 339:
#line 2507 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
		THIS->lexer_->pop_state ();
	;}
    break;

  case 340:
#line 2514 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 341:
#line 2518 "parser.yy"
    { THIS->lexer_->push_markup_state (); ;}
    break;

  case 342:
#line 2519 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
		THIS->lexer_->pop_state ();
	;}
    break;

  case 343:
#line 2526 "parser.yy"
    { 
		(yyval.scm) = scm_list_2 (ly_lily_module_constant ("line-markup"),  (yyvsp[0].scm)); 
	;}
    break;

  case 344:
#line 2529 "parser.yy"
    {
		(yyval.scm) = scm_car (scm_call_2 (ly_lily_module_constant ("map-markup-command-list"), (yyvsp[-1].scm), scm_list_1 ((yyvsp[0].scm))));
	;}
    break;

  case 345:
#line 2532 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 346:
#line 2538 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 347:
#line 2541 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 348:
#line 2547 "parser.yy"
    {
		(yyval.scm) = scm_call_2 (ly_lily_module_constant ("map-markup-command-list"), (yyvsp[-1].scm), (yyvsp[0].scm));
		
	;}
    break;

  case 349:
#line 2554 "parser.yy"
    {
		(yyval.scm) = scm_reverse_x ((yyvsp[-1].scm), SCM_EOL);
	;}
    break;

  case 350:
#line 2560 "parser.yy"
    {  (yyval.scm) = SCM_EOL; ;}
    break;

  case 351:
#line 2561 "parser.yy"
    {
		(yyval.scm) = scm_cons ((yyvsp[0].scm), (yyvsp[-1].scm));
	;}
    break;

  case 352:
#line 2564 "parser.yy"
    {
		(yyval.scm) = scm_append_x (scm_list_2 (scm_reverse_x ((yyvsp[0].scm), SCM_EOL), (yyvsp[-1].scm)));
	;}
    break;

  case 353:
#line 2570 "parser.yy"
    {
		(yyval.scm) = scm_list_1 ((yyvsp[0].scm));
	;}
    break;

  case 354:
#line 2573 "parser.yy"
    {
		(yyval.scm) = scm_list_2 ((yyvsp[-1].scm), (yyvsp[0].scm));
	;}
    break;

  case 355:
#line 2576 "parser.yy"
    {
		(yyval.scm) = scm_list_3 ((yyvsp[-2].scm), (yyvsp[-1].scm), (yyvsp[0].scm));
	;}
    break;

  case 356:
#line 2582 "parser.yy"
    {
		(yyval.scm) = scm_list_1 ((yyvsp[0].scm));
	;}
    break;

  case 357:
#line 2585 "parser.yy"
    {
		(yyval.scm) = scm_cons ((yyvsp[0].scm), (yyvsp[-1].scm));
	;}
    break;

  case 358:
#line 2591 "parser.yy"
    {
		(yyval.scm) = make_simple_markup ((yyvsp[0].scm));
	;}
    break;

  case 359:
#line 2594 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 360:
#line 2597 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 361:
#line 2600 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 362:
#line 2603 "parser.yy"
    {
		SCM nn = THIS->lexer_->lookup_identifier ("pitchnames");
		THIS->lexer_->push_note_state (alist_to_hashq (nn));
	;}
    break;

  case 363:
#line 2606 "parser.yy"
    {
		Score * sc = (yyvsp[-1].score);
		(yyval.scm) = scm_list_2 (ly_lily_module_constant ("score-markup"), sc->self_scm ());
		sc->unprotect ();
		THIS->lexer_->pop_state ();
	;}
    break;

  case 364:
#line 2612 "parser.yy"
    {
		(yyval.scm) = scm_list_2 ((yyvsp[-1].scm), (yyvsp[0].scm));
	;}
    break;

  case 365:
#line 2615 "parser.yy"
    {
		(yyval.scm) = scm_list_4 ((yyvsp[-3].scm), (yyvsp[-2].scm), (yyvsp[-1].scm), (yyvsp[0].scm));
	;}
    break;

  case 366:
#line 2618 "parser.yy"
    {
		(yyval.scm) = scm_list_3 ((yyvsp[-2].scm), (yyvsp[-1].scm), (yyvsp[0].scm));
	;}
    break;

  case 367:
#line 2621 "parser.yy"
    {
		(yyval.scm) = scm_list_1 ((yyvsp[0].scm));
	;}
    break;

  case 368:
#line 2624 "parser.yy"
    {
		(yyval.scm) = scm_list_2 ((yyvsp[-1].scm),(yyvsp[0].scm));
	;}
    break;

  case 369:
#line 2627 "parser.yy"
    {
		(yyval.scm) = scm_list_3 ((yyvsp[-2].scm), (yyvsp[-1].scm), (yyvsp[0].scm));
	;}
    break;

  case 370:
#line 2633 "parser.yy"
    {
		SCM mapper = ly_lily_module_constant ("map-markup-command-list");
		(yyval.scm) = scm_car (scm_call_2 (mapper, (yyvsp[-1].scm), scm_list_1 ((yyvsp[0].scm))));
	;}
    break;

  case 371:
#line 2637 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;


      default: break;
    }

/* Line 1052 of yacc.c.  */
#line 5509 "out/parser.cc"

  yyvsp -= yylen;
  yyssp -= yylen;
  yylsp -= yylen;

  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;
  *++yylsp = yyloc;

  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (YYPACT_NINF < yyn && yyn < YYLAST)
	{
	  int yytype = YYTRANSLATE (yychar);
	  YYSIZE_T yysize0 = yystrlen (yytname[yytype]);
	  YYSIZE_T yysize = yysize0;
	  YYSIZE_T yysize1;
	  int yysize_overflow = 0;
	  char *yymsg = 0;
#	  define YYERROR_VERBOSE_ARGS_MAXIMUM 5
	  char const *yyarg[YYERROR_VERBOSE_ARGS_MAXIMUM];
	  int yyx;

#if 0
	  /* This is so xgettext sees the translatable formats that are
	     constructed on the fly.  */
	  _("syntax error, unexpected %s");
	  _("syntax error, unexpected %s, expecting %s");
	  _("syntax error, unexpected %s, expecting %s or %s");
	  _("syntax error, unexpected %s, expecting %s or %s or %s");
	  _("syntax error, unexpected %s, expecting %s or %s or %s or %s");
#endif
	  char *yyfmt;
	  char const *yyf;
	  static char const yyunexpected[] = "syntax error, unexpected %s";
	  static char const yyexpecting[] = ", expecting %s";
	  static char const yyor[] = " or %s";
	  char yyformat[sizeof yyunexpected
			+ sizeof yyexpecting - 1
			+ ((YYERROR_VERBOSE_ARGS_MAXIMUM - 2)
			   * (sizeof yyor - 1))];
	  char const *yyprefix = yyexpecting;

	  /* Start YYX at -YYN if negative to avoid negative indexes in
	     YYCHECK.  */
	  int yyxbegin = yyn < 0 ? -yyn : 0;

	  /* Stay within bounds of both yycheck and yytname.  */
	  int yychecklim = YYLAST - yyn;
	  int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
	  int yycount = 1;

	  yyarg[0] = yytname[yytype];
	  yyfmt = yystpcpy (yyformat, yyunexpected);

	  for (yyx = yyxbegin; yyx < yyxend; ++yyx)
	    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
	      {
		if (yycount == YYERROR_VERBOSE_ARGS_MAXIMUM)
		  {
		    yycount = 1;
		    yysize = yysize0;
		    yyformat[sizeof yyunexpected - 1] = '\0';
		    break;
		  }
		yyarg[yycount++] = yytname[yyx];
		yysize1 = yysize + yystrlen (yytname[yyx]);
		yysize_overflow |= yysize1 < yysize;
		yysize = yysize1;
		yyfmt = yystpcpy (yyfmt, yyprefix);
		yyprefix = yyor;
	      }

	  yyf = _(yyformat);
	  yysize1 = yysize + strlen (yyf);
	  yysize_overflow |= yysize1 < yysize;
	  yysize = yysize1;

	  if (!yysize_overflow && yysize <= YYSTACK_ALLOC_MAXIMUM)
	    yymsg = (char *) YYSTACK_ALLOC (yysize);
	  if (yymsg)
	    {
	      /* Avoid sprintf, as that infringes on the user's name space.
		 Don't have undefined behavior even if the translation
		 produced a string with the wrong number of "%s"s.  */
	      char *yyp = yymsg;
	      int yyi = 0;
	      while ((*yyp = *yyf))
		{
		  if (*yyp == '%' && yyf[1] == 's' && yyi < yycount)
		    {
		      yyp = yystpcpy (yyp, yyarg[yyi++]);
		      yyf += 2;
		    }
		  else
		    {
		      yyp++;
		      yyf++;
		    }
		}
	      yyerror (yymsg);
	      YYSTACK_FREE (yymsg);
	    }
	  else
	    yyerror (_("syntax error; also memory exhausted"));
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror (_("syntax error"));
    }

  yyerror_range[0] = yylloc;

  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse look-ahead token after an
	 error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* If at end of input, pop the error token,
	     then the rest of the stack, then return failure.  */
	  if (yychar == YYEOF)
	     for (;;)
	       {
                 yyerror_range[0] = *yylsp;
		 YYPOPSTACK;
		 if (yyssp == yyss)
		   YYABORT;
		 yydestruct (_("Error: popping"),
                             yystos[*yyssp], yyvsp, yylsp);
	       }
        }
      else
	{
	  yydestruct (_("Error: discarding"), yytoken, &yylval, &yylloc);
	  yychar = YYEMPTY;
	}
    }

  /* Else will try to reuse look-ahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:

  /* Pacify compilers like GCC when the user code never invokes
     YYERROR and the label yyerrorlab therefore never appears in user
     code.  */
  if (0)
     goto yyerrorlab;

  yyerror_range[0] = yylsp[1-yylen];
  yylsp -= yylen;
  yyvsp -= yylen;
  yyssp -= yylen;
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (yyn != YYPACT_NINF)
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;

      yyerror_range[0] = *yylsp;
      yydestruct (_("Error: popping"), yystos[yystate], yyvsp, yylsp);
      YYPOPSTACK;
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  *++yyvsp = yylval;

  yyerror_range[1] = yylloc;
  /* Using YYLLOC is tempting, but would change the location of
     the look-ahead.  YYLOC is available though. */
  YYLLOC_DEFAULT (yyloc, yyerror_range - 1, 2);
  *++yylsp = yyloc;

  /* Shift the error token. */
  YY_SYMBOL_PRINT (_("Shifting"), yystos[yyn], yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yydestruct (_("Error: discarding lookahead"),
              yytoken, &yylval, &yylloc);
  yychar = YYEMPTY;
  yyresult = 1;
  goto yyreturn;

#ifndef yyoverflow
/*----------------------------------------------.
| yyoverflowlab -- parser overflow comes here.  |
`----------------------------------------------*/
yyoverflowlab:
  yyerror (_("parser stack overflow"));
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  return yyresult;
}


#line 2642 "parser.yy"


void
Lily_parser::set_yydebug (bool )
{
#if 0
	yydebug = 1;
#endif
}

void
Lily_parser::do_yyparse ()
{
	yyparse ((void*)this);
}





/*

It is a little strange to have this function in this file, but
otherwise, we have to import music classes into the lexer.

*/
int
Lily_lexer::try_special_identifiers (SCM *destination, SCM sid)
{
	if (scm_is_string (sid)) {
		*destination = sid;
		return STRING_IDENTIFIER;
	} else if (scm_is_number (sid)) {
		*destination = sid;
		return NUMBER_IDENTIFIER;
	} else if (unsmob_context_def (sid)) {
		*destination = unsmob_context_def (sid)->clone_scm ();
		return CONTEXT_DEF_IDENTIFIER;
	} else if (unsmob_score (sid)) {
		Score *score = new Score (*unsmob_score (sid));
		*destination = score->self_scm ();
		return SCORE_IDENTIFIER;
	} else if (Music *mus = unsmob_music (sid)) {
		mus = mus->clone ();
		*destination = mus->self_scm ();
		unsmob_music (*destination)->
			set_property ("origin", make_input (last_input_));

		bool is_event = scm_memq (ly_symbol2scm ("event"), mus->get_property ("types"))
			!= SCM_BOOL_F;

		return is_event ? EVENT_IDENTIFIER : MUSIC_IDENTIFIER;
	} else if (unsmob_duration (sid)) {
		*destination = unsmob_duration (sid)->smobbed_copy ();
		return DURATION_IDENTIFIER;
	} else if (unsmob_output_def (sid)) {
		Output_def *p = unsmob_output_def (sid);
		p = p->clone ();

		*destination = p->self_scm ();
		return OUTPUT_DEF_IDENTIFIER;
	} else if (Text_interface::is_markup (sid)) {
		*destination = sid;
		if (is_lyric_state ())
			return LYRIC_MARKUP_IDENTIFIER;
		return MARKUP_IDENTIFIER;
	}

	return -1;	
}

Music *
property_op_to_music (SCM op)
{
	Music *m = 0;
	SCM tag = scm_car (op);
	SCM symbol = scm_cadr (op);
	SCM args = scm_cddr (op);
	SCM grob_val = SCM_UNDEFINED;
	SCM grob_sym = SCM_UNDEFINED;
	SCM val = SCM_UNDEFINED;
	
	if (tag == ly_symbol2scm ("assign"))
		{
		m = MY_MAKE_MUSIC ("PropertySet");
		val = scm_car (args);
		}
	else if (tag == ly_symbol2scm ("unset"))
		m = MY_MAKE_MUSIC ("PropertyUnset");
	else if (tag == ly_symbol2scm ("poppush")
		 || tag == ly_symbol2scm ("push"))
		{
		m = MY_MAKE_MUSIC ("OverrideProperty");
		grob_sym = scm_car (args);
		grob_val = scm_cadr (args);
		}
	else if (tag == ly_symbol2scm ("pop")) {
		m = MY_MAKE_MUSIC ("RevertProperty");
		grob_sym = scm_car (args);
		}

	m->set_property ("symbol", symbol);

	if (val != SCM_UNDEFINED)
		m->set_property ("value", val);
	if (grob_val != SCM_UNDEFINED)
		m->set_property ("grob-value", grob_val);

	if (grob_sym != SCM_UNDEFINED)
		{
		bool itc = do_internal_type_checking_global;
		/* UGH.
		*/
		bool autobeam = ly_is_equal (symbol, ly_symbol2scm ("autoBeamSettings"));
		if (autobeam)
			do_internal_type_checking_global = false;
		m->set_property ("grob-property", grob_sym);
		if (autobeam)
			do_internal_type_checking_global = itc;
		}

	if (tag == ly_symbol2scm ("poppush"))
		m->set_property ("pop-first", SCM_BOOL_T);


	return m;
}

Music*
context_spec_music (SCM type, SCM id, Music *m, SCM ops)
{
	Music *csm = MY_MAKE_MUSIC ("ContextSpeccedMusic");

	csm->set_property ("element", m->self_scm ());
	m->unprotect ();

	csm->set_property ("context-type",
		scm_is_symbol (type) ? type : scm_string_to_symbol (type));
	csm->set_property ("property-operations", ops);

	if (scm_is_string (id))
		csm->set_property ("context-id", id);
	return csm;
}

SCM
get_next_unique_context_id ()
{
	return scm_makfrom0str ("$uniqueContextId");
}


SCM
get_next_unique_lyrics_context_id ()
{
	static int new_context_count;
	char s[128];
	snprintf (s, 1024, "uniqueContext%d", new_context_count++);
	return scm_makfrom0str (s);
}


