# -*-rpm-spec-mode-*-

%define info yes
%define docdir %{_docdir}/lilypond/

Name: lilypond
Version: 2.5.8
Release: 1
License: GPL
Group: Applications/Publishing
Source0: ftp.lilypond.org:/pub/LilyPond/development/lilypond-2.5.8.tar.gz
Summary: Create and print music notation 
URL: http://www.lilypond.org/
BuildRoot: %{_tmppath}/%{name}-%{version}-root


Buildrequires: t1utils bison flex mftrace ImageMagick
Buildrequires: texinfo >= 4.7
Buildrequires: guile-devel >= 1.6.4-8 
Buildrequires: freetype-devel >= 2.1
#Buildrequires: fontforge >= 20041211

Requires: tetex  tetex-latex libstdc++ python  tetex-dvips tetex-latex
Requires: guile >= 1.6.4-8 ec-fonts-mftraced >= 1.0.5

%description
LilyPond lets you create music notation.  It produces
beautiful sheet music from  a high-level description file.

%package documentation
Summary:  All LilyPond documentation, in HTML
Group: Applications/Publishing
# BuildArchitectures: noarch

%description documentation
Documentation and example files of LilyPond. An index is available at
%{docdir}/web/Documentation/out-www/index.html

%prep
%setup

%build

# DO NOT use % { configure } , it hardcodes all paths, runs libtool,
# so we can't do make prefixix=/tmp/ install.

# In fact, do not take out the spaces between % and { in the above comment,
# because RPM will gladly do a substitution anyway.

./configure --disable-checking --prefix=%{_prefix} --enable-optimising


make all
make web
make -C Documentation/user local_package_docdir=%{docdir} omf

%install


rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/tmp/lilypond-rpm-doc

make prefix="$RPM_BUILD_ROOT%{_prefix}" \
	infodir="$RPM_BUILD_ROOT%{_infodir}"  \
	mandir="$RPM_BUILD_ROOT%{_mandir}" install

#emacs
mkdir -p $RPM_BUILD_ROOT%{_datadir}/emacs/site-lisp/site-start.d
install -m 644 elisp/lilypond-init.el  $RPM_BUILD_ROOT%{_datadir}/emacs/site-lisp/site-start.d

#manual pages
gzip -9fn $RPM_BUILD_ROOT%{_mandir}/man1/*


# profile scripts.
mkdir -p $RPM_BUILD_ROOT/etc/profile.d
cp buildscripts/out/lilypond-profile $RPM_BUILD_ROOT/etc/profile.d/lilypond.sh
cp buildscripts/out/lilypond-login $RPM_BUILD_ROOT/etc/profile.d/lilypond.csh

# web doc
make prefix="$RPM_BUILD_ROOT%{_prefix}" \
  infodir="$RPM_BUILD_ROOT%{_infodir}"  \
  webdir="$RPM_BUILD_ROOT%{_prefix}/share/doc/lilypond/" web-install

ln -sf ../../doc/lilypond/Documentation/user/out-www/*png $RPM_BUILD_ROOT%{_infodir}/lilypond/

# info 
%if %{info}
rm -f $RPM_BUILD_ROOT/%{_infodir}/dir
gzip -9fn `find $RPM_BUILD_ROOT%{_infodir}/ -name '*.info'`
%endif



%post

touch /tmp/.lilypond-install
rm `find /var/lib/texmf -name 'feta*pk' -or -name 'feta*tfm' -or -name 'parmesan*pk' -or -name 'parmesan*tfm' -print` /tmp/.lilypond-install

%if %{info}
/sbin/install-info %{_infodir}/lilypond/lilypond.info.gz %{_infodir}/dir 
/sbin/install-info %{_infodir}/lilypond/music-glossary.info.gz %{_infodir}/dir 
%endif

export PACKAGEDIR=%{_datadir}/lilypond/2.5.8
if [ -d /usr/share/vim ]; then
  VIMDIR=`find /usr/share/vim -name bugreport.vim`
  VIMDIR=`dirname $VIMDIR`
  for a in `cd $PACKAGEDIR/vim/ ; find -type d -name '*' ` ; do
     mkdir -p  $VIMDIR/$a
     ln -s $PACKAGEDIR/vim/$a/*.vim $VIMDIR/$a/
  done
fi


# chkfontpath --add=%{_datadir}/lilypond/2.5.8/fonts/type1/

echo 'Logout first before using LilyPond.'

%preun
if [ -f /usr/share/lilypond/%{version}/ls-R ]; then
  rm -f /usr/share/lilypond/%{version}/ls-R
fi


if [ -d /usr/share/vim ]; then
	rm `find /usr/share/vim -name 'lilypond*.vim'`
fi


%if %{info}
    /sbin/install-info --delete %{_infodir}/lilypond/lilypond.info.gz %{_infodir}/dir 
    /sbin/install-info --delete %{_infodir}/lilypond/music-glossary.info.gz %{_infodir}/dir 
%endif

# chkfontpath --remove=%{_datadir}/share/lilypond/2.5.8/fonts/type1n/

%postun

%post documentation
scrollkeeper-update

%postun documentation
scrollkeeper-update



%files
%defattr(-, root, root)
%{_datadir}/emacs/site-lisp/lilypond*
%{_datadir}/emacs/site-lisp/site-start.d/lilypond*

%{_bindir}/abc2ly
%{_bindir}/convert-ly
%{_bindir}/etf2ly
%{_bindir}/lilypond
%{_bindir}/lilypond-latex
%{_bindir}/midi2ly
%{_bindir}/lilypond-book
%{_bindir}/mup2ly
%{_bindir}/ps2png

%doc THANKS
%doc COPYING
%doc DEDICATION
%doc README.txt
%doc AUTHORS.txt
%doc INSTALL.txt
%doc NEWS.txt

%if %{info}
%{_infodir}/lilypond/
%endif

%{_mandir}/man1/abc2ly.1.gz
%{_mandir}/man1/convert-ly.1.gz
%{_mandir}/man1/etf2ly.1.gz
%{_mandir}/man1/lilypond-latex.1.gz
%{_mandir}/man1/lilypond.1.gz
%{_mandir}/man1/midi2ly.1.gz
%{_mandir}/man1/lilypond-book.1.gz
%{_mandir}/man1/mup2ly.1.gz
%{_mandir}/man1/ps2png.1.gz

%{_datadir}/lilypond/2.5.8/
%{_datadir}/locale/*/LC_MESSAGES/lilypond.mo

%{_libdir}/lilypond/

/etc/profile.d/lilypond.*


%files documentation

%defattr(-, root, root)

%{docdir}
%{_datadir}/omf/lilypond/2.5.8


