%% Do not edit this file; it is automatically
%% generated from LSR http://lsr.dsi.unimi.it
%% This file is in the public domain.
\version "2.13.4"

\header {
  lsrtags = "text, tweaks-and-overrides"

  texidoc = "
For technical reasons, text scripts attached to note heads cannot
easily be centered on a note head's width, unlike articulations.

Instead of using trial-and-error offset tweaks, this snippet accesses a
note head (or rest) from the @code{TextScript} object's horizontal
parent (a paper column), using its extent to correct the positioning.



"
  doctitle = "Centering markup on note heads automatically"
} % begin verbatim

textScriptCenterOnNote = \override TextScript #'X-offset =
#(lambda (grob)
   (let* ((paper-col (ly:grob-parent grob X))
          (elts (ly:grob-object paper-col 'elements))
          (rhythmic-head
           (if (ly:grob-array? elts)
               (let loop ((array-idx 0))
                 (call/cc
                  (lambda (return)
                    (let ((array-len (ly:grob-array-length elts)))
                      (if (< array-idx (1- array-len))
                          (let ((elt (ly:grob-array-ref elts array-idx)))
                            (if (grob::has-interface elt
                                                     'rhythmic-head-interface)
                                (return elt)
                                (loop (1+ array-idx)))))
                      grob))))
               grob)))

     (+
      (ly:self-alignment-interface::x-aligned-on-self grob)
      (interval-center
       (ly:grob-robust-relative-extent rhythmic-head rhythmic-head X)))))

\relative c' {
  \override TextScript #'self-alignment-X = #CENTER
  \textScriptCenterOnNote
  <c e g c>1-\markup \arrow-head #Y #UP ##t
  <c e g c>1-\markup \huge "^"
}

