%%  Do not edit this file; it is auto-generated from LSR!
\version "2.10.12"

\header { texidoc = "
In \"simple\" lead-sheets, sometimes no actual notes are written,
instead only \"rhythmic patterns\" and chords above the measures are
noted giving the structure of a song.  Such a feature is for example
useful while creating/transcribing the structure of a song and also
when sharing lead sheets with guitarists or jazz musicians.

The standard support for this is described in section \"Measure
repeats\", but  then the first beat has to be an ordinary note or rest. 

This example shows two solutions to this problem, by redefining
ordinary rests to be printed as slashes. (If the duration of each beat
is not a quarter note, replace the r4 in the definitions by a rest of
the appropriate duration).
" }

% Macro to print single slash
rs = {
\once \override Rest #'stencil = #ly:percent-repeat-item-interface::beat-slash
\once \override Rest #'thickness = #'0.48
\once \override Rest #'slope = #'1.7
r4
}


% Function to print a specified number of slashes
comp = #(define-music-function (parser location count) ( integer?)
#{
\override Rest #'stencil = #ly:percent-repeat-item-interface::beat-slash
\override Rest #'thickness = #'0.48
\override Rest #'slope = #'1.7
\repeat unfold $count { r4 }
\revert Rest #'stencil
#})

\score{
\relative c'{
 c d e f | \rs \rs \rs \rs | \comp #4 |
}
}
