%%  Do not edit this file; it is auto-generated from LSR!
\version "2.11.23"

\header { texidoc = "
In music that contains many occurrences of the same sequence of notes
at different pitches, you can use the following music function. It
takes a note, of which the pitch is used. The supporting Scheme
functions were borrowed from the Tips and Tricks document in the manual.

This example creates the rhythm used throughout Mars, from The Planets,
by Gustav Holst.
" }

#(define (make-note-req p d)
  (make-music 'NoteEvent
   'duration d
   'pitch p))

#(define (make-note p d)
  (make-music 'EventChord
   'elements (list (make-note-req p d))))

#(define (seq-music-list elts)
  (make-music 'SequentialMusic
   'elements elts))

#(define (make-triplet elt)
  (make-music 'TimeScaledMusic
   'denominator 3
   'numerator 2
   'element elt))


rhythm = #(define-music-function (parser location note) (ly:music?)
          "Make the rhythm in Mars (the Planets) at the given note's pitch"
          (let* ((p (ly:music-property
                      (car (ly:music-property note 'elements))
                      'pitch)))
          (seq-music-list (list
            (make-triplet (seq-music-list (list
              (make-note p (ly:make-duration 3 0 2 3))
              (make-note p (ly:make-duration 3 0 2 3))
              (make-note p (ly:make-duration 3 0 2 3))
            )))
            (make-note p (ly:make-duration 2 0))
            (make-note p (ly:make-duration 2 0))
            (make-note p (ly:make-duration 3 0))
            (make-note p (ly:make-duration 3 0))
            (make-note p (ly:make-duration 2 0))
          ))))

\score {
   \new Staff {
       \time 5/4

       \rhythm c'
       \rhythm c''
       \rhythm g
   }
}

