#(ly:set-option 'old-relative)

% #(ly:set-point-and-click 'line-column)

instrument = "Piano"

\header {
  title = "Stndchen"
  subtitle = "(Serenade)"
  subsubtitle = "Leise flehen meine Lieder"
  opus = "D. 957 No. 4"
  date = "August 1828"
  composer = "Franz Schubert (1797-1828)"
  poet = "Text by Ludwig Rellstab (1799-1860)"
  enteredby = "JCN"
  copyright = "public domain"
  % instrument = \instrument

  % mutopia headers.
  mutopiatitle = "Standchen"
  mutopiasubtitle = "Leise flehen meine Lieder"
  mutopiacomposer = "Franz Schubert (1797-1828)"
  mutopiapoet = "Ludwig Rellstab (1799-1860)"
  mutopiaopus = "D957.4"
  mutopiainstrument = \instrument
  date = "1828/08"
  style = "Romantic"
  source = "Schubert-Lieder Edition Schott No. 608, (Not dated).
    Jubilaeums-Ausgabe zum 100. Todestage (~1928)."

  copyright = "Public Domain"
  maintainer = "Jan Nieuwenhuizen"
  maintainerEmail = "janneke@gnu.org"
  lastupdated =	 "2001/Apr/27"
  mutopiapublicdomain = "\\parbox[b]{\\hsize}{\\thefooter\\quad\\small
    \\\\This music is part of the Mutopia project,
    \\texttt{http://www.mutopiaproject.org/}\\\\It has been typeset
    and placed in the public domain by " + \maintainer +
    ".\\\\Unrestricted modification and redistribution is permitted
    and encouraged---copy this music and share it.}"
 tagline = \mutopiapublicdomain
 footer = "Mutopia-2001/04/27-xx"
} 

\version "1.9.4"

dynamicUp = \property Voice.DynamicLineSpanner \override #'direction = #1
dynamicRevert = \property Voice.DynamicLineSpanner \revert #'direction

\include "paper16.ly"

vocalVerse =  \notes\relative c''{
	\dynamicUp
	\times 2/3 {  g8[(  as)] g } c4. g8 |
	\times 2/3 {  f8[(  g)] f } c'4 f,8 r |
	g4.-> f8 \times 2/3 {  f[(  es)] d } |
	es2 r4 |
	R2. |
	R2. |
	\times 2/3 {  g8[(  as)] g } es'4. g,8 |
	\times 2/3 {  f8[(  g)] f } d'4. c8 |
	bes4. as8 \times 2/3 {  as[(  g)] f } |
	g2 r4 |
	R2. |
	R2. |
	g8. b16 es4. d8 |
	c8. g16 es4. c8 |
	\grace {
  \property Voice.Stem \override #'stroke-style = #"grace"
    as'32[( bes ] 
  \property Voice.Stem \revert #'stroke-style }
 \times 2/3 {  as8[)(  g)] as } c4. as8 |
	g2. |
	\grace {
  \property Voice.Stem \override #'stroke-style = #"grace"
    f32[( g ] 
  \property Voice.Stem \revert #'stroke-style }
 \times 2/3 {  f8[)(  e)] f } as4. f8 |
  
	es!2. |
	g8. b16 es4. d8 |
	c8. g16 e4. c8 |
 	\grace {
  \property Voice.Stem \override #'stroke-style = #"grace"
    a'32[( b ] 
  \property Voice.Stem \revert #'stroke-style }
 \times 2/3 {  a!8[)(  gis)] a } c4. a8 |
	g!2. |
	\times 2/3 {  d'8[\f(  cis)] d } f4. b,8 |
	c!2. |
}

vocalThrough =  \notes\relative c{
	\dynamicUp
	g''8. g16 b8. b16 d8. d16 |
	c4 b r |
	g4. b8 d8. c16 |
	b2 r4 |
	e4. d8 \times 2/3 {  d[(  c)] b } |
	a8. b16 c4-> a8 r |
	R2. |
	R2. |
	\grace {
  \property Voice.Stem \override #'stroke-style = #"grace"
    a32[( b ] 
  \property Voice.Stem \revert #'stroke-style }
 \times 2/3 {  a!8[)(  gis)] a } c4. a8 |
	g!2. |
	\times 2/3 {  d'8[\f(  cis)] d } f4. b,8 |
	c!2. ~ |
	% bug: slur on other staff fools lily into extending melisma
	c4 r c |
	as2. |
	g |
	e2 r4 |
}

lyricVerseOne =  \lyrics{
	Lei -- se fle -- hen mei -- ne Lie -- der
	durch die Nacht zu dir;
	in den stil -- len Hain her nie -- der,
	Lieb -- chen, komm zu mir! 
	
	Fl\"us -- ternd schlan -- ke Wip -- fel rau -- schen
	in des Mon -- des Licht,
	in des Mon -- des Licht;

	des Ver -- r\"a -- ters feind -- lich Lau -- schen
	f\"urch -- te, Hol -- de, nicht,
	f\"urch -- te, Hol -- de, nicht.
}
	
lyricVerseTwo =  \lyrics{
	H\"orst die Nach -- ti -- gal -- len schla -- gen?
	ach! sie fle -- hen dich, 
	mit der T\"o -- ne s\"u -- "\ss en" Kla -- gen
	fle -- hen sie f\"ur mich. 
	
	Sie -- ver -- "steh'n" des Bu -- sens Seh -- nen,
	ken -- nen Lieb -- es -- schmerz,
	ken -- nen Lieb -- es -- schmerz,

	r\"uh -- ren mit den Sil -- ber -- t\"o -- nen
	jed -- es wei -- che Herz,
	jed -- es wei -- che Herz.
}

lyricThrough =  \lyrics{
	La\ss auch dir die Brust be -- we -- gen 
	Lieb -- chen, h\"o -- re mich! 
	be -- bend harr' ich dir ent -- ge -- gen! 
	
	komm, be -- gl\"uk -- ke mich!
	komm, be -- gl\"uk -- ke mich, __ 
	be -- gl\"uk -- ke mich!
}

trebleIntro =  \notes\relative c{
	r8^"\bf M\\\"a\\ss ig"\pp <g' c>-. <c es>-. <g c>-. <c es>-. <g c>-. |
	r8 <as c>-. <c es>-. <as c>-. <c es>-. <as c>-. |
	r8 <as c>-. <c d>-. <as c>-. <c d>-. <as c>-. |
	r8 <g b>-. <b d>-. <g b>-. <b d>-. <g b>-. |
}

trebleVerseOne =  \notes\relative c{
	%5
	r8 <g' c> <c es> <g c> <c es> <g c> |
	r8 <f c'> <c' d> <f, c'> <c' d> <f, c'> |
	r8 <f g b> <g b d> <f g b> <g b d> <f g b> |
	r8 <es g c> <g c es> <es g c> <g c es> <es g c> |
	<g'' b,>4.( <f d>8)
	\times 2/3 { <f d>([ <es c> <d b>)] }

	%10
	<c es>2. |
	r8 <g, c> <c es> <g c> <c es> <g c> |
	r8 <f c'> <c' d> <f, c'> <c' d> <f, c'> |
	r8 <f as bes> <as bes d> <f as bes> <as bes d> <f as bes> |
	r8
	<es g bes>[
	<g bes es>
	<es g bes>
	<g bes es>]
	<es' c'>(
	<d bes'>4.()
	<f as>8)
	
	\times 2/3 { <f as>([ <es g> <d f>)] }
	%16
	<es g>2. |
	r8 <f, g> <g b> <f g> <g b> <f g> |
	r8 <es g> <g c> <es g> <g c> <es g> |
	r8\pp <es as c> <as c es> <es as c> <as c es> <es as c> |
	%20
	r8 <es g bes> <g bes es> <es g bes> <g bes es> <es g bes> |
	\property Voice.Slur \override #'attachment = #'(stem . stem)
	\grace {
  \property Voice.Stem \override #'stroke-style = #"grace"
    as'32[( bes ] 
  \property Voice.Stem \revert #'stroke-style }

	\times 2/3 {  as8[)( g as] } c4.->  as8) |
	\property Voice.Slur \revert #'attachment
	g2. |
	r8 <f, g> <g b> <f g> <g b> <f g> |
	r8 <e g> <g c> <e g> <g c> <e g> |
	r8 <f a c> <a c f> <f a c> <a c f> <f a c> |
	r8 <e g c> <g c e> <e g c> <g c e> <e g c> |
	\times 2/3  { <f' f'>\f( <e e'> <f f'> }
	<a a'>4.-> <f f'>8)  |
}

trebleEentje =  \notes \relative c' \context Voice {
	\stemBoth
	<e e'>2 r4 |
	<f as!>2\(\mf <as c>8.(-> <f as>16)\) |
	% urg: slurs with staccati are ugly
	<e g>4. <e g>8-.( <e g>-. <e g>)-. |
	<f g>4. <b, g'>8-.( <d g>-. <f g>)-. |
	<e g>2 <e g>4\pp |
	<f a>2\( <a c>8.( <f a>16)\) |
	<e g>4.\( <e g>8(-. <e g>-. <e g>)\)-. |
	<f g>4. <b, g'>8(-. <d g>-. <f g>)-. |
	%60
	<e g>2 r4 |
}

trebleThrough =  \notes \relative c'{
	\stemBoth
	<e e'>2. |
	%61
	R2. |
	<g, g'>8.[\< <g g'>16 <b b'>8. <b b'>16\>\! <d d'>8. <d d'>16] |

	%% score has double slur on chord.
	<c c'>4( <b c'>) r\!

	<g g'>4. <b b'>8 <d' d, >8.->[ c16] |
	%65
        <d, e b'>2.~(\f
	<c e a>2)  r4
	<< 
	{ 	a'8. b16 c4^> ( a8) r |
		a8. b16 c4^> ( a8) r |
	}\\{ 
		<d, f>4 <d f>2 |
		<c! es>4 <c es>2 |
	} >>

	% 4 bars copied from end verse1
	r8 <f, a c> <a c f> <f a c> <a c f> <f a c> |
	%70
	r8 <e g c> <g c e> <e g c> <g c e> <e g c> |
	\times 2/3 {  <f' f'>8( <e e'> <f f'> }

	<a a'>4.-> <f f'>8)
	<e e'>2. |
	<es! es'! >2. |
	\property Voice . TextScript \override #'font-shape = #'italic
	<d d'>2._"decresc."
	\property Voice . TextScript \revert #'font-shape

	%75
	<b b'>2. |
	<c c'>2 <e g>4\pp |

	% four copied from begin eentje
	<f as!>2( <as c>8.-> <f as>16) |
	<e g>4. <e g>8(-. <e g>-. <e g>)-. |
	<f g>4. <b, g'>8(-. <d g>-. <f g>)-. |
	%80

	\property Voice . TextScript \override #'font-shape = #'italic
	<e g>2._"dim."
	\property Voice . TextScript \revert #'font-shape

	<g, e' g>2. |
	<g e' g>2.\fermata |
}

bassIntro =  \notes\relative c{
	\dynamicUp
%1
	<c, c'>2 r4 |
	<as as'>2 r4 |
	<f f'>2 r4 |
	<g g'>2 r4 |
}

bassVerseOne =  \notes\relative c{
%	\clef bass
	\dynamicUp
%5
	<c, c'>2 r4 |
	<as as'>2 r4 |
	<g g'>2 r4 |
	<c c'>2 r4 |
	<g g'>8 <g'' d'>[ <d' f> <g, d'> <d' f> <g, d'>] |
%10
	<c,, c'>8 <g'' c>[ <c es> <g c> <c es> <g c>] |
	<c,, c'>2 r4 |
	<as as'>2 r4 |
	<bes bes'>2 r4 |
	<es, es'>2 r4 |
%15
	bes'8 <bes' f'>[ <f' as> <bes, f'> <f' as> <bes, f'>] |
	es,8 <bes' es>[ <es g> <bes es> <es g> <bes es>] |
	<g, g'>2 r4 |
	<c c'>2 r4 |
	<as as'>2 r4 |
	<es es'>2 r4 |
	<bes' bes'>8 <f'' bes>[ <bes d> <f bes> <bes d> <f bes>] |
	<es,, es'>8 <es'' g bes>[ <g bes es> <es g bes> <g bes es> <es g bes>] |
	<g,, g'>2 r4 |
	<c c'>2 r4 |
	<f, f'>2 r4 |
	<c' c'>2 r4 |
	<g g'>8 <d'' g>[ <g b> <d g> <g b> <d g>] |
	c,8 <c' e g>[ <e g c> <c e g> <e g c> <c e g>] |
}

bassEentje =  \notes\relative c{
	\dynamicUp
	<c, c'>8 <c' f as!>[ <f as c> <c f as> <f as c> <c f as>] |
	c,8 <c' e g>[ <e g c> <c e g> <e g c> <c e g>] |
	<g, g'>8 <d'' g>[ <g b> <d g> <g b> <d g>] |
	c,8 <e' g>[ <g c> <e g> <g c> <e g>] |
	<c, c'>8 <c' f a>[ <f a c> <c f a> <f a c> <c f a>] |
	c,8 <c' e g>[ <e g c> <c e g> <e g c> <c e g>] |
	<g, g'>8 <d'' g>[ <g b> <d g> <g b> <d g>] |
	c,8 <e' g>[ <g c> <e g> <g c> <e g>] |
}

bassThrough =  \notes\relative c{
	\dynamicUp
	%61
	<g, g'>8^"cresc." <g' b d>[ <b d f> <g b d> <as! b d >-> <b d f>] |
	<g, g'>8 <g' d'>[ <d' f> <g, d'> <as b d >-> <b d f>] |
	% copied
	<g, g'>8 <g' d'>[ <d' f> <g, d'> <as b d >-> <b d f>] |
	<g, g'>8 <g' d'>[ <d' f> <g, d'> <gis b d >-> <b d f>] |
	%65
	<gis, gis'>8 <d'' e>[\> <e b'> <d e> <e b'> <d e> \!] |
	<a, a'>8 <c' e>[ <e a> <c e> <e a> <c e>] |
	<a, a'>8 <a' d f>[ <d f a> <a d f> <d f a> <a d f>] |
	<a, a'>8 <a' c e>[ <c e a> <a c e> <c e a> <a c e>] |
	% 4 bars copied from end verse1
	<f, f'>2\p r4 |
	%70
	<c' c'>2 r4 |
	<g g'>8 <d'' g>[ <g b> <d g> <g b> <d g>] |
	c,8\> <c' e g>[ < e g c> \! <c e g> <e g c> <c e g>] |

	<c, c'>8 <c' es! g>[ <es g c> <c es g> <es g c> <c es g>] |
	<f,, f'>8 <d'' f>[ <f as!> <d f> <f as> <d f>] |
	%75
	<g,, g'>8 <d'' f>[ <f g> <d f> <f g> <d f>] |
	c,8 <c' e>[ <e g> <c e> <e g> <c e>] |
	c,8 <c' f>[ <f as> <c f> <f as> <c f>] |
	c,8 <c' e>[ <e g> <c e> <e g> <c e>] |
	g,8 <g' d'>[ <d' f> <g, d'> <d' f> <g, d'>] |
	%80
	c,8 <c' e>[ <e g> <c e> <e g> <c e>] |
	c,8 <c' g>[ <e c> <c g> <e c> <c g>] |
	<c, g' c>2._\fermata |
}
		
global =  \notes{
	\time 3/4 
	\key es \major
	\skip 1 * 3/4 * 4
	\break
	\skip 1 * 3/4 * 25
	\break
	\skip 1 * 3/4 * 6
	\break
	\skip 1 * 3/4 * 41
	\break
	\skip 1 * 3/4 * 6
	\bar "|."
}

allLyrics = \lyrics {
	% maybe should be bigger by default, in grob-description.scm ?
	\property Lyrics . LyricText \override #'font-relative-size = #1
	\property Lyrics . LyricHyphen \override #'maximum-length = #1.5
	\context LyricsVoice = "leise-1"  { \lyricVerseOne
	\lyricVerseTwo
	\lyricThrough
} }

lyricStaff = \context Lyrics {
	\allLyrics
}
		
vocals = \context Voice \notes {
	\clef treble
 	% certainly no auto-beaming for vocals
 	\property Voice.autoBeaming = ##f
	\property Staff.automaticMelismata= ##t

	\dynamicUp
	% duh 1 != 3/4
	R1 * 3/4 * 4
	\vocalVerse 
	R1 * 3/4 * 8
	\vocalVerse
	\vocalThrough
	R1 * 3/4 * 6
}

vocalStaff =  \context Staff = vocal<<
	  \property Staff.midiInstrument = "synth voice"
	\context Voice = "leise" << 	  \global
	  \vocals >>
>>

treble =  {
	\clef treble
	\property Voice.autoBeamSettings \override #'(begin * * * *) = #(ly:make-moment 0 1)
	\trebleIntro 
	\trebleVerseOne 
	\trebleEentje
	\trebleVerseOne 
	\trebleThrough
}

trebleStaff =  \context Staff = treble<< 
        \property Staff.midiInstrument = "acoustic grand"
	\global
	\treble
>>
bass =  {
	\clef bass
	\bassIntro 
	\bassVerseOne 
	\bassEentje
	\bassVerseOne 
	\bassThrough
}

bassStaff =  \context Staff = bass<<
        \property Staff.midiInstrument = "acoustic grand"
	\global
	\bass
>>

grandStaff =  \context PianoStaff <<

	\trebleStaff
	\bassStaff
>>


\score{
	<<

%{
	Transpose as you like for your voice
	Range untransposed is c' to f'' (for tenors and sopranos)
	\transpose c' a gives a' to d'' (for basses, who sing an octave down)

		\addlyrics 
			\notes \transpose c' a \vocalStaff
			\lyricStaff
		\notes \transpose c' a \grandStaff
%}

		\addlyrics
			\vocalStaff
			\lyricStaff 
		\grandStaff
	>>
	\paper {
		% Use
		%   textheight = 280.\mm
		%   linewidth = 190.\mm
		% to get this on 3 pages of a4.
		
		% Mandatory Mutopia settings yield 4 pages :(
		textheight = 270.0\mm
		linewidth = 180.0\mm

		\translator { \RemoveEmptyStaffContext }
	}
	\midi{
		\tempo 4 = 54
	}
}

