# -*-rpm-spec-mode-*-

%define info yes
%define docdir %{_docdir}/lilypond/

Name: lilypond
Version: 1.9.10
Release: 1
License: GPL
Group: Applications/Publishing
Source0: ftp.lilypond.org:/pub/LilyPond/development/lilypond-1.9.10.tar.gz
Summary: Create and print music notation 
URL: http://www.lilypond.org/
BuildRoot: %{_tmppath}/%{name}-%{version}-root


Buildrequires: t1utils bison flex mftrace ImageMagick
Buildrequires: texinfo >= 4.6
Buildrequires: guile-devel >= 1.6.4-8
Requires: tetex  tetex-latex libstdc++ python  tetex-dvips tetex-latex
Requires: guile >= 1.6.4-8

%description
LilyPond lets you create music notation.  It produces
beautiful sheet music from  a high-level description file.

%package documentation
Summary:  All LilyPond documentation, in HTML
Group: Applications/Publishing
# BuildArchitectures: noarch

%description documentation
Documentation and example files of LilyPond. An index is available at
%{docdir}/web/Documentation/out-www/index.html

%prep
%setup

%build

# DO NOT use % { configure } , it hardcodes all paths, runs libtool,
# so we can't do make prefixix=/tmp/ install.

# In fact, do not take out the spaces between % and { in the above comment,
# because RPM will gladly do a substitution anyway.

./configure --disable-checking --prefix=%{_prefix} --enable-optimising


make MAKE_PFA_FILES=1 all
make -C mf/ pfa

# make info
make -C Documentation

# make  html
make web
make -C Documentation/user omf

%install


rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/tmp/lilypond-rpm-doc

make prefix="$RPM_BUILD_ROOT%{_prefix}" infodir="$RPM_BUILD_ROOT%{_infodir}" MAKE_PFA_FILES=1 mandir="$RPM_BUILD_ROOT%{_mandir}" install

%if %{info}
rm -f $RPM_BUILD_ROOT/%{_infodir}/dir
gzip -9fn $RPM_BUILD_ROOT%{_infodir}/*
%endif

mkdir -p $RPM_BUILD_ROOT%{_datadir}/emacs/site-lisp/site-start.d
install -m 644 elisp/lilypond-init.el $RPM_BUILD_ROOT/%{_datadir}/emacs/site-lisp/site-start.d

gzip -9fn $RPM_BUILD_ROOT%{_mandir}/man1/*

mkdir -p $RPM_BUILD_ROOT/etc/profile.d
cp buildscripts/out/lilypond-profile $RPM_BUILD_ROOT/etc/profile.d/lilypond.sh
cp buildscripts/out/lilypond-login $RPM_BUILD_ROOT/etc/profile.d/lilypond.csh

make prefix="$RPM_BUILD_ROOT%{_prefix}" webdir="$RPM_BUILD_ROOT%{_prefix}/share/doc/lilypond/" out=www web-install


%post

touch /tmp/.lilypond-install
rm `find /var/lib/texmf -name 'feta*pk' -or -name 'feta*tfm' -or -name 'parmesan*pk' -or -name 'parmesan*tfm' -print` /tmp/.lilypond-install

%if %{info}
/sbin/install-info %{_infodir}/lilypond.info.gz %{_infodir}/dir 
%endif

# chkfontpath --add=%{_datadir}/lilypond/1.9.10/fonts/type1/

echo 'Please logout first before using LilyPond.'

%preun


%if %{info}
if [ $1 = 0 ]; then
    /sbin/install-info --delete %{_infodir}/lilypond.info.gz %{_infodir}/dir 
fi
%endif

# chkfontpath --remove=%{_datadir}/share/lilypond/1.9.10/fonts/type1/


%post documentation
scrollkeeper-update

%postun documentation
scrollkeeper-update



%files
%defattr(-, root, root)
%{_datadir}/emacs/site-lisp/lilypond*
%{_datadir}/emacs/site-lisp/site-start.d/lilypond-*

%{_bindir}/abc2ly
%{_bindir}/as2text
%{_bindir}/convert-ly
%{_bindir}/etf2ly
%{_bindir}/lilypond
%{_bindir}/lilypond-bin
%{_bindir}/midi2ly
%{_bindir}/lilypond-book
%{_bindir}/mup2ly
%{_bindir}/musedata2ly
%{_bindir}/pmx2ly

%doc THANKS
%doc COPYING
%doc DEDICATION
%doc README.txt
%doc AUTHORS.txt
%doc INSTALL.txt
%doc NEWS.txt

%if %{info}
%{_infodir}/*
%endif

%{_mandir}/man1/abc2ly.1.gz
%{_mandir}/man1/as2text.1.gz
%{_mandir}/man1/convert-ly.1.gz
%{_mandir}/man1/etf2ly.1.gz
%{_mandir}/man1/lilypond-bin.1.gz
%{_mandir}/man1/lilypond.1.gz
%{_mandir}/man1/midi2ly.1.gz
%{_mandir}/man1/lilypond-book.1.gz
%{_mandir}/man1/musedata2ly.1.gz
%{_mandir}/man1/mup2ly.1.gz
%{_mandir}/man1/pmx2ly.1.gz

%{_datadir}/lilypond/1.9.10/
%{_datadir}/locale/*/LC_MESSAGES/lilypond.mo

%{_libdir}/lilypond/

/etc/profile.d/lilypond.*


%files documentation

%defattr(-, root, root)

%{docdir}
%{_datadir}/omf/lilypond/1.9.10


