# Does info really work?
%define info yes

%define name lilypond
%define version 1.6.9
%define release 1mdk

Summary:	A program for printing sheet music.
Name:		%{name}
Version:	%{version}
Release:	%{release}
License:	GPL
Group:		Publishing
URL:		http://www.lilypond.org/
Source0:	ftp.cs.uu.nl:/pub/GNU/LilyPond/development/lilypond-%{version}.tar.gz
## Patch0: lilypond-GNUmakefile.in.patch.bz2
Source1:	%name-16x16.png.tar.bz2
Source2:	%name-32x32.png.tar.bz2
Source3:	%name-48x48.png.tar.bz2
BuildRoot:	%{_tmppath}/%{name}-buildroot
BuildRequires:	guile guile-devel
Requires:	tetex

%description
LilyPond is a music typesetter.  It produces beautiful sheet music using a
high level description file as input.  Lilypond is part of the GNU project.
 
LilyPond is split into two packages.  The package "lilypond" provides the
core package, containing the utilities for converting the music source
(.ly) files into printable output.  The package "lilypond-extras" provides
the full documentation, example .ly files for various features and the
Mutopia project files (musical equivalent of the Gutenberg project - see
http://www.mutopiaproject.org for details).
 
If you are new to lilypond, you will almost certainly want to install the
"lilypond-extras" package in addition to the "lilypond" package.
 
## You may also wish to investigate the "denemo" package, which provides a
## graphical front end to lilypond.
## 
## See the file README.first for more information.

%package documentation
Summary: LilyPond documentation, examples and Mutopia files.
Group: Publishing
Requires: lilypond

%description documentation
The documentation of LilyPond, both in HTML and PostScript, along with
example input files and the files from the Mutopia project.

%prep
rm -rf $RPM_BUILD_ROOT

%setup -a 1
## % patch0 -b .orig

%build
# DO NOT use % { configure } , it hardcodes all paths, runs libtool,
# so we can't do make prefix=/tmp/ install.
# -- not sure what this comment means; it's a relic from the PPC spec file -- mbrown@fensystems.co.uk
##./configure --disable-checking --disable-debugging --enable-printing --prefix=%{_prefix} --disable-optimising --enable-shared
## Add options if needed
./configure --disable-checking --prefix=%{_prefix} --enable-optimising
make MAKE_PFA_FILES=1 all

# make info
make -C Documentation

# make  html
make web-doc top-web 

%install

# Create installation root folders
rm -rf $RPM_BUILD_ROOT
RPM_DOC_ROOT=$RPM_BUILD_ROOT%{_docdir}/%{name}-%{version}
rm -rf $RPM_DOC_ROOT
mkdir -p $RPM_DOC_ROOT

strip lily/out/lilypond 
make prefix="$RPM_BUILD_ROOT%{_prefix}" MAKE_PFA_FILES=1 all install
# %{find_lang} %{name}

%if info=="yes"
gzip -9fn $RPM_BUILD_ROOT%{_prefix}/info/*
%endif

# Move info and man files into correct locations
# mv $RPM_BUILD_ROOT/usr/info $RPM_BUILD_ROOT%{_infodir}
# mv $RPM_BUILD_ROOT/usr/man $RPM_BUILD_ROOT%{_mandir}

mkdir -p $RPM_BUILD_ROOT/usr/share/emacs/site-lisp/site-start.d
install -m 644 lilypond-mode.el lilypond-font-lock.el lilypond-indent.el $RPM_BUILD_ROOT/usr/share/emacs/site-lisp/
install -m 644 lilypond-init.el $RPM_BUILD_ROOT/usr/share/emacs/site-lisp/site-start.d

gzip -9fn $RPM_BUILD_ROOT%{_prefix}/man/man1/*

mkdir -p $RPM_BUILD_ROOT%{_prefix}/../etc/profile.d
cp buildscripts/out/lilypond-profile $RPM_BUILD_ROOT%{_prefix}/../etc/profile.d/lilypond.sh
cp buildscripts/out/lilypond-login $RPM_BUILD_ROOT%{_prefix}/../etc/profile.d/lilypond.csh


# again, make sure that main package installs even if doco fails
mkdir -p web/out
tar -C web -xzf out/web.tar.gz 

# Create documentation tree in %{_docdir}
## mkdir -p $RPM_DOC_ROOT/HTML
## tar -C $RPM_DOC_ROOT/HTML -xzf out/web.tar.gz
## ln -s HTML/input $RPM_DOC_ROOT/Examples
## ln -s HTML/input/test $RPM_DOC_ROOT/Tricks

## mkdir -p $RPM_DOC_ROOT/Printable
## ln -s ../HTML/Documentation/user/out-www/lilypond.ps.gz $RPM_DOC_ROOT/Printable/Manual.ps.gz
## ln -s ../HTML/Documentation/user/out-www/glossary.ps.gz $RPM_DOC_ROOT/Printable/Glossary.ps.gz
## cp AUTHORS.txt COPYING DEDICATION NEWS README.txt VERSION $RPM_DOC_ROOT/README.first

# Menu
# Every entry must be changed according package specifications
# Pay attention to "section" "command" and "longtitle"

mkdir -p $RPM_BUILD_ROOT%{_menudir}
cat >$RPM_BUILD_ROOT%{_menudir}/%{name} <<EOF
?package(%name): command="%{_bindir}/%{name}" needs="X11" \
icon="%{name}.png" section="Publishing" \
title="%{name}" longtitle="%{name}"
EOF
  
# icon
install -d $RPM_BUILD_ROOT/%{_miconsdir}
install -d $RPM_BUILD_ROOT/%{_iconsdir}
install -d $RPM_BUILD_ROOT/%{_liconsdir}
bzcat %{SOURCE1} > $RPM_BUILD_ROOT/%{_miconsdir}/%{name}.png
bzcat %{SOURCE2} > $RPM_BUILD_ROOT/%{_iconsdir}/%{name}.png
bzcat %{SOURCE3} > $RPM_BUILD_ROOT/%{_liconsdir}/%{name}png

%post
%{update_menus}

touch /tmp/.lilypond-install
rm `find /var/lib/texmf -name 'feta*pk' -or -name 'feta*tfm' -or -name 'parmesan*pk' -or -name 'parmesan*tfm' -print` /tmp/.lilypond-install

%if info=="yes"
/sbin/install-info %{_prefix}/info/lilypond.info.gz %{_prefix}/info/dir 
%endif

%preun

%if info=="yes"
if [ $1 = 0 ]; then
    /sbin/install-info --delete %{_prefix}/info/lilypond.info.gz %{_prefix}/info/dir 
fi
%endif

rm -f /usr/share/lilypond/%{version}/fonts/type1/fonts.dir
chkfontpath --remove=/usr/share/lilypond/%{version}/fonts/type1/

%postun
%{clean_menus}

%clean
## This section is meant to clean the build directory tree, $RPM_BUILD_ROOT
rm -rf $RPM_BUILD_ROOT

## %files -f %{name}.lang
%files
# The special tag %doc designates files being part of the documentation of the
# package. The files so-called will be placed in /usr/doc/lilypond-%{version}/
%doc COPYING README.txt INSTALL.txt DEDICATION NEWS AUTHORS.txt
%{_datadir}/emacs/site-lisp/lilypond-*
# is the following really started during startup of emacs?
%{_datadir}/emacs/site-lisp/site-start.d/lilypond-*

%{_prefix}/bin/abc2ly
%{_prefix}/bin/as2text
%{_prefix}/bin/convert-ly
%{_prefix}/bin/etf2ly
%{_prefix}/bin/lilypond
%{_prefix}/bin/ly2dvi
%{_prefix}/bin/midi2ly
%{_prefix}/bin/lilypond-book
%{_prefix}/bin/mup2ly
%{_prefix}/bin/musedata2ly
%{_prefix}/bin/pmx2ly

%if info=="yes"
%{_prefix}/info/lilypond.info.gz
%{_prefix}/info/lilypond-internals.info.gz
%endif

%{_prefix}/man/man1/abc2ly.1.bz2
%{_prefix}/man/man1/as2text.1.bz2
%{_prefix}/man/man1/convert-ly.1.bz2
%{_prefix}/man/man1/etf2ly.1.bz2
%{_prefix}/man/man1/lilypond.1.bz2
%{_prefix}/man/man1/ly2dvi.1.bz2
%{_prefix}/man/man1/midi2ly.1.bz2
%{_prefix}/man/man1/lilypond-book.1.bz2
%{_prefix}/man/man1/musedata2ly.1.bz2
%{_prefix}/man/man1/mup2ly.1.bz2
%{_prefix}/man/man1/pmx2ly.1.bz2

%{_prefix}/share/%{name}/%{version}/
%{_prefix}/share/locale/*/LC_MESSAGES/lilypond.mo
%{_prefix}/../etc/profile.d/lilypond.*
%_bindir/*
%_menudir/*
%_miconsdir/*
%_iconsdir/*
%_liconsdir/*

%files documentation

%doc web/

%changelog
* Fri Aug 30 2002 Heikki Johannes Junes <hjunes@cc.hut.fi> 1.6.0-1mdk
- Adapted from lilypond.redhat.skel and skeleton found in Mandrake's RPM-docs.
- TODO: info (?) and dependencies.

%changelog
* Fri Jun 01 2001 Lenny Cartier <lenny@mandrakesoft.com> 1.4.2-1mdk
- updated by Michael Brown <mbrown@linux-mandrake.com> :
	- Upgraded to 1.4.2
	- Changed URL
	- Removed /etc/profile.d scripts: all TeX bits are now located properly
	- Rearranged documentation
	- Tidied spec file
	- Updated README.first

* Mon Feb 26 2001 Lenny Cartier <lenny@mandrakesoft.com> 1.3.129-1mdk
- added in contribs by Michael Brown <mbrown@fensystems.co.uk> :
	- Removed info files completely (couldn't get info reader to read them)
	- TODO: Get this to work at some point (in the meantime, use documentation in lilypond-extras)

* Sat Feb 17 2001 Michael Brown <mbrown@fensystems.co.uk>
- Moved TeX font folders into the system TeX tree (this ensures that the /var/lib/texmf font cache is used instead of current folder)
- Added mktexlsr to post-install and post-uninstall scripts
- Patched scripts in /etc/profile.d to reflect changes to font locations
- Added QuickStart guide and Points to note sections to README.first (well worth reading)
- Fixed install-info and uninstall-info sections to use Mandrake's RPM macros :-)

* Tue Feb 13 2001 Michael Brown <mbrown@fensystems.co.uk>
- First Mandrake package
- spec file heavily adapted from PowerPC contribs.
- Note HTML documentation may contain duff links and may be incomplete.  Lots of warnings appear when building HTML docs.
- PostScript documentation is duplicated (how do you get an rpm package to contain a symlink?)
- Created README.first file
