/*   
  staff-sym-referencer.hh -- declare staff_symbol_referencer
  
  source file of the GNU LilyPond music typesetter
  
  (c) 1999--2000 Han-Wen Nienhuys <hanwen@cs.uu.nl>
  
 */

#ifndef STAFF_SYMBOL_REFERENCER_HH
#define STAFF_SYMBOL_REFERENCER_HH

#include "score-element.hh"


/**
   A notation object that needs access to variables of the staff (no
   lines, leading).
   
 */
class Staff_symbol_referencer_interface 
{
public:
  Score_element * elt_l_;	// junkme.
  Staff_symbol_referencer_interface (Score_element const*);
  static void set_interface (Score_element*);
  static bool has_interface_b (Score_element*);
  void set_position (Real);
  static Real callback (Score_element *, Axis a);

  /**
     Leading are the lead strips between the sticks (lines) of
     typeface. ie. leading is vertical space.
   */
  
  Real staff_space () const;
  Staff_symbol * staff_symbol_l () const;
  int line_count () const;
  Real position_f () const;
};

int compare_position (Score_element *const&,Score_element *const&); 
#endif /* STAFF_SYMBOL_REFERENCER_HH */

