%
% common german names for notes. "es" means flat, "is" means sharp
%
% by Roland Meier <meier@informatik.th-darmstadt.de>
% based on swedish.ly by Mats Bengtsson.


%
% Please note that, while these names are used to enter *notes*, they
% actually are *melodic*s, i.e. they represent a pitch solely. Notes
% have a rhythmic part too. This is the reason that we don't write 'note { .. }'
%
\notenames {
	ceses	= \musical_pitch { -1 0 -2 }
	ces 	= \musical_pitch { -1 0 -1 }
	c 	= \musical_pitch { -1 0 0 }
	cis 	= \musical_pitch { -1 0 1 }
	cisis	= \musical_pitch { -1 0 2 }
	deses	= \musical_pitch { -1 1 -2 }
	des 	= \musical_pitch { -1 1 -1 }
	d 	= \musical_pitch { -1 1 0 }
	dis 	= \musical_pitch { -1 1 1 }
	disis	= \musical_pitch { -1 1 2 }
	eses 	= \musical_pitch { -1 2 -2 }
	es 	= \musical_pitch { -1 2 -1 }
	e 	= \musical_pitch { -1 2 0 }
	eis 	= \musical_pitch { -1 2 1 }
	eisis	= \musical_pitch { -1 2 2 }
	feses	= \musical_pitch { -1 3 -2 }
	fes 	= \musical_pitch { -1 3 -1 }
	f 	= \musical_pitch { -1 3 0 }
	fis 	= \musical_pitch { -1 3 1 }
	fisis	= \musical_pitch { -1 3 2 }
	geses	= \musical_pitch { -1 4 -2 }
	ges 	= \musical_pitch { -1 4 -1 }
	g 	= \musical_pitch { -1 4 0 }
	gis 	= \musical_pitch { -1 4 1 }
	gisis	= \musical_pitch { -1 4 2 }
	ases 	= \musical_pitch { -1 5 -2 }
	as 	= \musical_pitch { -1 5 -1 }
	a 	= \musical_pitch { -1 5 0 }
	ais 	= \musical_pitch { -1 5 1 }
	aisis	= \musical_pitch { -1 5 2 }
	heses	= \musical_pitch { -1 6 -2 }
	b 	= \musical_pitch { -1 6 -1 }
	h 	= \musical_pitch { -1 6 0 }
	his 	= \musical_pitch { -1 6 1 }
	hisis	= \musical_pitch { -1 6 2 }


	%
	% upper case: 1 octave lower.
	%


	Ceses	= \musical_pitch { -2 0 -2 }
	Ces 	= \musical_pitch { -2 0 -1 }
	C 	= \musical_pitch { -2 0 0 }
	Cis 	= \musical_pitch { -2 0 1 }
	Cisis	= \musical_pitch { -2 0 2 }
	Deses	= \musical_pitch { -2 1 -2 }
	Des 	= \musical_pitch { -2 1 -1 }
	D 	= \musical_pitch { -2 1 0 }
	Dis 	= \musical_pitch { -2 1 1 }
	Disis	= \musical_pitch { -2 1 2 }
	Eses 	= \musical_pitch { -2 2 -2 }
	Es 	= \musical_pitch { -2 2 -1 }
	E 	= \musical_pitch { -2 2 0 }
	Eis 	= \musical_pitch { -2 2 1 }
	Eisis	= \musical_pitch { -2 2 2 }
	Feses	= \musical_pitch { -2 3 -2 }
	Fes 	= \musical_pitch { -2 3 -1 }
	F 	= \musical_pitch { -2 3 0 }
	Fis 	= \musical_pitch { -2 3 1 }
	Fisis	= \musical_pitch { -2 3 2 }
	Geses	= \musical_pitch { -2 4 -2 }
	Ges 	= \musical_pitch { -2 4 -1 }
	G 	= \musical_pitch { -2 4 0 }
	Gis 	= \musical_pitch { -2 4 1 }
	Gisis	= \musical_pitch { -2 4 2 }
	Ases 	= \musical_pitch { -2 5 -2 }
	As 	= \musical_pitch { -2 5 -1 }
	A 	= \musical_pitch { -2 5 0 }
	Ais 	= \musical_pitch { -2 5 1 }
	Aisis	= \musical_pitch { -2 5 2 }
	Heses	= \musical_pitch { -2 6 -2 }
	B 	= \musical_pitch { -2 6 -1 }
	H 	= \musical_pitch { -2 6 0 }
	His 	= \musical_pitch { -2 6 1 }
	Hisis	= \musical_pitch { -2 6 2 }


}
