#!/bin/sh

if [ "$1" = "" ];
then
    echo tar-docxx tarball.tar.gz
fi

cwd=`pwd`
TARBALL=`basename $1`
TAROUTDIR=/tmp/tar-docxx
mkdir $TAROUTDIR

echo untarring ...
tar -C $TAROUTDIR -zxf $1 '*cc' '*.c' '*.hh' '*.h'

cd $TAROUTDIR 
DATE=`date`

cat << EOF > banner.html
   This program documentation comes from $TARBALL.    It was generated by
   $USERNAME ($MAILADDRESS) on $DATE
EOF



mkdir docxx;
echo doc++ ...
doc++ -pSf -B banner.html -d docxx `find -type f`
tar -czf $cwd/progdocs.tar.gz docxx/
# rm -rf $TAROUTDIR
