#!@PYTHON@

import sys
import os

lilypath =''
try:
    lilypath = os.environ['LILYPOND_SOURCEDIR'] + '/'
except KeyError:
    print 'Please set LILYPOND_SOURCEDIR to the toplevel source, eg LILYPOND_SOURCEDIR=/home/foobar/lilypond-1.2.3/'
    sys.exit(1)

lilypath = lilypath + '/bin/'
sys.path.append(lilypath)


from lilypython import *
import getopt
import pipes


mp_version = '0.51'

class Options:
    def __init__(self):
	self.to_version = lilydirs.version_tuple()
	self.from_version = prev_version(self.to_version)

options = Options()
	

def help():
    sys.stdout.write(
	'Generate a patch to go to this version.\n'
	'  -f, --from=FROM      old is FROM\n'
	'  -d, --dir=DIR        diff to (or from) directory DIR\n'  
	'  -r, --release        diff against latest release\n'  
	'  -t, --to=TO          to version TO\n'  
	)

def untar(fn):
    # os.system('pwd');
    sys.stderr.write('untarring ' + fn + '\n')
    os.system ('gzip --quiet -dc ' + fn + '| tar xf - ')
    sys.stderr.flush()


header = 'Generated by make-patch, old = %s, new = %s\n\
\n\
usage \n\
\n\
	cd lilypond-source-dir; patch -E -p1 < %s\n\
\n\
Patches do not contain automatically generated files, \n\
i.e. you should rerun autoconf and configure\n\n'

# ugh, how to get rid of .tex files generated by lily?
pats = ['*.lsm', 'configure', '*.txt', '.dstreamrc', 'lilypond.spec']

def remove_automatic(dirnames):
    files = []
    files = files + multiple_find(pats, dirnames)

    for f in files:
	os.remove(f)

def makepatch(fromdir, todir, patfile_nm):

    remove_automatic([fromdir, todir])

    os.chdir(todir)
    
    f = open(patfile_nm, 'w')
    f.write(header %\
	    (fromdir, todir, \
	     os.path.basename(patfile_nm)))
    f.close()
	    
    sys.stderr.write('diffing to %s... ' % patfile_nm)
    os.system('pwd')
    print ('diff -urN ../%s . >> %s' % (fromdir, patfile_nm))
    os.system('diff -urN ../%s . >> %s' % (fromdir, patfile_nm))
    os.system('gzip --quiet -9f %s' % patfile_nm)
   
def main():
    os.environ['GZIP'] = '-q'
    sys.stderr.write('This is make-patch version %s\n' % mp_version)
    (cl_options, files) = getopt.getopt(sys.argv[1:], 
	'd:hf:o:rt:', ['output=', 'help', 'from=', 'to='])
    outfn = ''
    srcdir = ''

    # on default, we want to diff tar balls, again :-)
    from_b=1
    to_b=1
    for opt in cl_options:
	o = opt[0]
	a = opt[1]
	if o == '--from' or o == '-f':
	     options.from_version = version_str_to_tuple(a)
	     from_b=1
	elif o == '--to' or o == '-t':
	     options.to_version = version_str_to_tuple(a)
	     to_b=1
	elif o == '--dir' or o == '-d':
	    srcdir = a;
	    to_b=0
	elif o == '--help' or o == '-h':
	    help()
	    return 0;
	elif o == '--output' or o == '-o':
	    outfn = os.path.join(os.getcwd(), a)
	elif o == '--release' or o == '-r':
# huh?
#	    if options.from_version[3]:
#		options.from_version[3] = '';
	    options.from_version = (options.from_version[0], 
		options.from_version[1], options.from_version[2], '');
	else:
	    raise getopt.error

    if not outfn:
	pn = 'patch-%s' % version_tuple_to_str(options.to_version)
	outfn =  os.path.join(os.getcwd(), pn)

    import tempfile
    prev_cwd = os.getcwd();

    os.system('rm -rf /tmp/make-patch') 
    try:
	os.mkdir ('/tmp/make-patch')
    except:
	pass
	
    fromdir = dirname(options.from_version)
    todir =  dirname(options.to_version)

    diffdir = ''
    if srcdir != '':
	    diffdir = '/tmp/make-patch/' + 'lilypond-%s'\
		% version_tuple_to_str(options.to_version)

    if from_b != 0 or (from_b == 0 and to_b == 0):
	os.chdir ('/tmp/make-patch')
	untar(released_tarball(options.from_version))
	os.chdir(prev_cwd)
    else:
    	fromdir = diffdir
	sys.stderr.write('copying ' + srcdir + ' to ' + diffdir + '\n')
	# os.system('cp -pr %s %s' % (srcdir, diffdir))
	os.system('mkdir -p %s '% (diffdir))
	os.chdir (srcdir)
	os.system('tar cf - --exclude out . | tar -xf - -C %s' 
	  % diffdir)

    if to_b != 0:
	os.chdir ('/tmp/make-patch')
	untar(released_tarball(options.to_version))
	os.chdir(prev_cwd)
    else:
    	todir = diffdir
	sys.stderr.write('copying ' + srcdir + ' to ' + diffdir + '\n')
	os.system('mkdir -p %s '% (diffdir))
	# os.system('cp -pr %s %s'  (srcdir, diffdir))%
	os.chdir (srcdir)
	os.system('tar -cf - --exclude out . | tar -xf - -C %s '
	  % diffdir)

    os.chdir('/tmp/make-patch')
    os.chdir(todir)
    # os.system('rm -f *.aux *.dvi *.midi *.log *.ps *.tex *.ly')
    os.chdir ('/tmp/make-patch')

    makepatch(fromdir, todir, outfn) 

    os.chdir('/tmp/make-patch')
    sys.stderr.write('cleaning ... ')
    os.system('rm -fr %s %s' % (fromdir, todir))
    sys.stderr.write('\n')
    os.chdir(prev_cwd)

if __name__ == '__main__':
    main()

