/*
  register.hh -- declare Request_register

  source file of the GNU LilyPond music typesetter

  (c) 1996, 1997 Han-Wen Nienhuys <hanwen@stack.nl>
*/


#ifndef REGISTER_HH
#define REGISTER_HH

#include "lily-proto.hh"
#include "varray.hh"
#include "request.hh"
#include "score-elem-info.hh"
#include "staff-info.hh"




/**
  a struct which processes requests, and creates the #Score_elem#s.
  It may use derived classes. Hungarian postfix: register
  */
class Request_register {
    friend class Register_group_register;
    /**
      You cannot copy a Request_register
     */
    Request_register(const Request_register&){}

    enum { 
	VIRGIN,
	CREATION_INITED,
	MOVE_INITED,
	ACCEPTED_REQS,
	PROCESSED_REQS,
	ACKED_REQS,
	MOVE_DONE
    } status;

protected:
    

    /// utility
    virtual Paper_def * paper() const;

    
    /// make items/spanners with the requests you got
    virtual void do_process_requests(){}

    /** typeset any items/spanners. Default: do nothing
     */
    virtual void do_pre_move_processing(){}
    /** reset any appropriate data. Default: do nothing
     */
    virtual void do_post_move_processing(){}
   

    virtual void do_creation_processing () {}
    virtual void do_removal_processing() {}

    /**
      typeset a "command" item. Default: pass on to daddy.
      If the column is not breakable, #pre_p# and #post_p# are junked
      */
    virtual void typeset_breakable_item(Item * nobreak_p);
    /**
      Invoke walker method to typeset element. Default: pass on to daddy.
      */
    virtual void typeset_element(Score_elem*elem_p);
    
     /**
      take note of item/spanner
      put item in spanner. Adjust local key; etc.

      Default: ignore the info
      */
    virtual void acknowledge_element(Score_elem_info) {}
    /**
      Announce element. Default: pass on to daddy. Utility
      */
    virtual void announce_element(Score_elem_info);
    /**
      Set Feature of the register(s). Default: ignore Feature.
     */
    virtual void set_feature(Feature){}
    /**
      ask daddy for a feature
     */
    virtual Scalar get_feature(String type_str);
    /**
      Does this equal or contain a certain register?
     */

    virtual void sync_features() {}
   
    virtual bool contains_b(Request_register*reg_l)const;
    /**
      Get information on the staff. Default: ask daddy.
      */
    virtual Staff_info get_staff_info()const;
    virtual void fill_staff_info(Staff_info&);


    virtual void do_print()const;  
    /*    
	  @see{try_request}
	  Default: always return false
      */
    virtual bool do_try_request(Request *req_l);
public:
    void pre_move_processing();
    void process_requests();
    /**
      try to fit the request in this register

      @return
      false: not noted,  not taken.

      true: request swallowed. Don't try to put the request elsewhere.

      */
    bool try_request(Request*);

    void post_move_processing();
    
    Register_group_register * daddy_reg_l_;

    Request_register();
    virtual ~Request_register(){}
    NAME_MEMBERS();
    void print() const;
};

/**
  A macro to automate administration of registers.
 */
#define ADD_THIS_REGISTER(c)				\
struct c ## init {					\
    static Request_register * globalctor (){		\
	return new c;					\
    }							\
    c ## init () {					\
	add_request_register(c::static_name(), globalctor);	\
							\
    }							\
} _ ## c ## init;

typedef Request_register*(*Reg_ctor)(void);
void add_request_register(String s, Reg_ctor f);

#endif // REGISTER_HH

