/*
  voice-elt.cc -- implement Voice_element

  source file of the GNU LilyPond music typesetter

  (c) 1997 Han-Wen Nienhuys <hanwen@stack.nl>
*/

#include "proto.hh"
#include "plist.hh"
#include "debug.hh"
#include "voice.hh"
#include "voice-element.hh"
#include "musical-request.hh"
#include "command-request.hh"


void
Voice_element::transpose(Melodic_req const&d)const
{
    for (iter_top(req_p_list_,i); i.ok(); i++) {
	i->transpose(d);
      }
}

void
Voice_element::print() const
{
#ifndef NPRINT
    mtor << "voice_element { dur :"<< duration_ <<"\n";
    mtor << "principal: " << principal_req_l_->name() << "\n";
    for (iter_top(req_p_list_,rc); rc.ok(); rc++) {
	rc->print();
    }
    
    mtor << "}\n";
#endif
}

void
Voice_element::add(Request*r)
{
    if (! principal_req_l_ ) 
	principal_req_l_ = r;

    if (r->duration()) {
	assert (!duration_  || duration_ == r->duration());
	duration_ = r->duration();
    }
    
    r->elt_l_ = this;
    req_p_list_.bottom().add(r);
}


Voice_element::Voice_element()
{
    principal_req_l_ = 0;
    voice_C_ = 0;
    duration_ = 0;
}

Voice_element::Voice_element(Voice_element const&src)
    : Input(src)
{
    principal_req_l_ = 0;
    voice_C_=0;
    for (iter_top(src.req_p_list_, i); i.ok(); i++)
	add(i->clone());

}

void
Voice_element::set_default_group(String s)
{
    for (iter_top(req_p_list_, i); i.ok(); i++)
	if (i->command() &&i->command()->groupchange())
	    return ;
    Group_change_req *greq = new Group_change_req;
    greq->newgroup_str_ = s;
    add(greq);
}

