/*
  lexer.hh -- declare My_lily_lexer

  source file of the LilyPond music typesetter

  (c) 1997 Han-Wen Nienhuys <hanwen@stack.nl>
*/

#ifndef LEXER_HH
#define LEXER_HH

#include <FlexLexer.h>

#include "proto.hh"
#include "fproto.hh"
#include "varray.hh"
#include "string.hh"
#include "includable-lexer.hh"
#include "duration.hh"

bool busy_parsing();
void kill_lexer();
void set_lexer();


/// lexer for Mudela
class My_lily_lexer : public Includable_lexer {
    int lookup_keyword(String);
    void lookup_notename(int &large, int &small, String s);
    int scan_bare_word(String);
    int scan_escaped_word(String);

    bool post_quotes_b_;
public:
   void * lexval_l;
    
    
    Assoc<String, Identifier*> *identifier_assoc_p_;
    Keyword_table * keytable_p_;
    int errorlevel_i_;

    /* *************** */

    Identifier*lookup_identifier(String s);
 
    void push_note_state();
    void push_lyric_state();
    void pop_state();
    void LexerError(char const *);
    My_lily_lexer();
    void add_identifier(Identifier*i);
    ~My_lily_lexer();
    int yylex();
    void print_declarations(bool init_b) const;

    bool note_state_b() const;
    bool lyric_state_b() const;
};

#endif
